/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.statistics;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.algart.additions.arrays.UniformHistogram256Finder;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrixToSeveralNumbers;
import net.algart.executors.modules.core.matrices.statistics.HistogramFinder;
import net.algart.multimatrix.MultiMatrix;

public final class ImageStatistics
extends MultiMatrixToSeveralNumbers {
    public static final String INPUT_MASK = "mask";
    public static final String OUTPUT_MEAN = "mean";
    public static final String OUTPUT_PERCENTILE_1 = "percentile_1";
    public static final String OUTPUT_PERCENTILE_2 = "percentile_2";
    public static final String OUTPUT_MEAN_BETWEEN_PERCENTILES = "mean_between_percentiles";
    public static final String OUTPUT_NUMBER_OF_CHECKED_PIXELS = "number_of_checked_pixels";
    public static final String OUTPUT_HISTOGRAM = "histogram";
    private static final String[] OUTPUT_NAMES = new String[]{"mean", "percentile_1", "percentile_2", "mean_between_percentiles", "number_of_checked_pixels"};
    private double percentile1 = 0.1;
    private Double percentile2 = null;
    private boolean centeredHistogram = false;
    private boolean rawValues = false;
    private HistogramMode histogramMode = HistogramMode.RANGE_BASED;

    public ImageStatistics() {
        this.useVisibleResultParameter();
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addInputMat(INPUT_MASK);
        this.addOutputNumbers(OUTPUT_MEAN);
        this.addOutputNumbers(OUTPUT_PERCENTILE_1);
        this.addOutputNumbers(OUTPUT_PERCENTILE_2);
        this.addOutputNumbers(OUTPUT_MEAN_BETWEEN_PERCENTILES);
        this.addOutputNumbers(OUTPUT_NUMBER_OF_CHECKED_PIXELS);
        this.addOutputNumbers(OUTPUT_HISTOGRAM);
    }

    public Double getPercentile1() {
        return this.percentile1;
    }

    public ImageStatistics setPercentile1(double percentile1) {
        this.percentile1 = ImageStatistics.inRange(percentile1, 0.0, 1.0);
        return this;
    }

    public Double getPercentile2() {
        return this.percentile2;
    }

    public ImageStatistics setPercentile2(Double percentile2) {
        if (percentile2 != null) {
            ImageStatistics.inRange(percentile2, 0.0, 1.0);
        }
        this.percentile2 = percentile2;
        return this;
    }

    public ImageStatistics setPercentile2(String percentile2) {
        return this.setPercentile2(ImageStatistics.doubleOrNull(percentile2));
    }

    public boolean isCenteredHistogram() {
        return this.centeredHistogram;
    }

    public ImageStatistics setCenteredHistogram(boolean centeredHistogram) {
        this.centeredHistogram = centeredHistogram;
        return this;
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public ImageStatistics setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    public HistogramMode getHistogramMode() {
        return this.histogramMode;
    }

    public ImageStatistics setHistogramMode(HistogramMode histogramMode) {
        this.histogramMode = ImageStatistics.nonNull(histogramMode);
        return this;
    }

    @Override
    public void analyse(Map<String, SNumbers> results, MultiMatrix source) {
        this.analyse(results, source, this.getInputMat(INPUT_MASK, true).toMultiMatrix());
    }

    public void analyse(Map<String, SNumbers> results, MultiMatrix source, MultiMatrix mask) {
        Objects.requireNonNull(results, "Null results");
        Objects.requireNonNull(source, "Null source");
        source.checkDimensionEquality(mask, "source", INPUT_MASK);
        long t1 = ImageStatistics.debugTime();
        List<Matrix<? extends PArray>> allChannels = source.allChannels();
        for (String output : OUTPUT_NAMES) {
            SNumbers result = results.get(output);
            if (result == null) {
                result = new SNumbers();
                results.put(output, result);
            }
            result.setToZeros(Double.TYPE, allChannels.size(), 1);
        }
        SNumbers histogramNumbers = this.isOutputNecessary(OUTPUT_HISTOGRAM) ? this.getNumbers(OUTPUT_HISTOGRAM) : null;
        double percentile2 = this.percentile2 == null ? 1.0 - this.percentile1 : this.percentile2;
        BitArray maskArray = mask == null ? null : (BitArray)mask.nonZeroAnyChannelMatrix().array();
        UniformHistogram256Finder histogram256Finder = this.histogramMode.histogram256FinderUsed() ? UniformHistogram256Finder.newInstance(true) : null;
        long t2 = ImageStatistics.debugTime();
        long tInitializing = t2 - t1;
        long tHistogram = 0L;
        long tResults = 0L;
        for (int channelIndex = 0; channelIndex < allChannels.size(); ++channelIndex) {
            long tt1 = ImageStatistics.debugTime();
            PArray array = (PArray)allChannels.get(channelIndex).array();
            HistogramFinder finder = this.histogramMode.newFinder(array, maskArray, histogram256Finder);
            finder.find();
            long tt2 = ImageStatistics.debugTime();
            tHistogram += tt2 - tt1;
            double maxPossibleValue = this.rawValues ? 1.0 : source.maxPossibleValue();
            results.get(OUTPUT_MEAN).setValue(channelIndex, finder.mean() / maxPossibleValue);
            results.get(OUTPUT_NUMBER_OF_CHECKED_PIXELS).setValue(channelIndex, finder.count);
            if (histogramNumbers != null) {
                histogramNumbers.replaceColumnRange(channelIndex, SNumbers.ofArray(finder.histogram), 0, 1);
            }
            if (finder.range.size() == 0.0) {
                double r = finder.from / maxPossibleValue;
                results.get(OUTPUT_PERCENTILE_1).setValue(channelIndex, r);
                results.get(OUTPUT_PERCENTILE_2).setValue(channelIndex, r);
                results.get(OUTPUT_MEAN_BETWEEN_PERCENTILES).setValue(channelIndex, r);
            } else {
                if (!this.rawValues && !source.isFloatingPoint()) {
                    maxPossibleValue += 1.0;
                }
                double columnWidth = finder.columnWidth();
                if (this.centeredHistogram) {
                    finder.from -= 0.5 * columnWidth;
                }
                double p1Value = finder.from + finder.percentile(this.percentile1) * columnWidth;
                double p2Value = finder.from + finder.percentile(percentile2) * columnWidth;
                results.get(OUTPUT_PERCENTILE_1).setValue(channelIndex, p1Value / maxPossibleValue);
                results.get(OUTPUT_PERCENTILE_2).setValue(channelIndex, p2Value / maxPossibleValue);
                double meanBetweenRanks = finder.meanBetweenRanks(this.percentile1, percentile2);
                double truncatedMean = finder.from + meanBetweenRanks * columnWidth;
                results.get(OUTPUT_MEAN_BETWEEN_PERCENTILES).setValue(channelIndex, truncatedMean / maxPossibleValue);
                ImageStatistics.logDebug(String.format(Locale.US, "Image statistics for channel %d of %s calculated in %.3f ms:%n    %s", channelIndex, source, (double)(tt2 - tt1) * 1.0E-6, finder));
            }
            long tt3 = ImageStatistics.debugTime();
            tResults += tt3 - tt2;
        }
        long t3 = ImageStatistics.debugTime();
        if (LOGGABLE_DEBUG) {
            ImageStatistics.logDebug(String.format(Locale.US, "Image statistics of %s%s calculated in %.3f ms: %.3f initializing, %.3f finding histogram, %.3f making results", source, mask != null ? " with mask" : "", (double)(t3 - t1) * 1.0E-6, (double)tInitializing * 1.0E-6, (double)tHistogram * 1.0E-6, (double)tResults * 1.0E-6));
        }
    }

    @Override
    protected boolean analyseOnlyRequested() {
        return false;
    }

    public static enum HistogramMode {
        RANGE_BASED{

            @Override
            HistogramFinder newFinder(PArray array, BitArray maskArray, UniformHistogram256Finder finder256) {
                return new HistogramFinder.RangeBased(array, maskArray);
            }
        }
        ,
        UNIFORM_256{

            @Override
            HistogramFinder newFinder(PArray array, BitArray maskArray, UniformHistogram256Finder finder256) {
                return new HistogramFinder.Uniform(array, maskArray, finder256);
            }
        };


        public boolean histogram256FinderUsed() {
            return this == UNIFORM_256;
        }

        abstract HistogramFinder newFinder(PArray var1, BitArray var2, UniformHistogram256Finder var3);
    }
}

