/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.io;

import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;

public final class SupportedImageFormats
extends Executor
implements ReadOnlyExecutionInput {
    @Override
    public void process() {
        this.getScalar().setTo(SupportedImageFormats.information());
    }

    public static String information() {
        StringBuilder sb = new StringBuilder();
        IIORegistry registry = IIORegistry.getDefaultInstance();
        sb.append(String.format("Available reading file extensions (suffixes):%n", new Object[0]));
        sb.append(String.format("    %s%n", SupportedImageFormats.toString(ImageIO.getReaderFileSuffixes())));
        sb.append(String.format("Available writing file extensions (suffixes):%n", new Object[0]));
        sb.append(String.format("    %s%n", SupportedImageFormats.toString(ImageIO.getWriterFileSuffixes())));
        sb.append(String.format("%n", new Object[0]));
        sb.append(String.format("Available reading format names (for Java developers):%n", new Object[0]));
        sb.append(String.format("    %s%n", SupportedImageFormats.toString(ImageIO.getReaderFormatNames())));
        sb.append(String.format("Available writing format names (for Java developers):%n", new Object[0]));
        sb.append(String.format("    %s%n", SupportedImageFormats.toString(ImageIO.getWriterFormatNames())));
        sb.append(String.format("%n", new Object[0]));
        sb.append(String.format("Available readers:%n", new Object[0]));
        Iterator<ImageReaderSpi> readers = registry.getServiceProviders(ImageReaderSpi.class, true);
        while (readers.hasNext()) {
            ImageReaderSpi spi = readers.next();
            sb.append(String.format("%s: suffixes %s, format names %s%n", spi, Arrays.toString(spi.getFileSuffixes()), Arrays.toString(spi.getFormatNames())));
        }
        sb.append(String.format("%n", new Object[0]));
        sb.append(String.format("Available writers:%n", new Object[0]));
        Iterator<ImageWriterSpi> writers = registry.getServiceProviders(ImageWriterSpi.class, true);
        while (writers.hasNext()) {
            ImageWriterSpi spi = writers.next();
            sb.append(String.format("%s: suffixes %s, format names %s%n", spi, Arrays.toString(spi.getFileSuffixes()), Arrays.toString(spi.getFormatNames())));
        }
        return sb.toString();
    }

    private static String toString(String[] names) {
        names = (String[])names.clone();
        Arrays.sort(names, String::compareToIgnoreCase);
        return String.join((CharSequence)", ", names);
    }

    public static void main(String[] args) {
        System.out.print(SupportedImageFormats.information());
    }
}

