/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.io;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.io.MatrixIO;
import net.algart.multimatrix.MultiMatrix;

public final class ReadAlgARTImage
extends FileOperation
implements ReadOnlyExecutionInput {
    public ReadAlgARTImage() {
        this.addFileOperationPorts();
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public static ReadAlgARTImage getSecureInstance() {
        ReadAlgARTImage result = new ReadAlgARTImage();
        result.setSecure(true);
        return result;
    }

    @Override
    public ReadAlgARTImage setFile(String file) {
        super.setFile(file);
        return this;
    }

    @Override
    public void process() {
        SMat input = this.getInputMat(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            ReadAlgARTImage.logDebug(() -> "Copying " + String.valueOf(input));
            this.getMat().setTo(input);
        } else {
            this.getMat().setToOrRemove(this.readMultiMatrix());
        }
    }

    public MultiMatrix readMultiMatrix() {
        Path path = this.completeFilePath();
        try {
            if (this.skipIfMissing(path, false)) {
                return null;
            }
            ReadAlgARTImage.logDebug(() -> "Reading AlgART multi-matrix from " + String.valueOf(path));
            List matrices = MatrixIO.readImageFolder((Path)path);
            MultiMatrix multiMatrix = MultiMatrix.ofRGBA(matrices);
            MultiMatrix result = multiMatrix.clone();
            multiMatrix.freeResources();
            return result;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

