/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.geometry;

import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.matrices.geometry.SubMatrixFilter;
import net.algart.multimatrix.MultiMatrix;

public final class SubMatrix
extends SubMatrixFilter {
    public static final String OUTPUT_DIM_X = "dim_x";
    public static final String OUTPUT_DIM_Y = "dim_y";
    private boolean doAction = true;
    private Matrix.ContinuationMode continuationMode = Matrix.ContinuationMode.CYCLIC;

    public SubMatrix() {
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
        this.addOutputNumbers("rectangular_area");
        this.addOutputScalar(OUTPUT_DIM_X);
        this.addOutputScalar(OUTPUT_DIM_Y);
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public SubMatrix setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    public Matrix.ContinuationMode getContinuationMode() {
        return this.continuationMode;
    }

    public SubMatrix setContinuationMode(Matrix.ContinuationMode continuationMode) {
        this.continuationMode = continuationMode;
        return this;
    }

    public SubMatrix setContinuationMode(String continuationMode) {
        Objects.requireNonNull(continuationMode, "Null continuation mode");
        switch (continuationMode) {
            case "CYCLIC": {
                this.continuationMode = Matrix.ContinuationMode.CYCLIC;
                break;
            }
            case "PSEUDO_CYCLIC": {
                this.continuationMode = Matrix.ContinuationMode.PSEUDO_CYCLIC;
                break;
            }
            case "MIRROR_CYCLIC": {
                this.continuationMode = Matrix.ContinuationMode.MIRROR_CYCLIC;
                break;
            }
            case "ZERO_CONSTANT": {
                this.continuationMode = Matrix.ContinuationMode.ZERO_CONSTANT;
                break;
            }
            case "POSITIVE_INFINITY": {
                this.continuationMode = Matrix.ContinuationMode.getConstantMode((Object)Double.POSITIVE_INFINITY);
                break;
            }
            case "NEGATIVE_INFINITY": {
                this.continuationMode = Matrix.ContinuationMode.getConstantMode((Object)Double.NEGATIVE_INFINITY);
                break;
            }
            case "NAN_CONSTANT": {
                this.continuationMode = Matrix.ContinuationMode.NAN_CONSTANT;
                break;
            }
            default: {
                this.continuationMode = Matrix.ContinuationMode.NONE;
            }
        }
        return this;
    }

    @Override
    public MultiMatrix process(MultiMatrix source) {
        this.getScalar(OUTPUT_DIM_X).setTo(source.dim(0));
        this.getScalar(OUTPUT_DIM_Y).setTo(source.dim(1));
        return this.doAction ? super.process(source) : source;
    }

    @Override
    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        return this.extractSubMatrix(m, this.continuationMode);
    }

    @Override
    protected void logProcessing(String submatrixDescription) {
        if (this.currentChannel() == 0) {
            SubMatrix.logDebug(() -> "Extracting " + submatrixDescription);
        }
    }
}

