/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.drawing;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.common.awt.AWTFilter;
import net.algart.io.awt.MatrixToImage;

public final class DrawImage
extends Executor {
    public static final String INPUT_IMAGE = "image";
    private boolean percents = false;
    private boolean imageRequired = false;
    private double x = 0.0;
    private double y = 0.0;
    private double opacity = 1.0;
    private boolean convertMonoToColor = false;
    private boolean autoExpand = true;

    public DrawImage() {
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addInputMat(INPUT_IMAGE);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public boolean isImageRequired() {
        return this.imageRequired;
    }

    public DrawImage setImageRequired(boolean imageRequired) {
        this.imageRequired = imageRequired;
        return this;
    }

    public boolean isPercents() {
        return this.percents;
    }

    public DrawImage setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public DrawImage setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public DrawImage setY(double y) {
        this.y = y;
        return this;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public DrawImage setOpacity(double opacity) {
        if (opacity < 0.0 || opacity > 1.0) {
            throw new IllegalArgumentException("Opacity must be in range [0.0; 1.0]");
        }
        this.opacity = opacity;
        return this;
    }

    public boolean isConvertMonoToColor() {
        return this.convertMonoToColor;
    }

    public DrawImage setConvertMonoToColor(boolean convertMonoToColor) {
        this.convertMonoToColor = convertMonoToColor;
        return this;
    }

    public boolean isAutoExpand() {
        return this.autoExpand;
    }

    public DrawImage setAutoExpand(boolean autoExpand) {
        this.autoExpand = autoExpand;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        Matrix<? extends PArray> m;
        SMat input = this.getInputMat();
        if (this.convertMonoToColor) {
            input = AWTFilter.convertMonoToColor(input);
        }
        if ((m = this.getInputMat(INPUT_IMAGE, !this.imageRequired).toInterleavedBGR2D(false)) == null) {
            this.getMat().exchange(input);
            return;
        }
        Matrix<? extends PArray> source = input.toInterleavedBGR2D(false);
        assert (source != null) : "getInputMat() should not return non-initialized result";
        int x = Arrays.round32((double)(this.percents ? this.x / 100.0 * (double)(input.getDimX() - 1L) : this.x));
        int y = Arrays.round32((double)(this.percents ? this.y / 100.0 * (double)(input.getDimY() - 1L) : this.y));
        source = DrawImage.expandToFit(source, 0L, (long)x + m.dim(1), (long)y + m.dim(2));
        BufferedImage baseImage = MatrixToImage.ofInterleavedBGR(source);
        BufferedImage overlayImage = MatrixToImage.ofInterleavedBGR(m);
        Graphics2D g = baseImage.createGraphics();
        try {
            if (this.opacity != 1.0) {
                g.setComposite(AlphaComposite.getInstance(3, (float)this.opacity));
            }
            g.drawImage((Image)overlayImage, x, y, null);
        }
        finally {
            g.dispose();
        }
        this.getMat().setTo(baseImage);
    }

    @Override
    public String translateLegacyParameterAlias(String name) {
        return name.equals("requireImage") ? "imageRequired" : name;
    }

    private static Matrix<? extends PArray> expandToFit(Matrix<? extends PArray> source, long ... minDimensions) {
        long[] dimensions = source.dimensions();
        boolean needToExpand = false;
        for (int i = 0; i < minDimensions.length; ++i) {
            if (dimensions[i] >= minDimensions[i]) continue;
            dimensions[i] = minDimensions[i];
            needToExpand = true;
            break;
        }
        return needToExpand ? source.subMatr(new long[dimensions.length], dimensions, Matrix.ContinuationMode.ZERO_CONSTANT) : source;
    }
}

