/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.copying;

import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.core.matrices.geometry.SubMatrixFilter;

public final class FillMatrix
extends SubMatrixFilter {
    private String color = "#FFFFFF";
    private double grayscaleValue = 0.0;
    private boolean rawGrayscaleValue = false;

    public String getColor() {
        return this.color;
    }

    public FillMatrix setColor(String color) {
        this.color = FillMatrix.nonNull(color);
        return this;
    }

    public double getGrayscaleValue() {
        return this.grayscaleValue;
    }

    public FillMatrix setGrayscaleValue(double grayscaleValue) {
        this.grayscaleValue = grayscaleValue;
        return this;
    }

    public boolean isRawGrayscaleValue() {
        return this.rawGrayscaleValue;
    }

    public FillMatrix setRawGrayscaleValue(boolean rawGrayscaleValue) {
        this.rawGrayscaleValue = rawGrayscaleValue;
        return this;
    }

    @Override
    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        Class destType = Arrays.type(PArray.class, (Class)m.elementType());
        double maxPossibleValue = Arrays.maxPossibleValue((Class)destType, (double)1.0);
        double value = this.color.trim().isEmpty() ? (this.rawGrayscaleValue ? this.grayscaleValue : this.grayscaleValue * maxPossibleValue) : this.colorChannel(this.color, maxPossibleValue);
        if (this.extractSubMatrix(m, Matrix.ContinuationMode.NAN_CONSTANT) == m) {
            return Matrices.constantMatrix((double)value, (Class)destType, (long[])m.dimensions());
        }
        Matrix clone = m.matrix((Array)((PArray)m.array()).updatableClone((MemoryModel)Arrays.SMM));
        Matrix<? extends PArray> subMatrix = this.extractSubMatrix((Matrix<? extends PArray>)clone, Matrix.ContinuationMode.NAN_CONSTANT);
        ((UpdatablePArray)subMatrix.array()).fill(value);
        return clone;
    }

    @Override
    protected void logProcessing(String submatrixDescription) {
        if (this.currentChannel() == 0) {
            FillMatrix.logDebug(() -> "Filling " + submatrixDescription);
        }
    }
}

