/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannelFilter;

public final class ExtractLayerWithDecreasingNumberOfDimensions
extends MultiMatrixChannelFilter {
    private long lastCoordinate;

    public long getLastCoordinate() {
        return this.lastCoordinate;
    }

    public ExtractLayerWithDecreasingNumberOfDimensions setLastCoordinate(long lastCoordinate) {
        this.lastCoordinate = lastCoordinate;
        return this;
    }

    @Override
    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        if (m.dimCount() <= 1) {
            return m;
        }
        long[] coordinates = new long[m.dimCount()];
        int newDimCount = coordinates.length - 1;
        coordinates[newDimCount] = this.lastCoordinate >= 0L ? this.lastCoordinate : m.dim(newDimCount) + this.lastCoordinate;
        long index = m.index(coordinates);
        long[] newDimensions = JArrays.copyOfRange((long[])m.dimensions(), (int)0, (int)newDimCount);
        PArray newArray = (PArray)((PArray)m.array()).subArr(index, Arrays.longMul((long[])newDimensions));
        return Matrices.matrix((Array)newArray, (long[])newDimensions);
    }
}

