/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.logic.control;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Port;
import net.algart.executors.modules.core.logic.ConditionStyle;

abstract class AbstractCopyIfRequested
extends Executor {
    public static final String IF_PREFIX = "if_";
    public static final String IF_S_PREFIX = "if_s";
    public static final String S_PREFIX = "s";
    public static final String IF_X_PREFIX = "if_x";
    public static final String X_PREFIX = "x";
    public static final String IF_M_PREFIX = "if_m";
    public static final String M_PREFIX = "m";
    private ConditionStyle conditionStyle = ConditionStyle.JAVA_LIKE;
    private boolean invert = false;

    protected AbstractCopyIfRequested() {
        this.useVisibleResultParameter();
    }

    public ConditionStyle getConditionStyle() {
        return this.conditionStyle;
    }

    public AbstractCopyIfRequested setConditionStyle(ConditionStyle conditionStyle) {
        this.conditionStyle = AbstractCopyIfRequested.nonNull(conditionStyle);
        return this;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public AbstractCopyIfRequested setInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    @Override
    public Boolean checkInputNecessary(Port inputPort) {
        if (inputPort == null) {
            return null;
        }
        String inputPortName = inputPort.getName();
        if (inputPortName.startsWith(IF_PREFIX)) {
            return null;
        }
        String ifPortName = IF_PREFIX + inputPortName;
        return this.condition(ifPortName);
    }

    public boolean condition(String portName) {
        String conditionString = this.getInputScalar(portName, true).getValue();
        return this.conditionStyle.toBoolean(conditionString, false) != this.invert;
    }

    static String sPortName(int index) {
        return S_PREFIX + (index + 1);
    }

    static String ifSPortName(int index) {
        return IF_S_PREFIX + (index + 1);
    }

    static String xPortName(int index) {
        return X_PREFIX + (index + 1);
    }

    static String ifXPortName(int index) {
        return IF_X_PREFIX + (index + 1);
    }

    static String mPortName(int index) {
        return M_PREFIX + (index + 1);
    }

    static String ifMPortName(int index) {
        return IF_M_PREFIX + (index + 1);
    }
}

