/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.scalars;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SScalar;

public abstract class SeveralScalarsOperation
extends Executor {
    public static final String INPUT_PORT_PREFIX = "s";
    private final String[] predefinedInputPortNames;

    protected SeveralScalarsOperation(String ... predefinedInputPortNames) {
        Objects.requireNonNull(predefinedInputPortNames, "Null predefinedInputPortNames");
        this.predefinedInputPortNames = (String[])predefinedInputPortNames.clone();
        for (String port : predefinedInputPortNames) {
            this.addInputScalar(port);
        }
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    @Override
    public void process() {
        Integer requiredNumberOfInputs = this.requiredNumberOfInputs();
        boolean replaceWithNull = this.replaceUninitializedInputWithNull();
        ArrayList<SScalar> sourceList = new ArrayList<SScalar>();
        for (int k = 0; requiredNumberOfInputs == null || k < requiredNumberOfInputs; ++k) {
            String portName = this.inputPortName(k);
            if (requiredNumberOfInputs == null && !this.hasInputPort(portName)) break;
            SScalar input = this.getInputScalar(portName, this.allowUninitializedInput(k));
            sourceList.add((SScalar)(replaceWithNull && !input.isInitialized() ? null : input));
        }
        this.setStartProcessingTimeStamp();
        SScalar result = this.process(sourceList);
        this.setEndProcessingTimeStamp();
        this.getScalar().setTo(result);
    }

    public abstract SScalar process(List<SScalar> var1);

    protected Integer requiredNumberOfInputs() {
        return this.predefinedInputPortNames.length == 0 ? null : Integer.valueOf(this.predefinedInputPortNames.length);
    }

    protected boolean allowUninitializedInput(int inputIndex) {
        return true;
    }

    protected boolean replaceUninitializedInputWithNull() {
        return false;
    }

    protected String inputPortName(int inputIndex) {
        return inputIndex < this.predefinedInputPortNames.length ? this.predefinedInputPortNames[inputIndex] : INPUT_PORT_PREFIX + (inputIndex + 1);
    }
}

