/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.numbers;

import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SNumbers;
import net.algart.math.IRange;

public abstract class NumbersFilter
extends Executor {
    private int indexInBlock = 0;
    private int lengthInBlock = 0;
    private boolean replaceColumnRangeInInput = false;

    protected NumbersFilter() {
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public final int getIndexInBlock() {
        return this.indexInBlock;
    }

    public final NumbersFilter setIndexInBlock(int indexInBlock) {
        this.indexInBlock = NumbersFilter.nonNegative(indexInBlock);
        return this;
    }

    public final int getLengthInBlock() {
        return this.lengthInBlock;
    }

    public final NumbersFilter setLengthInBlock(int lengthInBlock) {
        this.lengthInBlock = NumbersFilter.nonNegative(lengthInBlock);
        return this;
    }

    public final boolean isReplaceColumnRangeInInput() {
        return this.replaceColumnRangeInInput;
    }

    public final NumbersFilter setReplaceColumnRangeInInput(boolean replaceColumnRangeInInput) {
        this.replaceColumnRangeInInput = replaceColumnRangeInInput;
        return this;
    }

    @Override
    public void process() {
        SNumbers input = this.getInputNumbers(this.allowUninitializedInput());
        this.setStartProcessingTimeStamp();
        SNumbers result = this.process(input);
        this.setEndProcessingTimeStamp();
        if (result != null) {
            this.getNumbers().exchange(result);
        } else if (this.hasDefaultOutputPort()) {
            this.getNumbers().remove();
        }
    }

    public SNumbers process(SNumbers input) {
        SNumbers result;
        SNumbers originalInput = Objects.requireNonNull(input, "Null input");
        IRange columnRange = this.selectedColumnRange();
        if (columnRange != null && input.isInitialized()) {
            input = input.columnRange((int)columnRange.min(), (int)columnRange.size());
        }
        if ((result = this.processNumbers(input)) == null) {
            if (this.resultRequired()) {
                throw new AssertionError((Object)"Invalid process implementation: it returned null, though resultRequired=true");
            }
            return null;
        }
        if (this.replaceColumnRangeInInput() && columnRange != null) {
            SNumbers corrected = originalInput.toPrecision(result.elementType());
            corrected.replaceColumnRange((int)columnRange.min(), result, 0, result.getBlockLength());
            result = corrected;
        }
        return result;
    }

    protected abstract SNumbers processNumbers(SNumbers var1);

    protected boolean allowUninitializedInput() {
        return false;
    }

    protected boolean resultRequired() {
        return true;
    }

    protected IRange selectedColumnRange() {
        return this.lengthInBlock <= 0 ? null : IRange.of((long)this.indexInBlock, (long)(this.indexInBlock + this.lengthInBlock - 1));
    }

    protected boolean replaceColumnRangeInInput() {
        return this.replaceColumnRangeInInput;
    }
}

