/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import net.algart.arrays.ArraySelector;

public abstract class TimingStatistics {
    final long[] times;
    int current = 0;
    boolean full = false;
    long last = 0L;
    long sumOfAllCalls = 0L;
    long numberOfAllCalls = 0L;
    private int numberOfAnalysedTimes = 0;
    private long sum = 0L;
    private double[] percentileLevels = new double[0];
    private long[] percentiles = new long[0];
    private int minIndex = -1;
    private int maxIndex = -1;
    private int medianIndex = -1;

    private TimingStatistics(int maximalNumberOfStoredTimes) {
        if (maximalNumberOfStoredTimes < 0) {
            throw new IllegalArgumentException("Negative number of stored times");
        }
        this.times = new long[maximalNumberOfStoredTimes];
    }

    public static TimingStatistics newInstance(int maximalNumberOfStoredTimes) {
        return maximalNumberOfStoredTimes == 0 ? new Empty() : new NonEmpty(maximalNumberOfStoredTimes);
    }

    public void setSettings(Settings settings) {
        Objects.requireNonNull(settings, "Null settings");
        this.percentileLevels = (double[])settings.percentileLevels.clone();
        this.percentiles = new long[this.percentileLevels.length];
        this.medianIndex = -1;
        this.maxIndex = -1;
        this.minIndex = -1;
        for (int k = 0; k < this.percentiles.length; ++k) {
            double level = this.percentileLevels[k];
            if (level == 0.0) {
                this.minIndex = k;
                continue;
            }
            if (level == 0.5) {
                this.medianIndex = k;
                continue;
            }
            if (level != 1.0) continue;
            this.maxIndex = k;
        }
    }

    public TimingStatistics analyse() {
        int n = this.numberOfStoredTimes();
        this.sum = Arrays.stream(this.times, 0, n).sum();
        TimingStatistics.findPercentiles(this.percentiles, this.times, n, this.percentileLevels);
        this.numberOfAnalysedTimes = n;
        return this;
    }

    public abstract long currentTime();

    public abstract void update(long var1);

    public boolean isEmpty() {
        return this.numberOfStoredTimes() == 0;
    }

    public int numberOfStoredTimes() {
        return this.full ? this.times.length : this.current;
    }

    public int numberOfAnalysedTimes() {
        return this.numberOfAnalysedTimes;
    }

    public long lastTime() {
        return this.last;
    }

    public double numberOfAllCalls() {
        return this.numberOfAllCalls;
    }

    public double summaryTimeOfAllCalls() {
        return this.sumOfAllCalls;
    }

    public double averageTimeOfAllCalls() {
        return this.numberOfAllCalls == 0L ? 0.0 : (double)this.sumOfAllCalls / (double)this.numberOfAllCalls;
    }

    public double summaryTimeOfLastAnalysedCalls() {
        return this.sum;
    }

    public double averageTimeOfLastAnalysedCalls() {
        return this.numberOfAnalysedTimes == 0 ? 0.0 : (double)this.sum / (double)this.numberOfAnalysedTimes;
    }

    public Double medianTimeOrNull() {
        return this.medianIndex == -1 ? null : Double.valueOf(this.numberOfAnalysedTimes == 0 ? 0.0 : (double)this.percentiles[this.medianIndex]);
    }

    public long[] percentiles() {
        return (long[])this.percentiles.clone();
    }

    public double[] percentileLevels() {
        return (double[])this.percentileLevels.clone();
    }

    public String toSimpleString() {
        return this.toSimpleString(null);
    }

    public String toSimpleString(Double totalTimeOfLastAnalysedCalls) {
        StringBuilder sb = new StringBuilder();
        if (this.minIndex != -1 && this.maxIndex != -1) {
            sb.append(TimingStatistics.leftPad(String.format(Locale.US, "%.6f..%.6f, ", (double)this.percentiles[this.minIndex] * 1.0E-6, (double)this.percentiles[this.maxIndex] * 1.0E-6), 26));
        }
        if (this.medianIndex != -1) {
            sb.append(TimingStatistics.leftPad(String.format(Locale.US, "median %.6f, ", (double)this.percentiles[this.medianIndex] * 1.0E-6), 20));
        }
        sb.append(TimingStatistics.leftPad(String.format(Locale.US, "mean ~%.6f ms", this.averageTimeOfLastAnalysedCalls() * 1.0E-6), 20));
        if (totalTimeOfLastAnalysedCalls != null) {
            sb.append(TimingStatistics.leftPad(String.format(Locale.US, " (%.3f%%)", this.summaryTimeOfLastAnalysedCalls() * 100.0 / totalTimeOfLastAnalysedCalls), 10));
        }
        return sb.toString();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "no information";
        }
        if (this.numberOfAnalysedTimes == 0) {
            return "not analysed yet";
        }
        StringBuilder sb = new StringBuilder();
        if (this.percentileLevels.length > 0) {
            sb.append(" [");
            for (int k = 0; k < this.percentiles.length; ++k) {
                double level;
                if (k > 0) {
                    sb.append(", ");
                }
                if ((level = this.percentileLevels[k]) == 0.0) {
                    sb.append("min ");
                } else if (level == 0.5) {
                    sb.append("median ");
                } else if (level == 1.0) {
                    sb.append("max ");
                }
                sb.append(String.format(Locale.US, "%.6f", (double)this.percentiles[k] * 1.0E-6));
            }
            sb.append("]");
        }
        String allInfo = this.numberOfAllCalls != (long)this.numberOfAnalysedTimes ? String.format(Locale.US, " [from start: %d calls, sum %.6f, mean ~%.6f ms]", this.numberOfAllCalls, this.summaryTimeOfAllCalls() * 1.0E-6, this.averageTimeOfAllCalls() * 1.0E-6) : "";
        return String.format(Locale.US, "%d calls: last %.6f%s, sum %.6f, mean ~%.6f ms%s", this.numberOfAnalysedTimes, (double)this.lastTime() * 1.0E-6, sb, this.summaryTimeOfLastAnalysedCalls() * 1.0E-6, this.averageTimeOfLastAnalysedCalls() * 1.0E-6, allInfo);
    }

    private static void findPercentiles(long[] result, long[] times, int length, double[] percentileLevels) {
        assert (length >= 0 && length <= times.length) : "length=" + length + ", must be 0<length<=" + times.length;
        assert (result.length == percentileLevels.length);
        if (length > 0 && percentileLevels.length > 0) {
            ArraySelector.getQuickSelector().select(percentileLevels, times, length);
            Arrays.setAll(result, k -> times[ArraySelector.percentileIndex((double)percentileLevels[k], (int)length)]);
        }
    }

    private static String leftPad(String s, int length) {
        return s.length() >= length ? s : " ".repeat(length - s.length()) + s;
    }

    private static class Empty
    extends TimingStatistics {
        private Empty() {
            super(0);
        }

        @Override
        public long currentTime() {
            return 0L;
        }

        @Override
        public void update(long time) {
        }
    }

    private static class NonEmpty
    extends TimingStatistics {
        private NonEmpty(int numberOfTimes) {
            super(numberOfTimes);
        }

        @Override
        public long currentTime() {
            return System.nanoTime();
        }

        @Override
        public void update(long time) {
            this.sumOfAllCalls += time;
            ++this.numberOfAllCalls;
            this.times[this.current++] = this.last = time;
            if (this.current == this.times.length) {
                this.current = 0;
                this.full = true;
            }
        }
    }

    public static class Settings {
        public static final int MAXIMAL_NUMBER_OF_PERCENTILES = 1000;
        private double[] percentileLevels = new double[0];

        public double[] getPercentileLevels() {
            return (double[])this.percentileLevels.clone();
        }

        public Settings setPercentileLevels(double[] percentileLevels) {
            Objects.requireNonNull(percentileLevels, "Null percentileLevels");
            if (percentileLevels.length > 1000) {
                throw new IllegalArgumentException("Requested number of percentiles " + percentileLevels.length + " > maximal possible value 1000");
            }
            if ((percentileLevels = (double[])percentileLevels.clone()).length > 0) {
                ArraySelector.checkPercentileLevels((double[])percentileLevels);
            }
            this.percentileLevels = percentileLevels;
            return this;
        }

        public Settings setUniformPercentileLevels(int numberOfPercentiles) {
            if (numberOfPercentiles < 0) {
                throw new IllegalArgumentException("Negative number of percentiles for timing  execution: " + numberOfPercentiles);
            }
            if (numberOfPercentiles > 1000) {
                throw new IllegalArgumentException("Requested number of percentiles " + numberOfPercentiles + " > maximal possible value 1000");
            }
            if (this.percentileLevels.length != numberOfPercentiles) {
                this.percentileLevels = new double[numberOfPercentiles];
            }
            if (this.percentileLevels.length == 1) {
                this.percentileLevels[0] = 0.5;
            } else if (this.percentileLevels.length != 0) {
                Arrays.setAll(this.percentileLevels, k -> (double)k / (double)(this.percentileLevels.length - 1));
            }
            return this;
        }
    }
}

