/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class OptionalArguments<T> {
    private final List<T> nullableArguments;

    public OptionalArguments(List<T> nullableArguments) {
        Objects.requireNonNull(nullableArguments, "Null arguments list");
        this.nullableArguments = new ArrayList<T>(nullableArguments);
    }

    public List<T> extract() {
        return this.nullableArguments.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public <P> List<P> extractParallel(Map<Integer, P> parallelArguments) {
        ArrayList<Object> result = new ArrayList<Object>();
        int n = this.nullableArguments.size();
        int m = parallelArguments.size();
        for (int k = 0; k < n; ++k) {
            if (this.nullableArguments.get(k) == null) continue;
            result.add(k < m ? (Object)parallelArguments.get(k) : null);
        }
        return result;
    }

    public int[] extractParallelIntegers(Map<Integer, Integer> parallelArguments, int defaultValue) {
        return this.extractParallel(parallelArguments).stream().mapToInt(v -> v == null ? defaultValue : v).toArray();
    }

    public double[] extractParallelDoubles(Map<Integer, Double> parallelArguments, double defaultValue) {
        return this.extractParallel(parallelArguments).stream().mapToDouble(v -> v == null ? defaultValue : v).toArray();
    }
}

