/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.build;

import jakarta.json.JsonObject;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.StreamSupport;
import net.algart.executors.api.SystemEnvironment;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.modules.core.build.ExecutorSpecificationVerifier;

public final class ExecutorsDirectory {
    private final Set<String> ids = new HashSet<String>();
    private final Set<String> instantiationNames = new HashSet<String>();
    private boolean descriptions = false;
    private String lastCategory = null;

    private void show(Path f) throws IOException {
        String description;
        JsonObject json = ExecutorSpecificationVerifier.readExecutorSpecification(f, true);
        if (json == null) {
            return;
        }
        ExecutorSpecification specification = ExecutorSpecification.of(json);
        String category = specification.getCategory();
        if (!category.equals(this.lastCategory)) {
            System.out.printf("%n%s%n", category);
        }
        this.lastCategory = category;
        System.out.printf("  %s%n", specification.getName());
        if (this.descriptions && (description = specification.getDescription()) != null) {
            System.out.printf("    %s%n", description);
        }
    }

    private void showAll(Path folder) throws IOException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(folder);){
            StreamSupport.stream(files.spliterator(), false).sorted(Comparator.comparing(Path::toString)).forEach(file -> {
                try {
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        this.showAll((Path)file);
                    } else if (file.getFileName().toString().endsWith(".json")) {
                        this.show((Path)file);
                    }
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            });
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        ExecutorsDirectory lister = new ExecutorsDirectory();
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equals("-descriptions")) {
            lister.descriptions = true;
            ++startArgIndex;
        }
        if (args.length == startArgIndex) {
            System.out.printf("Usage: %s [-descriptions] folder1_with_json_files folder2_with_json_files...s%n", ExecutorsDirectory.class.getName());
            return;
        }
        for (int k = startArgIndex; k < args.length; ++k) {
            String path = SystemEnvironment.replaceHomeEnvironmentVariable(args[k]);
            Path folder = Paths.get(path, new String[0]);
            System.out.printf("%s...%n", folder);
            lister.showAll(folder);
            System.out.println();
        }
    }
}

