/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.algart.executors.api.parameters.ValueType;

public enum EditionType {
    VALUE("value", false),
    ENUM("enum", false),
    FILE("file", true),
    FILE_TO_SAVE("file_to_save", true),
    FOLDER("folder", true),
    COLOR("color", false),
    RANGE("range", false);

    private final String typeName;
    private final boolean resources;
    private static final Map<String, EditionType> ALL_TYPES;

    private EditionType(String typeName, boolean resources) {
        this.typeName = Objects.requireNonNull(typeName);
        this.resources = resources;
    }

    public static Collection<String> typeNames() {
        return Collections.unmodifiableCollection(ALL_TYPES.keySet());
    }

    public String typeName() {
        return this.typeName;
    }

    public boolean isResources() {
        return this.resources;
    }

    public boolean isPath() {
        return this.isResources();
    }

    public boolean isEnum() {
        return this == ENUM;
    }

    public static EditionType ofTypeName(String typeName) {
        Objects.requireNonNull(typeName, "Null type name");
        return EditionType.fromTypeName(typeName).orElseThrow(() -> new IllegalArgumentException("Unknown control edition type \"" + typeName + "\""));
    }

    public static Optional<EditionType> fromTypeName(String typeName) {
        return Optional.ofNullable(ALL_TYPES.get(typeName));
    }

    public static EditionType defaultEditionType(ValueType valueType) {
        Objects.requireNonNull(valueType, "Null valueType");
        return valueType == ValueType.ENUM_STRING ? ENUM : VALUE;
    }

    public static void main(String[] args) {
        for (EditionType type : EditionType.values()) {
            System.out.printf("%s: %s%n", new Object[]{type.typeName(), EditionType.ofTypeName(type.typeName())});
        }
    }

    static {
        ALL_TYPES = new LinkedHashMap<String, EditionType>();
        for (EditionType type : EditionType.values()) {
            ALL_TYPES.put(type.typeName, type);
        }
    }
}

