/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings.executable;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.settings.SettingsSpecification;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorSpecification;

public final class ChainToSettings {
    public static final String SESSION_ID = "~~DUMMY_SESSION";

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.out.printf("Usage: %s chain.json new_resulting_settings_specification.json executor_name%n", ChainToSettings.class);
            return;
        }
        Path chainSpecificationFile = Paths.get(args[0], new String[0]);
        Path settingsSpecificationFile = Paths.get(args[1], new String[0]);
        String executorName = args[2];
        ExecutorFactory executorFactory = ExecutorFactory.newFactory(SESSION_ID);
        ChainSpecification chainSpecification = ChainSpecification.read(chainSpecificationFile);
        Chain chain = Chain.of(null, executorFactory, chainSpecification);
        ExecutorSpecification executorSpecification = new ExecutorSpecification();
        executorSpecification.setTo(chain);
        SettingsSpecification settingsSpecification = new SettingsSpecification();
        settingsSpecification.setId(UUID.randomUUID().toString());
        settingsSpecification.setCombineName("Combine " + executorName);
        settingsSpecification.setControls(executorSpecification.getControls());
        settingsSpecification.write(settingsSpecificationFile, new OpenOption[0]);
    }
}

