/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.settings;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.parameters.ValueType;
import net.algart.executors.api.settings.SettingsSpecification;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.json.Jsons;

public class SettingsBuilder
implements Cloneable {
    public static final boolean ABSOLUTE_PATHS_DEFAULT_VALUE = true;
    public static final String PATH_PARENT_FOLDER_SUFFIX = "_parent";
    public static final String PATH_FILE_NAME_SUFFIX = "_name";
    private final SettingsSpecification specification;
    private boolean absolutePaths = true;
    private boolean addSettingsClass = false;
    private boolean extractSubSettings = false;
    private volatile Object customSettingsInformation = null;

    protected SettingsBuilder(SettingsSpecification specification) {
        this.specification = Objects.requireNonNull(specification, "Null specification");
        this.specification.checkCompleteness();
    }

    public static SettingsBuilder read(Path specificationFile) throws IOException {
        return SettingsBuilder.of(SettingsSpecification.read(specificationFile));
    }

    public static SettingsBuilder of(SettingsSpecification specification) {
        return new SettingsBuilder(specification);
    }

    public boolean isAbsolutePaths() {
        return this.absolutePaths;
    }

    public SettingsBuilder setAbsolutePaths(boolean absolutePaths) {
        this.absolutePaths = absolutePaths;
        return this;
    }

    public boolean isAddSettingsClass() {
        return this.addSettingsClass;
    }

    public SettingsBuilder setAddSettingsClass(boolean addSettingsClass) {
        this.addSettingsClass = addSettingsClass;
        return this;
    }

    public boolean isExtractSubSettings() {
        return this.extractSubSettings;
    }

    public SettingsBuilder setExtractSubSettings(boolean extractSubSettings) {
        this.extractSubSettings = extractSubSettings;
        return this;
    }

    public Object getCustomSettingsInformation() {
        return this.customSettingsInformation;
    }

    public SettingsBuilder setCustomSettingsInformation(Object customSettingsInformation) {
        this.customSettingsInformation = customSettingsInformation;
        return this;
    }

    public SettingsSpecification specification() {
        return this.specification;
    }

    public Path specificationFile() {
        return this.specification.getSpecificationFile();
    }

    public String id() {
        return this.specification.getId();
    }

    public String splitId() {
        return this.specification.getSplitId();
    }

    public String getNamesId() {
        return this.specification.getGetNamesId();
    }

    public boolean isAutogeneratedCategory() {
        return this.specification.isAutogeneratedCategory();
    }

    public String category() {
        return this.specification.getCategory();
    }

    public String name() {
        return this.specification.getName();
    }

    public String combineName() {
        return this.specification.combineName();
    }

    public String splitName() {
        return this.specification.splitName();
    }

    public String className() {
        return this.specification.className();
    }

    public String getNamesName() {
        return this.specification.getNamesName();
    }

    public String combineDescription() {
        return this.specification.getCombineDescription();
    }

    public String splitDescription() {
        return this.specification.getSplitDescription();
    }

    public String getNamesDescription() {
        return this.specification.getGetNamesDescription();
    }

    public boolean hasPlatformId() {
        return this.specification.hasPlatformId();
    }

    public Set<String> tags() {
        return this.specification.getTags();
    }

    public String platformId() {
        return this.specification.getPlatformId();
    }

    public String platformCategory() {
        return this.specification.getPlatformCategory();
    }

    public Set<String> settingsKeySet() {
        return this.specification.controlKeySet();
    }

    public boolean hasPathControl() {
        return this.specification.hasPathControl();
    }

    public JsonObject buildDefault() {
        return this.buildFromExecutor(null, false);
    }

    public JsonObject build(Executor executor, JsonObject defaultSettings) {
        JsonObject result = this.build(executor);
        return defaultSettings == null ? result : Jsons.overrideEntries(defaultSettings, result);
    }

    public JsonObject build(Executor executor) {
        return this.buildFromExecutor(executor, true);
    }

    public JsonObject build(Parameters parameters) {
        return this.buildFromParametersAndPorts(null, parameters, null);
    }

    public void parseSettingsToParameters(Parameters parameters, JsonObject settings) {
        Objects.requireNonNull(parameters, "Null parameters");
        Objects.requireNonNull(settings, "Null settings");
        for (ControlSpecification control : this.specification.getControls().values()) {
            JsonValue jsonValue = (JsonValue)settings.get((Object)control.getName());
            if (jsonValue == null) continue;
            SettingsBuilder.setJsonValue(control, parameters, jsonValue);
        }
    }

    public void splitSettingsToOutputPorts(Executor executor, JsonObject settings) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(settings, "Null settings");
        for (ControlSpecification control : this.specification.getControls().values()) {
            Path fileName;
            String fileNamePort;
            Path parent;
            Path path;
            Object value;
            String name = SettingsBuilder.portName(control);
            if (!executor.hasOutputPort(name)) continue;
            ValueType valueType = control.getValueType();
            String jsonKey = control.key();
            JsonValue jsonValue = (JsonValue)settings.get((Object)jsonKey);
            if (jsonValue == null) {
                jsonValue = control.getDefaultJsonValue();
            }
            if (jsonValue == null) {
                jsonValue = valueType.emptyJsonValue();
            }
            assert (jsonValue != null);
            if (valueType.isSettings()) {
                JsonObject jo;
                JsonObject subSettings = jsonValue instanceof JsonObject ? (jo = (JsonObject)jsonValue) : Jsons.newEmptyJson();
                subSettings = Jsons.overrideOnlyExistingInBoth(subSettings, Jsons.extractSimpleValues(settings));
                value = Jsons.toPrettyString(subSettings);
            } else {
                value = valueType.toSmartParameter(jsonValue);
            }
            executor.getScalar(name).setTo(value);
            if (valueType != ValueType.STRING || !(value instanceof String) || !control.getEditionType().isPath()) continue;
            try {
                path = Paths.get((String)value, new String[0]);
            }
            catch (Exception ignored) {
                continue;
            }
            String parentFolderPort = name + PATH_PARENT_FOLDER_SUFFIX;
            if (executor.hasOutputPort(parentFolderPort) && (parent = path.getParent()) != null) {
                executor.getScalar(parentFolderPort).setTo(parent.toString());
            }
            if (!executor.hasOutputPort(fileNamePort = name + PATH_FILE_NAME_SUFFIX) || (fileName = path.getFileName()) == null) continue;
            executor.getScalar(fileNamePort).setTo(fileName.toString());
        }
    }

    public JsonObject overrideSettings(JsonObject executorSettings, JsonObject overridingParent) {
        String settingsName;
        JsonObject subSettings;
        Objects.requireNonNull(executorSettings, "Null executorSettings");
        Objects.requireNonNull(overridingParent, "Null overridingParent");
        if (overridingParent.isEmpty()) {
            return executorSettings;
        }
        if (this.extractSubSettings && (subSettings = SettingsBuilder.getSubSettingsByName(overridingParent, settingsName = this.name())) != null) {
            JsonObject onlyActual = Jsons.filterJson(subSettings, this.settingsKeySet());
            JsonObject overriddenBySubSettings = Jsons.overrideEntries(executorSettings, onlyActual);
            return SettingsBuilder.overrideEntriesExceptingGivenSettings(overriddenBySubSettings, overridingParent, settingsName);
        }
        return Jsons.overrideEntries(executorSettings, overridingParent);
    }

    public static JsonObject getSubSettingsByName(JsonObject parentSettings, String subSettingsName) {
        Objects.requireNonNull(subSettingsName, "Null sub-settings name");
        return SettingsBuilder.getSubSettingsByKey(parentSettings, ControlSpecification.settingsKey(subSettingsName));
    }

    public static JsonObject getSubSettingsByKey(JsonObject parentSettings, String subSettingsKey) {
        Objects.requireNonNull(parentSettings, "Null parent settings");
        Objects.requireNonNull(subSettingsKey, "Null sub-settings key");
        JsonValue subSettings = (JsonValue)parentSettings.get((Object)subSettingsKey);
        if (subSettings == null) {
            return null;
        }
        if (!(subSettings instanceof JsonObject)) {
            throw new JsonException("Cannot extract sub-settings \"" + subSettingsKey + "\" from the source JSON: this key does not correspond to sub-JSON - " + SettingsBuilder.toShortString(Jsons.toPrettyString(parentSettings)));
        }
        return (JsonObject)subSettings;
    }

    public static JsonObject overrideEntriesExceptingGivenSettings(JsonObject sourceJson, JsonObject overridingJson, String ... ignoredSettingsNames) {
        Objects.requireNonNull(sourceJson, "Null sourceJson");
        Objects.requireNonNull(overridingJson, "Null overridingJson");
        Set ignoredKeys = Arrays.stream(ignoredSettingsNames).map(ControlSpecification::settingsKey).collect(Collectors.toSet());
        JsonObjectBuilder builder = Jsons.createObjectBuilder(sourceJson);
        for (Map.Entry entry : overridingJson.entrySet()) {
            if (ignoredKeys.contains(entry.getKey())) continue;
            builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        return builder.build();
    }

    public static String portName(ControlSpecification controlSpecification) {
        return controlSpecification.getName();
    }

    public String toString() {
        return "settings (\"" + this.category() + "." + this.name() + "\")";
    }

    public SettingsBuilder clone() {
        try {
            return (SettingsBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private JsonObject buildFromExecutor(Executor executor, boolean useExecutorParameters) {
        Parameters parameters = useExecutorParameters ? executor.parameters() : null;
        Map<String, Port> inputPortsMap = useExecutorParameters ? executor.inputPortsMap() : null;
        return this.buildFromParametersAndPorts(executor, parameters, inputPortsMap);
    }

    private JsonObject buildFromParametersAndPorts(Executor executor, Parameters parameters, Map<String, Port> inputPortsMap) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (this.addSettingsClass) {
            builder.add("$class", this.specification.className());
        }
        for (ControlSpecification control : this.specification.getControls().values()) {
            JsonValue jsonValue = SettingsBuilder.getJsonValue(control, parameters, inputPortsMap);
            assert (jsonValue != null);
            if (executor != null) {
                jsonValue = this.replaceToAbsolutePath(executor, control, jsonValue);
            }
            String jsonKey = control.key();
            builder.add(jsonKey, jsonValue);
        }
        return builder.build();
    }

    private static JsonValue getJsonValue(ControlSpecification control, Parameters parameters, Map<String, Port> inputPortsMap) {
        SScalar scalar;
        Port inputPort;
        String name = control.getName();
        ValueType valueType = control.getValueType();
        JsonValue jsonValue = null;
        if (inputPortsMap != null && valueType.isSettings() && (inputPort = inputPortsMap.get(name)) != null && (scalar = inputPort.getData(SScalar.class, true)).isInitialized()) {
            String s = scalar.getValueOrDefault("").trim();
            jsonValue = s.isEmpty() ? Jsons.newEmptyJson() : Jsons.toJson(s);
            return jsonValue;
        }
        if (parameters != null && parameters.containsKey(name)) {
            jsonValue = valueType.toJsonValue(parameters, name);
        }
        if (jsonValue == null) {
            jsonValue = control.getDefaultJsonValue();
        }
        if (jsonValue == null) {
            jsonValue = valueType.emptyJsonValue();
        }
        return jsonValue;
    }

    private static void setJsonValue(ControlSpecification control, Parameters parameters, JsonValue jsonValue) {
        String name = control.getName();
        ValueType valueType = control.getValueType();
        Object parameterValue = valueType.toParameter(jsonValue);
        if (parameterValue == null) {
            parameterValue = ValueType.STRING.toParameter(jsonValue);
        }
        if (parameterValue != null) {
            parameters.put(name, parameterValue);
        }
    }

    private JsonValue replaceToAbsolutePath(Executor executor, ControlSpecification control, JsonValue jsonValue) {
        assert (jsonValue != null);
        if (control.getValueType() == ValueType.STRING && control.getEditionType().isPath() && this.absolutePaths) {
            assert (jsonValue instanceof JsonString) : "Invalid " + String.valueOf(control) + ": did not check default value";
            String path = ((JsonString)jsonValue).getString().trim();
            if (!path.isEmpty()) {
                path = PathPropertyReplacement.translatePropertiesAndCurrentDirectory(path, executor).toString();
            }
            jsonValue = Jsons.stringValue(path);
        }
        return jsonValue;
    }

    private static String toShortString(Object value) {
        String result = String.valueOf(value);
        return result.length() > 512 ? result.substring(0, 512) + "..." : result;
    }
}

