/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.mappings.core;

import jakarta.json.JsonObject;
import java.util.Locale;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.mappings.MappingBuilder;
import net.algart.executors.api.mappings.core.UseMapping;
import net.algart.json.Jsons;

public class MappingExecutor
extends Executor
implements ReadOnlyExecutionInput {
    public static final String MAPPING = "mapping";
    public static final String OUTPUT_KEYS = "keys";
    private volatile MappingBuilder mappingBuilder = null;

    public MappingExecutor() {
        this.setDefaultOutputScalar(MAPPING);
        this.addOutputScalar(OUTPUT_KEYS);
        this.disableOnChangeParametersAutomatic();
    }

    public String build() {
        this.execute();
        String s = this.getScalar(MAPPING).getValue();
        if (s == null) {
            throw new IllegalStateException("MappingExecutor does not return any mapping");
        }
        return s;
    }

    public JsonObject buildJson() {
        return Jsons.toJson(this.build());
    }

    @Override
    public void process() {
        long t1 = MappingExecutor.debugTime();
        MappingBuilder mappingBuilder = this.mappingBuilder();
        JsonObject mappingJson = mappingBuilder.build(this);
        String mappingString = Jsons.toPrettyString(mappingJson);
        this.getScalar(MAPPING).setTo(mappingString);
        this.getScalar(OUTPUT_KEYS).setTo(String.join((CharSequence)"\n", mappingJson.keySet()));
        long t2 = MappingExecutor.debugTime();
        MappingExecutor.logDebug(() -> String.format(Locale.US, "Building mapping \"%s\": %.3f ms%s", mappingBuilder.name(), (double)(t2 - t1) * 1.0E-6, LOGGABLE_TRACE ? "\n" + mappingString : ""));
    }

    public MappingBuilder mappingBuilder() {
        String sessionId = this.getSessionId();
        String executorId = this.getExecutorId();
        if (sessionId == null) {
            throw new IllegalStateException("Cannot find mapping worker: session ID is not set");
        }
        if (executorId == null) {
            throw new IllegalStateException("Cannot find mapping worker: executor ID is not set");
        }
        MappingBuilder mappingBuilder = this.mappingBuilder;
        if (mappingBuilder == null) {
            mappingBuilder = UseMapping.mappingLoader().registeredWorker(sessionId, executorId);
            this.mappingBuilder = mappingBuilder.clone();
        }
        return mappingBuilder;
    }

    @Override
    public String toString() {
        return "Executor of " + String.valueOf(this.mappingBuilder != null ? this.mappingBuilder : "some non-initialized mapping");
    }

    @Override
    protected boolean skipStandardAutomaticParameters() {
        return true;
    }
}

