/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.jep;

import java.awt.image.BufferedImage;
import java.lang.runtime.SwitchBootstraps;
import java.nio.Buffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import jep.DirectNDArray;
import jep.Interpreter;
import jep.JepConfig;
import jep.JepException;
import jep.NDArray;
import jep.python.PyObject;
import net.algart.arrays.Arrays;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.jep.Jep2SMat;
import net.algart.executors.api.jep.Jep2SNumbers;
import net.algart.executors.api.jep.JepPlatforms;
import net.algart.jep.JepPerformer;
import net.algart.jep.JepPerformerContainer;
import net.algart.jep.additions.AtomicPyObject;
import net.algart.jep.additions.JepExtendedConfiguration;
import net.algart.jep.additions.JepInterpretation;
import net.algart.jep.additions.JepNumpyIntegrationException;
import net.algart.jep.additions.JepType;
import net.algart.multimatrix.MultiMatrix;

public class JepAPI {
    public static final boolean REQUIRE_NUMPY_INTEGRATION = Arrays.SystemSettings.getBooleanProperty((String)"net.algart.jep.numpyIntegrationRequired", (boolean)true);
    private static final AtomicBoolean NUMPY_INTEGRATION_PROBLEM_LOGGED = new AtomicBoolean(false);
    private static final System.Logger LOG = System.getLogger(JepAPI.class.getName());
    public static final String STANDARD_API_PACKAGE = "pyalgart";
    public static final String STANDARD_API_MODULE = "pyalgart.api";
    public static final String STANDARD_API_MODULE_ALIAS = "pya";
    public static final String STANDARD_API_PARAMETERS_CLASS = "pyalgart.api.Parameters";
    public static final String STANDARD_API_INPUTS_CLASS = "pyalgart.api.Inputs";
    public static final String STANDARD_API_OUTPUTS_CLASS = "pyalgart.api.Outputs";
    public static final String STANDARD_API_ENVIRONMENT_VARIABLE = "_env";
    public static final String STANDARD_API_ENVIRONMENT_FIELD = "_env";
    public static final String STANDARD_API_EXECUTOR_FIELD = "_executor";
    public static final String STANDARD_API_PARAMETER_EXECUTOR = "executor";
    public static final String STANDARD_API_PARAMETER_PLATFORM = "platform";
    public static final String STANDARD_API_PARAMETER_WORKING_DIRECTORY = "working_dir";
    public static final String STANDARD_API_PARAMETER_CONTEXT_PATH = "context_path";
    public static final String STANDARD_API_JEP_VERIFIER = "pyalgart.jep_verifier";
    public static final String STANDARD_API_JEP_VERIFIER_FUNCTION = "pyalgart.jep_verifier.returnTestNdArray";
    public static final List<String> STANDARD_STARTUP_SUB_INTERPRETER = List.of("import pyalgart.api");
    public static final List<String> STANDARD_STARTUP_NORMAL = List.of("import numpy", "import pyalgart.api as pya", "import pyalgart.jep_verifier");

    private JepAPI() {
    }

    public static JepAPI getInstance() {
        return new JepAPI();
    }

    public static JepPerformerContainer newContainer(JepType type) {
        return JepAPI.initialize(JepPerformerContainer.newContainer(type));
    }

    public void loadParameters(Executor executor, AtomicPyObject parameters) {
        this.loadParameters(executor.parameters(), parameters);
    }

    public void loadSystemParameters(Executor executor, AtomicPyObject parameters, Path workingDirectory) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(parameters, "Null parameters");
        try (AtomicPyObject environment = parameters.getAtomic("_env");){
            this.loadEnvironment(executor, environment, workingDirectory);
        }
        parameters.setAttribute(STANDARD_API_EXECUTOR_FIELD, executor);
    }

    public void loadParameters(Map<String, Object> parametersMap, AtomicPyObject parameters) {
        Objects.requireNonNull(parameters, "Null parameters");
        Objects.requireNonNull(parametersMap, "Null parametersMap");
        for (Map.Entry<String, Object> entry : parametersMap.entrySet()) {
            parameters.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public void initializedGlobalEnvironment(JepPerformer performer, Executor executor, Path workingDirectory) {
        Objects.requireNonNull(performer, "Null performer");
        if (performer.type().isSubInterpreter()) {
            return;
        }
        try (AtomicPyObject environment = performer.getObject("pyalgart.api._env");){
            this.loadEnvironment(executor, environment, workingDirectory);
        }
    }

    public void loadEnvironment(Executor executor, AtomicPyObject env, Path workingDirectory) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(env, "Null environment");
        env.setAttribute(STANDARD_API_PARAMETER_EXECUTOR, executor);
        env.setAttribute(STANDARD_API_PARAMETER_PLATFORM, executor.executorPlatform());
        Path directory = workingDirectory != null ? workingDirectory : executor.getCurrentDirectory();
        env.setAttribute(STANDARD_API_PARAMETER_WORKING_DIRECTORY, directory == null ? null : directory.toString());
        Path contextPath = executor.contextPath();
        env.setAttribute(STANDARD_API_PARAMETER_CONTEXT_PATH, contextPath == null ? null : contextPath.toString());
    }

    public void readInputPorts(JepPerformer performer, Collection<Port> inputPorts, AtomicPyObject inputs) {
        Objects.requireNonNull(inputs, "Null inputs");
        Objects.requireNonNull(inputPorts, "Null inputPorts");
        for (Port port : inputPorts) {
            inputs.setAttribute(port.getName(), this.readInputPort(performer, port));
        }
    }

    public void writeOutputPorts(JepPerformer performer, Collection<Port> outputPorts, AtomicPyObject outputs) {
        Objects.requireNonNull(outputs, "Null outputs");
        Objects.requireNonNull(outputPorts, "Null outputPorts");
        for (Port port : outputPorts) {
            this.writeOutputPort(performer, port, outputs.getAttributeOrNull(port.getName()));
        }
    }

    public Object readInputPort(JepPerformer performer, Port port) {
        Objects.requireNonNull(port, "Null port");
        if (!port.isInput()) {
            throw new IllegalArgumentException("Non-input port: " + String.valueOf(port));
        }
        Data data = port.getData();
        DirectNDArray<Buffer> value = null;
        if (data != null && data.isInitialized()) {
            value = switch (data.type()) {
                default -> throw new MatchException(null, null);
                case DataType.SCALAR -> this.loadScalarToJep(performer, port);
                case DataType.NUMBERS -> this.loadNumbersToJep(performer, port);
                case DataType.MAT -> this.loadMatToJep(performer, port);
            };
        }
        return value;
    }

    public void writeOutputPort(JepPerformer performer, Port port, Object value) {
        this.writeOutputPort(performer, port, value, false);
    }

    public void writeOutputPort(JepPerformer performer, Port port, Object value, boolean preserveExisting) {
        Objects.requireNonNull(port, "Null port");
        if (!port.isOutput()) {
            throw new IllegalArgumentException("Non-output port: " + String.valueOf(port));
        }
        if (preserveExisting && port.hasData()) {
            return;
        }
        DataType dataType = port.getDataType();
        if (value == null) {
            port.removeData();
        } else if (dataType != null) {
            switch (dataType) {
                case SCALAR: {
                    this.storeScalarFromJep(performer, port, value);
                    break;
                }
                case NUMBERS: {
                    this.storeNumbersFromJep(performer, port, value);
                    break;
                }
                case MAT: {
                    this.storeMatFromJep(performer, port, value);
                }
            }
        }
    }

    public AtomicPyObject newAPIObject(JepPerformer performer, String className) {
        try {
            return performer.newObject(className, new Object[0]);
        }
        catch (JepException e) {
            throw new JepException("Cannot create an empty instance of Python class \"" + className + "\"; maybe, the Python code does not import/declare this class. Note that standard classes from \"pyalgart.api\" module are imported automatically", (Throwable)e);
        }
    }

    public String loadScalarToJep(JepPerformer performer, Port port) {
        Objects.requireNonNull(performer, "Null performer");
        Objects.requireNonNull(port, "Null port");
        return port.getData(SScalar.class, false).getValue();
    }

    public void storeScalarFromJep(JepPerformer performer, Port port, Object value) {
        Objects.requireNonNull(performer, "Null performer");
        Objects.requireNonNull(port, "Null port");
        value = JepAPI.closePyObject(performer, value);
        port.getData(SScalar.class, true).setTo(value);
    }

    public Object loadNumbersToJep(JepPerformer performer, Port port) {
        Objects.requireNonNull(performer, "Null performer");
        Objects.requireNonNull(port, "Null port");
        SNumbers numbers = port.getData(SNumbers.class, false);
        if (JepAPI.isNumpyIntegration(performer.configuration())) {
            return Jep2SNumbers.toNDArray(numbers);
        }
        JepAPI.checkNumbers(numbers);
        return numbers.getArray();
    }

    public void storeNumbersFromJep(JepPerformer performer, Port port, Object value) {
        Objects.requireNonNull(performer, "Null performer");
        Objects.requireNonNull(port, "Null port");
        SNumbers resultNumbers = port.getData(SNumbers.class, true);
        if (value instanceof SNumbers) {
            resultNumbers.setTo((SNumbers)value);
        } else {
            JepAPI.checkJepNDArray(port, value, false, true);
            Jep2SNumbers.setToArray(resultNumbers, value);
        }
    }

    public DirectNDArray<Buffer> loadMatToJep(JepPerformer performer, Port port) {
        Objects.requireNonNull(performer, "Null performer");
        Objects.requireNonNull(port, "Null port");
        SMat matrix = port.getData(SMat.class, false);
        if (JepAPI.isNumpyIntegration(performer.configuration())) {
            return Jep2SMat.toNDArray(matrix);
        }
        throw new IllegalArgumentException("Cannot pass the matrix\n    " + String.valueOf(matrix) + "\nto Python inputs: numpy.ndarray should be used in this case,\n but there is an integration problem between Python packages \"jep\" and \"numpy\".\nTo install \"jep\" with all required packages, please use the following command:\n   py -m pip install --upgrade setuptools wheel numpy\n   py -m pip install --no-cache-dir --force-reinstall --no-build-isolation jep==4.3.1\nNote that \"numpy\" must be installed BEFORE \"jep\" for correct integration between \"jep\" and \"numpy\".\nThe version 4.3.1 matches to the current Java \"jep\" library version.\nBefore installing \"jep\", please set the environment variable JAVA_HOME to a path containing the JDK.");
    }

    public void storeMatFromJep(JepPerformer performer, Port port, Object value) {
        Objects.requireNonNull(performer, "Null performer");
        Objects.requireNonNull(port, "Null port");
        Objects.requireNonNull(value, "Null value for storing in port " + port.getName());
        SMat resultMat = port.getData(SMat.class, true);
        if (JepAPI.isNumpyIntegration(performer.configuration())) {
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SMat.class, BufferedImage.class, MultiMatrix.class}, (Object)object2, n)) {
                case 0: {
                    SMat sMat = (SMat)object2;
                    resultMat.setTo(sMat);
                    break;
                }
                case 1: {
                    BufferedImage bufferedImage = (BufferedImage)object2;
                    resultMat.setTo(bufferedImage);
                    break;
                }
                case 2: {
                    MultiMatrix multiMatrix = (MultiMatrix)object2;
                    resultMat.setTo(multiMatrix);
                    break;
                }
                default: {
                    JepAPI.checkJepNDArray(port, value, true, false);
                    Jep2SMat.setToArray(resultMat, value);
                    break;
                }
            }
        } else {
            throw new IllegalStateException("Cannot load a matrix from Python outputs: numpy.ndarray should be used in this case,\n but there is an integration problem between Python packages \"jep\" and \"numpy\".\nTo install \"jep\" with all required packages, please use the following command:\n   py -m pip install --upgrade setuptools wheel numpy\n   py -m pip install --no-cache-dir --force-reinstall --no-build-isolation jep==4.3.1\nNote that \"numpy\" must be installed BEFORE \"jep\" for correct integration between \"jep\" and \"numpy\".\nThe version 4.3.1 matches to the current Java \"jep\" library version.\nBefore installing \"jep\", please set the environment variable JAVA_HOME to a path containing the JDK.");
        }
    }

    public static JepPerformerContainer initialize(JepPerformerContainer performerContainer) {
        Objects.requireNonNull(performerContainer, "Null performerContainer");
        return performerContainer.setConfigurationSupplier(() -> JepAPI.initializeConfiguration(performerContainer));
    }

    public static JepExtendedConfiguration initializeConfiguration(JepPerformerContainer performerContainer) {
        JepExtendedConfiguration configuration = new JepExtendedConfiguration();
        JepType type = performerContainer.type();
        configuration.addIncludePaths(JepPlatforms.pythonRootFolders().toArray(new String[0]));
        configuration.redirectStdout(System.out);
        configuration.redirectStdErr(System.err);
        configuration.setStartupCode(JepAPI.initializingJepStartupCode(type));
        configuration.setVerifier(JepAPI.standardJepVerifier(type));
        LOG.log(System.Logger.Level.TRACE, "Configuring " + String.valueOf(performerContainer) + ": " + String.valueOf((Object)configuration));
        return configuration;
    }

    public static List<String> initializingJepStartupCode(JepType type) {
        Objects.requireNonNull(type, "Null JEP interpretation mode");
        return type.isSubInterpreter() ? STANDARD_STARTUP_SUB_INTERPRETER : STANDARD_STARTUP_NORMAL;
    }

    public static VerificationStatus verifyPure(Interpreter jepInterpreter, JepConfig configuration) {
        return null;
    }

    public static VerificationStatus verifyNormal(Interpreter jepInterpreter, JepConfig configuration) {
        try {
            JepInterpretation.checkNumpyIntegration(jepInterpreter, STANDARD_API_JEP_VERIFIER_FUNCTION);
            return new VerificationStatus(true);
        }
        catch (JepNumpyIntegrationException e) {
            if (REQUIRE_NUMPY_INTEGRATION) {
                throw e;
            }
            System.Logger.Level level = NUMPY_INTEGRATION_PROBLEM_LOGGED.getAndSet(true) ? System.Logger.Level.DEBUG : System.Logger.Level.WARNING;
            LOG.log(level, e.getMessage());
            return new VerificationStatus(false);
        }
    }

    public static boolean isNumpyIntegrationVerified(JepConfig configuration) {
        JepExtendedConfiguration extendedConfiguration;
        return configuration instanceof JepExtendedConfiguration && (extendedConfiguration = (JepExtendedConfiguration)configuration).getVerificationStatus() instanceof VerificationStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNumpyIntegration(JepConfig configuration) {
        if (!(configuration instanceof JepExtendedConfiguration)) return false;
        JepExtendedConfiguration extendedConfiguration = (JepExtendedConfiguration)configuration;
        Object object = extendedConfiguration.getVerificationStatus();
        if (!(object instanceof VerificationStatus)) return false;
        VerificationStatus verificationStatus = (VerificationStatus)object;
        try {
            boolean bl2;
            boolean numpyIntegration = bl2 = verificationStatus.numpyAvailable();
            if (!numpyIntegration) return false;
            return true;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static JepExtendedConfiguration.Verifier standardJepVerifier(JepType type) {
        return type.isSubInterpreter() ? JepAPI::verifyPure : JepAPI::verifyNormal;
    }

    private static Object closePyObject(JepPerformer performer, Object value) {
        if (value instanceof PyObject) {
            PyObject pyObject = (PyObject)value;
            try (AtomicPyObject atomicObject = performer.wrapObject(pyObject);){
                value = atomicObject.toString();
            }
        }
        return value;
    }

    private static void checkJepNDArray(Port port, Object value, boolean allowDirectArray, boolean allowJavaArrays) {
        Objects.requireNonNull(value, "Null value for storing in port " + port.getName());
        if (allowJavaArrays && value.getClass().isArray()) {
            return;
        }
        if (!(value instanceof NDArray || allowDirectArray && value instanceof DirectNDArray)) {
            throw new JepException("Invalid type of property \"" + port.getName() + "\" in Python outputs: numpy.ndarray expected, but actual Java type is \"" + value.getClass().getCanonicalName() + "\"");
        }
    }

    private static void checkNumbers(SNumbers numbers) {
        Objects.requireNonNull(numbers, "Null numbers");
        if (!numbers.isInitialized()) {
            throw new IllegalArgumentException("Not initialized numbers");
        }
        if (numbers.getBlockLength() != 1) {
            throw new IllegalArgumentException("Cannot pass numbers with " + numbers.getBlockLength() + " > 1 columns\nto Python inputs: numpy.ndarray should be used in this case,\n but there is an integration problem between Python packages \"jep\" and \"numpy\".\nTo install \"jep\" with all required packages, please use the following command:\n   py -m pip install --upgrade setuptools wheel numpy\n   py -m pip install --no-cache-dir --force-reinstall --no-build-isolation jep==4.3.1\nNote that \"numpy\" must be installed BEFORE \"jep\" for correct integration between \"jep\" and \"numpy\".\nThe version 4.3.1 matches to the current Java \"jep\" library version.\nBefore installing \"jep\", please set the environment variable JAVA_HOME to a path containing the JDK.");
        }
    }

    public record VerificationStatus(boolean numpyAvailable) {
    }
}

