/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.jep;

import java.util.Arrays;
import java.util.Objects;
import jep.NDArray;
import net.algart.executors.api.data.SNumbers;

public class Jep2SNumbers {
    private Jep2SNumbers() {
    }

    public static NDArray<Object> toNDArray(SNumbers numbers) {
        Objects.requireNonNull(numbers, "Null numbers");
        if (!numbers.isInitialized()) {
            throw new IllegalArgumentException("Not initialized numbers");
        }
        int[] dimensions = new int[]{numbers.n(), numbers.getBlockLength()};
        return new NDArray(numbers.getArray(), numbers.isUnsigned(), dimensions);
    }

    public static SNumbers toSNumbers(SNumbers numbers) {
        return new SNumbers().setTo(numbers);
    }

    public static SNumbers setToArray(SNumbers result, Object array) {
        Objects.requireNonNull(result, "Null result");
        Objects.requireNonNull(array, "Null array");
        NDArray<?> ndArray = Jep2SNumbers.wrapUsualArray(array);
        int[] dimensions = ndArray.getDimensions();
        if (dimensions.length > 2) {
            throw new IllegalArgumentException("Cannot convert array to SNumbers: number of dimensions is greater than 2 " + Arrays.toString(dimensions));
        }
        result.setToArray(ndArray.getData(), dimensions.length == 1 ? 1 : dimensions[1]);
        return result;
    }

    private static NDArray<?> wrapUsualArray(Object array) {
        if (array instanceof NDArray) {
            return (NDArray)array;
        }
        Class<?> c = array.getClass();
        if (c.isArray()) {
            return new NDArray(array, net.algart.arrays.Arrays.isUnsignedElementType(c.getComponentType()));
        }
        throw new UnsupportedOperationException("Unsupported type of array: " + array.getClass().getCanonicalName() + " (Java array or NDArray/DirectNDArray expected)");
    }
}

