/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.core;

import java.util.Locale;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.graalvm.js.JSCaller;
import net.algart.executors.api.graalvm.js.core.UseJS;
import org.graalvm.polyglot.Value;

public class InterpretJS
extends Executor
implements ReadOnlyExecutionInput {
    private volatile JSCaller jsCaller = null;

    public InterpretJS() {
        this.disableOnChangeParametersAutomatic();
    }

    @Override
    public void initialize() {
        this.useVisibleResultParameter();
        long t1 = InterpretJS.debugTime();
        this.jsCaller().initialize();
        long t2 = InterpretJS.debugTime();
        InterpretJS.logDebug(() -> String.format(Locale.US, "JS module \"%s\" initialized in %.3f ms", this.jsCaller.name(), (double)(t2 - t1) * 1.0E-6));
    }

    @Override
    public void process() {
        long t1 = System.nanoTime();
        JSCaller jsCaller = this.jsCaller();
        Value parameters = jsCaller.loadParameters(this);
        Value inputs = jsCaller.readInputPorts(this);
        Value outputs = jsCaller.createOutputs();
        long t2 = InterpretJS.debugTime();
        Value result = jsCaller.callJS(parameters, inputs, outputs);
        long t3 = InterpretJS.debugTime();
        jsCaller.writeOutputPorts(this, outputs);
        jsCaller.writeOptionalOutputPort(this, DEFAULT_OUTPUT_PORT, result, true);
        long t4 = InterpretJS.debugTime();
        this.setSystemOutputs();
        InterpretJS.logDebug(() -> String.format(Locale.US, "JS module \"%s\" executed in %.5f ms: %.6f ms loading inputs + %.6f ms calling + %.6f ms returning outputs", jsCaller.name(), (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6));
    }

    public JSCaller jsCaller() {
        String sessionId = this.getSessionId();
        String executorId = this.getExecutorId();
        if (sessionId == null) {
            throw new IllegalStateException("Cannot find JavaScript worker: session ID is not set");
        }
        if (executorId == null) {
            throw new IllegalStateException("Cannot find JavaScript worker: executor ID is not set");
        }
        JSCaller jsCaller = this.jsCaller;
        if (jsCaller == null) {
            jsCaller = UseJS.jsCallerLoader().registeredWorker(sessionId, executorId);
            this.jsCaller = jsCaller = jsCaller.clone();
        }
        return jsCaller;
    }

    @Override
    public void close() {
        JSCaller jsCaller = this.jsCaller;
        if (jsCaller != null) {
            this.jsCaller = null;
            jsCaller.close();
        }
        super.close();
    }

    @Override
    protected boolean skipStandardAutomaticParameters() {
        return true;
    }

    private void setSystemOutputs() {
    }
}

