/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js;

import java.nio.file.Path;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.graalvm.GraalAPI;
import net.algart.executors.api.graalvm.js.JSSpecification;
import net.algart.graalvm.GraalPerformer;
import net.algart.graalvm.GraalPerformerContainer;
import net.algart.graalvm.GraalSourceContainer;
import net.algart.graalvm.JSInterpretation;
import org.graalvm.polyglot.Value;

public final class JSCaller
implements Cloneable,
AutoCloseable {
    private static final boolean REUSE_SINGLE_THREAD_FOR_ALL_INSTANCES = false;
    private final JSSpecification specification;
    private final Path workingDirectory;
    private final JSSpecification.JS js;
    private volatile GraalPerformerContainer.Local performerContainer;
    private final GraalAPI graalAPI = GraalAPI.getInstance().setConvertInputScalarToNumber(false).setConvertInputNumbersToArray(false).setConvertOutputIntegersToBriefForm(true);
    private final GraalSourceContainer importCode = GraalSourceContainer.newLiteralContainer();
    private volatile Value mainFunction = null;
    private volatile Value createEmptyObjectFunction = null;
    private final Object lock = new Object();

    private JSCaller(JSSpecification specification, Path workingDirectory) {
        this.specification = Objects.requireNonNull(specification, "Null specification");
        this.workingDirectory = Objects.requireNonNull(workingDirectory, "Null workingDirectory");
        this.js = specification.getJS();
        if (this.js == null) {
            Path file = specification.getSpecificationFile();
            throw new IllegalArgumentException("JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + " is not a JS executor configuration: no \"JS\" section");
        }
        this.createPerformerContainer();
    }

    public static JSCaller of(JSSpecification specification, Path workingDirectory) {
        return new JSCaller(specification, workingDirectory);
    }

    public JSSpecification specification() {
        return this.specification;
    }

    public String executorId() {
        return this.specification.getId();
    }

    public String name() {
        return this.specification.getName();
    }

    public String platformId() {
        return this.specification.getPlatformId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraalPerformer performer() {
        Object object = this.lock;
        synchronized (object) {
            return this.performerContainer.performer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.lock;
        synchronized (object) {
            String functionName = this.js.getFunction();
            String importing = JSInterpretation.importJSCode(this.js.getModule(), functionName);
            GraalPerformer performer = this.performer();
            String script = JSInterpretation.addJSExportFunction(importing, functionName, performer);
            this.importCode.setModuleJS(script, "importing");
            Value module = performer.perform(this.importCode);
            this.mainFunction = JSInterpretation.addedJSModuleMember(module, functionName, performer);
            this.createEmptyObjectFunction = GraalAPI.JS.storedCreateEmptyObjectFunction(performer);
        }
    }

    public Value loadParameters(Executor executor) {
        Objects.requireNonNull(executor, "Null executor");
        Value parameters = this.createEmptyObjectFunction.execute(new Object[0]);
        this.graalAPI.loadSystemParameters(executor, parameters, null);
        this.graalAPI.loadParameters(executor, parameters);
        return parameters;
    }

    public Value readInputPorts(Executor executor) {
        Objects.requireNonNull(executor, "Null executor");
        Value inputs = this.createEmptyObjectFunction.execute(new Object[0]);
        this.graalAPI.readInputPorts(executor.inputPorts(), inputs);
        return inputs;
    }

    public Value createOutputs() {
        return this.createEmptyObjectFunction.execute(new Object[0]);
    }

    public void writeOutputPorts(Executor executor, Value outputs) {
        Objects.requireNonNull(executor, "Null executor");
        this.graalAPI.writeOutputPorts(executor.outputPorts(), outputs);
    }

    public void writeOptionalOutputPort(Executor executor, String portName, Value value, boolean preserveExisting) {
        Port outputPort;
        Objects.requireNonNull(executor, "Null executor");
        if (value != null && (outputPort = executor.getOutputPort(portName)) != null) {
            this.graalAPI.writeOutputPort(outputPort, value, preserveExisting);
        }
    }

    public Value callJS(Value parameters, Value inputs, Value outputs) {
        return this.mainFunction.execute(new Object[]{parameters, inputs, outputs});
    }

    public JSCaller clone() {
        try {
            JSCaller clone = (JSCaller)super.clone();
            clone.createPerformerContainer();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closePerformerContainer();
        }
    }

    private void closePerformerContainer() {
        this.mainFunction = null;
        this.performerContainer.freeResources();
    }

    private void createPerformerContainer() {
        this.performerContainer = GraalPerformerContainer.getLocalAllAccess(this.workingDirectory);
        GraalAPI.JS.initializeJS(this.performerContainer);
    }
}

