/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains.core;

import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.core.UseChain;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.core.CombineChainSettings;
import net.algart.executors.api.system.ExecutorFactory;

public abstract class ChainExecutor
extends Executor {
    private volatile Chain chain = null;

    public Chain chain() {
        Chain chain = this.chain;
        if (chain == null) {
            this.chain = chain = ChainExecutor.registeredChain(this.getSessionId(), this.getExecutorId());
        }
        return chain;
    }

    public ExecutorFactory executorFactory() {
        return this.chain().executorFactory();
    }

    public SettingsBuilder settingsBuilder() {
        return this.chain().settingsBuilder();
    }

    public CombineChainSettings newCombine() {
        return this.chain().newCombine();
    }

    @Override
    public void close() {
        Chain chain = this.chain;
        if (chain != null) {
            this.chain = null;
            chain.freeResources();
        }
        super.close();
    }

    @Override
    public String toString() {
        return "Executor of " + String.valueOf(this.chain != null ? this.chain : "some non-initialized chain");
    }

    public static Chain registeredChain(String sessionId, String executorId) {
        Objects.requireNonNull(sessionId, "Cannot find chain worker: session ID is not set");
        Objects.requireNonNull(executorId, "Cannot find chain worker: executor ID is not set");
        Chain chain = UseChain.chainLoader().registeredWorker(sessionId, executorId);
        chain = chain.cleanCopy();
        return chain;
    }

    public static void copyInputToOutput(Executor executor) {
        for (Port input : executor.inputPorts()) {
            String inputName = input.getName();
            if (inputName == null) continue;
            Port outputPort = executor.getOutputPort(inputName);
            if (outputPort == null && inputName.equals(executor.defaultInputPortName())) {
                outputPort = executor.getOutputPort(executor.defaultOutputPortName());
            }
            if (outputPort == null || outputPort.getDataType() != input.getDataType()) continue;
            outputPort.getData().setTo(input.getData());
        }
    }
}

