/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains;

import java.io.IOError;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import net.algart.arrays.Arrays;
import net.algart.contexts.InterruptionException;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.ExecutionStatus;
import net.algart.executors.api.Executor;
import net.algart.executors.api.HighLevelException;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.ChainInputPort;
import net.algart.executors.api.chains.ChainOutputPort;
import net.algart.executors.api.chains.ChainParameter;
import net.algart.executors.api.chains.ChainPort;
import net.algart.executors.api.chains.ChainPortKey;
import net.algart.executors.api.chains.ChainPortType;
import net.algart.executors.api.chains.ChainRunningException;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.ExecutionStage;
import net.algart.executors.api.system.ExecutorExpectedException;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.PortSpecification;
import net.algart.executors.api.system.RecursiveDependenceException;
import net.algart.executors.modules.core.common.FunctionTiming;
import net.algart.executors.modules.core.common.TimingStatistics;

public final class ChainBlock {
    public static final boolean SUPPORT_ALIASES = Arrays.SystemSettings.getBooleanProperty((String)"net.algart.executors.api.chains.aliases", (boolean)true);
    public static final boolean WARNING_FOR_ALIASES = Arrays.SystemSettings.getBooleanProperty((String)"net.algart.executors.api.chains.warningForAliases", (boolean)false);
    private static final String DEFAULT_CHAIN_PORT_CAPTION_PATTERN = "[$$$]";
    private static final boolean ANALYSE_CONDITIONAL_INPUTS = Arrays.SystemSettings.getBooleanProperty((String)"net.algart.executors.api.analyseConditionalInputs", (boolean)true);
    private static final System.Logger LOG = System.getLogger(ChainBlock.class.getName());
    Chain chain;
    final String id;
    private final String executorId;
    private final ExecutorSpecification executorSpecification;
    ChainSpecification.Block blockSpecification = null;
    private ExecutionStage executionStage = ExecutionStage.RUN_TIME;
    private boolean enabled = true;
    private String systemName = null;
    private boolean standardInput = false;
    private boolean standardOutput = false;
    private boolean standardData = false;
    private String standardInputOutputPortName = null;
    volatile ExecutionBlock executor = null;
    private final Object lock = new Object();
    final Map<String, ChainParameter> parameters = new LinkedHashMap<String, ChainParameter>();
    final Map<ChainPortKey, ChainInputPort> inputPorts = new LinkedHashMap<ChainPortKey, ChainInputPort>();
    final Map<ChainPortKey, ChainOutputPort> outputPorts = new LinkedHashMap<ChainPortKey, ChainOutputPort>();
    private final AtomicInteger numberOfExecutionsForAssertion = new AtomicInteger(0);
    private final AtomicBoolean needToReset = new AtomicBoolean(true);
    private volatile boolean ready;
    private volatile boolean readyAlwaysNecessaryInputs;
    private volatile boolean dataFreed;
    private volatile boolean closed;
    private volatile boolean checkingNow;
    private FunctionTiming timing;
    private volatile int executionOrder;

    private ChainBlock(Chain chain, String id, String executorId) {
        this.chain = Objects.requireNonNull(chain, "Null containing chain");
        this.id = Objects.requireNonNull(id, "Null block id");
        this.executorId = Objects.requireNonNull(executorId, "Null block executorId");
        ExecutorFactory factory = chain.executorFactory();
        this.executorSpecification = factory.getSpecification(executorId);
        this.initialize();
    }

    private ChainBlock(ChainBlock block, Chain newChain) {
        this(block);
        Objects.requireNonNull(newChain, "Null new chain");
        this.chain = newChain;
    }

    private ChainBlock(ChainBlock block) {
        Objects.requireNonNull(block, "Null chain block");
        this.chain = block.chain;
        this.id = block.id;
        this.executorId = block.executorId;
        this.executorSpecification = block.executorSpecification;
        this.blockSpecification = block.blockSpecification;
        this.executionStage = block.executionStage;
        this.enabled = block.enabled;
        this.systemName = block.systemName;
        this.standardInput = block.standardInput;
        this.standardOutput = block.standardOutput;
        this.standardData = block.standardData;
        this.standardInputOutputPortName = block.standardInputOutputPortName;
        this.executor = null;
        this.initialize();
        this.parameters.putAll(block.parameters);
        block.inputPorts.forEach((key, port) -> this.inputPorts.put((ChainPortKey)key, port.cleanCopy(this)));
        block.outputPorts.forEach((key, port) -> this.outputPorts.put((ChainPortKey)key, port.cleanCopy(this)));
    }

    public static ChainBlock newInstance(Chain chain, String id, String executorId) {
        return new ChainBlock(chain, id, executorId);
    }

    public ChainBlock cleanCopy(Chain newChain) {
        return new ChainBlock(this, newChain);
    }

    public static String standardInputOutputPortCaption(String systemName) {
        return systemName == null ? null : DEFAULT_CHAIN_PORT_CAPTION_PATTERN.replace("$$$", systemName);
    }

    public static ChainBlock of(Chain chain, ChainSpecification.Block block) {
        Objects.requireNonNull(block, "Null block");
        String executorId = block.getExecutorId();
        ChainBlock result = ChainBlock.newInstance(chain, block.getUuid(), executorId);
        result.blockSpecification = block;
        result.setExecutionStage(block.getExecutionStage());
        result.setEnabled(block.getSystem().isEnabled());
        result.setSystemName(block.getSystem().name());
        boolean enabledRunTime = result.isExecutedAtRunTime();
        result.setStandardInput(enabledRunTime && result.executorSpecification != null && result.executorSpecification.isInput());
        result.setStandardOutput(enabledRunTime && result.executorSpecification != null && result.executorSpecification.isOutput());
        result.setStandardData(enabledRunTime && result.executorSpecification != null && result.executorSpecification.isData());
        result.loadParameters(block);
        result.loadPorts(block);
        result.setEnabledByLegacyWayIfNecessary();
        result.setSystemNameByLegacyWayIfNecessary();
        if (result.executorSpecification == null) {
            LOG.log(System.Logger.Level.DEBUG, () -> "Specification of executor " + executorId + " is not registered yet (while creating chain block) and will be probably loaded later; " + result.detailedMessage());
        }
        return result;
    }

    public static void prepareExecution(Collection<ChainBlock> blocks) {
        blocks.forEach(ChainBlock::prepareExecution);
    }

    public static void executeWithAllDependentInputs(Collection<ChainBlock> blocks, boolean multithreading) {
        Stream<ChainBlock> blockStream = multithreading ? blocks.parallelStream() : blocks.stream();
        blockStream.forEach(ChainBlock::executeWithAllDependentInputs);
    }

    public String getId() {
        return this.id;
    }

    public String getExecutorId() {
        return this.executorId;
    }

    public ExecutorSpecification getExecutorSpecification() {
        return this.executorSpecification;
    }

    public ChainSpecification.Block getBlock() {
        return this.blockSpecification;
    }

    public Map<String, ChainParameter> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Collection<ChainInputPort> getAllInputPorts() {
        return Collections.unmodifiableCollection(this.inputPorts.values());
    }

    public Collection<ChainOutputPort> getAllOutputPorts() {
        return Collections.unmodifiableCollection(this.outputPorts.values());
    }

    public ChainParameter getParameter(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public void addParameter(ChainParameter parameter) {
        Objects.requireNonNull(parameter, "Null parameter");
        if (this.parameters.putIfAbsent(parameter.getName(), parameter) != null) {
            throw new IllegalArgumentException("Duplicate parameter name: " + parameter.getName());
        }
    }

    public ChainInputPort getActualInputPort(String portName) {
        return this.inputPorts.get(new ChainPortKey(ChainPortType.INPUT_PORT, portName));
    }

    public void addInputPort(ChainInputPort inputPort) {
        Objects.requireNonNull(inputPort, "Null input port");
        if (this.inputPorts.putIfAbsent(inputPort.key, inputPort) != null) {
            throw new IllegalArgumentException("Duplicate input port name: " + String.valueOf(inputPort.key));
        }
    }

    public ChainOutputPort getActualOutputPort(String portName) {
        return this.outputPorts.get(new ChainPortKey(ChainPortType.OUTPUT_PORT, portName));
    }

    public void addOutputPort(ChainOutputPort outputPort) {
        Objects.requireNonNull(outputPort, "Null output port");
        if (this.outputPorts.putIfAbsent(outputPort.key, outputPort) != null) {
            throw new IllegalArgumentException("Duplicate output port name: " + String.valueOf(outputPort.key));
        }
    }

    public int numberOfConnectedInputPorts() {
        return (int)this.inputPorts.values().stream().filter(ChainPort::isConnected).count();
    }

    public int numberOfConnectedOutputPorts() {
        return (int)this.outputPorts.values().stream().filter(ChainPort::isConnected).count();
    }

    public ExecutionStage getExecutionStage() {
        return this.executionStage;
    }

    public ChainBlock setExecutionStage(ExecutionStage executionStage) {
        this.executionStage = Objects.requireNonNull(executionStage, "Null executionStage");
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ChainBlock setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public ChainBlock setSystemName(String systemName) {
        this.systemName = systemName;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionBlock getExecutor() {
        Object object = this.lock;
        synchronized (object) {
            if (this.executor == null) {
                throw new IllegalStateException("Executor is not initialized for " + String.valueOf(this));
            }
            return this.executor;
        }
    }

    public boolean isStandardInput() {
        return this.standardInput;
    }

    public ChainBlock setStandardInput(boolean standardInput) {
        this.standardInput = standardInput;
        return this;
    }

    public boolean isStandardOutput() {
        return this.standardOutput;
    }

    public ChainBlock setStandardOutput(boolean standardOutput) {
        this.standardOutput = standardOutput;
        return this;
    }

    public boolean isStandardData() {
        return this.standardData;
    }

    public ChainBlock setStandardData(boolean standardData) {
        this.standardData = standardData;
        return this;
    }

    public String getStandardInputOutputName() {
        return this.standardInputOutputPortName;
    }

    public ChainBlock setStandardInputOutputPortName(String standardInputOutputPortName) {
        this.standardInputOutputPortName = standardInputOutputPortName;
        return this;
    }

    public String getStandardInputOutputPortCaption() {
        return ChainBlock.standardInputOutputPortCaption(this.getSystemName());
    }

    public String getStandardParameterName() {
        return this.getSystemName();
    }

    public ChainInputPort reqStandardDataPort() {
        if (!this.isStandardData()) {
            throw new IllegalStateException("This block is not a standard data block: " + String.valueOf(this));
        }
        ChainInputPort result = this.getActualInputPort(Executor.DEFAULT_INPUT_PORT);
        if (result == null) {
            throw new IllegalStateException("Standard data block must have the input port \"" + Executor.DEFAULT_INPUT_PORT + "\" (" + String.valueOf(this) + ")");
        }
        return result;
    }

    public ChainInputPort reqStandardInputPort() {
        if (!this.isStandardInput()) {
            throw new IllegalStateException("This block is not a standard input block: " + String.valueOf(this));
        }
        ChainInputPort result = this.getActualInputPort(Executor.DEFAULT_INPUT_PORT);
        if (result == null) {
            throw new IllegalStateException("Standard input block must have the input port \"" + Executor.DEFAULT_INPUT_PORT + "\" (" + String.valueOf(this) + ")");
        }
        return result;
    }

    public ChainOutputPort reqStandardOutputPort() {
        if (!this.isStandardOutput()) {
            throw new IllegalStateException("This block is not a standard output block: " + String.valueOf(this));
        }
        ChainOutputPort result = this.getActualOutputPort(Executor.DEFAULT_OUTPUT_PORT);
        if (result == null) {
            throw new IllegalStateException("Standard output block must have the output port \"" + Executor.DEFAULT_OUTPUT_PORT + "\" (" + String.valueOf(this) + ")");
        }
        return result;
    }

    public ChainInputPort reqActualInputPort(String portName) {
        Objects.requireNonNull(portName, "Null portName");
        ChainInputPort result = this.getActualInputPort(portName);
        if (result == null) {
            throw new IllegalStateException("Block has no input port \"" + portName + "\" (" + String.valueOf(this) + ")");
        }
        return result;
    }

    public ChainOutputPort reqActualOutputPort(String portName) {
        Objects.requireNonNull(portName, "Null portName");
        ChainOutputPort result = this.getActualOutputPort(portName);
        if (result == null) {
            throw new IllegalStateException("Block has no output port \"" + portName + "\" (" + String.valueOf(this) + ")");
        }
        return result;
    }

    public void setActualInputData(String portName, Data data) {
        Objects.requireNonNull(data, "Null data");
        ChainInputPort inputPort = this.reqActualInputPort(portName);
        inputPort.getData().setTo(data, true);
    }

    public void getActualOutputData(String portName, Data resultData) {
        Objects.requireNonNull(resultData, "Null resultData");
        ChainOutputPort outputPort = this.reqActualOutputPort(portName);
        resultData.setTo(outputPort.getData(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExecutedAtLoadingTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.isEnabled() && this.executionStage == ExecutionStage.LOADING_TIME;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExecutedAtRunTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.isEnabled() && this.executionStage == ExecutionStage.RUN_TIME;
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isDataFreed() {
        return this.dataFreed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int executionOrder() {
        return this.executionOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize(boolean initializeAlsoNonRunTime) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isEnabled() && (initializeAlsoNonRunTime || this.isExecutedAtRunTime()) && this.executor == null) {
                ExecutionBlock executor;
                try {
                    ExecutorFactory factory = this.chain.executorFactory();
                    executor = factory.newExecutor(this.executorId, CreateMode.NO_REQUEST);
                }
                catch (ClassNotFoundException | ExecutorExpectedException e) {
                    throw new IllegalStateException("Cannot initialize block with executor ID " + this.executorId + (String)(this.blockSpecification == null ? "" : " (name=" + ExecutorSpecification.quote(this.blockSpecification.getExecutorName()) + ", category=" + ExecutorSpecification.quote(this.blockSpecification.getExecutorCategory()) + ")") + (e instanceof ClassNotFoundException ? " - Java class not found: " + e.getMessage() : " - non-registered ID \"" + this.executorId + "\""), e);
                }
                if (executor == null) {
                    throw new AssertionError((Object)"Invalid executor factory (created null executor)");
                }
                this.initializePortsSpecifiedInChain(executor);
                executor.setOwnerId(this.chain.id());
                executor.setContextId(this.chain.contextId());
                executor.setContextName(this.chain.name());
                Path path = this.chain.chainSpecificationPath();
                if (path != null) {
                    executor.setContextPath(path.toAbsolutePath().toString());
                }
                this.updateSystemSettings(executor);
                this.updateParameters(executor);
                if (executor instanceof Executor) {
                    Executor e = (Executor)executor;
                    e.setTimingEnabled(this.chain.isTimingByExecutorsEnabled());
                }
                this.executor = executor;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isExecutedAtRunTime()) {
                this.needToReset.set(true);
                this.executionOrder = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needToRepeat() {
        Object object = this.lock;
        synchronized (object) {
            return this.isExecutedAtRunTime() && this.getExecutor().needToRepeat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareExecution() {
        Object object = this.lock;
        synchronized (object) {
            this.ready = false;
            this.dataFreed = false;
            this.closed = false;
            this.readyAlwaysNecessaryInputs = false;
            this.numberOfExecutionsForAssertion.set(0);
            for (ChainOutputPort chainOutputPort : this.outputPorts.values()) {
                chainOutputPort.resetConnectedInputsInformation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.ready) {
                try {
                    if (this.isExecutedAtRunTime()) {
                        ExecutionBlock executor = this.getExecutor();
                        this.copyInputPortsToExecutor();
                        try {
                            Executor e;
                            ExecutionStatus status;
                            Executor caller = this.chain.getCaller();
                            ExecutionStatus executionStatus = status = caller == null ? null : caller.status();
                            if (status != null) {
                                status.setComment(this::friendlyCaption);
                            }
                            if (executor instanceof Executor && (status = (e = (Executor)executor).status()) != null) {
                                status.setExecutorClassId(this.executorId);
                                status.setExecutorInstanceId(this.id);
                            }
                            long t1 = this.timing.currentTime();
                            if (caller != null && caller.isInterrupted()) {
                                throw new InterruptionException("Execution aborted");
                            }
                            if (this.needToReset.getAndSet(false)) {
                                executor.reset();
                            }
                            executor.execute();
                            if (executor.needToRepeat()) {
                                this.chain.needToRepeat = true;
                            }
                            long t2 = this.timing.currentTime();
                            this.timing.updateExecution(t2 - t1);
                        }
                        catch (IOError | AssertionError | RuntimeException e) {
                            if (this.chain.isIgnoreExceptions()) {
                                Executor.LOG.log(System.Logger.Level.INFO, "IGNORING EXCEPTION:\n      " + String.valueOf(e));
                            }
                            if (ChainBlock.isHighLevelException((Throwable)e)) {
                                throw e;
                            }
                            throw this.translateException((Throwable)e);
                        }
                        this.copyOutputPortsFromExecutor();
                    }
                    this.executionOrder = this.chain.executionIndex.getAndIncrement();
                }
                finally {
                    this.ready = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithAllDependentInputs() {
        if (this.ready) {
            return;
        }
        if (!this.isExecutedAtRunTime()) {
            return;
        }
        ArrayList<ChainInputPort> necessaryAlways = new ArrayList<ChainInputPort>();
        ArrayList<ChainInputPort> necessarySometimes = new ArrayList<ChainInputPort>();
        this.checkConnectedInputs(necessaryAlways, necessarySometimes);
        this.streamOfInputs(necessaryAlways).forEach(chainInputPort -> {
            if (!this.ready) {
                chainInputPort.connectedSourceBlock().executeWithAllDependentInputs();
            }
        });
        List<ChainInputPort> actualInputPorts = necessaryAlways;
        if (!necessarySometimes.isEmpty()) {
            List<ChainInputPort> necessaryNow;
            Object object = this.lock;
            synchronized (object) {
                if (!this.readyAlwaysNecessaryInputs) {
                    this.copyFromConnectedPorts(necessaryAlways);
                    this.copyInputPortsToExecutor(necessaryAlways);
                    this.readyAlwaysNecessaryInputs = true;
                }
                necessaryNow = ChainBlock.allNecessaryNow(necessarySometimes);
            }
            this.streamOfInputs(necessaryNow).forEach(chainInputPort -> {
                if (!this.ready) {
                    chainInputPort.connectedSourceBlock().executeWithAllDependentInputs();
                }
            });
            actualInputPorts = necessaryNow;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return;
            }
            if (this.numberOfExecutionsForAssertion.incrementAndGet() > 1) {
                throw new AssertionError((Object)("Cannot be called more than once: " + String.valueOf(this)));
            }
            long t1 = this.timing.currentTime();
            this.copyFromConnectedPorts(actualInputPorts);
            long t2 = this.timing.currentTime();
            this.execute();
            long t3 = this.timing.currentTime();
            this.timing.updatePassingData(t2 - t1);
            this.timing.updateSummary(t3 - t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeData() {
        Object object = this.lock;
        synchronized (object) {
            for (ChainPort chainPort : this.inputPorts.values()) {
                chainPort.removeData();
            }
            for (ChainPort chainPort : this.outputPorts.values()) {
                chainPort.removeData();
            }
            if (this.executor != null) {
                this.executor.freeAllPortData();
            }
            this.dataFreed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeResources() {
        Object object = this.lock;
        synchronized (object) {
            this.prepareExecution();
            this.freeData();
            ExecutionBlock executor = this.executor;
            if (executor != null) {
                this.executor = null;
                executor.close();
            }
            this.closed = true;
        }
    }

    public ChainRunningException translateException(Throwable e) {
        return new ChainRunningException(this.detailedMessage(), e);
    }

    public FunctionTiming timing() {
        return this.timing;
    }

    public boolean hasTiming() {
        return !this.timing.isEmpty();
    }

    public void analyseTiming() {
        this.timing.analyse();
    }

    public String simpleTimingInfo(Double totalTimeOfLastAnalysedCalls) {
        return this.timing.toSimpleStringForSummary(totalTimeOfLastAnalysedCalls) + " - block ID '" + this.id + "', " + this.friendlyCaption();
    }

    public String timingInfo() {
        String blockName = this.blockSpecification != null ? this.blockSpecification.getSystem().name() : null;
        return String.format("block%s%s%s%s%s%s ID '%s', executor ID '%s'%s, %s [%X]: %s", !this.isEnabled() ? " [DISABLED]" : "", this.executionStage != ExecutionStage.RUN_TIME ? " [" + String.valueOf((Object)this.executionStage) + "]" : "", this.standardInput ? " [input]" : "", this.standardOutput ? " [output]" : "", this.standardData ? " [data]" : "", blockName != null ? " \"" + blockName + "\"" : "", this.id, this.executorId, this.executor == null ? "" : ", class " + this.executor.getClass().getSimpleName(), this.friendlyCaption(true), System.identityHashCode(this), this.timing);
    }

    public String friendlyName() {
        return this.friendlyName(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaller(Executor caller) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isExecutedAtRunTime()) {
                this.getExecutor().setCaller(caller);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimingSettings(int numberOfAnalysedCalls, TimingStatistics.Settings settings) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isExecutedAtRunTime()) {
                this.timing.setSettings(numberOfAnalysedCalls, settings);
            }
        }
    }

    public String toString() {
        String systemName = this.getSystemName();
        StringBuilder sb = new StringBuilder("ChainBlock" + (!this.isEnabled() ? " [DISABLED]" : "") + (String)(this.executionStage != ExecutionStage.RUN_TIME ? " [" + String.valueOf((Object)this.executionStage) + "]" : "") + (this.standardInput ? " [input]" : "") + (this.standardOutput ? " [output]" : "") + (this.standardData ? " [data]" : "") + (this.ready ? ", ready" : "") + (this.dataFreed ? ", data freed" : "") + (this.closed ? ", closed" : "") + " {\n      ID='" + this.id + "'\n" + (String)(systemName == null ? "" : "      system name='" + systemName + "'\n") + "      executor ID='" + this.executorId + "'" + (String)(this.executorSpecification == null ? " (no executor specification)" : " (name='" + this.executorSpecification.getName() + "')") + "\n      address='" + System.identityHashCode(this) + " (belongs to " + System.identityHashCode(this.chain) + ")'\n      parameters=[\n");
        for (ChainParameter chainParameter : this.parameters.values()) {
            sb.append("        ").append(chainParameter).append('\n');
        }
        sb.append("      ],\n      inputPorts=[\n");
        for (ChainInputPort chainInputPort : this.inputPorts.values()) {
            sb.append("        ").append(chainInputPort).append('\n');
        }
        sb.append("      ] (").append(this.numberOfConnectedInputPorts()).append(" connected),\n      outputPorts=[\n");
        for (ChainOutputPort chainOutputPort : this.outputPorts.values()) {
            sb.append("        ").append(chainOutputPort).append('\n');
        }
        sb.append("      ] (").append(this.numberOfConnectedOutputPorts()).append(" connected),\n    }");
        return sb.toString();
    }

    public static boolean isHighLevelException(Throwable e) {
        return e instanceof HighLevelException || e instanceof InterruptionException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkRecursiveDependencies() {
        if (this.ready) {
            return;
        }
        this.checkingNow = true;
        try {
            for (ChainInputPort chainInputPort : this.inputPorts.values()) {
                if (chainInputPort.isConnected()) {
                    ChainBlock sourceBlock = chainInputPort.connectedSourceBlock();
                    if (sourceBlock.checkingNow) {
                        throw new RecursiveDependenceException("Recursive dependence in the chain: cannot calculate " + String.valueOf(sourceBlock));
                    }
                    sourceBlock.checkRecursiveDependencies();
                }
                this.ready = true;
            }
        }
        finally {
            this.checkingNow = false;
        }
    }

    public void copyInputPortsToExecutor() {
        this.copyInputPortsToExecutor(this.inputPorts.values());
    }

    private String friendlyName(boolean useCaption) {
        String executorName = this.executorSpecification != null ? this.executorSpecification.getName() : (this.blockSpecification != null ? this.blockSpecification.getExecutorName() : null);
        String caption = null;
        if (useCaption && this.blockSpecification != null && Objects.equals(caption = this.blockSpecification.getSystem().getCaption(), executorName)) {
            caption = null;
        }
        return (this.executorSpecification == null ? "dynamic " : "") + (String)(executorName != null ? "executor '" + executorName + "'" : "executor") + (String)(caption != null ? " ('" + caption + "')" : "");
    }

    private String friendlyCaption() {
        return this.friendlyCaption(false);
    }

    private String friendlyCaption(boolean quoted) {
        String caption;
        String executorName = this.executorSpecification != null ? this.executorSpecification.getName() : (this.blockSpecification != null ? this.blockSpecification.getExecutorName() : null);
        String string = caption = this.blockSpecification == null ? null : this.blockSpecification.getSystem().getCaption();
        if (caption == null) {
            caption = executorName;
        }
        return caption != null ? (quoted ? "'" + caption + "'" : caption) : (this.executorSpecification == null ? "dynamic " : "") + "executor";
    }

    private String detailedMessage() {
        String systemName = this.getSystemName();
        return "occurred in " + this.friendlyName(true) + ":\n      block ID " + this.id + "\n      " + (String)(systemName == null ? "" : "system name '" + systemName + "'\n      ") + (String)(this.executor == null ? "" : String.valueOf(this.executor.getClass()) + "\n      ") + (String)(this.executorSpecification == null ? "probably dynamic executor" : "executor name '" + this.executorSpecification.getName() + "'") + " (executor ID " + this.executorId + ")\n      in the chain '" + this.chain.name() + "' (ID " + this.chain.id() + ")";
    }

    private void copyFromConnectedPorts(Collection<ChainInputPort> inputPorts) {
        for (ChainInputPort chainInputPort : inputPorts) {
            chainInputPort.copyFromConnectedPort();
        }
    }

    private void copyInputPortsToExecutor(Collection<ChainInputPort> inputPorts) {
        for (ChainInputPort chainInputPort : inputPorts) {
            try {
                chainInputPort.copyToExecutorPort();
            }
            catch (AssertionError | RuntimeException e) {
                throw new ChainRunningException("Occurred while copying input port of " + this.executor.getClass().getName() + " from " + String.valueOf(chainInputPort) + " in block " + String.valueOf(this), (Throwable)e);
            }
        }
    }

    private void copyOutputPortsFromExecutor() {
        for (ChainOutputPort chainOutputPort : this.outputPorts.values()) {
            chainOutputPort.copyFromExecutorPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnectedInputs(List<ChainInputPort> necessaryAlways, List<ChainInputPort> necessarySometimes) {
        Object object = this.lock;
        synchronized (object) {
            assert (this.isExecutedAtRunTime()) : "this method should be used for executable blocks only";
            necessaryAlways.clear();
            necessarySometimes.clear();
            for (ChainInputPort inputPort : this.inputPorts.values()) {
                if (!inputPort.isConnected()) continue;
                Boolean necessary = inputPort.necessary();
                if (!ANALYSE_CONDITIONAL_INPUTS || necessary == null) {
                    necessaryAlways.add(inputPort);
                    continue;
                }
                necessarySometimes.add(inputPort);
            }
        }
    }

    private static List<ChainInputPort> allNecessaryNow(List<ChainInputPort> necessarySometimes) {
        ArrayList<ChainInputPort> result = new ArrayList<ChainInputPort>();
        for (ChainInputPort inputPort : necessarySometimes) {
            Boolean necessary = inputPort.necessary();
            if (necessary == null || !necessary.booleanValue()) continue;
            result.add(inputPort);
        }
        return result;
    }

    private Stream<ChainInputPort> streamOfInputs(Collection<ChainInputPort> inputs) {
        return this.chain.isMultithreading() ? inputs.parallelStream() : inputs.stream();
    }

    private void loadParameters(ChainSpecification.Block block) {
        this.parameters.clear();
        for (ChainSpecification.Block.Parameter parameter : block.getNameToParameterMap().values()) {
            this.addParameter(ChainParameter.of(this, parameter));
        }
    }

    private void setEnabledByLegacyWayIfNecessary() {
        Object value;
        ChainParameter parameter = this.parameters.get("$__system.enabled");
        if (parameter != null && (value = parameter.getValue()) instanceof Boolean) {
            this.enabled = (Boolean)value;
        }
    }

    private void setSystemNameByLegacyWayIfNecessary() {
        String systemName;
        ChainParameter parameter = this.parameters.get("$__system.name");
        if (parameter != null && (systemName = parameter.toScalar()) != null && !(systemName = systemName.trim()).isEmpty()) {
            this.systemName = systemName;
        }
    }

    private void loadPorts(ChainSpecification.Block block) {
        this.inputPorts.clear();
        this.outputPorts.clear();
        if (this.executorSpecification != null) {
            for (PortSpecification portSpecification : this.executorSpecification.getInputPorts().values()) {
                ChainInputPort inputPort = ChainInputPort.of(this, portSpecification);
                Objects.requireNonNull(inputPort, "Null input port");
                if (this.inputPorts.putIfAbsent(inputPort.key, inputPort) == null) continue;
                throw new IllegalArgumentException("Duplicate input port name: " + String.valueOf(inputPort.key));
            }
            for (PortSpecification portSpecification : this.executorSpecification.getOutputPorts().values()) {
                ChainOutputPort outputPort = ChainOutputPort.of(this, portSpecification);
                Objects.requireNonNull(outputPort, "Null output port");
                if (this.outputPorts.putIfAbsent(outputPort.key, outputPort) == null) continue;
                throw new IllegalArgumentException("Duplicate output port name: " + String.valueOf(outputPort.key));
            }
        }
        LinkedHashMap<ChainPortKey, ChainInputPort> chainInputPorts = new LinkedHashMap<ChainPortKey, ChainInputPort>();
        LinkedHashMap<ChainPortKey, ChainOutputPort> chainOutputPorts = new LinkedHashMap<ChainPortKey, ChainOutputPort>();
        block6: for (ChainSpecification.Block.Port port : block.getUuidToPortMap().values()) {
            switch (port.getPortType().actualPortType()) {
                case INPUT: {
                    ChainInputPort inputPort = ChainInputPort.of(this, port);
                    if (chainInputPorts.putIfAbsent(inputPort.key, inputPort) == null) continue block6;
                    throw new IllegalArgumentException("Duplicate input port name \"" + String.valueOf(inputPort.key) + "\" in " + String.valueOf(block));
                }
                case OUTPUT: {
                    ChainOutputPort outputPort = ChainOutputPort.of(this, port);
                    if (chainOutputPorts.putIfAbsent(outputPort.key, outputPort) == null) break;
                    throw new IllegalArgumentException("Duplicate output port name \"" + String.valueOf(outputPort.key) + "\" in " + String.valueOf(block));
                }
            }
        }
        this.inputPorts.putAll(chainInputPorts);
        this.outputPorts.putAll(chainOutputPorts);
    }

    private void initializePortsSpecifiedInChain(ExecutionBlock executor) {
        Port port;
        for (ChainInputPort chainInputPort : this.inputPorts.values()) {
            if (!chainInputPort.portType.isActual()) continue;
            port = Port.newInput(chainInputPort.name, chainInputPort.dataType);
            port.setConnected(chainInputPort.isConnected());
            executor.replacePort(port);
        }
        for (ChainOutputPort chainOutputPort : this.outputPorts.values()) {
            if (!chainOutputPort.portType.isActual()) continue;
            port = Port.newOutput(chainOutputPort.name, chainOutputPort.dataType);
            port.setConnected(chainOutputPort.isConnected());
            executor.replacePort(port);
        }
    }

    private void updateParameters(ExecutionBlock executor) {
        Parameters executorParameters = executor.parameters();
        for (ChainParameter p : this.parameters.values()) {
            String parameterName = ChainBlock.resolveParameterAlias(executor, p.getName(), name -> "Legacy parameter name \"" + name + "\" detected");
            executorParameters.put(parameterName, p.getValue());
        }
        for (String name2 : this.parameters.keySet()) {
            executor.onChangeParameter(ChainBlock.resolveParameterAlias(executor, name2, null));
        }
    }

    private void updateSystemSettings(ExecutionBlock executor) {
        executor.setCurrentDirectory(this.chain.getCurrentDirectory());
        if (executor instanceof Executor) {
            Executor e = (Executor)executor;
            e.setMultithreadingEnvironment(this.chain.isMultithreading());
        }
    }

    private void initialize() {
        this.ready = false;
        this.dataFreed = false;
        this.closed = false;
        this.readyAlwaysNecessaryInputs = false;
        this.checkingNow = false;
        this.timing = FunctionTiming.newDisabledInstance();
        this.executionOrder = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugInformation(String name) {
        Object object = this.chain.blocksInteractionLock;
        synchronized (object) {
            ChainBlock block = this.chain.getBlock("14fca6f5-4240-4b31-b27e-bb7e08029dda");
            if (block != null) {
                ChainInputPort input = block.inputPorts.get(new ChainPortKey(ChainPortType.INPUT_PORT, "input"));
                ChainOutputPort output = block.outputPorts.get(new ChainPortKey(ChainPortType.OUTPUT_PORT, "output"));
                System.out.println(this.chain.contextId() + "/" + System.identityHashCode(block) + " !!!! " + name + ": " + String.valueOf(input.data.isInitialized() ? input.data : "") + " -> " + String.valueOf(output.data) + ", " + output.getCountOfConnectedInputs() + (block.isReady() ? ", ready" : ", NOT ready") + (block.isDataFreed() ? ", freed " : "") + " from: " + this.friendlyCaption() + ", " + System.identityHashCode(this));
                this.chain.debugCheck("BLOCK ");
            }
        }
    }

    static String resolveParameterAlias(ExecutionBlock executor, String name, Function<String, String> message) {
        Objects.requireNonNull(name, "Null parameter name");
        if (!SUPPORT_ALIASES) {
            return name;
        }
        String translatedName = executor.translateLegacyParameterAlias(name);
        if (translatedName == null) {
            translatedName = name;
        }
        if (message != null && !translatedName.equals(name)) {
            LOG.log(WARNING_FOR_ALIASES ? System.Logger.Level.WARNING : System.Logger.Level.DEBUG, () -> (String)message.apply(name) + " in " + String.valueOf(executor.getClass()) + ", we recommend resaving the chain file " + ChainBlock.contextMessageInfo(executor));
        }
        return translatedName;
    }

    private static String contextMessageInfo(ExecutionBlock e) {
        return "(" + (String)(e.getContextName() == null ? "no context" : "context \"" + e.getContextName() + "\"") + (String)(e.getContextPath() == null ? "" : " at " + e.getContextPath()) + ")";
    }
}

