/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tiles;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArraysPer8;
import net.algart.arrays.UpdatablePArray;
import net.algart.io.awt.ImageToMatrix;
import net.algart.math.IRectangularArea;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.TiffSampleType;
import net.algart.matrices.tiff.TiffWriter;
import net.algart.matrices.tiff.tiles.TiffIOMap;
import net.algart.matrices.tiff.tiles.TiffTile;
import net.algart.matrices.tiff.tiles.TiffTileIndex;

public final class TiffWriteMap
extends TiffIOMap {
    private static final boolean AUTO_INTERLEAVE_SOURCE = true;
    private static final boolean IGNORE_WRITING_OUTSIDE_MAP = true;
    private final TiffWriter owner;
    private final boolean existing;

    public TiffWriteMap(TiffWriter owner, TiffIFD ifd, boolean resizable, boolean existing) {
        super(ifd, resizable);
        if (existing) {
            if (!ifd.isLoadedFromFile()) {
                throw new IllegalArgumentException("For existing map, IFD must be read from TIFF file");
            }
            if (resizable) {
                throw new IllegalArgumentException("Existing TIFF write map must not be resizable");
            }
        }
        this.owner = Objects.requireNonNull(owner, "Null owning writer");
        this.existing = existing;
    }

    @Override
    public TiffReader reader() {
        return this.owner.reader();
    }

    @Override
    public TiffWriter owner() {
        return this.owner;
    }

    @Override
    public boolean isExisting() {
        return this.existing;
    }

    public byte[] readSampleBytesAndStore(int fromX, int fromY, int sizeX, int sizeY, TiffReader.UnusualPrecisions autoUnpackUnusualPrecisions) throws IOException {
        return this.readSampleBytes(fromX, fromY, sizeX, sizeY, autoUnpackUnusualPrecisions, true, this.cachedTileSupplier());
    }

    public Object readJavaArrayAndStore(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.readJavaArray(fromX, fromY, sizeX, sizeY, true, this.cachedTileSupplier());
    }

    public Matrix<UpdatablePArray> readMatrixAndStore(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.readMatrix(fromX, fromY, sizeX, sizeY, true, this.cachedTileSupplier());
    }

    public Matrix<UpdatablePArray> readInterleavedMatrixAndStore(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.readInterleavedMatrix(fromX, fromY, sizeX, sizeY, true, this.cachedTileSupplier());
    }

    public List<Matrix<UpdatablePArray>> readChannelsAndStore(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.readChannels(fromX, fromY, sizeX, sizeY, true, this.cachedTileSupplier());
    }

    public BufferedImage readBufferedImageAndStore(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.readBufferedImage(fromX, fromY, sizeX, sizeY, true, this.cachedTileSupplier());
    }

    public void preloadAndStore(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        this.preloadAndStore(fromX, fromY, sizeX, sizeY, true);
    }

    public void preloadAndStore(int fromX, int fromY, int sizeX, int sizeY, boolean loadTilesFullyInsideRectangle) throws IOException {
        this.preloadAndStore(fromX, fromY, sizeX, sizeY, loadTilesFullyInsideRectangle, this.cachedTileSupplier());
    }

    public void preloadAndStore(int fromX, int fromY, int sizeX, int sizeY, boolean loadTilesFullyInsideRectangle, TiffIOMap.TileSupplier tileSupplier) throws IOException {
        TiffWriteMap.checkRequestedArea(fromX, fromY, sizeX, sizeY);
        if (sizeX > 0 && sizeY > 0) {
            IRectangularArea areaToWrite = IRectangularArea.ofSize((long)fromX, (long)fromY, (long)sizeX, (long)sizeY);
            for (TiffTile tile : this.tiles()) {
                if (!tile.actualRectangle().intersects(areaToWrite)) continue;
                if (loadTilesFullyInsideRectangle || !areaToWrite.contains(tile.actualRectangle())) {
                    TiffTile existing = tileSupplier.getTile(tile.index());
                    tile.copyData(existing, false);
                    continue;
                }
                tile.unfreeze();
            }
        }
    }

    public List<TiffTile> updateSampleBytes(byte[] samples, long fromX, long fromY, long sizeX, long sizeY) {
        Objects.requireNonNull(samples, "Null samples");
        TiffWriteMap.checkRequestedArea(fromX, fromY, sizeX, sizeY);
        assert (fromX == (long)((int)fromX) && fromY == (long)((int)fromY) && sizeX == (long)((int)sizeX) && sizeY == (long)((int)sizeY));
        return this.updateSampleBytes(samples, (int)fromX, (int)fromY, (int)sizeX, (int)sizeY);
    }

    public List<TiffTile> updateSampleBytes(byte[] samples, int fromX, int fromY, int sizeX, int sizeY) {
        Objects.requireNonNull(samples, "Null samples");
        TiffWriteMap.checkRequestedArea(fromX, fromY, sizeX, sizeY);
        TiffWriteMap.checkRequestedAreaInArray(samples, sizeX, sizeY, this.totalAlignedBitsPerPixel());
        ArrayList<TiffTile> updatedTiles = new ArrayList<TiffTile>();
        if (sizeX == 0 || sizeY == 0) {
            return updatedTiles;
        }
        int toX = fromX + sizeX;
        int toY = fromY + sizeY;
        if (this.needToExpandDimensions(toX, toY)) {
            if (this.isResizable()) {
                this.expandDimensions(toX, toY);
            } else {
                toX = Math.min(toX, this.dimX());
                toY = Math.min(toY, this.dimY());
                if (toX <= fromX || toY <= fromY) {
                    return updatedTiles;
                }
            }
        }
        int mapTileSizeX = this.tileSizeX();
        int mapTileSizeY = this.tileSizeY();
        int numberOfSeparatedPlanes = this.numberOfSeparatedPlanes();
        int samplesPerPixel = this.tileSamplesPerPixel();
        long bitsPerSample = this.alignedBitsPerSample();
        long bitsPerPixel = this.tileAlignedBitsPerPixel();
        int minXIndex = Math.max(0, TiffWriteMap.divFloor(fromX, mapTileSizeX));
        int minYIndex = Math.max(0, TiffWriteMap.divFloor(fromY, mapTileSizeY));
        if (this.isResizable() && (minXIndex >= this.gridCountX() || minYIndex >= this.gridCountY())) {
            throw new AssertionError((Object)("Map was not expanded/checked properly: minimal tile index (" + minXIndex + "," + minYIndex + ") is out of tile grid 0<=x<" + this.gridCountX() + ", 0<=y<" + this.gridCountY() + "; map: " + String.valueOf(this)));
        }
        int maxXIndex = Math.min(this.gridCountX() - 1, TiffWriteMap.divFloor(toX - 1, mapTileSizeX));
        int maxYIndex = Math.min(this.gridCountY() - 1, TiffWriteMap.divFloor(toY - 1, mapTileSizeY));
        if (minYIndex > maxYIndex || minXIndex > maxXIndex) {
            return updatedTiles;
        }
        long tileChunkedRowSizeInBits = (long)mapTileSizeX * bitsPerPixel;
        long samplesChunkedRowSizeInBits = (long)sizeX * bitsPerPixel;
        long tileOneChannelRowSizeInBits = (long)mapTileSizeX * bitsPerSample;
        long samplesOneChannelRowSizeInBits = (long)sizeX * bitsPerSample;
        if (!this.isPlanarSeparated()) {
            // empty if block
        }
        boolean sourceInterleaved = false;
        for (int p = 0; p < numberOfSeparatedPlanes; ++p) {
            for (int yIndex = minYIndex; yIndex <= maxYIndex; ++yIndex) {
                int tileStartY = Math.max(yIndex * mapTileSizeY, fromY);
                int fromYInTile = tileStartY % mapTileSizeY;
                int yDiff = tileStartY - fromY;
                for (int xIndex = minXIndex; xIndex <= maxXIndex; ++xIndex) {
                    int tileStartX = Math.max(xIndex * mapTileSizeX, fromX);
                    int fromXInTile = tileStartX % mapTileSizeX;
                    int xDiff = tileStartX - fromX;
                    TiffTile tile = this.getOrNew(xIndex, yIndex, p);
                    if (tile.isFrozen()) continue;
                    tile.checkReadyForNewDecodedData(false);
                    tile.cropStripToMap();
                    tile.fillWhenEmpty(this.owner.getTileInitializer());
                    byte[] data = tile.getDecodedData();
                    int tileSizeX = tile.getSizeX();
                    int tileSizeY = tile.getSizeY();
                    int sizeXInTile = Math.min(toX - tileStartX, tileSizeX - fromXInTile);
                    if (sizeXInTile <= 0) {
                        throw new AssertionError((Object)("sizeXInTile=" + sizeXInTile));
                    }
                    int sizeYInTile = Math.min(toY - tileStartY, tileSizeY - fromYInTile);
                    if (sizeYInTile <= 0) {
                        throw new AssertionError((Object)("sizeYInTile=" + sizeYInTile));
                    }
                    tile.markNewRectangleAsSet(fromXInTile, fromYInTile, sizeXInTile, sizeYInTile);
                    if (sourceInterleaved) {
                        assert (false) : "AUTO_INTERLEAVE_SOURCE=false, but sourceInterleaved=true";
                        partSizeXInBits = (long)sizeXInTile * bitsPerPixel;
                        long tOffset = ((long)fromYInTile * (long)tileSizeX + (long)fromXInTile) * bitsPerPixel;
                        long sOffset = ((long)yDiff * (long)sizeX + (long)xDiff) * bitsPerPixel;
                        for (int i = 0; i < sizeYInTile; ++i) {
                            assert (sOffset >= 0L && tOffset >= 0L) : "possibly int instead of long";
                            PackedBitArraysPer8.copyBitsNoSync((byte[])data, (long)tOffset, (byte[])samples, (long)sOffset, (long)partSizeXInBits);
                            tOffset += tileChunkedRowSizeInBits;
                            sOffset += samplesChunkedRowSizeInBits;
                        }
                    } else {
                        partSizeXInBits = (long)sizeXInTile * bitsPerSample;
                        for (int s = 0; s < samplesPerPixel; ++s) {
                            long tOffset = (((long)s * (long)tileSizeY + (long)fromYInTile) * (long)tileSizeX + (long)fromXInTile) * bitsPerSample;
                            long sOffset = (((long)(p + s) * (long)sizeY + (long)yDiff) * (long)sizeX + (long)xDiff) * bitsPerSample;
                            for (int i = 0; i < sizeYInTile; ++i) {
                                assert (sOffset >= 0L && tOffset >= 0L) : "possibly int instead of long";
                                PackedBitArraysPer8.copyBitsNoSync((byte[])data, (long)tOffset, (byte[])samples, (long)sOffset, (long)partSizeXInBits);
                                tOffset += tileOneChannelRowSizeInBits;
                                sOffset += samplesOneChannelRowSizeInBits;
                            }
                        }
                    }
                    updatedTiles.add(tile);
                }
            }
        }
        return updatedTiles;
    }

    public List<TiffTile> updateJavaArray(Object samplesArray, int fromX, int fromY, int sizeX, int sizeY) {
        Objects.requireNonNull(samplesArray, "Null samplesArray");
        long numberOfPixels = TiffWriteMap.checkRequestedArea(fromX, fromY, sizeX, sizeY);
        Class<?> elementType = samplesArray.getClass().getComponentType();
        if (elementType == null) {
            throw new IllegalArgumentException("The specified samplesArray is not actual an array: it is " + String.valueOf(samplesArray.getClass()));
        }
        if (!(elementType == this.elementType() || this.isBinary() && elementType == Long.TYPE)) {
            throw new IllegalArgumentException("Invalid element type of samples array: " + String.valueOf(elementType) + ", but the specified TIFF map stores " + this.sampleType().prettyName() + " elements");
        }
        long numberOfSamples = Math.multiplyExact(numberOfPixels, this.numberOfChannels());
        if (numberOfSamples > this.maxNumberOfSamplesInArray()) {
            throw new IllegalArgumentException("Too large area for updating TIFF in a single operation: " + sizeX + "x" + sizeY + "x" + this.numberOfChannels() + " exceed the limit " + this.maxNumberOfSamplesInArray());
        }
        byte[] samples = TiffSampleType.bytes(samplesArray, numberOfSamples, this.byteOrder());
        return this.updateSampleBytes(samples, fromX, fromY, sizeX, sizeY);
    }

    public List<TiffTile> updateMatrix(Matrix<? extends PArray> matrix, int fromX, int fromY) {
        Objects.requireNonNull(matrix, "Null matrix");
        if (!this.isPlanarSeparated()) {
            // empty if block
        }
        boolean sourceInterleaved = false;
        Class elementType = matrix.elementType();
        if (elementType != this.elementType()) {
            throw new IllegalArgumentException("Invalid element type of the matrix: \"" + String.valueOf(elementType) + "\" (" + Arrays.bitsPerElement((Class)elementType) + "-bit), although the specified TIFF map stores \"" + String.valueOf(this.elementType()) + "\" (" + this.bitsPerUnpackedSample() + "-bit) elements");
        }
        if (matrix.dimCount() != 3 && (matrix.dimCount() != 2 || this.numberOfChannels() != 1)) {
            throw new IllegalArgumentException("Illegal number of matrix dimensions " + matrix.dimCount() + ": it must be 3-dimensional dimX*dimY*C, where C is the number of channels (z-dimension), or 3-dimensional C*dimX*dimY for interleaved case, or may be 2-dimensional in the case of monochrome TIFF image");
        }
        int dimChannelsIndex = sourceInterleaved ? 0 : 2;
        long numberOfChannels = matrix.dim(dimChannelsIndex);
        long sizeX = matrix.dim(sourceInterleaved ? 1 : 0);
        long sizeY = matrix.dim(sourceInterleaved ? 2 : 1);
        if (numberOfChannels != (long)this.numberOfChannels()) {
            throw new IllegalArgumentException("Invalid number of channels in the matrix: " + numberOfChannels + " (matrix " + matrix.dim(0) + "*" + matrix.dim(1) + "*" + matrix.dim(2) + "), " + (matrix.dim(2 - dimChannelsIndex) == (long)this.numberOfChannels() ? "probably because of invalid interleaving mode: TIFF image is " + (sourceInterleaved ? "" : "NOT ") + "interleaved" : "because the specified TIFF map stores " + this.numberOfChannels() + " channels"));
        }
        PArray array = (PArray)matrix.array();
        if (array.length() > this.maxNumberOfSamplesInArray()) {
            throw new IllegalArgumentException("Too large matrix for updating TIFF in a single operation: " + String.valueOf(matrix) + " (number of elements " + array.length() + " exceed the limit " + this.maxNumberOfSamplesInArray() + ")");
        }
        byte[] samples = TiffSampleType.bytes(array, this.byteOrder());
        return this.updateSampleBytes(samples, (long)fromX, (long)fromY, sizeX, sizeY);
    }

    public List<TiffTile> updateChannels(List<? extends Matrix<? extends PArray>> channels, int fromX, int fromY) {
        Objects.requireNonNull(channels, "Null channels");
        return this.updateMatrix((Matrix<? extends PArray>)Matrices.mergeLayers((MemoryModel)Arrays.SMM, channels), fromX, fromY);
    }

    public List<TiffTile> updateBufferedImage(BufferedImage bufferedImage, int fromX, int fromY) {
        Objects.requireNonNull(bufferedImage, "Null bufferedImage");
        return this.updateChannels(ImageToMatrix.toChannels((BufferedImage)bufferedImage), fromX, fromY);
    }

    public void writeJavaArray(Object samplesArray) throws IOException {
        this.owner.writeJavaArray(this, samplesArray);
    }

    public void writeMatrix(Matrix<? extends PArray> matrix) throws IOException {
        this.owner.writeMatrix(this, matrix);
    }

    public void writeChannels(List<? extends Matrix<? extends PArray>> channels) throws IOException {
        this.owner.writeChannels(this, channels);
    }

    public void writeBufferedImage(BufferedImage bufferedImage) throws IOException {
        this.owner.writeBufferedImage(this, bufferedImage);
    }

    public void writeTile(TiffTile tile, boolean freeAndFreezeAfterWriting) throws IOException {
        this.owner.writeTile(tile, freeAndFreezeAfterWriting);
    }

    public int writeAllTiles(Collection<TiffTile> tiles) throws IOException {
        return this.writeTiles(tiles, tile -> true, true);
    }

    public int writeCompletedTiles(Collection<TiffTile> tiles) throws IOException {
        return this.writeCompletedTiles(tiles, true);
    }

    public int writeCompletedTiles(Collection<TiffTile> tiles, boolean freeAndFreezeAfterWriting) throws IOException {
        return this.writeTiles(tiles, TiffTile::isCompleted, freeAndFreezeAfterWriting);
    }

    public int writeTiles(Collection<TiffTile> tiles, Predicate<TiffTile> needToWrite, boolean freeAndFreezeAfterWriting) throws IOException {
        return this.owner.writeTiles(tiles, needToWrite, freeAndFreezeAfterWriting);
    }

    public int completeWriting() throws IOException {
        return this.owner.completeWriting(this);
    }

    public void updateIFD() throws TiffException {
        if (!this.isExisting()) {
            throw new IllegalStateException("IFD can be updated only for existing maps");
        }
        if (this.isResizable()) {
            throw new AssertionError((Object)"Existing map cannot be resizable");
        }
        TiffIFD ifd = this.ifd();
        long[] offsets = ifd.cachedTileOrStripOffsets();
        long[] byteCounts = ifd.cachedTileOrStripByteCounts();
        assert (offsets != null);
        assert (byteCounts != null);
        int numberOfSeparatedPlanes = this.numberOfSeparatedPlanes();
        int gridCountY = this.gridCountY();
        int gridCountX = this.gridCountX();
        int n = this.numberOfGridTiles();
        assert (n == gridCountX * gridCountY * numberOfSeparatedPlanes);
        if (offsets.length != n || byteCounts.length != n) {
            throw new IllegalStateException("IFD offsets and byteCounts has been modified after creating this TIFF map: offsets.length = " + offsets.length + ", byteCounts.length = " + byteCounts.length + ", but number of grids = " + n);
        }
        int k = 0;
        for (int p = 0; p < numberOfSeparatedPlanes; ++p) {
            for (int yIndex = 0; yIndex < gridCountY; ++yIndex) {
                int xIndex = 0;
                while (xIndex < gridCountX) {
                    TiffTileIndex tileIndex = this.index(xIndex, yIndex, p);
                    TiffTile tile = this.get(tileIndex);
                    if (tile != null && tile.isStoredInFile()) {
                        offsets[k] = tile.getStoredInFileDataOffset();
                        byteCounts[k] = tile.getStoredInFileDataLength();
                    }
                    ++xIndex;
                    ++k;
                }
            }
        }
        ifd.updateDataPositioning(offsets, byteCounts);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ 0x77;
    }

    @Override
    String mapKindName() {
        return "map-for-writing" + (this.existing ? " (existing)" : " (new)");
    }

    private static void checkRequestedAreaInArray(byte[] array, long sizeX, long sizeY, int bitsPerPixel) {
        Objects.requireNonNull(array, "Null array");
        if (bitsPerPixel <= 0) {
            throw new IllegalArgumentException("Zero or negative bitsPerPixel = " + bitsPerPixel);
        }
        long arrayBits = (long)array.length * 8L;
        TiffWriteMap.checkRequestedArea(0L, 0L, sizeX, sizeY);
        if (sizeX * sizeY > arrayBits || sizeX * sizeY * (long)bitsPerPixel > arrayBits) {
            throw new IllegalArgumentException("Requested area " + sizeX + "x" + sizeY + " is too large for array of " + array.length + " bytes, " + bitsPerPixel + " per pixel");
        }
    }
}

