/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tiles;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatablePArray;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.tiles.TiffIOMap;
import net.algart.matrices.tiff.tiles.TiffTile;
import net.algart.matrices.tiff.tiles.TiffTileIndex;

public final class TiffReadMap
extends TiffIOMap {
    private final TiffReader owner;

    public TiffReadMap(TiffReader owner, TiffIFD ifd) {
        super(ifd, false);
        if (!ifd.isLoadedFromFile()) {
            throw new IllegalArgumentException("IFD must be read from TIFF file");
        }
        this.owner = Objects.requireNonNull(owner, "Null owning reader");
    }

    @Override
    public TiffReader owner() {
        return this.owner;
    }

    @Override
    public TiffReader reader() {
        return this.owner;
    }

    @Override
    public boolean isExisting() {
        return true;
    }

    public TiffReader.UnpackBits getAutoUnpackBits() {
        return this.owner.getAutoUnpackBits();
    }

    public boolean isAutoScaleWhenIncreasingBitDepth() {
        return this.owner.isAutoScaleWhenIncreasingBitDepth();
    }

    public byte[] loadSampleBytes() throws IOException {
        return this.loadSampleBytes(0, 0, this.dimX(), this.dimY());
    }

    public byte[] loadSampleBytes(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.loadSampleBytes(fromX, fromY, sizeX, sizeY, this.owner.getUnusualPrecisions());
    }

    public byte[] loadSampleBytes(int fromX, int fromY, int sizeX, int sizeY, TiffReader.UnusualPrecisions unusualPrecisions) throws IOException {
        return this.loadSampleBytes(fromX, fromY, sizeX, sizeY, unusualPrecisions, false);
    }

    public byte[] readSampleBytes() throws IOException {
        return this.owner.readSampleBytes(this);
    }

    public byte[] readSampleBytes(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.owner.readSampleBytes(this, fromX, fromY, sizeX, sizeY);
    }

    public Object readJavaArray() throws IOException {
        return this.owner.readJavaArray(this);
    }

    public Object readJavaArray(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.owner.readJavaArray(this, fromX, fromY, sizeX, sizeY);
    }

    public Matrix<UpdatablePArray> readMatrix() throws IOException {
        return this.owner.readMatrix(this);
    }

    public Matrix<UpdatablePArray> readMatrix(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.owner.readMatrix(this, fromX, fromY, sizeX, sizeY);
    }

    public Matrix<UpdatablePArray> readInterleavedMatrix() throws IOException {
        return this.owner.readInterleavedMatrix(this);
    }

    public Matrix<UpdatablePArray> readInterleavedMatrix(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.owner.readInterleavedMatrix(this, fromX, fromY, sizeX, sizeY);
    }

    public List<Matrix<UpdatablePArray>> readChannels() throws IOException {
        return this.owner.readChannels(this);
    }

    public List<Matrix<UpdatablePArray>> readChannels(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.owner.readChannels(this, fromX, fromY, sizeX, sizeY);
    }

    public BufferedImage readBufferedImage() throws IOException {
        return this.owner.readBufferedImage(this);
    }

    public BufferedImage readBufferedImage(int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.owner.readBufferedImage(this, fromX, fromY, sizeX, sizeY);
    }

    public TiffTile readCachedTile(TiffTileIndex tileIndex) throws IOException {
        return this.owner.readCachedTile(tileIndex);
    }

    public TiffTile readTile(TiffTileIndex tileIndex) throws IOException {
        return this.owner.readTile(tileIndex);
    }

    public TiffTile readEncodedTile(TiffTileIndex tileIndex) throws IOException {
        return this.owner.readEncodedTile(tileIndex);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ 0x72;
    }

    @Override
    String mapKindName() {
        return "map-for-reading";
    }
}

