/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tags;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum TagPhotometricInterpretation {
    WHITE_IS_ZERO(0, "White-is-zero"),
    BLACK_IS_ZERO(1, "Black-is-zero"),
    RGB(2, "RGB"),
    RGB_PALETTE(3, "RGB palette"),
    TRANSPARENCY_MASK(4, "Transparency mask"),
    CMYK(5, "CMYK"),
    Y_CB_CR(6, "YCbCr"),
    CIE_LAB(8, "CIELAB"),
    ICC_LAB(9, "ICCLAB"),
    CFA_ARRAY(32803, "Color filter array"),
    UNKNOWN(-1, "unknown");

    private final int code;
    private final String name;
    private static final Map<Integer, TagPhotometricInterpretation> LOOKUP;

    private TagPhotometricInterpretation(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static TagPhotometricInterpretation fromCodeOrUnknown(int code) {
        return LOOKUP.getOrDefault(code, UNKNOWN);
    }

    public int code() {
        this.checkUnknown();
        return this.code;
    }

    public String prettyName() {
        return this.name;
    }

    public boolean isInvertedBrightness() {
        return this == WHITE_IS_ZERO || this == CMYK;
    }

    public boolean isIndexed() {
        return this == RGB_PALETTE || this == CFA_ARRAY;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public TagPhotometricInterpretation checkUnknown() {
        if (this == UNKNOWN) {
            throw new IllegalArgumentException("Unknown TIFF photometric interpretation is not allowed");
        }
        return this;
    }

    static {
        LOOKUP = Arrays.stream(TagPhotometricInterpretation.values()).filter(v -> v.code >= 0).collect(Collectors.toMap(TagPhotometricInterpretation::code, v -> v));
    }
}

