/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.tags;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.tags.SvsDescription;

public class TagDescription {
    public static final TagDescription EMPTY = new TagDescription(null);
    private final String description;
    private volatile TiffIFD ifd = null;

    protected TagDescription(String description) {
        this.description = description;
    }

    public static TagDescription of(String imageDescription) {
        if (imageDescription == null) {
            return EMPTY;
        }
        if (SvsDescription.isSvs(imageDescription)) {
            return new SvsDescription(imageDescription);
        }
        return new TagDescription(imageDescription);
    }

    public TiffIFD getIFD() {
        return this.ifd;
    }

    public TagDescription setIFD(TiffIFD ifd) {
        this.ifd = ifd;
        return this;
    }

    public final Integer globalIndex() {
        return this.ifd == null ? null : this.ifd.getGlobalIndex();
    }

    public final String description() {
        return this.description(null);
    }

    public final String description(String defaultValue) {
        return this.description == null ? defaultValue : this.description;
    }

    public final boolean isPresent() {
        return this.description != null;
    }

    public final boolean isEmpty() {
        return this.description == null;
    }

    public boolean isSvs() {
        return this instanceof SvsDescription;
    }

    public final String formatName() {
        return this.formatName(false);
    }

    public String formatName(boolean pretty) {
        return pretty ? "Additional description" : "description";
    }

    public String application() {
        return "Common TIFF";
    }

    public final boolean hasAttributes() {
        return !this.attributes().isEmpty();
    }

    public Map<String, String> attributes() {
        return Collections.emptyMap();
    }

    public Set<String> humanReadableAttributeNames() {
        return Collections.emptySet();
    }

    public final double reqDouble(String name) throws TiffException {
        Objects.requireNonNull(name, "Null attribute name");
        String value = this.attributes().get(name);
        if (value == null) {
            throw new TiffException("SVS image description does not contain \"" + name + "\" attribute");
        }
        try {
            return TagDescription.parseJsonDouble(value);
        }
        catch (NumberFormatException e) {
            throw new TiffException("SVS image description contains invalid \"" + name + "\" attribute: " + value + " is not a number", e);
        }
    }

    public final OptionalDouble optDouble(String name) {
        Objects.requireNonNull(name, "Null attribute name");
        String value = this.attributes().get(name);
        if (value == null) {
            return OptionalDouble.empty();
        }
        try {
            return OptionalDouble.of(TagDescription.parseJsonDouble(value));
        }
        catch (NumberFormatException e) {
            return OptionalDouble.empty();
        }
    }

    public String jsonString() {
        return "{\n  \"application\": \"" + TiffIFD.escapeJsonString(this.application()) + "\",\n  \"exists\": " + this.isPresent() + (String)(this.isPresent() ? ",\n  \"description\": \"" + TiffIFD.escapeJsonString(this.description()) + "\"" : "") + (String)(this.ifd != null && this.ifd.hasGlobalIndex() ? ",\n  \"globalIndex\": " + this.ifd.getGlobalIndex() : "") + "\n}";
    }

    public String toString() {
        return this.description == null ? "No ImageDescription tag" : (this.description.isBlank() ? "Empty ImageDescription (\"%s\")" : "\"%s\"").formatted(this.description);
    }

    public String toString(TiffIFD.StringFormat format) {
        Objects.requireNonNull(format, "Null format");
        return format.isJson() ? this.jsonString() : this.toString();
    }

    private static double parseJsonDouble(String s) throws NumberFormatException {
        double result = Double.parseDouble(s);
        if (!Double.isFinite(result)) {
            throw new NumberFormatException("unallowed value");
        }
        return result;
    }
}

