/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.codecs;

import java.io.IOException;
import java.io.InputStream;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.codecs.CCITTFaxDecoderStreamAdapted;

class TinyTwelveMonkey {
    private static final System.Logger LOG = System.getLogger(TinyTwelveMonkey.class.getName());
    static final int COMPRESSION_CCITT_MODIFIED_HUFFMAN_RLE = 2;
    static final int COMPRESSION_CCITT_T4 = 3;
    static final int COMPRESSION_CCITT_T6 = 4;
    static final int GROUP3OPT_2DENCODING = 1;
    static final int GROUP3OPT_UNCOMPRESSED = 2;
    static final int GROUP3OPT_FILLBITS = 4;
    static final int GROUP3OPT_BYTEALIGNED = 8;
    static final int GROUP4OPT_UNCOMPRESSED = 2;
    static final int GROUP4OPT_BYTEALIGNED = 4;
    static final int TAG_GROUP3OPTIONS = 292;
    static final int TAG_GROUP4OPTIONS = 293;
    static final int FILL_LEFT_TO_RIGHT = 1;

    private TinyTwelveMonkey() {
    }

    static int findCCITTType(int encodedCompression, InputStream stream) throws IOException {
        int compressionType = CCITTFaxDecoderStreamAdapted.findCompressionType(encodedCompression, stream);
        if (compressionType != encodedCompression) {
            LOG.log(System.Logger.Level.DEBUG, "CCITTFaxDecoderStreamAdapted detected compression type %d, that does not match encoded CCITT compression type: %d".formatted(compressionType, encodedCompression));
        }
        return compressionType;
    }

    public static long getCCITTReadingOptions(TiffIFD ifd, int compression) {
        return switch (compression) {
            case 2 -> 0L;
            case 3 -> ifd.optLong(292, 0L);
            case 4 -> ifd.optLong(293, 0L);
            default -> throw new IllegalArgumentException("No CCITT options for compression: " + compression);
        };
    }

    public static long getCCITTWritingOptions(TiffIFD ifd, int compression) {
        if (compression != 2) {
            return ifd.optLong(compression == 3 ? 292 : 293, 0L);
        }
        return 0L;
    }

    static <T> T notNull(T pParameter, String pParamName) {
        if (pParameter == null) {
            throw new IllegalArgumentException(String.format("%s may not be null", pParamName == null ? "method parameter" : pParamName));
        }
        return pParameter;
    }

    static boolean isTrue(boolean pExpression, String pMessage) {
        return TinyTwelveMonkey.isTrue(pExpression, pExpression, pMessage);
    }

    static <T> T isTrue(boolean condition, T value, String message) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message == null ? "expression may not be %s" : message, value));
        }
        return value;
    }
}

