/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.codecs;

import java.lang.reflect.InvocationTargetException;
import java.nio.ByteOrder;
import java.util.Objects;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;

public interface TiffCodec {
    public byte[] compress(byte[] var1, Options var2) throws TiffException;

    public byte[] decompress(byte[] var1, Options var2) throws TiffException;

    public static class Options
    implements Cloneable {
        int width = 0;
        int height = 0;
        int numberOfChannels = 0;
        int bitsPerSample = 0;
        boolean signed = false;
        boolean floatingPoint = false;
        int compressionCode = 1;
        boolean littleEndian = false;
        boolean interleaved = false;
        int maxSizeInBytes = 0;
        private Double compressionQuality = null;
        private Double losslessCompressionLevel = null;
        private TiffIFD ifd = null;

        public int getWidth() {
            return this.width;
        }

        public Options setWidth(int width) {
            if (width < 0) {
                throw new IllegalArgumentException("Negative width = " + width);
            }
            this.width = width;
            return this;
        }

        public int getHeight() {
            return this.height;
        }

        public Options setHeight(int height) {
            if (height < 0) {
                throw new IllegalArgumentException("Negative height = " + height);
            }
            this.height = height;
            return this;
        }

        public Options setSizes(int width, int height) {
            return this.setWidth(width).setHeight(height);
        }

        public int getNumberOfChannels() {
            return this.numberOfChannels;
        }

        public Options setNumberOfChannels(int numberOfChannels) {
            if (numberOfChannels < 0) {
                throw new IllegalArgumentException("Negative numberOfChannels = " + numberOfChannels);
            }
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        public int getBitsPerSample() {
            return this.bitsPerSample;
        }

        public Options setBitsPerSample(int bitsPerSample) {
            if (bitsPerSample < 0) {
                throw new IllegalArgumentException("Negative bitsPerSample = " + bitsPerSample);
            }
            this.bitsPerSample = bitsPerSample;
            return this;
        }

        public boolean isSigned() {
            return this.signed;
        }

        public Options setSigned(boolean signed) {
            this.signed = signed;
            return this;
        }

        public boolean isFloatingPoint() {
            return this.floatingPoint;
        }

        public Options setFloatingPoint(boolean floatingPoint) {
            this.floatingPoint = floatingPoint;
            return this;
        }

        public int getCompressionCode() {
            return this.compressionCode;
        }

        public Options setCompressionCode(int compressionCode) {
            this.compressionCode = compressionCode;
            return this;
        }

        public boolean isLittleEndian() {
            return this.littleEndian;
        }

        public Options setLittleEndian(boolean littleEndian) {
            this.littleEndian = littleEndian;
            return this;
        }

        public Options setByteOrder(ByteOrder byteOrder) {
            Objects.requireNonNull(byteOrder, "Null byteOrder");
            this.littleEndian = byteOrder == ByteOrder.LITTLE_ENDIAN;
            return this;
        }

        public boolean isInterleaved() {
            return this.interleaved;
        }

        public Options setInterleaved(boolean interleaved) {
            this.interleaved = interleaved;
            return this;
        }

        public int getMaxSizeInBytes() {
            return this.maxSizeInBytes;
        }

        public Options setMaxSizeInBytes(int maxSizeInBytes) {
            if (maxSizeInBytes < 0) {
                throw new IllegalArgumentException("Negative maxSizeInBytes = " + maxSizeInBytes);
            }
            this.maxSizeInBytes = maxSizeInBytes;
            return this;
        }

        public boolean hasQuality() {
            return this.compressionQuality != null;
        }

        public Double getCompressionQuality() {
            return this.compressionQuality;
        }

        public Options setCompressionQuality(Double compressionQuality) {
            this.compressionQuality = compressionQuality;
            return this;
        }

        public double compressionQuality() {
            if (this.compressionQuality == null) {
                throw new IllegalStateException("Lossy quality level is required, but is not set");
            }
            return this.compressionQuality;
        }

        public Double getLosslessCompressionLevel() {
            return this.losslessCompressionLevel;
        }

        public Options setLosslessCompressionLevel(Double losslessCompressionLevel) {
            this.losslessCompressionLevel = losslessCompressionLevel;
            return this;
        }

        public TiffIFD getIfd() {
            return this.ifd;
        }

        public Options setIfd(TiffIFD ifd) {
            this.ifd = ifd;
            return this;
        }

        public Options setTo(Options options) {
            Objects.requireNonNull(options, "Null options");
            this.width = options.width;
            this.height = options.height;
            this.numberOfChannels = options.numberOfChannels;
            this.bitsPerSample = options.bitsPerSample;
            this.signed = options.signed;
            this.floatingPoint = options.floatingPoint;
            this.littleEndian = options.littleEndian;
            this.interleaved = options.interleaved;
            this.maxSizeInBytes = options.maxSizeInBytes;
            this.compressionQuality = options.compressionQuality;
            this.losslessCompressionLevel = options.losslessCompressionLevel;
            this.ifd = options.ifd;
            return this;
        }

        public final Object toSCIFIOStyleOptions(String scifioStyleClassName) {
            Class<?> c;
            Objects.requireNonNull(scifioStyleClassName, "Null scifioStyleClassName");
            try {
                c = Class.forName(scifioStyleClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("No class " + scifioStyleClassName, e);
            }
            return this.toSCIFIOStyleOptions(c);
        }

        public <T> T toSCIFIOStyleOptions(Class<T> scifioStyleClass) {
            T result;
            Objects.requireNonNull(scifioStyleClass, "Null scifioStyleClass");
            try {
                result = scifioStyleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Class " + String.valueOf(scifioStyleClass) + " cannot be created with empty constructor", e);
            }
            Options.setField(scifioStyleClass, result, "width", this.width);
            Options.setField(scifioStyleClass, result, "height", this.height);
            Options.setField(scifioStyleClass, result, "channels", this.numberOfChannels);
            Options.setField(scifioStyleClass, result, "bitsPerSample", this.bitsPerSample);
            Options.setField(scifioStyleClass, result, "littleEndian", this.littleEndian);
            Options.setField(scifioStyleClass, result, "interleaved", this.interleaved);
            Options.setField(scifioStyleClass, result, "maxBytes", this.maxSizeInBytes);
            if (this.compressionQuality != null) {
                Options.setField(scifioStyleClass, result, "quality", this.compressionQuality);
            }
            return result;
        }

        public void setToSCIFIOStyleOptions(Object scifioStyleOptions) {
            Objects.requireNonNull(scifioStyleOptions, "Null scifioStyleOptions");
            this.setWidth(Options.getField(scifioStyleOptions, Integer.class, "width"));
            this.setHeight(Options.getField(scifioStyleOptions, Integer.class, "height"));
            this.setNumberOfChannels(Options.getField(scifioStyleOptions, Integer.class, "channels"));
            this.setBitsPerSample(Options.getField(scifioStyleOptions, Integer.class, "bitsPerSample"));
            this.setSigned(false);
            this.setFloatingPoint(false);
            this.setLittleEndian(Options.getField(scifioStyleOptions, Boolean.class, "littleEndian"));
            this.setInterleaved(Options.getField(scifioStyleOptions, Boolean.class, "interleaved"));
            this.setMaxSizeInBytes(Options.getField(scifioStyleOptions, Integer.class, "maxBytes"));
            this.setCompressionQuality(Options.getField(scifioStyleOptions, Double.class, "quality"));
        }

        public String toString() {
            return "Options: width=" + this.width + ", height=" + this.height + ", numberOfChannels=" + this.numberOfChannels + ", bitsPerSample=" + this.bitsPerSample + ", signed=" + this.signed + ", floatingPoint=" + this.floatingPoint + ", compressionCode=" + this.compressionCode + ", littleEndian=" + this.littleEndian + ", interleaved=" + this.interleaved + ", maxSizeInBytes=" + this.maxSizeInBytes + ", compressionQuality=" + this.compressionQuality + ", losslessCompressionLevel=" + this.losslessCompressionLevel;
        }

        public Options clone() {
            Options result;
            try {
                result = (Options)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
            result.setTo(this);
            return result;
        }

        static void setField(Class<?> oldStyleClass, Object result, String fieldName, Object value) {
            try {
                oldStyleClass.getField(fieldName).set(result, value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException("Cannot set field \"" + fieldName + "\" in the class " + oldStyleClass.getName() + ": " + String.valueOf(e));
            }
        }

        static <T> T getField(Object options, Class<T> fieldType, String fieldName) {
            Object result;
            Class<?> oldStyleClass = options.getClass();
            try {
                result = oldStyleClass.getField(fieldName).get(options);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException("Cannot get field \"" + fieldName + "\" in the class " + oldStyleClass.getName() + ": " + String.valueOf(e));
            }
            try {
                return fieldType.cast(result);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid type of the field \"" + fieldName + "\" in the class " + oldStyleClass.getName() + ": " + String.valueOf(result.getClass()) + " instead of required " + String.valueOf(fieldType));
            }
        }
    }

    public static interface Timing {
        public void setTiming(boolean var1);

        public void clearTiming();

        public long timeMain();

        public long timeBridge();

        public long timeAdditional();
    }
}

