/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.codecs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.codecs.CCITTFaxDecoderStreamAdapted;
import net.algart.matrices.tiff.codecs.CCITTFaxEncoderStreamAdapted;
import net.algart.matrices.tiff.codecs.TiffCodec;
import net.algart.matrices.tiff.codecs.TinyTwelveMonkey;
import net.algart.matrices.tiff.tags.TagCompression;

public class CCITTFaxCodec
implements TiffCodec {
    @Override
    public byte[] compress(byte[] data, TiffCodec.Options options) throws TiffException {
        Objects.requireNonNull(data, "Null data");
        Objects.requireNonNull(options, "Null codec options");
        TiffIFD ifd = options.getIfd();
        Objects.requireNonNull(ifd, "IFD is not set in the options");
        if (options.numberOfChannels != 1 || options.bitsPerSample != 1) {
            throw new TiffException("CCITT compression (" + TagCompression.toPrettyString(options.compressionCode) + ") for " + options.numberOfChannels + " channels and " + options.bitsPerSample + "-bit samples is not allowed (CCITT compressions support 1 sample/pixel, 1 bit/sample only)");
        }
        ByteArrayOutputStream compressedDataStream = new ByteArrayOutputStream();
        long writingOptions = TinyTwelveMonkey.getCCITTWritingOptions(ifd, options.compressionCode);
        CCITTFaxEncoderStreamAdapted compressorStream = new CCITTFaxEncoderStreamAdapted(compressedDataStream, options.width, options.height, options.compressionCode, 1, writingOptions);
        try {
            compressorStream.write(data);
            ((OutputStream)compressorStream).close();
        }
        catch (IOException e) {
            throw new TiffException(e);
        }
        return compressedDataStream.toByteArray();
    }

    @Override
    public byte[] decompress(byte[] data, TiffCodec.Options options) throws TiffException {
        Objects.requireNonNull(data, "Null data");
        Objects.requireNonNull(options, "Null codec options");
        TiffIFD ifd = options.getIfd();
        Objects.requireNonNull(ifd, "IFD is not set in the options");
        ByteArrayInputStream compressedDataStream = new ByteArrayInputStream(data);
        long readingOptions = TinyTwelveMonkey.getCCITTReadingOptions(ifd, options.compressionCode);
        try {
            int overrideCCITTCompressionCode = TinyTwelveMonkey.findCCITTType(options.compressionCode, compressedDataStream);
            CCITTFaxDecoderStreamAdapted decompressorStream = new CCITTFaxDecoderStreamAdapted(compressedDataStream, options.width, options.height, overrideCCITTCompressionCode, readingOptions, options.compressionCode == 2);
            int bitsPerPixel = options.numberOfChannels * options.bitsPerSample;
            int bytesPerRow = (bitsPerPixel * options.width + 7) / 8;
            int resultSize = bytesPerRow * options.height;
            return decompressorStream.readNBytes(resultSize);
        }
        catch (IOException e) {
            throw new TiffException(e);
        }
    }
}

