/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.awt;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.MemoryCacheImageInputStream;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.tags.TagPhotometricInterpretation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JPEGDecoding {
    private static final System.Logger LOG = System.getLogger(JPEGDecoding.class.getName());
    static final boolean USE_MEMORY_CACHE = true;
    private static final boolean IGNORE_EXCEPTION_WHILE_ATTEMPT_TO_READ_METADATA = true;

    private JPEGDecoding() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInformation readJPEG(InputStream in) throws IOException {
        MemoryCacheImageInputStream stream = new MemoryCacheImageInputStream(in);
        ImageReader reader = JPEGDecoding.getImageReaderOrNull(stream);
        if (reader == null) {
            return null;
        }
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        try {
            IIOMetadata imageMetadata = null;
            try {
                imageMetadata = reader.getImageMetadata(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            BufferedImage image = reader.read(0, param);
            ImageInformation imageInformation = new ImageInformation(image, imageMetadata);
            return imageInformation;
        }
        finally {
            reader.dispose();
        }
    }

    public static String tryToFindColorSpace(IIOMetadata metadata) {
        if (metadata == null) {
            return null;
        }
        Node tree = metadata.getAsTree("javax_imageio_1.0");
        NodeList rootNodes = tree.getChildNodes();
        int n = rootNodes.getLength();
        for (int k = 0; k < n; ++k) {
            Node rootChild = rootNodes.item(k);
            String childName = rootChild.getNodeName();
            if (!"Chroma".equalsIgnoreCase(childName)) continue;
            NodeList nodes = rootChild.getChildNodes();
            int m = nodes.getLength();
            for (int i = 0; i < m; ++i) {
                Node subChild = nodes.item(i);
                String subChildName = subChild.getNodeName();
                if (!"ColorSpaceType".equalsIgnoreCase(subChildName)) continue;
                NamedNodeMap attributes = subChild.getAttributes();
                Node name = attributes.getNamedItem("name");
                return name.getNodeValue();
            }
        }
        return null;
    }

    public static boolean isCompleteDecodingYCbCrNecessary(ImageInformation imageInformation, TagPhotometricInterpretation declaredColorSpace, int[] declaredSubsampling) {
        Objects.requireNonNull(imageInformation, "Null image information");
        Objects.requireNonNull(declaredColorSpace, "Null color space");
        Objects.requireNonNull(declaredSubsampling, "Null declared subsampling");
        String colorSpace = JPEGDecoding.tryToFindColorSpace(imageInformation.metadata);
        return "RGB".equalsIgnoreCase(colorSpace) && declaredColorSpace == TagPhotometricInterpretation.Y_CB_CR && declaredSubsampling.length >= 2 && declaredSubsampling[0] == 1 && declaredSubsampling[1] == 1 && imageInformation.bufferedImage.getRaster().getNumBands() == 3;
    }

    public static void completeDecodingYCbCr(byte[][] data, ImageInformation imageInformation, TagPhotometricInterpretation declaredColorSpace, int[] declaredSubsampling) throws TiffException {
        Objects.requireNonNull(data, "Null data");
        Objects.requireNonNull(imageInformation, "Null image information");
        Objects.requireNonNull(declaredColorSpace, "Null color space");
        Objects.requireNonNull(declaredSubsampling, "Null declared subsampling");
        long bandLength = (long)imageInformation.bufferedImage.getWidth() * (long)imageInformation.bufferedImage.getHeight();
        if ((long)data[0].length != bandLength) {
            throw new TiffException("Cannot correct unpacked JPEG: number of bytes per sample in JPEG must be 1, but actually we have " + (double)data[0].length / (double)bandLength + " bytes/sample");
        }
        for (int i = 0; i < data[0].length; ++i) {
            int y = data[0][i] & 0xFF;
            int cb = data[1][i] & 0xFF;
            int cr = data[2][i] & 0xFF;
            double red = (double)y + 1.402 * (double)(cr -= 128);
            double green = (double)y - 0.34414 * (double)(cb -= 128) - 0.71414 * (double)cr;
            double blue = (double)y + 1.772 * (double)cb;
            data[0][i] = (byte)JPEGDecoding.toUnsignedByte(red);
            data[1][i] = (byte)JPEGDecoding.toUnsignedByte(green);
            data[2][i] = (byte)JPEGDecoding.toUnsignedByte(blue);
        }
    }

    public static ImageReader getImageReaderOrNull(Object inputStream) {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(inputStream);
        return JPEGDecoding.findAWTCodec(readers);
    }

    static <T> T findAWTCodec(Iterator<T> iterator) {
        if (!iterator.hasNext()) {
            return null;
        }
        T first = iterator.next();
        if (JPEGDecoding.isProbableAWTClass(first)) {
            return first;
        }
        while (iterator.hasNext()) {
            T other = iterator.next();
            if (!JPEGDecoding.isProbableAWTClass(other)) continue;
            return other;
        }
        return first;
    }

    private static int toUnsignedByte(double v) {
        return v < 0.0 ? 0 : (v > 255.0 ? 255 : (int)Math.round(v));
    }

    private static boolean isProbableAWTClass(Object o) {
        return o != null && o.getClass().getName().startsWith("com.sun.");
    }

    public record ImageInformation(BufferedImage bufferedImage, IIOMetadata metadata) {
    }
}

