/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.awt;

import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteOrder;
import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.matrices.tiff.awt.SignedByteBuffer;
import net.algart.matrices.tiff.awt.SignedShortBuffer;
import net.algart.matrices.tiff.awt.TwoChannelColorSpace;
import net.algart.matrices.tiff.awt.UnsignedIntBuffer;
import net.algart.matrices.tiff.awt.UnsignedIntColorModel;

public final class AWTImages {
    private AWTImages() {
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, boolean signed) {
        return AWTImages.makeImage(new byte[][]{data}, w, h, signed);
    }

    public static BufferedImage makeImage(short[] data, int w, int h, boolean signed) {
        return AWTImages.makeImage(new short[][]{data}, w, h, signed);
    }

    public static BufferedImage makeImage(int[] data, int w, int h, boolean signed) {
        return AWTImages.makeImage(new int[][]{data}, w, h, signed);
    }

    public static BufferedImage makeImage(float[] data, int w, int h) {
        return AWTImages.makeImage(new float[][]{data}, w, h);
    }

    public static BufferedImage makeImage(double[] data, int w, int h) {
        return AWTImages.makeImage(new double[][]{data}, w, h);
    }

    public static BufferedImage makeSeparatedImage(byte[] data, int w, int h, int c) {
        return AWTImages.makeImage(data, w, h, c, false);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved) {
        return AWTImages.makeImage(data, w, h, c, interleaved, false);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, boolean signed) {
        if (c == 1) {
            return AWTImages.makeImage(data, w, h, signed);
        }
        if (c > 2) {
            return AWTImages.makeRGBImage(data, c, w, h, interleaved);
        }
        int dataType = 0;
        DataBuffer buffer = signed ? new SignedByteBuffer(data, c * w * h) : new DataBufferByte(data, c * w * h);
        return AWTImages.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(short[] data, int w, int h, int c, boolean interleaved, boolean signed) {
        DataBuffer buffer;
        int dataType;
        if (c == 1) {
            return AWTImages.makeImage(data, w, h, signed);
        }
        if (signed) {
            dataType = 2;
            buffer = new SignedShortBuffer(data, c * w * h);
        } else {
            dataType = 1;
            buffer = new DataBufferUShort(data, c * w * h);
        }
        return AWTImages.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(int[] data, int w, int h, int c, boolean interleaved, boolean signed) {
        if (c == 1) {
            return AWTImages.makeImage(data, w, h, signed);
        }
        int dataType = 3;
        DataBuffer buffer = signed ? new DataBufferInt(data, c * w * h) : new UnsignedIntBuffer(data, c * w * h);
        return AWTImages.constructImage(c, 3, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(float[] data, int w, int h, int c, boolean interleaved) {
        if (c == 1) {
            return AWTImages.makeImage(data, w, h);
        }
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, c * w * h);
        return AWTImages.constructImage(c, 4, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(double[] data, int w, int h, int c, boolean interleaved) {
        if (c == 1) {
            return AWTImages.makeImage(data, w, h);
        }
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, c * w * h);
        return AWTImages.constructImage(c, 5, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, boolean signed) {
        if (data.length > 2) {
            return AWTImages.makeRGBImage(data, w, h);
        }
        int dataType = 0;
        DataBuffer buffer = signed ? new SignedByteBuffer(data, data[0].length) : new DataBufferByte(data, data[0].length);
        return AWTImages.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(short[][] data, int w, int h, boolean signed) {
        DataBuffer buffer;
        int dataType;
        if (signed) {
            dataType = 2;
            buffer = new SignedShortBuffer(data, data[0].length);
        } else {
            dataType = 1;
            buffer = new DataBufferUShort(data, data[0].length);
        }
        return AWTImages.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(int[][] data, int w, int h, boolean signed) {
        int dataType = 3;
        DataBuffer buffer = signed ? new DataBufferInt(data, data[0].length) : new UnsignedIntBuffer(data, data[0].length);
        return AWTImages.constructImage(data.length, 3, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(float[][] data, int w, int h) {
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, data[0].length);
        return AWTImages.constructImage(data.length, 4, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(double[][] data, int w, int h) {
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, data[0].length);
        return AWTImages.constructImage(data.length, 5, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, int bpp, boolean fp, boolean little, boolean signed) {
        Object pixels = AWTImages.makeArray(data, bpp % 3 == 0 ? bpp / 3 : bpp, fp, little);
        if (pixels instanceof byte[]) {
            return AWTImages.makeImage((byte[])pixels, w, h, c, interleaved, signed);
        }
        if (pixels instanceof short[]) {
            return AWTImages.makeImage((short[])pixels, w, h, c, interleaved, signed);
        }
        if (pixels instanceof int[]) {
            return AWTImages.makeImage((int[])pixels, w, h, c, interleaved, signed);
        }
        if (pixels instanceof float[]) {
            return AWTImages.makeImage((float[])pixels, w, h, c, interleaved);
        }
        if (pixels instanceof double[]) {
            return AWTImages.makeImage((double[])pixels, w, h, c, interleaved);
        }
        return null;
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, int bpp, boolean fp, boolean little, boolean signed) {
        int c = data.length;
        Object v = null;
        for (int i = 0; i < c; ++i) {
            Object pixels = AWTImages.makeArray(data[i], bpp % 3 == 0 ? bpp / 3 : bpp, fp, little);
            if (pixels instanceof byte[]) {
                if (v == null) {
                    v = new byte[c][];
                }
                ((byte[][])v)[i] = (byte[])pixels;
                continue;
            }
            if (pixels instanceof short[]) {
                if (v == null) {
                    v = new short[c][];
                }
                ((short[][])v)[i] = (short[])pixels;
                continue;
            }
            if (pixels instanceof int[]) {
                if (v == null) {
                    v = new int[c][];
                }
                ((int[][])v)[i] = (int[])pixels;
                continue;
            }
            if (pixels instanceof float[]) {
                if (v == null) {
                    v = new float[c][];
                }
                ((float[][])v)[i] = (float[])pixels;
                continue;
            }
            if (!(pixels instanceof double[])) continue;
            if (v == null) {
                v = new double[c][];
            }
            ((double[][])v)[i] = (double[])pixels;
        }
        if (v instanceof byte[][]) {
            return AWTImages.makeImage(v, w, h, signed);
        }
        if (v instanceof short[][]) {
            return AWTImages.makeImage((short[][])v, w, h, signed);
        }
        if (v instanceof int[][]) {
            return AWTImages.makeImage((int[][])v, w, h, signed);
        }
        if (v instanceof float[][]) {
            return AWTImages.makeImage(v, w, h);
        }
        if (v instanceof double[][]) {
            return AWTImages.makeImage((double[][])v, w, h);
        }
        return null;
    }

    public static BufferedImage makeRGBImage(byte[] data, int c, int w, int h, boolean interleaved) {
        int cc = Math.min(c, 4);
        int[] buf = new int[data.length / c];
        int nBits = (cc - 1) * 8;
        for (int i = 0; i < buf.length; ++i) {
            for (int q = 0; q < cc; ++q) {
                if (interleaved) {
                    int n = i;
                    buf[n] = buf[n] | (data[i * c + q] & 0xFF) << nBits - q * 8;
                    continue;
                }
                int n = i;
                buf[n] = buf[n] | (data[q * buf.length + i] & 0xFF) << nBits - q * 8;
            }
        }
        DataBufferInt buffer = new DataBufferInt(buf, buf.length);
        return AWTImages.constructImage(cc, 3, w, h, false, false, buffer);
    }

    public static BufferedImage makeRGBImage(byte[][] data, int w, int h) {
        int[] buf = new int[data[0].length];
        int nBits = (data.length - 1) * 8;
        for (int i = 0; i < buf.length; ++i) {
            for (int q = 0; q < data.length; ++q) {
                int n = i;
                buf[n] = buf[n] | (data[q][i] & 0xFF) << nBits - q * 8;
            }
        }
        DataBufferInt buffer = new DataBufferInt(buf, buf.length);
        return AWTImages.constructImage(data.length, 3, w, h, false, false, buffer);
    }

    public static BufferedImage constructImage(int c, int type, int w, int h, boolean interleaved, boolean banded, DataBuffer buffer) {
        return AWTImages.constructImage(c, type, w, h, interleaved, banded, buffer, null);
    }

    public static BufferedImage constructImage(int c, int type, int w, int h, boolean interleaved, boolean banded, DataBuffer buffer, ColorModel colorModel) {
        SampleModel model;
        if (c > 4) {
            throw new IllegalArgumentException("Cannot construct image with " + c + " channels");
        }
        if (colorModel == null || colorModel instanceof DirectColorModel) {
            colorModel = AWTImages.makeColorModel(c, type);
            if (colorModel == null) {
                return null;
            }
            if (buffer instanceof UnsignedIntBuffer) {
                colorModel = new UnsignedIntColorModel(32, type, c);
            }
        }
        if (c > 2 && type == 3 && buffer.getNumBanks() == 1 && !(buffer instanceof UnsignedIntBuffer)) {
            int[] bitMasks = new int[c];
            for (i = 0; i < c; ++i) {
                bitMasks[i] = 255 << (c - i - 1) * 8;
            }
            model = new SinglePixelPackedSampleModel(3, w, h, bitMasks);
        } else if (banded) {
            model = new BandedSampleModel(type, w, h, c);
        } else if (interleaved) {
            bandOffsets = new int[c];
            for (i = 0; i < c; ++i) {
                bandOffsets[i] = i;
            }
            model = new PixelInterleavedSampleModel(type, w, h, c, c * w, bandOffsets);
        } else {
            bandOffsets = new int[c];
            for (i = 0; i < c; ++i) {
                bandOffsets[i] = i * w * h;
            }
            model = new ComponentSampleModel(type, w, h, 1, w, bandOffsets);
        }
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        BufferedImage b = null;
        if (c == 1 && type == 0 && !(buffer instanceof SignedByteBuffer)) {
            b = colorModel instanceof IndexColorModel ? new BufferedImage(w, h, 13) : new BufferedImage(w, h, 10);
            b.setData(raster);
        } else if (c == 1 && type == 1) {
            if (!(colorModel instanceof IndexColorModel)) {
                b = new BufferedImage(w, h, 11);
                b.setData(raster);
            }
        } else if (c > 2 && type == 3 && buffer.getNumBanks() == 1 && !(buffer instanceof UnsignedIntBuffer)) {
            b = c == 3 ? new BufferedImage(w, h, 1) : new BufferedImage(w, h, 2);
            b.setData(raster);
        }
        if (b == null) {
            b = new BufferedImage(colorModel, raster, false, null);
        }
        return b;
    }

    public static Object getPixels(BufferedImage image) {
        return AWTImages.getPixels(image, 0, 0, image.getWidth(), image.getHeight());
    }

    public static Object getPixels(BufferedImage image, int x, int y, int w, int h) {
        WritableRaster raster = image.getRaster();
        return AWTImages.getPixels(raster, x, y, w, h);
    }

    public static Object getPixels(WritableRaster raster) {
        return AWTImages.getPixels(raster, 0, 0, raster.getWidth(), raster.getHeight());
    }

    public static Object getPixels(WritableRaster raster, int x, int y, int w, int h) {
        int tt = raster.getTransferType();
        if (tt == 0) {
            return AWTImages.getBytes(raster, x, y, w, h);
        }
        if (tt == 1 || tt == 2) {
            return AWTImages.getShorts(raster, x, y, w, h);
        }
        if (tt == 3) {
            return AWTImages.getInts(raster, x, y, w, h);
        }
        if (tt == 4) {
            return AWTImages.getFloats(raster, x, y, w, h);
        }
        if (tt == 5) {
            return AWTImages.getDoubles(raster, x, y, w, h);
        }
        return null;
    }

    public static byte[][] getBytes(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImages.getBytes(r);
    }

    public static byte[][] getBytes(WritableRaster r) {
        return AWTImages.getBytes(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static byte[][] getBytes(WritableRaster r, int x, int y, int w, int h) {
        int[] rgbIndexes;
        boolean wholeImage;
        boolean bl = wholeImage = x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight();
        if (wholeImage && AWTImages.canDirectlyUseBankData(r, 0, DataBufferByte.class)) {
            return ((DataBufferByte)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        byte[][] samples = new byte[c][w * h];
        if (wholeImage && (rgbIndexes = AWTImages.tryDirectlyUseBankDataForRGB(r)) != null) {
            assert (c == 3);
            byte[][] data = ((DataBufferByte)r.getDataBuffer()).getBankData();
            if (data.length == 1 && (long)data[0].length == 3L * (long)w * (long)h) {
                AWTImages.separateRGB(samples, rgbIndexes, data[0], w * h);
                return samples;
            }
        }
        int[] buf = new int[w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (byte)buf[j];
            }
        }
        return samples;
    }

    public static short[][] getShorts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImages.getShorts(r);
    }

    public static short[][] getShorts(WritableRaster r) {
        return AWTImages.getShorts(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static short[][] getShorts(WritableRaster r, int x, int y, int w, int h) {
        boolean wholeImage;
        boolean bl = wholeImage = x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight();
        if (wholeImage && AWTImages.canDirectlyUseBankData(r, 1, DataBufferUShort.class)) {
            return ((DataBufferUShort)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        short[][] samples = new short[c][w * h];
        int[] buf = new int[w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (short)buf[j];
            }
        }
        return samples;
    }

    public static int[][] getInts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImages.getInts(r);
    }

    public static int[][] getInts(WritableRaster r) {
        return AWTImages.getInts(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static int[][] getInts(WritableRaster r, int x, int y, int w, int h) {
        boolean wholeImage;
        boolean bl = wholeImage = x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight();
        if (wholeImage && AWTImages.canDirectlyUseBankData(r, 3, DataBufferInt.class)) {
            return ((DataBufferInt)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        int[][] samples = new int[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h, i, samples[i]);
        }
        return samples;
    }

    public static float[][] getFloats(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImages.getFloats(r);
    }

    public static float[][] getFloats(WritableRaster r) {
        return AWTImages.getFloats(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static float[][] getFloats(WritableRaster r, int x, int y, int w, int h) {
        boolean wholeImage;
        boolean bl = wholeImage = x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight();
        if (wholeImage && AWTImages.canDirectlyUseBankData(r, 4, DataBufferFloat.class)) {
            return ((DataBufferFloat)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        float[][] samples = new float[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h, i, samples[i]);
        }
        return samples;
    }

    public static double[][] getDoubles(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImages.getDoubles(r);
    }

    public static double[][] getDoubles(WritableRaster r) {
        return AWTImages.getDoubles(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static double[][] getDoubles(WritableRaster r, int x, int y, int w, int h) {
        boolean wholeImage;
        boolean bl = wholeImage = x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight();
        if (wholeImage && AWTImages.canDirectlyUseBankData(r, 5, DataBufferDouble.class)) {
            return ((DataBufferDouble)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        double[][] samples = new double[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h, i, samples[i]);
        }
        return samples;
    }

    public static byte[][] getPixelBytes(BufferedImage img, boolean little) {
        return AWTImages.getPixelBytes(img, little, 0, 0, img.getWidth(), img.getHeight());
    }

    public static byte[][] getPixelBytes(WritableRaster r, boolean little) {
        return AWTImages.getPixelBytes(r, little, 0, 0, r.getWidth(), r.getHeight());
    }

    public static byte[][] getPixelBytes(BufferedImage img, boolean little, int x, int y, int w, int h) {
        byte[][] pixelBytes;
        block14: {
            ByteOrder byteOrder;
            Object pixels;
            block17: {
                block16: {
                    int imageType;
                    block15: {
                        block13: {
                            pixels = AWTImages.getPixels(img, x, y, w, h);
                            imageType = img.getType();
                            pixelBytes = null;
                            ByteOrder byteOrder2 = byteOrder = little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                            if (!(pixels instanceof byte[][])) break block13;
                            pixelBytes = (byte[][])pixels;
                            break block14;
                        }
                        if (!(pixels instanceof short[][])) break block15;
                        short[][] s = (short[][])pixels;
                        pixelBytes = new byte[s.length][s[0].length * 2];
                        for (int i = 0; i < pixelBytes.length; ++i) {
                            for (int j = 0; j < s[0].length; ++j) {
                                JArrays.setBytes8((byte[])pixelBytes[i], (int)(j * 2), (long)s[i][j], (int)2, (ByteOrder)byteOrder);
                            }
                        }
                        break block14;
                    }
                    if (!(pixels instanceof int[][])) break block16;
                    int[][] in = (int[][])pixels;
                    if (imageType == 1 || imageType == 4 || imageType == 2) {
                        pixelBytes = new byte[in.length][in[0].length];
                        for (int c = 0; c < in.length; ++c) {
                            for (int i = 0; i < in[0].length; ++i) {
                                if (imageType != 4) {
                                    pixelBytes[c][i] = (byte)(in[c][i] & 0xFF);
                                    continue;
                                }
                                pixelBytes[in.length - c - 1][i] = (byte)(in[c][i] & 0xFF);
                            }
                        }
                    } else {
                        pixelBytes = new byte[in.length][in[0].length * 4];
                        for (int i = 0; i < pixelBytes.length; ++i) {
                            for (int j = 0; j < in[0].length; ++j) {
                                JArrays.setBytes8((byte[])pixelBytes[i], (int)(j * 4), (long)in[i][j], (int)4, (ByteOrder)byteOrder);
                            }
                        }
                    }
                    break block14;
                }
                if (!(pixels instanceof float[][])) break block17;
                float[][] in = (float[][])pixels;
                pixelBytes = new byte[in.length][in[0].length * 4];
                for (int i = 0; i < pixelBytes.length; ++i) {
                    for (int j = 0; j < in[0].length; ++j) {
                        int v = Float.floatToIntBits(in[i][j]);
                        JArrays.setBytes8((byte[])pixelBytes[i], (int)(j * 4), (long)v, (int)4, (ByteOrder)byteOrder);
                    }
                }
                break block14;
            }
            if (!(pixels instanceof double[][])) break block14;
            double[][] in = (double[][])pixels;
            pixelBytes = new byte[in.length][in[0].length * 8];
            for (int i = 0; i < pixelBytes.length; ++i) {
                for (int j = 0; j < in[0].length; ++j) {
                    long v = Double.doubleToLongBits(in[i][j]);
                    JArrays.setBytes8((byte[])pixelBytes[i], (int)(j * 8), (long)v, (int)8, (ByteOrder)byteOrder);
                }
            }
        }
        return pixelBytes;
    }

    public static byte[][] getPixelBytes(WritableRaster r, boolean little, int x, int y, int w, int h) {
        ByteOrder byteOrder;
        Object pixels = AWTImages.getPixels(r);
        byte[][] pixelBytes = null;
        int bpp = 0;
        ByteOrder byteOrder2 = byteOrder = little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        if (pixels instanceof byte[][]) {
            pixelBytes = (byte[][])pixels;
            bpp = 1;
        } else if (pixels instanceof short[][]) {
            short[][] s = (short[][])pixels;
            bpp = 2;
            pixelBytes = new byte[s.length][s[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < s[0].length; ++j) {
                    JArrays.setBytes8((byte[])pixelBytes[i], (int)(j * bpp), (long)s[i][j], (int)bpp, (ByteOrder)byteOrder);
                }
            }
        } else if (pixels instanceof int[][]) {
            int[][] in = (int[][])pixels;
            bpp = 4;
            pixelBytes = new byte[in.length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    JArrays.setBytes8((byte[])pixelBytes[i], (int)(j * bpp), (long)in[i][j], (int)bpp, (ByteOrder)byteOrder);
                }
            }
        } else if (pixels instanceof float[][]) {
            float[][] in = (float[][])pixels;
            bpp = 4;
            pixelBytes = new byte[in.length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    int v = Float.floatToIntBits(in[i][j]);
                    JArrays.setBytes8((byte[])pixelBytes[i], (int)(j * bpp), (long)v, (int)bpp, (ByteOrder)byteOrder);
                }
            }
        } else if (pixels instanceof double[][]) {
            double[][] in = (double[][])pixels;
            bpp = 8;
            pixelBytes = new byte[in.length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    long v = Double.doubleToLongBits(in[i][j]);
                    JArrays.setBytes8((byte[])pixelBytes[i], (int)(j * bpp), (long)v, (int)bpp, (ByteOrder)byteOrder);
                }
            }
        }
        if (x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight()) {
            return pixelBytes;
        }
        byte[][] croppedBytes = new byte[pixelBytes.length][w * h * bpp];
        for (int c = 0; c < croppedBytes.length; ++c) {
            for (int row = 0; row < h; ++row) {
                int src = (row + y) * r.getWidth() * bpp + x * bpp;
                int dest = row * w * bpp;
                System.arraycopy(pixelBytes[c], src, croppedBytes[c], dest, w * bpp);
            }
        }
        return croppedBytes;
    }

    public static ColorSpace makeColorSpace(int c) {
        int type;
        switch (c) {
            case 1: {
                type = 1003;
                break;
            }
            case 2: {
                type = -1;
                break;
            }
            case 3: 
            case 4: {
                type = 1000;
                break;
            }
            default: {
                return null;
            }
        }
        return TwoChannelColorSpace.getInstance(type);
    }

    public static ColorModel makeColorModel(int c, int dataType) {
        ColorSpace cs = AWTImages.makeColorSpace(c);
        return cs == null ? null : new ComponentColorModel(cs, c == 4, false, 3, dataType);
    }

    private static boolean canDirectlyUseBankData(WritableRaster r, int transferType, Class<? extends DataBuffer> dataBufferClass) {
        int tt = r.getTransferType();
        if (tt != transferType) {
            return false;
        }
        DataBuffer buffer = r.getDataBuffer();
        if (!dataBufferClass.isInstance(buffer)) {
            return false;
        }
        SampleModel model = r.getSampleModel();
        if (!(model instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel csm = (ComponentSampleModel)model;
        int pixelStride = csm.getPixelStride();
        if (pixelStride != 1) {
            return false;
        }
        int w = r.getWidth();
        int scanlineStride = csm.getScanlineStride();
        if (scanlineStride != w) {
            return false;
        }
        int c = r.getNumBands();
        int[] bandOffsets = csm.getBandOffsets();
        if (bandOffsets.length != c) {
            return false;
        }
        for (int bandOffset : bandOffsets) {
            if (bandOffset == 0) continue;
            return false;
        }
        for (int i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] == i) continue;
            return false;
        }
        return true;
    }

    private static int[] tryDirectlyUseBankDataForRGB(WritableRaster raster) {
        if (raster.getTransferType() != 0) {
            return null;
        }
        DataBuffer buffer = raster.getDataBuffer();
        if (!(buffer instanceof DataBufferByte)) {
            return null;
        }
        if (raster.getNumBands() != 3) {
            return null;
        }
        SampleModel model = raster.getSampleModel();
        if (!(model instanceof ComponentSampleModel)) {
            return null;
        }
        ComponentSampleModel csm = (ComponentSampleModel)model;
        int pixelStride = csm.getPixelStride();
        if (pixelStride != 3) {
            return null;
        }
        int width = raster.getWidth();
        int scanlineStride = csm.getScanlineStride();
        if (scanlineStride != pixelStride * width) {
            return null;
        }
        int[] bandOffsets = csm.getBandOffsets();
        if (bandOffsets.length != 3) {
            return null;
        }
        if (bandOffsets[0] == 0 && bandOffsets[1] == 1 && bandOffsets[2] == 2) {
            return new int[]{0, 1, 2};
        }
        if (bandOffsets[0] == 2 && bandOffsets[1] == 1 && bandOffsets[2] == 0) {
            return new int[]{2, 1, 0};
        }
        return null;
    }

    private static void separateRGB(byte[][] result, int[] rgbIndexes, byte[] bytes, int numberOfPixels) {
        Objects.requireNonNull(bytes, "Null bytes");
        assert (bytes.length == 3 * numberOfPixels);
        byte[] rgb0 = result[rgbIndexes[0]];
        byte[] rgb1 = result[rgbIndexes[1]];
        byte[] rgb2 = result[rgbIndexes[2]];
        assert (rgb0.length == numberOfPixels);
        assert (rgb1.length == numberOfPixels);
        assert (rgb2.length == numberOfPixels);
        int disp = 0;
        for (int i = 0; i < numberOfPixels; ++i) {
            rgb0[i] = bytes[disp++];
            rgb1[i] = bytes[disp++];
            rgb2[i] = bytes[disp++];
        }
    }

    static Object makeArray(byte[] b, int bpp, boolean fp, boolean little) {
        ByteOrder byteOrder;
        ByteOrder byteOrder2 = byteOrder = little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        if (bpp == 1) {
            return b;
        }
        if (bpp == 2) {
            return JArrays.bytesToShortArray((byte[])b, (ByteOrder)byteOrder);
        }
        if (bpp == 4 && fp) {
            return JArrays.bytesToFloatArray((byte[])b, (ByteOrder)byteOrder);
        }
        if (bpp == 4) {
            return JArrays.bytesToIntArray((byte[])b, (ByteOrder)byteOrder);
        }
        if (bpp == 8 && fp) {
            return JArrays.bytesToDoubleArray((byte[])b, (ByteOrder)byteOrder);
        }
        if (bpp == 8) {
            return JArrays.bytesToLongArray((byte[])b, (ByteOrder)byteOrder);
        }
        return null;
    }
}

