/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffImageKind;
import net.algart.matrices.tiff.app.TiffInfo;
import net.algart.matrices.tiff.app.TiffInfoImageViewer;
import net.algart.matrices.tiff.pyramids.TiffPyramidMetadata;

public class TiffInfoViewer {
    public static final String ALGART_TIFF_WEBSITE = "https://algart.net/java/AlgART-TIFF/";
    private static final String APPLICATION_TITLE = "TIFF Information Viewer";
    private static final boolean DEFAULT_WORD_WRAP = false;
    private static final int DEFAULT_FONT_SIZE = 15;
    private static final int[] FONT_SIZES = new int[]{12, 15, 18, 22};
    private static final Color COMMON_BACKGROUND = new Color(240, 240, 240);
    private static final Color ERROR_BACKGROUND = new Color(255, 255, 155);
    private static final Color SVS_FOREGROUND = new Color(0, 128, 0);
    private static final String PREF_LAST_DIR = "lastDirectory";
    private static final String PREF_WINDOW_X = "windowX";
    private static final String PREF_WINDOW_Y = "windowY";
    private static final String PREF_WINDOW_WIDTH = "windowWidth";
    private static final String PREF_WINDOW_HEIGHT = "windowHeight";
    static final System.Logger LOG = System.getLogger(TiffInfoViewer.class.getName());
    private static final FileFilter TIFF_FILTER = new FileNameExtensionFilter("TIFF / SVS files (*.tif, *.tiff, *.svs)", "tif", "tiff", "svs");
    private static final FileFilter SVS_FILTER = new FileNameExtensionFilter("SVS files only (*.svs)", "svs");
    private final Preferences prefs = Preferences.userNodeForPackage(TiffInfoViewer.class);
    JFrame frame;
    private JButton openFileButton;
    private JButton showImageButton;
    private JMenuItem openItem;
    private JMenuItem reloadItem;
    private JMenuItem showImageItem;
    private JComboBox<String> ifdComboBox;
    private JTextArea ifdTextArea;
    private JTextArea summaryInfoTextArea;
    private JTextArea svsInfoTextArea;
    private FileFilter lastFileFilter = TIFF_FILTER;
    private TiffInfo info = null;
    private Path tiffFile = null;
    private TiffIFD.StringFormat stringFormat = TiffIFD.StringFormat.NORMAL;
    boolean viewTileGrid = false;
    private volatile boolean loadingInProgress = false;
    private volatile boolean loadingOk = false;

    public static void main(String[] args) {
        if (args.length >= 1 && args[0].equals("-h")) {
            System.out.println("Usage:");
            System.out.println("    " + TiffInfoViewer.class.getSimpleName() + " [some_file.tiff]");
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "Cannot set look and feel", (Throwable)e);
        }
        TiffInfoViewer tiffInfoViewer = new TiffInfoViewer();
        SwingUtilities.invokeLater(() -> {
            try {
                tiffInfoViewer.createGUI(args);
            }
            catch (Throwable e) {
                tiffInfoViewer.showErrorMessage(e, "Error while creating GUI");
            }
        });
    }

    private void createGUI(String[] args) {
        this.frame = new JFrame(APPLICATION_TITLE);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLayout(new BorderLayout());
        this.frame.setJMenuBar(this.buildMenuBar());
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel leftPanel = new JPanel(new FlowLayout(0, 5, 5));
        this.frame.setIconImages(List.of(new ImageIcon(TiffInfoViewer.reqResource("icon16.png")).getImage(), new ImageIcon(TiffInfoViewer.reqResource("icon32.png")).getImage()));
        this.openFileButton = new JButton("Open TIFF");
        this.openFileButton.addActionListener(e -> this.chooseAndOpenFile());
        leftPanel.add(this.openFileButton);
        this.addIFDComboBox(leftPanel);
        this.addShowImageButton(leftPanel);
        topPanel.add((Component)leftPanel, "West");
        this.frame.add((Component)topPanel, "North");
        this.addBottomInfoTextArea();
        this.addIFDTextArea();
        this.frame.pack();
        Dimension frameSize = this.frame.getPreferredSize();
        this.frame.setMinimumSize(new Dimension(frameSize.width, frameSize.height - this.ifdTextArea.getPreferredSize().height + 32));
        this.frame.setLocationRelativeTo(null);
        this.loadPreferences();
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TiffInfoViewer.this.savePreferences();
            }
        });
        if (args.length >= 1) {
            this.loadTiff(Path.of(args[0], new String[0]));
        }
    }

    private void addIFDTextArea() {
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setBackground(COMMON_BACKGROUND);
        textPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ifdTextArea = new JTextArea(10, 80);
        this.ifdTextArea.setFont(TiffInfoViewer.getPreferredMonoFont(15));
        this.ifdTextArea.setEditable(false);
        this.ifdTextArea.setLineWrap(false);
        this.ifdTextArea.setWrapStyleWord(true);
        this.ifdTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ifdTextArea.setBackground(Color.WHITE);
        this.ifdTextArea.setForeground(new Color(20, 20, 20));
        this.ifdTextArea.setOpaque(true);
        JScrollPane scrollPane = new JScrollPane(this.ifdTextArea, 22, 30);
        textPanel.add((Component)scrollPane, "Center");
        this.frame.add((Component)textPanel, "Center");
    }

    private void addBottomInfoTextArea() {
        this.summaryInfoTextArea = new JTextArea(2, 80);
        this.summaryInfoTextArea.setEditable(false);
        this.summaryInfoTextArea.setLineWrap(false);
        this.summaryInfoTextArea.setWrapStyleWord(true);
        this.summaryInfoTextArea.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.summaryInfoTextArea.setFont(TiffInfoViewer.getPreferredMonoFont(15));
        this.summaryInfoTextArea.setBackground(COMMON_BACKGROUND);
        this.summaryInfoTextArea.setForeground(new Color(20, 20, 20));
        this.summaryInfoTextArea.setOpaque(true);
        this.svsInfoTextArea = new JTextArea(1, 80);
        this.svsInfoTextArea.setEditable(false);
        this.svsInfoTextArea.setLineWrap(false);
        this.svsInfoTextArea.setWrapStyleWord(true);
        this.svsInfoTextArea.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.svsInfoTextArea.setFont(TiffInfoViewer.getPreferredMonoFont(15));
        this.svsInfoTextArea.setBackground(COMMON_BACKGROUND);
        this.svsInfoTextArea.setForeground(SVS_FOREGROUND);
        this.svsInfoTextArea.setOpaque(true);
        this.svsInfoTextArea.setVisible(false);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        infoPanel.add(this.summaryInfoTextArea);
        infoPanel.add(this.svsInfoTextArea);
        this.frame.add((Component)infoPanel, "South");
    }

    private void addShowImageButton(JPanel leftPanel) {
        this.showImageButton = new JButton("Show image");
        this.showImageButton.setEnabled(false);
        this.showImageButton.addActionListener(e -> this.showImageWindow());
        leftPanel.add(Box.createHorizontalStrut(10));
        leftPanel.add(this.showImageButton);
    }

    private void addIFDComboBox(JPanel leftPanel) {
        this.ifdComboBox = new JComboBox();
        this.ifdComboBox.setFont(new Font("Monospaced", 0, 15));
        this.ifdComboBox.setMaximumRowCount(32);
        this.ifdComboBox.addActionListener(e -> this.updateTextArea());
        this.ifdComboBox.setPrototypeDisplayValue("Image #999");
        leftPanel.add(Box.createHorizontalStrut(10));
        leftPanel.add(new JLabel("Select TIFF image (IFD):"));
        leftPanel.add(this.ifdComboBox);
    }

    private void addFormatComboBox(JPanel leftPanel) {
        JComboBox<ViewMode> formatComboBox = new JComboBox<ViewMode>(ViewMode.values());
        formatComboBox.setSelectedItem((Object)this.stringFormat);
        formatComboBox.addActionListener(e -> {
            ViewMode selectedItem = (ViewMode)((Object)((Object)formatComboBox.getSelectedItem()));
            if (selectedItem != null) {
                this.stringFormat = selectedItem.stringFormat;
                this.reload();
                this.updateTextArea();
            }
        });
        leftPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        leftPanel.add(new JLabel("View mode:"));
        leftPanel.add(formatComboBox);
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        this.openItem = new JMenuItem("Open TIFF...");
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.openItem.addActionListener(e -> this.chooseAndOpenFile());
        fileMenu.add(this.openItem);
        this.reloadItem = new JMenuItem("Reload TIFF");
        this.reloadItem.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.reloadItem.addActionListener(e -> this.reload());
        fileMenu.add(this.reloadItem);
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 512));
        exitItem.addActionListener(e -> this.frame.dispatchEvent(new WindowEvent(this.frame, 201)));
        fileMenu.add(exitItem);
        JMenu editMenu = new JMenu("Edit");
        JMenuItem copyItem = new JMenuItem("Copy");
        copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        copyItem.addActionListener(e -> this.ifdTextArea.copy());
        editMenu.add(copyItem);
        JMenu viewMenu = new JMenu("View");
        JMenu viewModeMenu = new JMenu("View mode");
        ButtonGroup viewModeGroup = new ButtonGroup();
        for (ViewMode viewMode : ViewMode.values()) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(viewMode.toString());
            if (viewMode.stringFormat == this.stringFormat) {
                item.setSelected(true);
            }
            item.addActionListener(e -> {
                this.stringFormat = viewMode.stringFormat;
                this.reload();
                this.updateTextArea();
            });
            viewModeGroup.add(item);
            viewModeMenu.add(item);
        }
        viewMenu.add(viewModeMenu);
        JMenu fontSizeMenu = new JMenu("Font size");
        ButtonGroup fontSizeGroup = new ButtonGroup();
        for (int size : FONT_SIZES) {
            JRadioButtonMenuItem sizeItem = new JRadioButtonMenuItem(size + " pt");
            if (size == 15) {
                sizeItem.setSelected(true);
            }
            sizeItem.addActionListener(e -> this.setTextAreasFontSize(size));
            fontSizeGroup.add(sizeItem);
            fontSizeMenu.add(sizeItem);
        }
        viewMenu.add(fontSizeMenu);
        JCheckBoxMenuItem wrapItem = new JCheckBoxMenuItem("Word wrap");
        wrapItem.setSelected(false);
        wrapItem.addActionListener(e -> {
            boolean wrap = wrapItem.isSelected();
            this.ifdTextArea.setLineWrap(wrap);
            this.summaryInfoTextArea.setLineWrap(wrap);
            this.svsInfoTextArea.setLineWrap(wrap);
        });
        viewMenu.add(wrapItem);
        viewMenu.addSeparator();
        JMenuItem prevImageItem = new JMenuItem("Previous image");
        prevImageItem.setAccelerator(KeyStroke.getKeyStroke(37, 512));
        prevImageItem.addActionListener(e -> this.selectPreviousImage());
        viewMenu.add(prevImageItem);
        JMenuItem nextImageItem = new JMenuItem("Next image");
        nextImageItem.setAccelerator(KeyStroke.getKeyStroke(39, 512));
        nextImageItem.addActionListener(e -> this.selectNextImage());
        viewMenu.add(nextImageItem);
        viewMenu.addSeparator();
        this.showImageItem = new JMenuItem("Show image");
        this.showImageItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.showImageItem.addActionListener(e -> this.showImageWindow());
        viewMenu.add(this.showImageItem);
        JCheckBoxMenuItem tileGridItem = new JCheckBoxMenuItem("Tile grid on image");
        tileGridItem.setSelected(this.viewTileGrid);
        tileGridItem.addActionListener(e -> {
            this.viewTileGrid = tileGridItem.isSelected();
        });
        viewMenu.add(tileGridItem);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem aboutItem = new JMenuItem("About");
        aboutItem.addActionListener(e -> this.showAboutDialog());
        helpMenu.add(aboutItem);
        fileMenu.setMnemonic('F');
        editMenu.setMnemonic('E');
        viewMenu.setMnemonic('V');
        helpMenu.setMnemonic('H');
        this.fixMenuItemMargins(fileMenu);
        this.fixMenuItemMargins(editMenu);
        this.fixMenuItemMargins(viewMenu);
        this.fixMenuItemMargins(helpMenu);
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(viewMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private void fixMenuItemMargins(JMenu menu) {
    }

    private void setTextAreasFontSize(int size) {
        Font mono = TiffInfoViewer.getPreferredMonoFont(size);
        this.ifdTextArea.setFont(mono);
        this.summaryInfoTextArea.setFont(mono);
        this.svsInfoTextArea.setFont(mono);
    }

    private void selectNextImage() {
        int i = this.ifdComboBox.getSelectedIndex();
        if (i >= 0 && i + 1 < this.ifdComboBox.getItemCount()) {
            this.ifdComboBox.setSelectedIndex(i + 1);
        }
    }

    private void selectPreviousImage() {
        int i = this.ifdComboBox.getSelectedIndex();
        if (i > 0) {
            this.ifdComboBox.setSelectedIndex(i - 1);
        }
    }

    private void chooseAndOpenFile() {
        File file;
        File dir;
        JFileChooser chooser = new JFileChooser();
        String last = this.prefs.get(PREF_LAST_DIR, null);
        if (last != null && (dir = new File(last)).exists() && dir.isDirectory()) {
            chooser.setCurrentDirectory(dir);
        }
        chooser.addChoosableFileFilter(TIFF_FILTER);
        chooser.addChoosableFileFilter(SVS_FILTER);
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setFileFilter(this.lastFileFilter != null ? this.lastFileFilter : chooser.getAcceptAllFileFilter());
        chooser.setDialogTitle("Select a TIFF file");
        int result = chooser.showOpenDialog(this.frame);
        if (result == 0 && (file = chooser.getSelectedFile()) != null) {
            this.prefs.put(PREF_LAST_DIR, file.getParent());
            this.lastFileFilter = chooser.getFileFilter();
            if (this.lastFileFilter == chooser.getAcceptAllFileFilter()) {
                this.lastFileFilter = null;
            }
            this.loadTiff(file.toPath());
        }
    }

    private void loadTiff(Path file) {
        this.tiffFile = file;
        this.reload();
    }

    private void reload() {
        if (this.tiffFile == null || this.loadingInProgress) {
            LOG.log(System.Logger.Level.DEBUG, "Skipping loading...");
            return;
        }
        this.ifdComboBox.removeAllItems();
        this.ifdTextArea.setText("Analysing TIFF file...");
        this.summaryInfoTextArea.setText("");
        this.svsInfoTextArea.setText("");
        this.loadingOk = false;
        this.setOpenInProgress(true);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                TiffInfoViewer.this.info = new TiffInfo();
                TiffInfoViewer.this.info.setDisableAppendingForStrictFormats(true);
                TiffInfoViewer.this.info.setStringFormat(TiffInfoViewer.this.stringFormat);
                TiffInfoViewer.this.info.collectTiffInfo(TiffInfoViewer.this.tiffFile);
                TiffInfoViewer.this.loadingOk = true;
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    TiffInfoViewer.this.showErrorMessage(e, "Error reading TIFF");
                    TiffInfoViewer.this.ifdTextArea.setText("");
                }
                finally {
                    TiffInfoViewer.this.setOpenInProgress(false);
                }
                TiffInfoViewer.this.applyInfo();
            }
        }.execute();
    }

    private void applyInfo() {
        Object caption;
        this.summaryInfoTextArea.setText(this.info.prefixInfo() + "\n" + this.info.summaryInfo());
        this.summaryInfoTextArea.setBackground(this.info.isTiff() ? COMMON_BACKGROUND : ERROR_BACKGROUND);
        this.summaryInfoTextArea.setCaretPosition(0);
        this.svsInfoTextArea.setText(this.info.svsInfo());
        this.svsInfoTextArea.setVisible(this.info.metadata().isNonTrivial());
        this.svsInfoTextArea.setCaretPosition(0);
        TiffPyramidMetadata metadata = this.info.metadata();
        assert (metadata != null);
        Object longest = "";
        assert (this.info.getFirstIFDIndex() == 0);
        String[] captions = new String[this.info.numberOfImages()];
        for (int i = 0; i < this.info.numberOfImages(); ++i) {
            TiffIFD ifd = metadata.ifd(i);
            try {
                caption = (ifd.isMainIFD() ? "" : "  ") + "#" + i + " [" + ifd.getImageDimX() + "x" + ifd.getImageDimY() + (ifd.hasTileInformation() ? " tiled" : "") + "]";
            }
            catch (TiffException e) {
                caption = "#" + i + " [error]";
                LOG.log(System.Logger.Level.ERROR, "Error parsing IFD", (Throwable)e);
            }
            if (((String)caption).length() > ((String)longest).length()) {
                longest = caption;
            }
            captions[i] = caption;
        }
        int maxLength = ((String)longest).length();
        for (int i = 0; i < captions.length; ++i) {
            caption = captions[i];
            StringBuilder sb = new StringBuilder((String)caption + " ".repeat(maxLength - ((String)caption).length()));
            int layer = metadata.imageToLayer(i);
            if (metadata.isPyramid()) {
                if (layer >= 0) {
                    sb.append(" (layer ").append(layer).append(")");
                }
                for (TiffImageKind kind : TiffImageKind.values()) {
                    if (metadata.specialKindIndex(kind) != i) continue;
                    sb.append(" (").append(kind.kindName().toUpperCase()).append(")");
                }
            }
            caption = sb.toString();
            this.ifdComboBox.addItem((String)caption);
            if (((String)caption).length() <= ((String)longest).length()) continue;
            longest = caption;
        }
        if (this.info.numberOfImages() == 0) {
            this.ifdTextArea.setText("");
        } else {
            this.ifdComboBox.setSelectedIndex(0);
            this.updateTextArea();
        }
        this.ifdComboBox.setPrototypeDisplayValue((String)longest);
        this.frame.setTitle("TIFF Information Viewer: " + this.tiffFile.toString());
    }

    private void setOpenInProgress(boolean inProgress) {
        this.openFileButton.setEnabled(!inProgress);
        this.openItem.setEnabled(!inProgress);
        this.reloadItem.setEnabled(!inProgress);
        this.showImageButton.setEnabled(this.loadingOk);
        this.showImageItem.setEnabled(this.loadingOk);
        this.loadingInProgress = inProgress;
    }

    private void setShowImageInProgress(boolean inProgress) {
        this.showImageButton.setEnabled(this.loadingOk && !inProgress);
        this.showImageItem.setEnabled(this.loadingOk && !inProgress);
        this.showImageButton.setText(inProgress ? "Opening..." : "Show image");
    }

    private void updateTextArea() {
        int index = this.ifdComboBox.getSelectedIndex();
        if (index >= 0 && this.info != null && index < this.info.numberOfImages()) {
            this.ifdTextArea.setText(this.info.ifdInformation(index));
            this.ifdTextArea.setCaretPosition(0);
        }
    }

    private void savePreferences() {
        Rectangle bounds = this.frame.getBounds();
        this.prefs.putInt(PREF_WINDOW_X, bounds.x);
        this.prefs.putInt(PREF_WINDOW_Y, bounds.y);
        this.prefs.putInt(PREF_WINDOW_WIDTH, bounds.width);
        this.prefs.putInt(PREF_WINDOW_HEIGHT, bounds.height);
    }

    private void loadPreferences() {
        int x = this.prefs.getInt(PREF_WINDOW_X, Integer.MIN_VALUE);
        int y = this.prefs.getInt(PREF_WINDOW_Y, Integer.MIN_VALUE);
        int w = this.prefs.getInt(PREF_WINDOW_WIDTH, this.frame.getWidth());
        int h = this.prefs.getInt(PREF_WINDOW_HEIGHT, this.frame.getHeight());
        this.frame.setSize(w, h);
        if (x != Integer.MIN_VALUE && y != Integer.MIN_VALUE) {
            Rectangle screen = this.frame.getGraphicsConfiguration().getBounds();
            if (x + w <= screen.x + screen.width && y + h <= screen.y + screen.height) {
                this.frame.setLocation(x, y);
            } else {
                this.frame.setLocationRelativeTo(null);
            }
        } else {
            this.frame.setLocationRelativeTo(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showImageWindow() {
        int index = this.ifdComboBox.getSelectedIndex();
        if (index < 0 || this.info == null || index >= this.info.numberOfImages()) {
            return;
        }
        try (TiffInfoImageViewer imageViewer = new TiffInfoImageViewer(this, this.tiffFile, index);){
            this.setShowImageInProgress(true);
            imageViewer.show();
        }
        catch (IOException e) {
            this.showErrorMessage(e, "Error reading TIFF image");
        }
        finally {
            this.setShowImageInProgress(false);
        }
    }

    private void showAboutDialog() {
        final JDialog dialog = new JDialog(this.frame, "About TIFF Info Viewer", true);
        dialog.setLayout(new BorderLayout(10, 10));
        dialog.setResizable(false);
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel icon = new JLabel(new ImageIcon(TiffInfoViewer.reqResource("icon32.png")));
        content.add(icon);
        content.add(Box.createVerticalStrut(16));
        JLabel title = new JLabel("AlgART TIFF Information Viewer");
        title.setFont(title.getFont().deriveFont(1, 16.0f));
        content.add(title);
        content.add(Box.createVerticalStrut(8));
        content.add(new JLabel("By Daniel Alievsky"));
        content.add(new JLabel("Version 1.5.1"));
        content.add(Box.createVerticalStrut(8));
        JLabel link = new JLabel("<html><a href=\"\">https://algart.net/java/AlgART-TIFF/</a></html>");
        link.setCursor(Cursor.getPredefinedCursor(12));
        link.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(TiffInfoViewer.ALGART_TIFF_WEBSITE));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(dialog, "Cannot open browser:\n" + ex.getMessage(), "Error", 0);
                }
            }
        });
        content.add(Box.createVerticalStrut(10));
        content.add(link);
        dialog.add((Component)content, "Center");
        JButton ok = new JButton("OK");
        ok.addActionListener(e -> dialog.dispose());
        JPanel btnPanel = new JPanel();
        btnPanel.add(ok);
        dialog.add((Component)btnPanel, "South");
        dialog.pack();
        dialog.getRootPane().registerKeyboardAction(e -> dialog.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
        dialog.setLocationRelativeTo(this.frame);
        dialog.setVisible(true);
    }

    void showErrorMessage(Throwable e, String title) {
        if (e instanceof ExecutionException && e.getCause() != null) {
            e = e.getCause();
        }
        LOG.log(System.Logger.Level.ERROR, title + ": " + e.getMessage(), e);
        if (e instanceof TiffException && e.getCause() instanceof IOException) {
            e = e.getCause();
        }
        JOptionPane.showMessageDialog(this.frame, e.getMessage(), title, 0);
    }

    private static Font getPreferredMonoFont(int size) {
        String preferred = "Consolas";
        if (TiffInfoViewer.isFontAvailable(preferred)) {
            return new Font(preferred, 0, size);
        }
        return new Font("Monospaced", 0, size);
    }

    private static boolean isFontAvailable(String fontName) {
        String[] fonts;
        for (String f : fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (!f.equalsIgnoreCase(fontName)) continue;
            return true;
        }
        return false;
    }

    private static URL reqResource(String name) {
        URL result = TiffInfoViewer.class.getResource(name);
        Objects.requireNonNull(result, "Resource " + name + " not found");
        return result;
    }

    public static enum ViewMode {
        BRIEF(TiffIFD.StringFormat.BRIEF, "Brief"),
        NORMAL(TiffIFD.StringFormat.NORMAL, "Normal"),
        NORMAL_SORTED(TiffIFD.StringFormat.NORMAL_SORTED, "Normal (sorted)"),
        DETAILED(TiffIFD.StringFormat.DETAILED, "Detailed"),
        JSON(TiffIFD.StringFormat.JSON, "JSON");

        private final TiffIFD.StringFormat stringFormat;
        private final String caption;

        private ViewMode(TiffIFD.StringFormat stringFormat, String caption) {
            this.stringFormat = stringFormat;
            this.caption = caption;
        }

        public String toString() {
            return this.caption;
        }
    }
}

