/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.app;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.algart.arrays.PackedBitArraysPer8;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.app.TiffInfoViewer;
import net.algart.matrices.tiff.tiles.TiffReadMap;
import net.algart.matrices.tiff.tiles.TiffTile;
import net.algart.matrices.tiff.tiles.TiffTileIndex;

class TiffInfoImageViewer
implements Closeable {
    private static final int MAX_IMAGE_DIM = 16000;
    private final TiffInfoViewer app;
    private final TiffReader reader;
    private final int index;
    private TiffReadMap map = null;
    private int numberOfImages;
    private int dimX;
    private int dimY;
    private BufferedImage bi = null;

    public TiffInfoImageViewer(TiffInfoViewer app, Path tiffFile, int index) throws IOException {
        this.app = Objects.requireNonNull(app);
        Objects.requireNonNull(tiffFile);
        this.reader = new TiffReaderWithGrid(tiffFile, app.viewTileGrid);
        this.index = index;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public void show() throws IOException {
        this.openMap();
        if (!this.confirm()) {
            return;
        }
        this.loadImage();
        this.showWindow();
    }

    private void openMap() throws IOException {
        this.map = this.reader.map(this.index);
        this.numberOfImages = this.reader.numberOfImages();
        this.dimX = this.map.dimX();
        this.dimY = this.map.dimY();
    }

    private boolean confirm() {
        if (this.dimX > 16000 || this.dimY > 16000) {
            this.dimX = Math.min(this.dimX, 16000);
            this.dimY = Math.min(this.dimY, 16000);
            int choice = JOptionPane.showConfirmDialog(this.app.frame, "The image is too large to display: %d\u00d7%d pixels.%nWe will show only its part %d\u00d7%d.%nDo you want to continue?".formatted(this.map.dimX(), this.map.dimY(), this.dimX, this.dimY), "Large Image Warning", 0, 2);
            return choice == 0;
        }
        return true;
    }

    private void loadImage() throws IOException {
        this.bi = this.map.readBufferedImage(0, 0, this.dimX, this.dimY);
    }

    private void showWindow() {
        JFrame imgFrame = new JFrame("TIFF Image #" + this.index + " from " + this.numberOfImages + " images (" + this.dimX + "x" + this.dimY + (String)(this.dimX == this.map.dimX() && this.dimY == this.map.dimY() ? "" : " from " + this.map.dimX() + "x" + this.map.dimY()) + ")");
        imgFrame.setDefaultCloseOperation(2);
        imgFrame.add(new JScrollPane(new JLabel(new ImageIcon(this.bi))));
        imgFrame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = imgFrame.getSize();
        frameSize.width = Math.min(frameSize.width, screenSize.width - 10);
        frameSize.height = Math.min(frameSize.height, screenSize.height - 50);
        imgFrame.setSize(frameSize);
        imgFrame.setLocationRelativeTo(this.app.frame);
        imgFrame.setVisible(true);
    }

    private static class TiffReaderWithGrid
    extends TiffReader {
        private final boolean viewTileGrid;

        TiffReaderWithGrid(Path tiffFile, boolean viewTileGrid) throws IOException {
            super(tiffFile);
            this.viewTileGrid = viewTileGrid;
        }

        @Override
        public TiffTile readTile(TiffTileIndex tileIndex) throws IOException {
            TiffTile tile = super.readTile(tileIndex);
            if (this.viewTileGrid && tile.map().isTiled()) {
                TiffReaderWithGrid.addTileBorder(tile);
            }
            return tile;
        }

        private static void addTileBorder(TiffTile tile) {
            if (!tile.isSeparated()) {
                throw new AssertionError((Object)"Tile is not separated");
            }
            byte[] decoded = tile.getDecodedData();
            int sample = tile.bitsPerSample();
            int sizeX = tile.getSizeX() * sample;
            int sizeY = tile.getSizeY();
            int sizeInBits = sizeX * sizeY;
            for (int c = 0; c < tile.samplesPerPixel(); ++c) {
                int disp = c * sizeInBits;
                PackedBitArraysPer8.fillBits((byte[])decoded, (long)disp, (long)sizeX, (boolean)false);
                PackedBitArraysPer8.fillBits((byte[])decoded, (long)(disp + sizeInBits - sizeX), (long)sizeX, (boolean)false);
                int k = 0;
                while (k < sizeY) {
                    PackedBitArraysPer8.fillBits((byte[])decoded, (long)disp, (long)sample, (boolean)false);
                    PackedBitArraysPer8.fillBits((byte[])decoded, (long)(disp + sizeX - sample), (long)sample, (boolean)false);
                    ++k;
                    disp += sizeX;
                }
            }
        }
    }
}

