/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.app;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.io.MatrixIO;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffImageKind;
import net.algart.matrices.tiff.TiffWriter;
import net.algart.matrices.tiff.pyramids.TiffPyramidMetadata;
import net.algart.matrices.tiff.tags.SvsDescription;
import net.algart.matrices.tiff.tags.TagCompression;
import net.algart.matrices.tiff.tiles.TiffWriteMap;

public class MakeSvs {
    Path targetFile = null;
    Path baseFile = null;
    Path labelFile = null;
    Path macroFile = null;
    ByteOrder byteOrder = null;
    Boolean bigTiff = null;
    TagCompression compression = TagCompression.JPEG;
    Double quality = null;
    int numberOfLayers = 3;
    int scaleRatio = 4;
    int maxThumbnailSize = 1024;
    double pixelSize = 0.5;

    public static void main(String[] args) throws IOException {
        String s;
        int startArgIndex = 0;
        MakeSvs make = new MakeSvs();
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-le")) {
            make.byteOrder = ByteOrder.LITTLE_ENDIAN;
            ++startArgIndex;
        } else if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-be")) {
            make.byteOrder = ByteOrder.BIG_ENDIAN;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-bigTiff")) {
            make.bigTiff = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].toLowerCase().startsWith("-compression=")) {
            s = args[startArgIndex].substring("-compression=".length());
            make.compression = TagCompression.fromName(s).or(() -> TagCompression.fromCode(s)).orElseThrow(() -> new IllegalArgumentException("Unknown compression name/code: " + s));
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].toLowerCase().startsWith("-quality=")) {
            s = args[startArgIndex].toLowerCase().substring("-quality=".length());
            if (!s.equals("null")) {
                make.quality = Double.parseDouble(s);
            }
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].toLowerCase().startsWith("-ratio=")) {
            s = args[startArgIndex].toLowerCase().substring("-ratio=".length());
            make.scaleRatio = Integer.parseInt(s);
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].toLowerCase().startsWith("-pixel=")) {
            s = args[startArgIndex].toLowerCase().substring("-pixel=".length());
            make.pixelSize = Double.parseDouble(s);
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 3) {
            System.out.printf("Usage:%n    %s [-le|-be] [-bigTiff] [-compression=JPEG|JPEG_RGB] [-quality=xxx] [=ratio=2|4] [-pixel=xxx] target.svs number-of-layers source.jpg/png/bmp/tif [label.png macro.png] %n", MakeSvs.class.getSimpleName());
            return;
        }
        make.targetFile = Paths.get(args[startArgIndex++], new String[0]);
        make.numberOfLayers = Integer.parseInt(args[startArgIndex++]);
        make.baseFile = Paths.get(args[startArgIndex], new String[0]);
        if (args.length > startArgIndex + 1) {
            make.labelFile = Paths.get(args[startArgIndex + 1], new String[0]);
        }
        if (args.length > startArgIndex + 2) {
            make.macroFile = Paths.get(args[startArgIndex + 2], new String[0]);
        }
        make.makeSvs();
    }

    public void makeSvs() throws IOException {
        System.out.printf("Reading %s...%n", this.baseFile);
        long t1 = System.nanoTime();
        List<Matrix<? extends PArray>> image = MatrixIO.readImage((Path)this.baseFile);
        List label = null;
        List macro = null;
        if (this.labelFile != null) {
            System.out.printf("Reading %s...%n", this.labelFile);
            label = MatrixIO.readImage((Path)this.labelFile);
        }
        if (this.macroFile != null) {
            System.out.printf("Reading %s...%n", this.macroFile);
            macro = MatrixIO.readImage((Path)this.macroFile);
        }
        System.out.printf("Building %s, base compression %s (\"%s\")...%n", new Object[]{this.targetFile, this.compression, this.compression.prettyName()});
        long t2 = System.nanoTime();
        try (TiffWriter writer = new TiffWriter(this.targetFile);){
            if (this.byteOrder != null) {
                writer.setByteOrder(this.byteOrder);
            }
            if (this.bigTiff != null) {
                writer.setBigTiff(this.bigTiff);
            }
            if (this.quality != null) {
                writer.setCompressionQuality(this.quality);
            }
            if (this.quality != null) {
                writer.setCompressionQuality(this.quality);
            }
            writer.create();
            long baseImageDimX = ((Matrix)image.getFirst()).dimX();
            System.out.printf("Writing image #0 %dx%d...%n", baseImageDimX, ((Matrix)image.getFirst()).dimY());
            TiffIFD firstIFD = this.addSvsImage(writer, (List<? extends Matrix<? extends PArray>>)image, null, 0, TiffImageKind.BASE);
            List<? extends Matrix<? extends PArray>> thumbnail = MakeSvs.scaleThumbnail((List<? extends Matrix<? extends PArray>>)image, this.maxThumbnailSize);
            System.out.printf("Writing thumbnail %dx%d...%n", thumbnail.getFirst().dimX(), thumbnail.getFirst().dimY());
            this.addSvsImage(writer, thumbnail, firstIFD, 1, TiffImageKind.THUMBNAIL);
            List<Matrix<? extends PArray>> layer = image;
            for (int i = 1; i < this.numberOfLayers; ++i) {
                layer = MakeSvs.downscale((List<? extends Matrix<? extends PArray>>)layer, this.scaleRatio);
                System.out.printf("Writing image #%d %dx%d...%n", i, layer.getFirst().dimX(), layer.getFirst().dimY());
                this.addSvsImage(writer, layer, firstIFD, i + 1, TiffImageKind.ORDINARY);
            }
            if (label != null) {
                System.out.printf("Writing label %dx%d...%n", ((Matrix)label.getFirst()).dimX(), ((Matrix)label.getFirst()).dimY());
                this.addSvsImage(writer, label, firstIFD, this.numberOfLayers + 1, TiffImageKind.LABEL);
            }
            if (macro != null) {
                System.out.printf("Writing macro %dx%d...%n", ((Matrix)macro.getFirst()).dimX(), ((Matrix)macro.getFirst()).dimY());
                this.addSvsImage(writer, macro, firstIFD, this.numberOfLayers + 2, TiffImageKind.MACRO);
            }
        }
        long t3 = System.nanoTime();
        System.out.printf(Locale.US, "Building SVS finished: %.3f seconds reading, %.3f seconds writing TIFF.%n", (double)(t2 - t1) * 1.0E-9, (double)(t3 - t2) * 1.0E-9);
    }

    private TiffIFD addSvsImage(TiffWriter writer, List<? extends Matrix<? extends PArray>> image, TiffIFD firstIFD, int index, TiffImageKind kind) throws IOException {
        TiffIFD ifd = writer.newIFD(true).putChannelsInformation(image).putCompression(this.compression).setGlobalIndex(index);
        TiffPyramidMetadata.correctForSpecialKinds(ifd, kind);
        SvsDescription.Builder builder = new SvsDescription.Builder();
        builder.applicationSuffix("(test)");
        if (kind == TiffImageKind.BASE || kind == TiffImageKind.THUMBNAIL) {
            builder.pixelSize(this.pixelSize).dateTime(LocalDateTime.now());
        }
        if (firstIFD != null) {
            builder.updateFrom(firstIFD);
        }
        builder.updateFrom(ifd);
        if (this.quality != null) {
            builder.quality((int)Math.round(this.quality * 100.0));
        }
        ifd.putDescription(builder.build(kind));
        TiffWriteMap map = writer.newFixedMap(ifd);
        map.writeChannels(image);
        return ifd;
    }

    private static List<? extends Matrix<? extends PArray>> scaleThumbnail(List<? extends Matrix<? extends PArray>> channels, int maxThumbnailSize) {
        long[] dimensions = channels.getFirst().dimensions();
        if (dimensions.length != 2) {
            throw new IllegalArgumentException("This method works only with 2D matrices");
        }
        long maxDimension = Math.max(dimensions[0], dimensions[1]);
        if (maxDimension <= (long)maxThumbnailSize) {
            return channels;
        }
        return MakeSvs.resize(channels, Math.round((double)dimensions[0] * (double)maxThumbnailSize / (double)maxDimension), Math.round((double)dimensions[1] * (double)maxThumbnailSize / (double)maxDimension));
    }

    private static List<Matrix<? extends PArray>> downscale(List<? extends Matrix<? extends PArray>> channels, int scaleRatio) {
        long[] dimensions = channels.getFirst().dimensions();
        if (dimensions.length != 2) {
            throw new IllegalArgumentException("This method works only with 2D matrices");
        }
        dimensions[0] = dimensions[0] / (long)scaleRatio;
        dimensions[1] = dimensions[1] / (long)scaleRatio;
        return MakeSvs.resize(channels, dimensions);
    }

    private static List<Matrix<? extends PArray>> resize(List<? extends Matrix<? extends PArray>> channels, long ... dimensions) {
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>(channels.size());
        for (Matrix<? extends PArray> matrix : channels) {
            result.add((Matrix<? extends PArray>)Matrices.asResized((Matrices.ResizingMethod)Matrices.ResizingMethod.AVERAGING, matrix, (long[])dimensions).clone());
        }
        return result;
    }
}

