/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff.app;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import net.algart.io.MatrixIO;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffWriter;
import net.algart.matrices.tiff.tags.TagCompression;
import net.algart.matrices.tiff.tiles.TiffWriteMap;

public class ConvertToTiff {
    public static void main(String[] args) throws IOException {
        ConvertToTiff.doMain(args, true);
    }

    static boolean doMain(String[] args, boolean printUsage) throws IOException {
        int startArgIndex = 0;
        boolean bigTiff = false;
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-bigTiff")) {
            bigTiff = true;
            ++startArgIndex;
        }
        boolean littleEndian = false;
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-littleEndian")) {
            littleEndian = true;
            ++startArgIndex;
        }
        Double quality = null;
        if (args.length > startArgIndex && args[startArgIndex].toLowerCase().startsWith("-quality=")) {
            String s = args[startArgIndex].toLowerCase().substring("-quality=".length());
            quality = Double.parseDouble(s);
            ++startArgIndex;
        }
        Double compressionLevel = null;
        if (args.length > startArgIndex && args[startArgIndex].toLowerCase().startsWith("-compressionlevel=")) {
            String s = args[startArgIndex].toLowerCase().substring("-compressionlevel=".length());
            compressionLevel = Double.parseDouble(s);
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 2) {
            if (printUsage) {
                System.out.println("Usage:");
                System.out.printf("    %s [-bigTiff] [-littleEndian] [-quality=0.3] [-compressionLevel=1.0] source.jpg/png/bmp target.tiff [compression]%nPossible \"compression\": NONE, LZW, DEFLATE, JPEG, JPEG_2000, ...", ConvertToTiff.class.getName());
            }
            return false;
        }
        Path sourceFile = Paths.get(args[startArgIndex], new String[0]);
        Path targetFile = Paths.get(args[startArgIndex + 1], new String[0]);
        TagCompression compression = startArgIndex + 2 < args.length ? TagCompression.valueOf(args[startArgIndex + 2]) : null;
        System.out.printf("Reading %s...%n", sourceFile);
        long t1 = System.nanoTime();
        List image = MatrixIO.readImage((Path)sourceFile);
        System.out.printf("Writing TIFF %s...%n", targetFile);
        long t2 = System.nanoTime();
        try (TiffWriter writer = new TiffWriter(targetFile);){
            writer.setBigTiff(bigTiff);
            writer.setLittleEndian(littleEndian);
            writer.create();
            writer.setCompressionQuality(quality);
            writer.setLosslessCompressionLevel(compressionLevel);
            TiffIFD ifd = writer.newIFD().putChannelsInformation(image).putCompression(compression);
            TiffWriteMap map = writer.newFixedMap(ifd);
            map.writeChannels(image);
        }
        long t3 = System.nanoTime();
        System.out.printf(Locale.US, "Conversion to TIFF finished: %.3f seconds reading, %.3f seconds writing TIFF.%n", (double)(t2 - t1) * 1.0E-9, (double)(t3 - t2) * 1.0E-9);
        return true;
    }
}

