/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArraysPer8;
import net.algart.io.awt.ImageToMatrix;
import net.algart.matrices.tiff.SCIFIOBridge;
import net.algart.matrices.tiff.TiffCreateMode;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffIO;
import net.algart.matrices.tiff.TiffOpenMode;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.TiffSampleType;
import net.algart.matrices.tiff.UnsupportedTiffFormatException;
import net.algart.matrices.tiff.codecs.TiffCodec;
import net.algart.matrices.tiff.data.TiffPacking;
import net.algart.matrices.tiff.data.TiffPrediction;
import net.algart.matrices.tiff.tags.TagCompression;
import net.algart.matrices.tiff.tags.TagPhotometricInterpretation;
import net.algart.matrices.tiff.tags.TagRational;
import net.algart.matrices.tiff.tiles.TiffMap;
import net.algart.matrices.tiff.tiles.TiffTile;
import net.algart.matrices.tiff.tiles.TiffTileIO;
import net.algart.matrices.tiff.tiles.TiffTileIndex;
import net.algart.matrices.tiff.tiles.TiffWriteMap;
import org.scijava.io.handle.BytesHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.BytesLocation;

public non-sealed class TiffWriter
extends TiffIO {
    public static final long MAXIMAL_ALLOWED_32BIT_IFD_OFFSET = 4000000000L;
    private static final boolean AVOID_LONG8_FOR_ACTUAL_32_BITS = true;
    private static final boolean AUTO_INTERLEAVE_SOURCE = true;
    private boolean bigTiff = false;
    private boolean writingForwardAllowed = true;
    private boolean smartCorrection = false;
    private TiffCodec.Options codecOptions = new TiffCodec.Options();
    private boolean enforceUseExternalCodec = false;
    private Double compressionQuality = null;
    private Double losslessCompressionLevel = null;
    private boolean alwaysWriteToFileEnd = false;
    private boolean missingTilesAllowed = false;
    private byte byteFiller = 0;
    private Consumer<TiffTile> tileInitializer = this::fillEmptyTile;
    private volatile TiffReader reader = null;
    private final LinkedHashSet<Long> allUsedIFDOffsets = new LinkedHashSet();
    private volatile long positionOfLastIFDOffset = -1L;
    private volatile TiffWriteMap lastMap = null;
    private long timeWriting = 0L;
    private long timePreparingEncoding = 0L;
    private long timeCustomizingEncoding = 0L;
    private long timeEncoding = 0L;
    private long timeEncodingMain = 0L;
    private long timeEncodingBridge = 0L;
    private long timeEncodingAdditional = 0L;

    public TiffWriter(Path file) {
        this(TiffWriter.getFileHandle(file));
    }

    public TiffWriter(Path file, TiffCreateMode createMode) throws IOException {
        this(TiffWriter.openWithDeletingPreviousFileIfRequested(file, createMode));
        try {
            createMode.configureWriter(this);
        }
        catch (IOException exception) {
            try {
                this.stream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    public TiffWriter(DataHandle<?> outputStream) {
        super(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLittleEndian() {
        Object object = this.fileLock;
        synchronized (object) {
            return this.stream.isLittleEndian();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiffWriter setLittleEndian(boolean littleEndian) {
        Object object = this.fileLock;
        synchronized (object) {
            this.stream.setLittleEndian(littleEndian);
        }
        return this;
    }

    public ByteOrder getByteOrder() {
        return this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public TiffWriter setByteOrder(ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder);
        return this.setLittleEndian(byteOrder == ByteOrder.LITTLE_ENDIAN);
    }

    public boolean isBigTiff() {
        return this.bigTiff;
    }

    public TiffWriter setBigTiff(boolean bigTiff) {
        this.bigTiff = bigTiff;
        return this;
    }

    public TiffWriter setFormatLike(TiffReader reader) {
        Objects.requireNonNull(reader, "Null TIFF reader");
        this.setBigTiff(reader.isBigTiff());
        this.setLittleEndian(reader.isLittleEndian());
        return this;
    }

    public boolean isWritingForwardAllowed() {
        return this.writingForwardAllowed;
    }

    public TiffWriter setWritingForwardAllowed(boolean writingForwardAllowed) {
        this.writingForwardAllowed = writingForwardAllowed;
        return this;
    }

    public boolean isSmartCorrection() {
        return this.smartCorrection;
    }

    public TiffWriter setSmartCorrection(boolean smartCorrection) {
        this.smartCorrection = smartCorrection;
        return this;
    }

    public TiffCodec.Options getCodecOptions() {
        return this.codecOptions.clone();
    }

    public TiffWriter setCodecOptions(TiffCodec.Options codecOptions) {
        this.codecOptions = Objects.requireNonNull(codecOptions, "Null codecOptions").clone();
        return this;
    }

    public boolean isEnforceUseExternalCodec() {
        return this.enforceUseExternalCodec;
    }

    public TiffWriter setEnforceUseExternalCodec(boolean enforceUseExternalCodec) {
        this.enforceUseExternalCodec = enforceUseExternalCodec;
        return this;
    }

    public boolean hasCompressionQuality() {
        return this.compressionQuality != null;
    }

    public Double getCompressionQuality() {
        return this.compressionQuality;
    }

    public TiffWriter setCompressionQuality(Double compressionQuality) {
        return compressionQuality == null ? this.removeCompressionQuality() : this.setCompressionQuality((double)compressionQuality);
    }

    public TiffWriter setCompressionQuality(double quality) {
        if (quality < 0.0) {
            throw new IllegalArgumentException("Negative quality " + quality + " is not allowed");
        }
        this.compressionQuality = quality;
        return this;
    }

    public TiffWriter removeCompressionQuality() {
        this.compressionQuality = null;
        return this;
    }

    public boolean hasLosslessCompressionLevel() {
        return this.losslessCompressionLevel != null;
    }

    public Double getLosslessCompressionLevel() {
        return this.losslessCompressionLevel;
    }

    public TiffWriter setLosslessCompressionLevel(Double losslessCompressionLevel) {
        return losslessCompressionLevel == null ? this.removeLosslessCompressionLevel() : this.setLosslessCompressionLevel((double)losslessCompressionLevel);
    }

    public TiffWriter setLosslessCompressionLevel(double losslessCompressionLevel) {
        if (losslessCompressionLevel < 0.0) {
            throw new IllegalArgumentException("Negative losslessCompressionLevel " + losslessCompressionLevel + " is not allowed");
        }
        this.losslessCompressionLevel = losslessCompressionLevel;
        return this;
    }

    public TiffWriter removeLosslessCompressionLevel() {
        this.losslessCompressionLevel = null;
        return this;
    }

    public boolean isAlwaysWriteToFileEnd() {
        return this.alwaysWriteToFileEnd;
    }

    public TiffWriter setAlwaysWriteToFileEnd(boolean alwaysWriteToFileEnd) {
        this.alwaysWriteToFileEnd = alwaysWriteToFileEnd;
        return this;
    }

    public boolean isMissingTilesAllowed() {
        return this.missingTilesAllowed;
    }

    public TiffWriter setMissingTilesAllowed(boolean missingTilesAllowed) {
        this.missingTilesAllowed = missingTilesAllowed;
        return this;
    }

    public byte getByteFiller() {
        return this.byteFiller;
    }

    public TiffWriter setByteFiller(byte byteFiller) {
        this.byteFiller = byteFiller;
        return this;
    }

    public Consumer<TiffTile> getTileInitializer() {
        return this.tileInitializer;
    }

    public TiffWriter setTileInitializer(Consumer<TiffTile> tileInitializer) {
        this.tileInitializer = Objects.requireNonNull(tileInitializer, "Null tileInitializer");
        return this;
    }

    public long positionOfFirstIFDOffset() {
        return this.bigTiff ? 8L : 4L;
    }

    public long positionOfLastIFDOffset() {
        return this.positionOfLastIFDOffset;
    }

    public Set<Long> allUsedIFDOffsets() {
        return Collections.unmodifiableSet(this.allUsedIFDOffsets);
    }

    public final void openExisting() throws IOException {
        this.open(false);
    }

    public final void openForAppend() throws IOException {
        this.open(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void open(boolean createIfNotExists) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            this.resetReader();
            if (!this.stream.exists() || this.stream.length() == 0L) {
                if (!createIfNotExists) throw new FileNotFoundException("Output TIFF file " + TiffWriter.prettyFileName("%s", this.stream) + " does not exist");
                this.create();
            } else {
                this.allUsedIFDOffsets.clear();
                this.reader = this.newReader(TiffOpenMode.VALID_TIFF);
                this.reader.setCaching(false);
                long[] offsets = this.reader.readIFDOffsets();
                long readerPositionOfLastOffset = this.reader.positionOfLastIFDOffset();
                this.setFormatLike(this.reader);
                this.allUsedIFDOffsets.addAll(Arrays.stream(offsets).boxed().toList());
                this.positionOfLastIFDOffset = readerPositionOfLastOffset;
                this.seekToEnd();
            }
            return;
        }
    }

    public final void create(boolean appendToExistingFile) throws IOException {
        if (appendToExistingFile) {
            this.openForAppend();
        } else {
            this.create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            this.resetReader();
            this.allUsedIFDOffsets.clear();
            this.stream.seek(0L);
            if (this.isLittleEndian()) {
                this.stream.writeByte(73);
                this.stream.writeByte(73);
            } else {
                this.stream.writeByte(77);
                this.stream.writeByte(77);
            }
            if (this.bigTiff) {
                this.stream.writeShort(43);
            } else {
                this.stream.writeShort(42);
            }
            if (this.bigTiff) {
                this.stream.writeShort(8);
                this.stream.writeShort(0);
            }
            this.positionOfLastIFDOffset = this.stream.offset();
            this.writeOffset(0L);
            this.stream.setLength(this.stream.offset());
        }
    }

    public int numberOfExistingImages() {
        return this.reader().numberOfMainIFDs();
    }

    public TiffReader reader() {
        return this.reader(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiffReader reader(boolean alwaysCreateNew) {
        Object object = this.fileLock;
        synchronized (object) {
            if (alwaysCreateNew || this.reader == null) {
                try {
                    this.reader = new TiffReader(this.stream, TiffOpenMode.NO_CHECKS, false);
                }
                catch (IOException e) {
                    throw new AssertionError("Impossible in NO_CHECKS mode", e);
                }
                this.reader.setCaching(false);
            }
            return this.reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetReader() {
        Object object = this.fileLock;
        synchronized (object) {
            this.reader = null;
        }
    }

    public TiffReader newReader(TiffOpenMode openMode) throws IOException {
        return new TiffReader(this.stream, openMode, false);
    }

    public long rewriteIFD(TiffIFD ifd) throws IOException {
        return this.rewriteIFD(ifd, false);
    }

    public long rewriteIFD(TiffIFD ifd, boolean updateIFDLinkages) throws IOException {
        Objects.requireNonNull(ifd, "Null IFD");
        if (!ifd.hasFileOffsetForWriting()) {
            throw new IllegalArgumentException("Offset for writing IFD is not specified");
        }
        long offset = ifd.getFileOffsetForWriting();
        assert ((offset & 1L) == 0L) : "TiffIFD.setFileOffsetForWriting() has not check offset parity: " + offset;
        return this.writeIFDAt(ifd, offset, updateIFDLinkages);
    }

    public long writeIFDAtFileEnd(TiffIFD ifd) throws IOException {
        return this.writeIFDAt(ifd, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeIFDAt(TiffIFD ifd, Long startOffset, boolean updateIFDLinkages) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            this.checkVirginFile();
            this.resetReader();
            if (startOffset == null) {
                this.appendFileUntilEvenLength();
                startOffset = this.stream.length();
            }
            if (!this.bigTiff && startOffset > 4000000000L) {
                throw new TiffException("Attempt to write too large TIFF file without big-TIFF mode: offset of new IFD will be " + startOffset + " > 4000000000");
            }
            ifd.setFileOffsetForWriting(startOffset);
            this.stream.seek(startOffset.longValue());
            TreeMap<Integer, Object> sortedIFD = new TreeMap<Integer, Object>(ifd.map());
            int numberOfEntries = sortedIFD.size();
            int mainIFDLength = TiffIFD.sizeOfIFDTable(numberOfEntries, this.bigTiff, true);
            this.writeIFDNumberOfEntries(numberOfEntries);
            long positionOfNextOffset = this.writeIFDEntries(sortedIFD, startOffset, mainIFDLength);
            long previousPositionOfLastIFDOffset = this.positionOfLastIFDOffset;
            this.writeIFDNextOffsetAt(ifd, positionOfNextOffset, updateIFDLinkages);
            if (updateIFDLinkages && !this.allUsedIFDOffsets.contains(startOffset)) {
                this.writeIFDOffsetAt(startOffset, previousPositionOfLastIFDOffset, false);
            }
            return startOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteIFDOffset(int ifdIndex, long ifdOffset) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            long position;
            if (ifdIndex < 0) {
                throw new IllegalArgumentException("Negative IFD index: " + ifdIndex);
            }
            if (ifdOffset <= 0L) {
                throw new IllegalArgumentException("Zero or negative IFD offset " + ifdOffset);
            }
            if (this.positionOfLastIFDOffset < 0L) {
                throw new IllegalStateException("The TIFF file is not yet open");
            }
            if (ifdIndex == 0) {
                position = this.positionOfFirstIFDOffset();
            } else {
                TiffReader reader = this.reader();
                reader.readSingleIFDOffset(ifdIndex);
                position = reader.positionOfLastIFDOffset();
            }
            this.writeIFDOffsetAt(ifdOffset, position, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteLastIFDOffset(long newLastIFDOffset) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            if (newLastIFDOffset < 0L) {
                throw new IllegalArgumentException("Negative new last IFD offset " + newLastIFDOffset);
            }
            if (this.positionOfLastIFDOffset < 0L) {
                throw new IllegalStateException("The TIFF file is not yet open");
            }
            this.writeIFDOffsetAt(newLastIFDOffset, this.positionOfLastIFDOffset, false);
        }
    }

    public void fillEmptyTile(TiffTile tiffTile) {
        if (this.byteFiller != 0) {
            Arrays.fill(tiffTile.getDecodedData(), this.byteFiller);
        }
    }

    public void writeTile(TiffTile tile, boolean freeAndFreezeAfterWriting) throws IOException {
        this.encode(tile);
        this.writeEncodedTile(tile, freeAndFreezeAfterWriting);
    }

    public int writeTiles(Collection<TiffTile> tiles, Predicate<TiffTile> needToWrite, boolean freeAndFreezeAfterWriting) throws IOException {
        Objects.requireNonNull(tiles, "Null tiles");
        Objects.requireNonNull(needToWrite, "Null needToWrite");
        long t1 = TiffWriter.debugTime();
        int count = 0;
        long sizeInBytes = 0L;
        for (TiffTile tile : tiles) {
            if (!needToWrite.test(tile)) continue;
            this.writeTile(tile, freeAndFreezeAfterWriting);
            ++count;
            sizeInBytes += (long)tile.getSizeInBytes();
        }
        long t2 = TiffWriter.debugTime();
        this.logTiles(tiles, "middle", "encoded/wrote", count, sizeInBytes, t1, t2);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEncodedTile(TiffTile tile, boolean freeAndFreezeAfterWriting) throws IOException {
        Objects.requireNonNull(tile, "Null tile");
        if (tile.isEmpty()) {
            return;
        }
        long t1 = TiffWriter.debugTime();
        Object object = this.fileLock;
        synchronized (object) {
            this.checkVirginFile();
            this.resetReader();
            TiffTileIO.write(tile, this.stream, this.alwaysWriteToFileEnd, !this.bigTiff);
            if (freeAndFreezeAfterWriting) {
                tile.freeAndFreeze();
            }
        }
        long t2 = TiffWriter.debugTime();
        this.timeWriting += t2 - t1;
    }

    public boolean encode(TiffTile tile) throws TiffException {
        Objects.requireNonNull(tile, "Null tile");
        if (tile.isEmpty() || tile.isEncoded()) {
            return false;
        }
        tile.checkStoredNumberOfPixels();
        long t1 = TiffWriter.debugTime();
        this.prepareEncoding(tile);
        long t2 = TiffWriter.debugTime();
        TagCompression compression = tile.compression().orElse(null);
        TiffCodec codec = null;
        if (!this.enforceUseExternalCodec && compression != null) {
            codec = compression.codec();
        }
        TiffCodec.Options options = this.buildOptions(tile);
        long t3 = TiffWriter.debugTime();
        byte[] data = tile.getDecodedData();
        if (codec != null) {
            options = compression.customizeWriting(tile, options);
            if (codec instanceof TiffCodec.Timing) {
                TiffCodec.Timing timing = (TiffCodec.Timing)((Object)codec);
                timing.setTiming(BUILT_IN_TIMING && LOGGABLE_DEBUG);
                timing.clearTiming();
            }
            encodedData = (Optional<byte[]>)codec.compress(data, options);
            tile.setEncodedData((byte[])encodedData);
        } else {
            encodedData = this.encodeByExternalCodec(tile, tile.getDecodedData(), options);
            if (encodedData.isEmpty()) {
                throw new UnsupportedTiffFormatException("TIFF compression with code " + tile.compressionCode() + " cannot be encoded: " + String.valueOf(tile.ifd()));
            }
            tile.setEncodedData(encodedData.get());
        }
        if (tile.ifd().isReversedFillOrder()) {
            PackedBitArraysPer8.reverseBitOrderInPlace((byte[])tile.getEncodedData());
        }
        long t4 = TiffWriter.debugTime();
        this.timePreparingEncoding += t2 - t1;
        this.timeCustomizingEncoding += t3 - t2;
        this.timeEncoding += t4 - t3;
        if (codec instanceof TiffCodec.Timing) {
            TiffCodec.Timing timing = (TiffCodec.Timing)((Object)codec);
            this.timeEncodingMain += timing.timeMain();
            this.timeEncodingBridge += timing.timeBridge();
            this.timeEncodingAdditional += timing.timeAdditional();
        } else {
            this.timeEncodingMain += t4 - t3;
        }
        return true;
    }

    public void prepareEncoding(TiffTile tile) throws TiffException {
        Objects.requireNonNull(tile, "Null tile");
        if (tile.isInterleaved()) {
            throw new IllegalArgumentException("Tile for encoding and writing to TIFF file must not be interleaved:: " + String.valueOf(tile));
        }
        tile.interleaveSamples();
        TiffPacking.packTiffBits(tile);
        TiffPrediction.subtractPredictionIfRequested(tile);
    }

    public void encode(TiffWriteMap map) throws TiffException {
        this.encode(map, null);
    }

    public void correctForEncoding(TiffIFD ifd) throws TiffException {
        this.correctForEncoding(ifd, this.isSmartCorrection());
    }

    public void correctForEncoding(TiffIFD ifd, boolean smartCorrection) throws TiffException {
        TagPhotometricInterpretation suggestedPhotometric;
        TagCompression compression;
        TiffSampleType sampleType;
        int samplesPerPixel = ifd.getSamplesPerPixel();
        if (!ifd.containsKey(258)) {
            ifd.put(258, new int[]{1});
        }
        try {
            sampleType = ifd.sampleType();
        }
        catch (TiffException e) {
            throw new UnsupportedTiffFormatException("Cannot write TIFF, because requested combination of number of bits per sample and sample format is not supported: " + e.getMessage());
        }
        if (smartCorrection) {
            ifd.putSampleType(sampleType);
        } else {
            int bits = ifd.checkSupportedBitDepth();
            if (sampleType == TiffSampleType.FLOAT && bits != 32) {
                throw new UnsupportedTiffFormatException("Cannot write TIFF, because requested number of bits per sample is not supported: " + bits + " bits for floating-point precision");
            }
        }
        if (!ifd.containsKey(259)) {
            ifd.put(259, 1);
        }
        if (!(compression = ifd.optCompression().orElse(TagCompression.NONE)).isWritingSupported()) {
            throw new UnsupportedTiffFormatException("TIFF compression with code " + compression.code() + " (\"" + compression.prettyName() + "\") is not supported for writing");
        }
        TagPhotometricInterpretation newPhotometric = suggestedPhotometric = ifd.containsKey(262) ? ifd.getPhotometricInterpretation() : null;
        if (compression.isStandardJpeg()) {
            if (samplesPerPixel != 1 && samplesPerPixel != 3) {
                throw new TiffException("JPEG compression for " + samplesPerPixel + " channels is not supported");
            }
            if (newPhotometric == null) {
                newPhotometric = samplesPerPixel == 1 ? TagPhotometricInterpretation.BLACK_IS_ZERO : (compression.isPreferRGB() || !ifd.isChunked() ? TagPhotometricInterpretation.RGB : TagPhotometricInterpretation.Y_CB_CR);
            } else {
                TiffWriter.checkPhotometricInterpretation(newPhotometric, samplesPerPixel == 1 ? EnumSet.of(TagPhotometricInterpretation.BLACK_IS_ZERO) : (!this.enforceUseExternalCodec ? EnumSet.of(TagPhotometricInterpretation.Y_CB_CR, TagPhotometricInterpretation.RGB) : EnumSet.of(TagPhotometricInterpretation.Y_CB_CR)), "JPEG " + samplesPerPixel + "-channel image");
            }
        } else if (samplesPerPixel == 1) {
            boolean hasColorMap = ifd.containsKey(320);
            if (newPhotometric == null) {
                newPhotometric = hasColorMap ? TagPhotometricInterpretation.RGB_PALETTE : TagPhotometricInterpretation.BLACK_IS_ZERO;
            } else {
                if (newPhotometric == TagPhotometricInterpretation.RGB_PALETTE && !hasColorMap) {
                    throw new TiffException("Cannot write TIFF image: newPhotometric interpretation \"" + newPhotometric.prettyName() + "\" requires also \"ColorMap\" tag");
                }
                TiffWriter.checkPhotometricInterpretation(newPhotometric, EnumSet.of(TagPhotometricInterpretation.BLACK_IS_ZERO, TagPhotometricInterpretation.WHITE_IS_ZERO, TagPhotometricInterpretation.RGB_PALETTE), samplesPerPixel + "-channel image");
            }
        } else if (samplesPerPixel == 3) {
            if (newPhotometric == null) {
                newPhotometric = TagPhotometricInterpretation.RGB;
            } else if (ifd.isStandardYCbCrNonJpeg()) {
                if (!smartCorrection) {
                    throw new UnsupportedTiffFormatException("Cannot write TIFF: encoding YCbCr photometric interpretation is not supported for compression \"" + compression.prettyName() + "\"");
                }
                newPhotometric = TagPhotometricInterpretation.RGB;
            }
        } else if (newPhotometric == null && samplesPerPixel == 4) {
            newPhotometric = TagPhotometricInterpretation.RGB;
        }
        if (newPhotometric != suggestedPhotometric) {
            ifd.putPhotometricInterpretation(newPhotometric);
        }
        this.correctForEntireTiff(ifd);
    }

    public void correctForEntireTiff(TiffIFD ifd) throws TiffException {
        ifd.remove(330);
        ifd.remove(34665);
        ifd.remove(34853);
        ifd.setLittleEndian(this.stream.isLittleEndian());
        ifd.setBigTiff(this.bigTiff);
    }

    public TiffIFD newIFD() {
        return this.newIFD(false);
    }

    public TiffIFD newIFD(boolean tiled) {
        TiffIFD ifd = new TiffIFD();
        ifd.putCompression(TagCompression.NONE);
        if (tiled) {
            ifd.defaultTileSizes();
        } else {
            ifd.defaultStripSize();
        }
        return ifd;
    }

    public TiffIFD existingIFD(int ifdIndex) throws IOException {
        TiffReader reader = this.reader();
        TiffIFD ifd = reader.readSingleIFD(ifdIndex);
        ifd.setFileOffsetForWriting(ifd.getFileOffsetForReading());
        return ifd;
    }

    public TiffWriteMap newMap(TiffIFD ifd, boolean resizable, boolean correctForEncoding) throws TiffException {
        Objects.requireNonNull(ifd, "Null IFD");
        if (ifd.isFrozen()) {
            throw new IllegalStateException("IFD is already frozen for usage while writing TIFF; probably you called this method twice");
        }
        if (correctForEncoding) {
            this.correctForEncoding(ifd);
        } else {
            this.correctForEntireTiff(ifd);
        }
        TiffWriteMap map = new TiffWriteMap(this, ifd, resizable, false);
        this.prepareNewMap(map);
        this.lastMap = map;
        return map;
    }

    public TiffWriteMap newMap(TiffIFD ifd, boolean resizable) throws TiffException {
        return this.newMap(ifd, resizable, true);
    }

    public TiffWriteMap newFixedMap(TiffIFD ifd) throws TiffException {
        return this.newMap(ifd, false);
    }

    public TiffWriteMap newResizableMap(TiffIFD ifd) throws TiffException {
        return this.newMap(ifd, true);
    }

    public TiffWriteMap existingMap(int ifdIndex) throws IOException {
        return this.existingMap(this.existingIFD(ifdIndex));
    }

    public TiffWriteMap existingMap(TiffIFD ifd) throws TiffException {
        Objects.requireNonNull(ifd, "Null IFD");
        if (!ifd.isLoadedFromFile()) {
            throw new IllegalArgumentException("IFD must be read from TIFF file");
        }
        this.correctForEncoding(ifd, false);
        TiffWriteMap map = new TiffWriteMap(this, ifd, false, true);
        long[] offsets = ifd.cachedTileOrStripOffsets();
        long[] byteCounts = ifd.cachedTileOrStripByteCounts();
        assert (offsets != null);
        assert (byteCounts != null);
        map.buildTileGrid();
        if (offsets.length < map.numberOfTiles() || byteCounts.length < map.numberOfTiles()) {
            throw new ConcurrentModificationException("Strange length of tile offsets " + offsets.length + " or byte counts " + byteCounts.length);
        }
        ifd.freeze();
        int k = 0;
        for (TiffTile tile : map.tiles()) {
            tile.setStoredInFileDataRange(offsets[k], (int)byteCounts[k], true);
            tile.markWholeTileAsSet();
            ++k;
        }
        this.lastMap = map;
        return map;
    }

    public TiffWriteMap lastMap() {
        return this.lastMap;
    }

    public void writeForward(TiffWriteMap map) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        if (!this.writingForwardAllowed || map.isResizable()) {
            return;
        }
        long[] offsets = new long[map.numberOfGridTiles()];
        long[] byteCounts = new long[map.numberOfGridTiles()];
        TiffIFD ifd = map.ifd();
        ifd.updateDataPositioning(offsets, byteCounts);
        if (!ifd.hasFileOffsetForWriting()) {
            this.writeIFDAt(ifd, null, false);
        }
    }

    public void writeSampleBytes(TiffWriteMap map, byte[] samples) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        map.checkZeroDimensions();
        this.writeSampleBytes(map, samples, 0, 0, map.dimX(), map.dimY());
    }

    public void writeSampleBytes(TiffWriteMap map, byte[] samples, int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        Objects.requireNonNull(samples, "Null samples");
        this.clearTime();
        long t1 = TiffWriter.debugTime();
        map.updateSampleBytes(samples, fromX, fromY, sizeX, sizeY);
        long t2 = TiffWriter.debugTime();
        this.writeForward(map);
        long t3 = TiffWriter.debugTime();
        this.encode(map);
        long t4 = TiffWriter.debugTime();
        this.completeWriting(map);
        this.logWritingMatrix(map, "byte samples", sizeX, sizeY, t1, t2, t3, t4);
    }

    public void writeJavaArray(TiffWriteMap map, Object samplesArray) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        map.checkZeroDimensions();
        this.writeJavaArray(map, samplesArray, 0, 0, map.dimX(), map.dimY());
    }

    public void writeJavaArray(TiffWriteMap map, Object samplesArray, int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        Objects.requireNonNull(samplesArray, "Null samplesArray");
        this.clearTime();
        long t1 = TiffWriter.debugTime();
        map.updateJavaArray(samplesArray, fromX, fromY, sizeX, sizeY);
        long t2 = TiffWriter.debugTime();
        this.writeForward(map);
        long t3 = TiffWriter.debugTime();
        this.encode(map);
        long t4 = TiffWriter.debugTime();
        this.completeWriting(map);
        this.logWritingMatrix(map, "pixel array", sizeX, sizeY, t1, t2, t3, t4);
    }

    public void writeMatrix(TiffWriteMap map, Matrix<? extends PArray> matrix) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        this.writeMatrix(map, matrix, 0, 0);
    }

    public void writeMatrix(TiffWriteMap map, Matrix<? extends PArray> matrix, int fromX, int fromY) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        Objects.requireNonNull(matrix, "Null matrix");
        this.clearTime();
        long t1 = TiffWriter.debugTime();
        map.updateMatrix(matrix, fromX, fromY);
        long t2 = TiffWriter.debugTime();
        this.writeForward(map);
        long t3 = TiffWriter.debugTime();
        this.encode(map);
        long t4 = TiffWriter.debugTime();
        this.completeWriting(map);
        this.logWritingMatrix(map, matrix, t1, t2, t3, t4);
    }

    public void writeChannels(TiffWriteMap map, List<? extends Matrix<? extends PArray>> channels) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        this.writeChannels(map, channels, 0, 0);
    }

    public void writeChannels(TiffWriteMap map, List<? extends Matrix<? extends PArray>> channels, int fromX, int fromY) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        Objects.requireNonNull(channels, "Null channels");
        this.writeMatrix(map, (Matrix<? extends PArray>)Matrices.mergeLayers(channels), fromX, fromY);
    }

    public void writeBufferedImage(TiffWriteMap map, BufferedImage bufferedImage) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        this.writeBufferedImage(map, bufferedImage, 0, 0);
    }

    public void writeBufferedImage(TiffWriteMap map, BufferedImage bufferedImage, int fromX, int fromY) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        Objects.requireNonNull(bufferedImage, "Null bufferedImage");
        this.writeChannels(map, ImageToMatrix.toChannels((BufferedImage)bufferedImage), fromX, fromY);
    }

    public int completeWriting(TiffWriteMap map) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        boolean resizable = map.isResizable();
        map.checkTooSmallDimensionsForCurrentGrid();
        this.encode(map, "completion");
        TiffIFD ifd = map.ifd();
        if (resizable) {
            ifd.updateImageDimensions(map.dimX(), map.dimY(), true);
        }
        int count = this.completeWritingMap(map);
        map.cropAllUnset();
        if (ifd.hasFileOffsetForWriting()) {
            this.rewriteIFD(ifd, true);
        } else {
            this.writeIFDAt(ifd, null, true);
        }
        this.seekToEnd();
        return count;
    }

    @Override
    public void close() throws IOException {
        this.lastMap = null;
        super.close();
        this.resetReader();
    }

    public int sizeOfHeader() {
        return TiffIFD.sizeOfFileHeader(this.bigTiff);
    }

    public String toString() {
        return "TIFF writer";
    }

    protected Optional<byte[]> encodeByExternalCodec(TiffTile tile, byte[] decodedData, TiffCodec.Options options) throws TiffException {
        Objects.requireNonNull(tile, "Null tile");
        Objects.requireNonNull(decodedData, "Null decoded data");
        Objects.requireNonNull(options, "Null options");
        if (!SCIFIOBridge.isScifioInstalled()) {
            return Optional.empty();
        }
        Object scifioCodecOptions = options.toSCIFIOStyleOptions(SCIFIOBridge.codecOptionsClass());
        int width = tile.getSizeX();
        int height = tile.getSizeY();
        byte[] encodedData = this.compressByScifioCodec(tile.ifd(), decodedData, width, height, scifioCodecOptions);
        return Optional.of(encodedData);
    }

    private void prepareNewMap(TiffWriteMap map) {
        Objects.requireNonNull(map, "Null TIFF map");
        map.buildTileGrid();
        TiffIFD ifd = map.ifd();
        ifd.removeNextIFDOffset();
        ifd.removeDataPositioning();
        if (map.isResizable()) {
            ifd.removeImageDimensions();
        }
        ifd.freeze();
    }

    private byte[] compressByScifioCodec(TiffIFD ifd, byte[] data, int width, int height, Object scifioCodecOptions) throws TiffException {
        Object compression;
        Objects.requireNonNull(ifd, "Null ifd");
        Objects.requireNonNull(data, "Null data");
        Objects.requireNonNull(scifioCodecOptions, "Null scifioCodecOptions");
        int compressionCode = ifd.getCompressionCode();
        Object scifio = this.scifio();
        if (scifio == null) {
            throw new UnsupportedTiffFormatException("Writing with TIFF compression " + TagCompression.toPrettyString(ifd.optInt(259, 1)) + " is not supported without external codecs");
        }
        try {
            compression = SCIFIOBridge.createTiffCompression(compressionCode);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedTiffFormatException("TIFF compression code " + compressionCode + " is unknown and is not correctly recognized by the external SCIFIO subsystem", e);
        }
        try {
            Class<?> scifioIFDClass = SCIFIOBridge.scifioIFDClass();
            Map<Integer, Object> scifioIFD = SCIFIOBridge.createIFD(scifioIFDClass);
            scifioIFD.putAll(ifd.map());
            scifioIFD.put(0, ifd.isLittleEndian());
            scifioIFD.put(1, ifd.isBigTiff());
            scifioIFD.put(256, width);
            scifioIFD.put(257, height);
            scifioCodecOptions = SCIFIOBridge.getCompressionCodecOptions(compression, scifioIFD, scifioCodecOptions);
            return SCIFIOBridge.callCompress(scifio, compression, data, scifioCodecOptions);
        }
        catch (InvocationTargetException e) {
            throw new TiffException("TIFF compression code " + compressionCode + " is unknown and cannot be correctly processed for compression by the external SCIFIO subsystem", e);
        }
    }

    private void clearTime() {
        this.timeWriting = 0L;
        this.timeCustomizingEncoding = 0L;
        this.timePreparingEncoding = 0L;
        this.timeEncoding = 0L;
        this.timeEncodingMain = 0L;
        this.timeEncodingBridge = 0L;
        this.timeEncodingAdditional = 0L;
    }

    private void checkVirginFile() throws IOException {
        if (this.positionOfLastIFDOffset < 0L) {
            throw new IllegalStateException("TIFF file is not yet created / opened for writing");
        }
        boolean exists = this.stream.exists();
        if (!exists || this.stream.length() < (long)this.sizeOfHeader()) {
            throw new IllegalStateException((String)(exists ? "Existing TIFF file is too short (" + this.stream.length() + " bytes)" : "TIFF file does not exists yet") + ": probably file header was not written correctly by open()/create() methods");
        }
    }

    private void writeIFDNumberOfEntries(int numberOfEntries) throws IOException {
        if (this.bigTiff) {
            this.stream.writeLong((long)numberOfEntries);
        } else {
            TiffWriter.writeUnsignedShort(this.stream, numberOfEntries);
        }
    }

    private long writeIFDEntries(Map<Integer, Object> ifd, long startOffset, int mainIFDLength) throws IOException {
        long positionOfNextOffset;
        long afterMain = startOffset + (long)mainIFDLength;
        BytesLocation bytesLocation = new BytesLocation(0, "memory-buffer");
        try (BytesHandle extraBuffer = TiffWriter.getBytesHandle(bytesLocation);){
            extraBuffer.setLittleEndian(this.isLittleEndian());
            for (Map.Entry<Integer, Object> e : ifd.entrySet()) {
                this.writeIFDValueAtCurrentPosition((DataHandle<?>)extraBuffer, afterMain, e.getKey(), e.getValue());
            }
            positionOfNextOffset = this.stream.offset();
            this.writeOffset(0L);
            long extraLength = extraBuffer.length();
            assert (extraBuffer.offset() == extraLength);
            extraBuffer.seek(0L);
            TiffWriter.copyData(extraBuffer, this.stream, extraLength);
        }
        return positionOfNextOffset;
    }

    private void writeIFDValueAtCurrentPosition(DataHandle<?> extraBuffer, long bufferOffsetInResultFile, int tag, Object value) throws IOException {
        if (value instanceof Short) {
            Short v = (Short)value;
            value = new short[]{v};
        } else if (value instanceof Integer) {
            Integer v = (Integer)value;
            value = new int[]{v};
        } else if (value instanceof Long) {
            Long v = (Long)value;
            value = new long[]{v};
        } else if (value instanceof TagRational) {
            TagRational v = (TagRational)value;
            value = new TagRational[]{v};
        } else if (value instanceof Float) {
            Float v = (Float)value;
            value = new float[]{v.floatValue()};
        } else if (value instanceof Double) {
            Double v = (Double)value;
            value = new double[]{v};
        }
        boolean emptyStringList = false;
        if (value instanceof String[]) {
            CharSequence[] list = (String[])value;
            emptyStringList = list.length == 0;
            value = String.join((CharSequence)"\u0000", list);
        } else if (value instanceof List) {
            List list = (List)value;
            emptyStringList = list.isEmpty();
            value = list.stream().map(String::valueOf).collect(Collectors.joining("\u0000"));
        }
        boolean bigTiff = this.bigTiff;
        int dataLength = bigTiff ? 8 : 4;
        int dataLengthDiv2 = dataLength >> 1;
        int dataLengthDiv4 = dataLength >> 2;
        TiffWriter.writeUnsignedShort(this.stream, tag);
        if (value instanceof byte[]) {
            byte[] q = (byte[])value;
            this.stream.writeShort(7);
            this.writeIntOrLong(this.stream, q.length);
            if (q.length <= dataLength) {
                for (byte byteValue : q) {
                    this.stream.writeByte((int)byteValue);
                }
                for (int i = q.length; i < dataLength; ++i) {
                    this.stream.writeByte(0);
                }
            } else {
                TiffWriter.appendUntilEvenPosition(extraBuffer);
                this.writeOffset(bufferOffsetInResultFile + extraBuffer.offset());
                extraBuffer.write(q);
            }
        } else if (value instanceof short[]) {
            short[] q = (short[])value;
            this.stream.writeShort(1);
            this.writeIntOrLong(this.stream, q.length);
            if (q.length <= dataLength) {
                for (short s : q) {
                    this.stream.writeByte((int)s);
                }
                for (int i = q.length; i < dataLength; ++i) {
                    this.stream.writeByte(0);
                }
            } else {
                TiffWriter.appendUntilEvenPosition(extraBuffer);
                this.writeOffset(bufferOffsetInResultFile + extraBuffer.offset());
                for (short shortValue : q) {
                    extraBuffer.writeByte((int)shortValue);
                }
            }
        } else if (value instanceof String) {
            String stringValue = (String)value;
            this.stream.writeShort(2);
            byte[] q = stringValue.getBytes(StandardCharsets.UTF_8);
            this.writeIntOrLong(this.stream, emptyStringList ? 0 : q.length + 1);
            if (q.length < dataLength) {
                for (byte c : q) {
                    TiffWriter.writeUnsignedByte(this.stream, c & 0xFF);
                }
                for (int i = q.length; i < dataLength; ++i) {
                    this.stream.writeByte(0);
                }
            } else {
                TiffWriter.appendUntilEvenPosition(extraBuffer);
                this.writeOffset(bufferOffsetInResultFile + extraBuffer.offset());
                for (byte c : q) {
                    TiffWriter.writeUnsignedByte(extraBuffer, c & 0xFF);
                }
                extraBuffer.writeByte(0);
            }
        } else if (value instanceof int[]) {
            int v;
            int[] q = (int[])value;
            if (q.length == 1 && (v = q[0]) >= 65535) {
                this.stream.writeShort(4);
                this.writeIntOrLong(this.stream, q.length);
                this.writeIntOrLong(this.stream, v);
                return;
            }
            this.stream.writeShort(3);
            this.writeIntOrLong(this.stream, q.length);
            if (q.length <= dataLengthDiv2) {
                for (int intValue : q) {
                    TiffWriter.writeUnsignedShort(this.stream, intValue);
                }
                for (int i = q.length; i < dataLengthDiv2; ++i) {
                    this.stream.writeShort(0);
                }
            } else {
                TiffWriter.appendUntilEvenPosition(extraBuffer);
                this.writeOffset(bufferOffsetInResultFile + extraBuffer.offset());
                for (int intValue : q) {
                    extraBuffer.writeShort(intValue);
                }
            }
        } else if (value instanceof long[]) {
            long v;
            long[] q = (long[])value;
            if (q.length == 1 && bigTiff && (v = q[0]) == (long)((int)v)) {
                switch (tag) {
                    case 254: 
                    case 256: 
                    case 257: 
                    case 278: 
                    case 322: 
                    case 323: 
                    case 32997: {
                        this.stream.writeShort(4);
                        this.writeIntOrLong(this.stream, q.length);
                        this.stream.writeInt((int)v);
                        this.stream.writeInt(0);
                        return;
                    }
                }
            }
            int type = bigTiff ? 16 : 4;
            this.stream.writeShort(type);
            this.writeIntOrLong(this.stream, q.length);
            if (q.length <= 1) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.writeIntOrLong(this.stream, q[0]);
                }
                for (i = q.length; i < 1; ++i) {
                    this.writeIntOrLong(this.stream, 0);
                }
            } else {
                TiffWriter.appendUntilEvenPosition(extraBuffer);
                this.writeOffset(bufferOffsetInResultFile + extraBuffer.offset());
                for (long longValue : q) {
                    this.writeIntOrLong(extraBuffer, longValue);
                }
            }
        } else if (value instanceof TagRational[]) {
            Object q = value;
            this.stream.writeShort(5);
            this.writeIntOrLong(this.stream, ((TagRational[])q).length);
            if (bigTiff && ((Object)q).length == 1) {
                this.stream.writeInt((int)((TagRational)q[0]).getNumerator());
                this.stream.writeInt((int)((TagRational)q[0]).getDenominator());
            } else {
                TiffWriter.appendUntilEvenPosition(extraBuffer);
                this.writeOffset(bufferOffsetInResultFile + extraBuffer.offset());
                for (Object tagRational : q) {
                    extraBuffer.writeInt((int)((TagRational)tagRational).getNumerator());
                    extraBuffer.writeInt((int)((TagRational)tagRational).getDenominator());
                }
            }
        } else if (value instanceof float[]) {
            float[] q = (float[])value;
            this.stream.writeShort(11);
            this.writeIntOrLong(this.stream, q.length);
            if (q.length <= dataLengthDiv4) {
                for (float floatValue : q) {
                    this.stream.writeFloat(floatValue);
                }
                for (int i = q.length; i < dataLengthDiv4; ++i) {
                    this.stream.writeInt(0);
                }
            } else {
                TiffWriter.appendUntilEvenPosition(extraBuffer);
                this.writeOffset(bufferOffsetInResultFile + extraBuffer.offset());
                for (float floatValue : q) {
                    extraBuffer.writeFloat(floatValue);
                }
            }
        } else if (value instanceof double[]) {
            double[] q = (double[])value;
            this.stream.writeShort(12);
            this.writeIntOrLong(this.stream, q.length);
            TiffWriter.appendUntilEvenPosition(extraBuffer);
            this.writeOffset(bufferOffsetInResultFile + extraBuffer.offset());
            for (double doubleValue : q) {
                extraBuffer.writeDouble(doubleValue);
            }
        } else if (!(value instanceof TiffIFD.UnsupportedTypeValue)) {
            throw new UnsupportedOperationException("Unknown IFD tag " + tag + " value type (" + value.getClass().getSimpleName() + "): " + String.valueOf(value));
        }
    }

    private void writeIFDNextOffsetAt(TiffIFD ifd, long positionToWrite, boolean updatePositionOfLastIFDOffset) throws IOException {
        this.writeIFDOffsetAt(ifd.hasNextIFDOffset() ? ifd.getNextIFDOffset() : 0L, positionToWrite, updatePositionOfLastIFDOffset);
    }

    private void encode(TiffWriteMap map, String stage) throws TiffException {
        Objects.requireNonNull(map, "Null TIFF map");
        long t1 = TiffWriter.debugTime();
        int count = 0;
        long sizeInBytes = 0L;
        for (TiffTile tile : map.tiles()) {
            boolean wasNotEncodedYet = this.encode(tile);
            if (!wasNotEncodedYet) continue;
            ++count;
            sizeInBytes += (long)tile.getSizeInBytes();
        }
        long t2 = TiffWriter.debugTime();
        this.logTiles(map, stage, "encoded", count, sizeInBytes, t1, t2);
    }

    private int completeWritingMap(TiffWriteMap map) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        long[] offsets = new long[map.numberOfGridTiles()];
        long[] byteCounts = new long[map.numberOfGridTiles()];
        TiffTile filler = null;
        int numberOfSeparatedPlanes = map.numberOfSeparatedPlanes();
        int gridCountY = map.gridCountY();
        int gridCountX = map.gridCountX();
        long t1 = TiffWriter.debugTime();
        int count = 0;
        long sizeInBytes = 0L;
        int k = 0;
        for (int p = 0; p < numberOfSeparatedPlanes; ++p) {
            for (int yIndex = 0; yIndex < gridCountY; ++yIndex) {
                int xIndex = 0;
                while (xIndex < gridCountX) {
                    TiffTileIndex tileIndex = map.index(xIndex, yIndex, p);
                    TiffTile tile = map.getOrNew(tileIndex);
                    tile.cropStripToMap();
                    if (!tile.isEmpty()) {
                        this.writeEncodedTile(tile, true);
                        ++count;
                        sizeInBytes += (long)tile.getSizeInBytes();
                    }
                    if (tile.isStoredInFile()) {
                        offsets[k] = tile.getStoredInFileDataOffset();
                        byteCounts[k] = tile.getStoredInFileDataLength();
                    } else {
                        assert (tile.isEmpty()) : "writeEncodedTile() call above did not store data file offset!";
                        if (!this.missingTilesAllowed) {
                            if (!tile.equalSizes(filler)) {
                                filler = new TiffTile(tileIndex).setEqualSizes(tile);
                                filler.fillWhenEmpty(this.tileInitializer);
                                this.encode(filler);
                                this.writeEncodedTile(filler, false);
                            }
                            offsets[k] = filler.getStoredInFileDataOffset();
                            byteCounts[k] = filler.getStoredInFileDataLength();
                            tile.copyStoredInFileDataRange(filler);
                        }
                    }
                    ++xIndex;
                    ++k;
                }
            }
        }
        map.ifd().updateDataPositioning(offsets, byteCounts);
        long t2 = TiffWriter.debugTime();
        this.logTiles(map, "completion", "wrote", count, sizeInBytes, t1, t2);
        return count;
    }

    private void writeIntOrLong(DataHandle<?> handle, long value) throws IOException {
        if (this.bigTiff) {
            handle.writeLong(value);
        } else {
            if (value < Integer.MIN_VALUE || value > 0xFFFFFFFFL) {
                throw new TiffException("Attempt to write 64-bit value as 32-bit: " + value);
            }
            handle.writeInt((int)value);
        }
    }

    private void writeIntOrLong(DataHandle<?> handle, int value) throws IOException {
        if (this.bigTiff) {
            handle.writeLong((long)value);
        } else {
            handle.writeInt(value);
        }
    }

    private static void writeUnsignedShort(DataHandle<?> handle, int value) throws IOException {
        if (value < 0 || value > 65535) {
            throw new TiffException("Attempt to write 32-bit value as 16-bit: " + value);
        }
        handle.writeShort(value);
    }

    private static void writeUnsignedByte(DataHandle<?> handle, int value) throws IOException {
        if (value < 0 || value > 255) {
            throw new TiffException("Attempt to write 16/32-bit value as 8-bit: " + value);
        }
        handle.writeByte(value);
    }

    private void writeOffset(long offset) throws IOException {
        if (offset < 0L) {
            throw new AssertionError((Object)("Illegal usage of writeOffset: negative offset " + offset));
        }
        if (this.bigTiff) {
            this.stream.writeLong(offset);
        } else {
            if (offset > 0xFFFFFFF0L) {
                throw new TiffException("Attempt to write too large 64-bit offset as unsigned 32-bit: " + offset + " > 2^32-16; such large files should be written in BigTIFF mode");
            }
            this.stream.writeInt((int)offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIFDOffsetAt(long offset, long positionToWrite, boolean updatePositionOfLastIFDOffset) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            this.resetReader();
            long savedPosition = this.stream.offset();
            try {
                this.stream.seek(positionToWrite);
                this.writeOffset(offset);
                this.allUsedIFDOffsets.add(offset);
                if (updatePositionOfLastIFDOffset && offset == 0L) {
                    this.positionOfLastIFDOffset = positionToWrite;
                }
            }
            finally {
                this.stream.seek(savedPosition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seekToEnd() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            this.stream.seek(this.stream.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendFileUntilEvenLength() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            this.seekToEnd();
            TiffWriter.appendUntilEvenPosition(this.stream);
        }
    }

    private static void appendUntilEvenPosition(DataHandle<?> handle) throws IOException {
        if ((handle.offset() & 1L) != 0L) {
            handle.writeByte(0);
        }
    }

    private TiffCodec.Options buildOptions(TiffTile tile) throws TiffException {
        TiffCodec.Options options = this.codecOptions.clone();
        options.setSizes(tile.getSizeX(), tile.getSizeY());
        options.setBitsPerSample(tile.bitsPerSample());
        options.setNumberOfChannels(tile.samplesPerPixel());
        options.setSigned(tile.sampleType().isSigned());
        options.setFloatingPoint(tile.sampleType().isFloatingPoint());
        options.setCompressionCode(tile.compressionCode());
        options.setByteOrder(tile.byteOrder());
        options.setInterleaved(true);
        if (this.compressionQuality != null) {
            options.setCompressionQuality(this.compressionQuality);
        }
        if (this.losslessCompressionLevel != null) {
            options.setLosslessCompressionLevel(this.losslessCompressionLevel);
        }
        options.setIfd(tile.ifd());
        return options;
    }

    private void logWritingMatrix(TiffWriteMap map, Matrix<?> matrix, long t1, long t2, long t3, long t4) {
        if (BUILT_IN_TIMING && LOGGABLE_DEBUG) {
            boolean sourceInterleaved;
            if (!map.isPlanarSeparated()) {
                // empty if block
            }
            long dimX = matrix.dim((sourceInterleaved = false) ? 1 : 0);
            long dimY = matrix.dim(sourceInterleaved ? 2 : 1);
            this.logWritingMatrix(map, "matrix", dimX, dimY, t1, t2, t3, t4);
        }
    }

    private void logTiles(Collection<TiffTile> tiles, String stage, String action, int count, long sizeInBytes, long t1, long t2) {
        this.logTiles(tiles.isEmpty() ? null : tiles.iterator().next().map(), stage, action, count, sizeInBytes, t1, t2);
    }

    private void logTiles(TiffMap map, String stage, String action, int count, long sizeInBytes, long t1, long t2) {
        if (BUILT_IN_TIMING && LOGGABLE_DEBUG) {
            LOG.log(System.Logger.Level.TRACE, () -> count == 0 ? String.format(Locale.US, "%s%s %s no tiles in %.3f ms", this.getClass().getSimpleName(), stage == null ? "" : " (" + stage + " stage)", action, (double)(t2 - t1) * 1.0E-6) : String.format(Locale.US, "%s%s %s %d tiles %dx%dx%d (%.3f MB) in %.3f ms, %.3f MB/s", this.getClass().getSimpleName(), stage == null ? "" : " (" + stage + " stage)", action, count, map.numberOfChannels(), map.tileSizeX(), map.tileSizeY(), (double)sizeInBytes / 1048576.0, (double)(t2 - t1) * 1.0E-6, (double)sizeInBytes / 1048576.0 / ((double)(t2 - t1) * 1.0E-9)));
        }
    }

    private void logWritingMatrix(TiffWriteMap map, String name, long dimX, long dimY, long t1, long t2, long t3, long t4) {
        if (BUILT_IN_TIMING && LOGGABLE_DEBUG) {
            long t5 = TiffWriter.debugTime();
            long sizeInBytes = map.totalSizeInBytes();
            LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "%s wrote %dx%dx%d %s (%.3f MB) in %.3f ms = %.3f conversion/copying data + %.3f writing IFD + %.3f/%.3f encoding/writing (%.3f prepare, %.3f customize, %.3f encode [%.3f main%s], %.3f write), %.3f MB/s", this.getClass().getSimpleName(), dimX, dimY, map.numberOfChannels(), name, (double)sizeInBytes / 1048576.0, (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6, (double)this.timePreparingEncoding * 1.0E-6, (double)this.timeCustomizingEncoding * 1.0E-6, (double)this.timeEncoding * 1.0E-6, (double)this.timeEncodingMain * 1.0E-6, this.timeEncodingBridge + this.timeEncodingAdditional > 0L ? String.format(Locale.US, " + %.3f encode-bridge + %.3f encode-additional", (double)this.timeEncodingBridge * 1.0E-6, (double)this.timeEncodingAdditional * 1.0E-6) : "", (double)this.timeWriting * 1.0E-6, (double)sizeInBytes / 1048576.0 / ((double)(t5 - t1) * 1.0E-9)));
        }
    }

    private static void checkPhotometricInterpretation(TagPhotometricInterpretation photometricInterpretation, EnumSet<TagPhotometricInterpretation> allowed, String whatToWrite) throws TiffException {
        if (photometricInterpretation != null && !allowed.contains((Object)photometricInterpretation)) {
            throw new TiffException("Writing " + whatToWrite + " with photometric interpretation \"" + photometricInterpretation.prettyName() + "\" is not supported (only " + allowed.stream().map(photometric -> "\"" + photometric.prettyName() + "\"").collect(Collectors.joining(", ")) + " allowed)");
        }
    }

    private static DataHandle<?> openWithDeletingPreviousFileIfRequested(Path file, TiffCreateMode createMode) throws IOException {
        Objects.requireNonNull(file, "Null file");
        Objects.requireNonNull(createMode, "Null createMode");
        if (createMode.isForceCreateNewFile()) {
            Files.deleteIfExists(file);
        }
        return TiffWriter.getFileHandle(file);
    }
}

