/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.algart.arrays.Arrays;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PackedBitArraysPer8;
import net.algart.arrays.UpdatablePArray;
import net.algart.io.awt.MatrixToImage;
import net.algart.matrices.tiff.SCIFIOBridge;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffIO;
import net.algart.matrices.tiff.TiffOpenMode;
import net.algart.matrices.tiff.TiffSampleType;
import net.algart.matrices.tiff.UnsupportedTiffFormatException;
import net.algart.matrices.tiff.codecs.TiffCodec;
import net.algart.matrices.tiff.data.TiffJPEGDecodingHelper;
import net.algart.matrices.tiff.data.TiffPrediction;
import net.algart.matrices.tiff.data.TiffUnpacking;
import net.algart.matrices.tiff.data.TiffUnusualPrecisions;
import net.algart.matrices.tiff.tags.TagCompression;
import net.algart.matrices.tiff.tags.TagRational;
import net.algart.matrices.tiff.tags.TagTypes;
import net.algart.matrices.tiff.tags.Tags;
import net.algart.matrices.tiff.tiles.TiffIOMap;
import net.algart.matrices.tiff.tiles.TiffMap;
import net.algart.matrices.tiff.tiles.TiffReadMap;
import net.algart.matrices.tiff.tiles.TiffTile;
import net.algart.matrices.tiff.tiles.TiffTileIO;
import net.algart.matrices.tiff.tiles.TiffTileIndex;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.ReadBufferDataHandle;

public non-sealed class TiffReader
extends TiffIO {
    public static final long DEFAULT_MAX_CACHING_MEMORY = Math.max(0L, Arrays.SystemSettings.getLongProperty((String)"net.algart.matrices.tiff.defaultMaxCachingMemory", (long)0x10000000L));
    private static final boolean OPTIMIZE_READING_IFD_ARRAYS = true;
    static final boolean USE_LEGACY_UNPACK_BYTES = false;
    private static final int MINIMAL_ALLOWED_TIFF_FILE_LENGTH = 26;
    private boolean caching = true;
    private long maxCachingMemory = DEFAULT_MAX_CACHING_MEMORY;
    private UnpackBits autoUnpackBits = UnpackBits.NONE;
    private UnusualPrecisions unusualPrecisions = UnusualPrecisions.UNPACK;
    private boolean autoScaleWhenIncreasingBitDepth = true;
    private boolean autoCorrectInvertedBrightness = false;
    private boolean enforceUseExternalCodec = false;
    private boolean cropTilesToImageBoundaries = true;
    private boolean cachingIFDs = true;
    private boolean missingTilesAllowed = false;
    private byte byteFiller = 0;
    private final Exception openingException;
    private final boolean tiff;
    private final boolean validTiff;
    private final boolean bigTiff;
    private volatile List<TiffIFD> allIFDs;
    private volatile List<TiffIFD> mainIFDs;
    private volatile TiffIFD firstIFD;
    private TiffCodec.Options codecOptions = new TiffCodec.Options();
    private volatile long positionOfLastIFDOffset = -1L;
    private final Map<TiffTileIndex, CachedTile> tileCacheMap = new HashMap<TiffTileIndex, CachedTile>();
    private final Queue<CachedTile> tileCache = new LinkedList<CachedTile>();
    private long currentCacheMemory = 0L;
    private final Object tileCacheLock = new Object();
    private volatile TiffReadMap lastMap = null;
    private long timeReading = 0L;
    private long timeCustomizingDecoding = 0L;
    private long timeDecoding = 0L;
    private long timeDecodingMain = 0L;
    private long timeDecodingBridge = 0L;
    private long timeDecodingAdditional = 0L;
    private long timeCompleteDecoding = 0L;

    public TiffReader(Path file) throws IOException {
        this(file, TiffOpenMode.VALID_TIFF);
    }

    public TiffReader(Path file, TiffOpenMode openMode) throws IOException {
        this(TiffReader.getFileHandle(file), openMode, true);
    }

    public TiffReader(DataHandle<?> inputStream, TiffOpenMode openMode) throws IOException {
        this(inputStream, openMode, false);
    }

    public TiffReader(DataHandle<?> inputStream, TiffOpenMode openMode, boolean closeStreamOnException) throws IOException {
        this(TiffReader.checkNonNull(inputStream, openMode), (Consumer<Exception>)null);
        boolean tiffButInvalid;
        assert (this.tiff || !this.validTiff);
        if (!openMode.isAnythingChecked()) {
            return;
        }
        boolean bl = tiffButInvalid = this.tiff && !this.validTiff;
        if (openMode.isRequireTiff() ? !this.validTiff : tiffButInvalid) {
            Exception exception;
            if (closeStreamOnException) {
                try {
                    this.stream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if ((exception = this.openingException) instanceof IOException) {
                IOException e = (IOException)exception;
                throw e;
            }
            exception = this.openingException;
            if (exception instanceof RuntimeException) {
                RuntimeException e = (RuntimeException)exception;
                throw e;
            }
            throw new TiffException(this.openingException);
        }
        if (openMode.isRequireTiff()) {
            this.checkFirstOffset();
        }
    }

    public TiffReader(DataHandle<?> inputStream, Consumer<Exception> exceptionHandler) {
        super((DataHandle<?>)(inputStream instanceof ReadBufferDataHandle ? inputStream : new ReadBufferDataHandle((DataHandle)inputStream)));
        AtomicBoolean tiff = new AtomicBoolean(false);
        AtomicBoolean bigTiff = new AtomicBoolean(false);
        this.openingException = this.startReading(tiff, bigTiff);
        this.tiff = tiff.get();
        this.bigTiff = bigTiff.get();
        boolean bl = this.validTiff = this.openingException == null;
        assert (!this.validTiff || this.tiff);
        if (exceptionHandler != null && this.openingException != null) {
            exceptionHandler.accept(this.openingException);
        }
    }

    public boolean isCaching() {
        return this.caching;
    }

    public TiffReader setCaching(boolean caching) {
        this.caching = caching;
        return this;
    }

    public long getMaxCachingMemory() {
        return this.maxCachingMemory;
    }

    public TiffReader setMaxCachingMemory(long maxCachingMemory) {
        if (maxCachingMemory < 0L) {
            throw new IllegalArgumentException("Negative maxCachingMemory = " + maxCachingMemory);
        }
        this.maxCachingMemory = maxCachingMemory;
        return this;
    }

    public UnpackBits getAutoUnpackBits() {
        return this.autoUnpackBits;
    }

    public TiffReader setAutoUnpackBits(UnpackBits autoUnpackBits) {
        this.autoUnpackBits = Objects.requireNonNull(autoUnpackBits, "Null autoUnpackBits");
        return this;
    }

    public UnusualPrecisions getUnusualPrecisions() {
        return this.unusualPrecisions;
    }

    public TiffReader setUnusualPrecisions(UnusualPrecisions unusualPrecisions) {
        this.unusualPrecisions = Objects.requireNonNull(unusualPrecisions, "Null unusualPrecisions");
        return this;
    }

    public boolean isAutoScaleWhenIncreasingBitDepth() {
        return this.autoScaleWhenIncreasingBitDepth;
    }

    public TiffReader setAutoScaleWhenIncreasingBitDepth(boolean autoScaleWhenIncreasingBitDepth) {
        this.autoScaleWhenIncreasingBitDepth = autoScaleWhenIncreasingBitDepth;
        return this;
    }

    public boolean isAutoCorrectInvertedBrightness() {
        return this.autoCorrectInvertedBrightness;
    }

    public TiffReader setAutoCorrectInvertedBrightness(boolean autoCorrectInvertedBrightness) {
        this.autoCorrectInvertedBrightness = autoCorrectInvertedBrightness;
        return this;
    }

    public boolean isEnforceUseExternalCodec() {
        return this.enforceUseExternalCodec;
    }

    public TiffReader setEnforceUseExternalCodec(boolean enforceUseExternalCodec) {
        this.enforceUseExternalCodec = enforceUseExternalCodec;
        return this;
    }

    public boolean isCropTilesToImageBoundaries() {
        return this.cropTilesToImageBoundaries;
    }

    public TiffReader setCropTilesToImageBoundaries(boolean cropTilesToImageBoundaries) {
        this.cropTilesToImageBoundaries = cropTilesToImageBoundaries;
        return this;
    }

    public TiffCodec.Options getCodecOptions() {
        return this.codecOptions.clone();
    }

    public TiffReader setCodecOptions(TiffCodec.Options codecOptions) {
        this.codecOptions = Objects.requireNonNull(codecOptions, "Null codecOptions").clone();
        return this;
    }

    public boolean isCachingIFDs() {
        return this.cachingIFDs;
    }

    public TiffReader setCachingIFDs(boolean cachingIFDs) {
        this.cachingIFDs = cachingIFDs;
        return this;
    }

    public boolean isMissingTilesAllowed() {
        return this.missingTilesAllowed;
    }

    public TiffReader setMissingTilesAllowed(boolean missingTilesAllowed) {
        this.missingTilesAllowed = missingTilesAllowed;
        return this;
    }

    public byte getByteFiller() {
        return this.byteFiller;
    }

    public TiffReader setByteFiller(byte byteFiller) {
        this.byteFiller = byteFiller;
        return this;
    }

    public Exception openingException() {
        return this.openingException;
    }

    public boolean isTiff() {
        return this.tiff;
    }

    public boolean isBigTiff() {
        return this.bigTiff;
    }

    public boolean isValidTiff() {
        return this.validTiff;
    }

    public boolean isLittleEndian() {
        return this.stream.isLittleEndian();
    }

    public ByteOrder getByteOrder() {
        return this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public long positionOfFirstIFDOffset() {
        return this.bigTiff ? 8L : 4L;
    }

    public long positionOfLastIFDOffset() {
        return this.positionOfLastIFDOffset;
    }

    public int numberOfImages() {
        try {
            return this.allIFDs().size();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public int numberOfMainIFDs() {
        try {
            return this.mainIFDs().size();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public TiffIFD ifd(int ifdIndex) throws IOException {
        List<TiffIFD> allIFDs = this.allIFDs();
        if (ifdIndex < 0) {
            throw new IllegalArgumentException("Negative IFD index " + ifdIndex);
        }
        if (ifdIndex >= allIFDs.size()) {
            throw new TiffException("Too large IFD index " + ifdIndex + " >= " + allIFDs.size());
        }
        return allIFDs.get(ifdIndex);
    }

    public int dimX(int ifdIndex) throws IOException {
        return this.ifd(ifdIndex).getImageDimX();
    }

    public int dimY(int ifdIndex) throws IOException {
        return this.ifd(ifdIndex).getImageDimY();
    }

    public int numberOfChannels(int ifdIndex) throws IOException {
        return this.ifd(ifdIndex).getSamplesPerPixel();
    }

    public TiffReadMap map(int ifdIndex) throws IOException {
        return this.map(this.ifd(ifdIndex));
    }

    public List<TiffReadMap> allMaps() throws IOException {
        ArrayList<TiffReadMap> result = new ArrayList<TiffReadMap>();
        for (TiffIFD tiffIFD : this.allIFDs()) {
            result.add(this.map(tiffIFD));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TiffIFD> allIFDs() throws IOException {
        List<TiffIFD> allIFDs;
        long t1 = TiffReader.debugTime();
        Object object = this.fileLock;
        synchronized (object) {
            allIFDs = this.allIFDs;
            if (this.cachingIFDs && allIFDs != null) {
                return allIFDs;
            }
            long[] offsets = this.readIFDOffsets();
            allIFDs = new ArrayList<TiffIFD>();
            ArrayList<TiffIFD> mainIFDs = new ArrayList<TiffIFD>();
            for (long offset : offsets) {
                TiffIFD ifd = this.readIFDAt(offset);
                assert (ifd != null);
                ifd.setGlobalIndex(allIFDs.size());
                allIFDs.add(ifd);
                mainIFDs.add(ifd);
                long[] subOffsets = null;
                try {
                    subOffsets = ifd.getLongArray(330);
                }
                catch (TiffException tiffException) {
                    // empty catch block
                }
                if (subOffsets == null) continue;
                for (long subOffset : subOffsets) {
                    TiffIFD subIFD = this.readIFDAt(subOffset, 330, false);
                    assert (subIFD != null);
                    subIFD.setGlobalIndex(allIFDs.size());
                    allIFDs.add(subIFD);
                }
            }
            this.allIFDs = Collections.unmodifiableList(allIFDs);
            this.mainIFDs = Collections.unmodifiableList(mainIFDs);
        }
        if (BUILT_IN_TIMING && LOGGABLE_DEBUG) {
            long t2 = TiffReader.debugTime();
            LOG.log(System.Logger.Level.DEBUG, String.format(Locale.US, "%s read %d IFDs: %.3f ms", this.getClass().getSimpleName(), allIFDs.size(), (double)(t2 - t1) * 1.0E-6));
        }
        return allIFDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TiffIFD> mainIFDs() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            this.allIFDs();
            return Collections.unmodifiableList(this.mainIFDs);
        }
    }

    public TiffIFD firstIFD() throws IOException {
        TiffIFD firstIFD = this.firstIFD;
        if (this.cachingIFDs && firstIFD != null) {
            return this.firstIFD;
        }
        long offset = this.readFirstIFDOffset();
        firstIFD = this.readIFDAt(offset);
        firstIFD.setGlobalIndex(0);
        if (this.cachingIFDs) {
            this.firstIFD = firstIFD;
        }
        return firstIFD;
    }

    public List<TiffIFD> exifIFDs() throws IOException {
        List<TiffIFD> ifds = this.allIFDs();
        ArrayList<TiffIFD> result = new ArrayList<TiffIFD>();
        for (TiffIFD ifd : ifds) {
            TiffIFD exifIFD;
            long offset = ifd.getLong(34665, 0);
            if (offset == 0L || (exifIFD = this.readIFDAt(offset, 34665, false)) == null) continue;
            result.add(exifIFD);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readFirstIFDOffset() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            this.stream.seek(this.positionOfFirstIFDOffset());
            return this.readFirstOffsetFromCurrentPosition(true, this.bigTiff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readSingleIFDOffset(int ifdIndex) throws IOException {
        if (ifdIndex < 0) {
            throw new IllegalArgumentException("Negative IFD index = " + ifdIndex);
        }
        Object object = this.fileLock;
        synchronized (object) {
            long fileLength = this.stream.length();
            long offset = this.readFirstIFDOffset();
            while (offset > 0L && offset < fileLength) {
                if (ifdIndex-- <= 0) {
                    return offset;
                }
                this.stream.seek(offset);
                this.skipIFDEntries(fileLength);
                long newOffset = this.readNextOffset(true);
                if (newOffset == offset) {
                    throw new TiffException("TIFF file is broken - infinite loop of IFD offsets is detected for offset " + offset);
                }
                offset = newOffset;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] readIFDOffsets() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            if (!this.validTiff) {
                return new long[0];
            }
            long fileLength = this.stream.length();
            LinkedHashSet<Long> ifdOffsets = new LinkedHashSet<Long>();
            long offset = this.readFirstIFDOffset();
            while (offset > 0L && offset < fileLength) {
                this.stream.seek(offset);
                boolean wasNotPresent = ifdOffsets.add(offset);
                if (!wasNotPresent) {
                    throw new TiffException("TIFF file is broken - infinite loop of IFD offsets is detected for offset " + offset + " (the stored ifdOffsets sequence is " + ifdOffsets.stream().map(Object::toString).collect(Collectors.joining(", ")) + ", " + offset + ", ...)");
                }
                this.skipIFDEntries(fileLength);
                offset = this.readNextOffset(true);
            }
            return ifdOffsets.stream().mapToLong(v -> v).toArray();
        }
    }

    public TiffIFD readSingleIFD(int ifdIndex) throws IOException {
        long startOffset = this.readSingleIFDOffset(ifdIndex);
        if (startOffset < 0L) {
            throw new TiffException("No IFD #" + ifdIndex + " in TIFF" + this.prettyInName() + ": too large index");
        }
        return this.readIFDAt(startOffset);
    }

    public TiffIFD readIFDAt(long startOffset) throws IOException {
        return this.readIFDAt(startOffset, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiffIFD readIFDAt(long startOffset, Integer subIFDType, boolean readNextOffset) throws IOException {
        TiffIFD ifd;
        if (startOffset < 0L) {
            throw new IllegalArgumentException("Negative file offset = " + startOffset);
        }
        if (startOffset < (long)this.sizeOfHeader()) {
            throw new IllegalArgumentException("Attempt to read IFD from too small start offset " + startOffset);
        }
        long t1 = TiffReader.debugTime();
        long timeEntries = 0L;
        long timeArrays = 0L;
        Object object = this.fileLock;
        synchronized (object) {
            if (startOffset >= this.stream.length()) {
                throw new TiffException("TIFF IFD offset " + startOffset + " is outside the file");
            }
            LinkedHashMap<Integer, Object> map = new LinkedHashMap<Integer, Object>();
            LinkedHashMap<Integer, TiffIFD.TiffEntry> detailedEntries = new LinkedHashMap<Integer, TiffIFD.TiffEntry>();
            this.stream.seek(startOffset);
            long numberOfEntries = this.bigTiff ? this.stream.readLong() : (long)this.stream.readUnsignedShort();
            TiffIFD.checkNumberOfEntries(numberOfEntries, this.bigTiff);
            int bytesPerEntry = TiffIFD.TiffEntry.bytesPerEntry(this.bigTiff);
            int baseOffset = this.bigTiff ? 8 : 2;
            for (long i = 0L; i < numberOfEntries; ++i) {
                long tEntry1 = TiffReader.debugTime();
                TiffIFD.TiffEntry entry = this.readIFDEntry(startOffset + (long)baseOffset + (long)bytesPerEntry * i);
                int tag = entry.tag();
                long tEntry2 = TiffReader.debugTime();
                timeEntries += tEntry2 - tEntry1;
                Object value = TiffReader.readIFDValueAtEntryOffset(this.stream, entry);
                long tEntry3 = TiffReader.debugTime();
                timeArrays += tEntry3 - tEntry2;
                if (value == null || map.containsKey(tag)) continue;
                map.put(tag, value);
                detailedEntries.put(tag, entry);
            }
            long positionOfNextOffset = startOffset + (long)baseOffset + (long)bytesPerEntry * numberOfEntries;
            this.stream.seek(positionOfNextOffset);
            ifd = new TiffIFD(map, detailedEntries);
            ifd.setLoadedFromFile(true);
            ifd.setLittleEndian(this.stream.isLittleEndian());
            ifd.setBigTiff(this.bigTiff);
            ifd.setFileOffsetForReading(startOffset);
            ifd.setSubIFDType(subIFDType);
            if (readNextOffset) {
                long nextOffset = this.readNextOffset(false);
                ifd.setNextIFDOffset(nextOffset);
                this.stream.seek(positionOfNextOffset);
            }
        }
        if (BUILT_IN_TIMING && LOGGABLE_DEBUG) {
            long t2 = TiffReader.debugTime();
            LOG.log(System.Logger.Level.TRACE, String.format(Locale.US, "%s read IFD at offset %d: %.3f ms, including %.6f entries + %.6f arrays", this.getClass().getSimpleName(), startOffset, (double)(t2 - t1) * 1.0E-6, (double)timeEntries * 1.0E-6, (double)timeArrays * 1.0E-6));
        }
        return ifd;
    }

    public TiffTile readCachedTile(TiffTileIndex tileIndex) throws IOException {
        if (!this.caching || this.maxCachingMemory == 0L) {
            return this.readTile(tileIndex);
        }
        return this.getCachedTile(tileIndex).readIfNecessary();
    }

    public TiffTile readTile(TiffTileIndex tileIndex) throws IOException {
        TiffTile tile = this.readEncodedTile(tileIndex);
        if (tile.isEmpty()) {
            return tile;
        }
        this.decode(tile);
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiffTile readEncodedTile(TiffTileIndex tileIndex) throws IOException {
        int byteCount;
        long offset;
        boolean alreadyStored;
        Objects.requireNonNull(tileIndex, "Null tileIndex");
        long t1 = TiffReader.debugTime();
        TiffIFD ifd = tileIndex.ifd();
        int index = tileIndex.linearIndex();
        TiffTile existingTile = tileIndex.existingTile();
        boolean bl = alreadyStored = existingTile != null && existingTile.isStoredInFile();
        if (alreadyStored) {
            offset = existingTile.getStoredInFileDataOffset();
            byteCount = existingTile.getStoredInFileDataLength();
            assert (offset >= 0L && byteCount >= 0);
        } else {
            offset = ifd.cachedTileOrStripOffset(index);
            assert (offset >= 0L) : "offset " + offset + " was not checked in TiffIFD";
            byteCount = TiffReader.cachedByteCountWithCompatibilityTrick(ifd, index);
            byteCount = this.correctZeroByteCount(tileIndex, byteCount, offset);
        }
        TiffTile result = new TiffTile(tileIndex);
        if (this.cropTilesToImageBoundaries) {
            result.cropStripToMap();
        }
        if (byteCount == -1) {
            return result;
        }
        Object object = this.fileLock;
        synchronized (object) {
            if (offset >= this.stream.length()) {
                throw new TiffException("Offset of TIFF tile/strip " + offset + " is out of file length (tile " + String.valueOf(tileIndex) + ")");
            }
            TiffTileIO.readAt(result, this.stream, offset, byteCount);
            if (alreadyStored) {
                result.expandStoredInFileDataCapacity(existingTile.getStoredInFileDataCapacity());
            }
        }
        long t2 = TiffReader.debugTime();
        this.timeReading += t2 - t1;
        return result;
    }

    public boolean decode(TiffTile tile) throws TiffException {
        Objects.requireNonNull(tile, "Null tile");
        if (!tile.isEncoded()) {
            return false;
        }
        long t1 = TiffReader.debugTime();
        this.prepareDecoding(tile);
        byte[] encodedData = tile.getEncodedData();
        TagCompression compression = tile.compression().orElse(null);
        TiffCodec codec = null;
        if (!this.enforceUseExternalCodec && compression != null) {
            codec = compression.codec();
        }
        TiffCodec.Options options = this.buildOptions(tile);
        long t2 = TiffReader.debugTime();
        if (codec != null) {
            options = compression.customizeReading(tile, options);
            if (codec instanceof TiffCodec.Timing) {
                TiffCodec.Timing timing = (TiffCodec.Timing)((Object)codec);
                timing.setTiming(BUILT_IN_TIMING && LOGGABLE_DEBUG);
                timing.clearTiming();
            }
            decodedData = (Optional<byte[]>)codec.decompress(encodedData, options);
            tile.setPartiallyDecodedData((byte[])decodedData);
        } else {
            decodedData = this.decodeByExternalCodec(tile, encodedData, options);
            if (decodedData.isEmpty()) {
                throw new UnsupportedTiffFormatException("TIFF compression with code " + tile.compressionCode() + (String)(tile.compression().isPresent() ? " (" + tile.compression().get().prettyName() + ")" : "") + " cannot be decoded");
            }
            tile.setPartiallyDecodedData(decodedData.get());
        }
        tile.setInterleaved(options.isInterleaved());
        long t3 = TiffReader.debugTime();
        this.completeDecoding(tile);
        long t4 = TiffReader.debugTime();
        this.timeCustomizingDecoding += t2 - t1;
        this.timeDecoding += t3 - t2;
        if (codec instanceof TiffCodec.Timing) {
            TiffCodec.Timing timing = (TiffCodec.Timing)((Object)codec);
            this.timeDecodingMain += timing.timeMain();
            this.timeDecodingBridge += timing.timeBridge();
            this.timeDecodingAdditional += timing.timeAdditional();
        } else {
            this.timeDecodingMain += t3 - t2;
        }
        this.timeCompleteDecoding += t4 - t3;
        return true;
    }

    public void prepareDecoding(TiffTile tile) throws TiffException {
        Objects.requireNonNull(tile, "Null tile");
        if (tile.isEmpty()) {
            return;
        }
        if (tile.ifd().isReversedFillOrder()) {
            PackedBitArraysPer8.reverseBitOrderInPlace((byte[])tile.getEncodedData());
        }
        boolean throwExceptionForStrangeDataStream = this.context != null;
        TiffJPEGDecodingHelper.embedJPEGTableInDataIfRequested(tile, throwExceptionForStrangeDataStream);
    }

    public void completeDecoding(TiffTile tile) throws TiffException {
        Objects.requireNonNull(tile, "Null tile");
        tile.checkDecodedData();
        TiffPrediction.unsubtractPredictionIfRequested(tile);
        if (!TiffUnpacking.separateUnpackedSamples(tile) && !TiffUnpacking.separateYCbCrToRGB(tile)) {
            TiffUnpacking.unpackTiffBitsAndInvertValues(tile, this.autoScaleWhenIncreasingBitDepth, this.autoCorrectInvertedBrightness);
        }
        tile.checkDataLengthAlignment();
    }

    public TiffReadMap map(TiffIFD ifd) throws TiffException {
        return this.map(ifd, true);
    }

    public TiffReadMap map(TiffIFD ifd, boolean builtTileGrid) throws TiffException {
        Objects.requireNonNull(ifd, "Null IFD");
        TiffReadMap map = new TiffReadMap(this, ifd);
        this.unusualPrecisions.throwIfDisabled(map);
        if (builtTileGrid) {
            map.buildTileGrid();
        }
        this.lastMap = map;
        return map;
    }

    public TiffReadMap lastMap() {
        return this.lastMap;
    }

    public Object readSampleBytes(int ifdIndex) throws IOException {
        return this.readJavaArray(this.map(ifdIndex));
    }

    public byte[] readSampleBytes(TiffIOMap map) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        return this.readSampleBytes(map, 0, 0, map.dimX(), map.dimY());
    }

    public byte[] readSampleBytes(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.readSampleBytes(map, fromX, fromY, sizeX, sizeY, this.unusualPrecisions, false, this::readCachedTile);
    }

    public byte[] readSampleBytes(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY, UnusualPrecisions unusualPrecisions, boolean storeTilesInMap, TiffIOMap.TileSupplier tileSupplier) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        Objects.requireNonNull(unusualPrecisions, "Null unusualPrecisions");
        Objects.requireNonNull(tileSupplier, "Null tileSupplier");
        long t1 = TiffReader.debugTime();
        this.clearTiming();
        TiffMap.checkRequestedArea(fromX, fromY, sizeX, sizeY);
        byte[] samples = map.loadSampleBytes(fromX, fromY, sizeX, sizeY, unusualPrecisions, storeTilesInMap, tileSupplier);
        int sizeInBytes = samples.length;
        long sizeInPixels = (long)sizeX * (long)sizeY;
        long t2 = TiffReader.debugTime();
        boolean unpackingBits = false;
        if (this.autoUnpackBits.isEnabled() && map.isBinary()) {
            unpackingBits = true;
            samples = PackedBitArraysPer8.unpackBitsToBytes((byte[])samples, (long)0L, (long)sizeInPixels, (byte)0, (byte)this.autoUnpackBits.bit1Value());
        }
        if (BUILT_IN_TIMING && LOGGABLE_DEBUG) {
            long t3 = TiffReader.debugTime();
            long timeNonClassified = t2 - t1 - (this.timeReading + this.timeDecoding);
            LOG.log(System.Logger.Level.DEBUG, String.format(Locale.US, "%s read %dx%dx%d samples (%.3f MB) in %.3f ms = %.3f read/decode (%.3f read; %.3f customize/bit-order, %.3f decode%s, %.3f complete; %.3f tiles->array and other)%s, %.3f MB/s", this.getClass().getSimpleName(), sizeX, sizeY, map.numberOfChannels(), (double)sizeInBytes / 1048576.0, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)this.timeReading * 1.0E-6, (double)this.timeCustomizingDecoding * 1.0E-6, (double)this.timeDecoding * 1.0E-6, this.timeDecoding != this.timeDecodingMain || this.timeDecodingBridge + this.timeDecodingAdditional > 0L ? String.format(Locale.US, " [= %.3f main%s]", (double)this.timeDecodingMain * 1.0E-6, this.timeDecodingBridge + this.timeDecodingAdditional > 0L ? String.format(Locale.US, " + %.3f decode-bridge + %.3f decode-additional", (double)this.timeDecodingBridge * 1.0E-6, (double)this.timeDecodingAdditional * 1.0E-6) : "") : "", (double)this.timeCompleteDecoding * 1.0E-6, (double)timeNonClassified * 1.0E-6, unpackingBits ? String.format(Locale.US, " + %.3f unpacking %d-bit", (double)(t3 - t2) * 1.0E-6, map.alignedBitsPerSample()) : "", (double)sizeInBytes / 1048576.0 / ((double)(t3 - t1) * 1.0E-9)));
        }
        return samples;
    }

    public Object readJavaArray(int ifdIndex) throws IOException {
        return this.readJavaArray(this.map(ifdIndex));
    }

    public Object readJavaArray(TiffIOMap map) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        return this.readJavaArray(map, 0, 0, map.dimX(), map.dimY());
    }

    public Object readJavaArray(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.readJavaArray(map, fromX, fromY, sizeX, sizeY, false, this::readCachedTile);
    }

    public Object readJavaArray(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY, boolean storeTilesInMap, TiffIOMap.TileSupplier tileSupplier) throws IOException {
        Object samplesArray;
        Objects.requireNonNull(map, "Null TIFF map");
        Objects.requireNonNull(tileSupplier, "Null tileSupplier");
        byte[] samples = this.readSampleBytes(map, fromX, fromY, sizeX, sizeY, this.unusualPrecisions.unpackIfEnabled(), storeTilesInMap, tileSupplier);
        long t1 = TiffReader.debugTime();
        TiffSampleType sampleType = map.sampleType();
        Object object = samplesArray = this.autoUnpackBits.isEnabled() && map.isBinary() ? samples : (Object)sampleType.javaArray(samples, this.getByteOrder());
        if (BUILT_IN_TIMING && LOGGABLE_DEBUG) {
            long t2 = TiffReader.debugTime();
            LOG.log(System.Logger.Level.DEBUG, String.format(Locale.US, "%s converted %d bytes (%.3f MB) to %s[] in %.3f ms%s", this.getClass().getSimpleName(), samples.length, (double)samples.length / 1048576.0, samplesArray.getClass().getComponentType().getSimpleName(), (double)(t2 - t1) * 1.0E-6, samples == samplesArray ? "" : String.format(Locale.US, " %.3f MB/s", (double)samples.length / 1048576.0 / ((double)(t2 - t1) * 1.0E-9))));
        }
        return samplesArray;
    }

    public Matrix<UpdatablePArray> readMatrix(int ifdIndex) throws IOException {
        return this.readMatrix(this.map(ifdIndex));
    }

    public Matrix<UpdatablePArray> readMatrix(TiffIOMap map) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        return this.readMatrix(map, 0, 0, map.dimX(), map.dimY());
    }

    public Matrix<UpdatablePArray> readMatrix(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.readMatrix(map, fromX, fromY, sizeX, sizeY, false, this::readCachedTile);
    }

    public Matrix<UpdatablePArray> readMatrix(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY, boolean storeTilesInMap, TiffIOMap.TileSupplier tileSupplier) throws IOException {
        Object samplesArray = this.readJavaArray(map, fromX, fromY, sizeX, sizeY, storeTilesInMap, tileSupplier);
        return TiffSampleType.asMatrix(samplesArray, sizeX, sizeY, map.numberOfChannels(), false);
    }

    public Matrix<UpdatablePArray> readInterleavedMatrix(int ifdIndex) throws IOException {
        return this.readInterleavedMatrix(this.map(ifdIndex));
    }

    public Matrix<UpdatablePArray> readInterleavedMatrix(TiffIOMap map) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        return this.readInterleavedMatrix(map, 0, 0, map.dimX(), map.dimY());
    }

    public Matrix<UpdatablePArray> readInterleavedMatrix(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.readInterleavedMatrix(map, fromX, fromY, sizeX, sizeY, false, this::readCachedTile);
    }

    public Matrix<UpdatablePArray> readInterleavedMatrix(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY, boolean storeTilesInMap, TiffIOMap.TileSupplier tileSupplier) throws IOException {
        Matrix<UpdatablePArray> mergedChannels = this.readMatrix(map, fromX, fromY, sizeX, sizeY, storeTilesInMap, tileSupplier);
        return Matrices.interleave((List)mergedChannels.asLayers());
    }

    public List<Matrix<UpdatablePArray>> readChannels(int ifdIndex) throws IOException {
        return this.readChannels(this.map(ifdIndex));
    }

    public List<Matrix<UpdatablePArray>> readChannels(TiffIOMap map) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        return this.readChannels(map, 0, 0, map.dimX(), map.dimY());
    }

    public List<Matrix<UpdatablePArray>> readChannels(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.readChannels(map, fromX, fromY, sizeX, sizeY, false, this::readCachedTile);
    }

    public List<Matrix<UpdatablePArray>> readChannels(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY, boolean storeTilesInMap, TiffIOMap.TileSupplier tileSupplier) throws IOException {
        Matrix<UpdatablePArray> mergedChannels = this.readMatrix(map, fromX, fromY, sizeX, sizeY, storeTilesInMap, tileSupplier);
        return Matrices.asLayers(mergedChannels, (int)128);
    }

    public BufferedImage readBufferedImage(int ifdIndex) throws IOException {
        return this.readBufferedImage(this.map(ifdIndex));
    }

    public BufferedImage readBufferedImage(TiffIOMap map) throws IOException {
        Objects.requireNonNull(map, "Null TIFF map");
        return this.readBufferedImage(map, 0, 0, map.dimX(), map.dimY());
    }

    public BufferedImage readBufferedImage(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY) throws IOException {
        return this.readBufferedImage(map, fromX, fromY, sizeX, sizeY, false, this::readCachedTile);
    }

    public BufferedImage readBufferedImage(TiffIOMap map, int fromX, int fromY, int sizeX, int sizeY, boolean storeTilesInMap, TiffIOMap.TileSupplier tileSupplier) throws IOException {
        Matrix<UpdatablePArray> interleaved = this.readInterleavedMatrix(map, fromX, fromY, sizeX, sizeY, storeTilesInMap, tileSupplier);
        return new MatrixToImage.InterleavedRGBToInterleaved().setUnsignedInt32(true).toBufferedImage(interleaved);
    }

    public final byte[] decompressBySCIFIOCodec(TiffIFD ifd, byte[] encodedData, Object scifioCodecOptions) throws TiffException {
        Object compression;
        Object scifio = this.requireScifio(ifd);
        int compressionCode = ifd.getCompressionCode();
        try {
            compression = SCIFIOBridge.createTiffCompression(compressionCode);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedTiffFormatException("TIFF compression code " + compressionCode + " is unknown and is not correctly recognized by the external SCIFIO subsystem", e);
        }
        try {
            return SCIFIOBridge.callDecompress(scifio, compression, encodedData, scifioCodecOptions);
        }
        catch (InvocationTargetException e) {
            throw new TiffException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void close() throws IOException {
        this.lastMap = null;
        super.close();
    }

    public int sizeOfHeader() {
        return TiffIFD.sizeOfFileHeader(this.bigTiff);
    }

    public String toString() {
        return "TIFF reader";
    }

    protected Optional<byte[]> decodeByExternalCodec(TiffTile tile, byte[] encodedData, TiffCodec.Options options) throws TiffException {
        Objects.requireNonNull(tile, "Null tile");
        Objects.requireNonNull(encodedData, "Null encoded data");
        Objects.requireNonNull(options, "Null options");
        if (!SCIFIOBridge.isScifioInstalled()) {
            return Optional.empty();
        }
        Object scifioCodecOptions = options.toSCIFIOStyleOptions(SCIFIOBridge.codecOptionsClass());
        byte[] decodedData = this.decompressBySCIFIOCodec(tile.ifd(), encodedData, scifioCodecOptions);
        return Optional.of(decodedData);
    }

    private void clearTiming() {
        this.timeReading = 0L;
        this.timeCustomizingDecoding = 0L;
        this.timeDecoding = 0L;
        this.timeDecodingMain = 0L;
        this.timeDecodingBridge = 0L;
        this.timeDecodingAdditional = 0L;
        this.timeCompleteDecoding = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception startReading(AtomicBoolean tiffReference, AtomicBoolean bigTiffReference) {
        tiffReference.set(false);
        bigTiffReference.set(false);
        try {
            Object object = this.fileLock;
            synchronized (object) {
                if (!this.stream.exists()) {
                    return new FileNotFoundException("File not found:" + this.prettyInName());
                }
                this.testHeader(tiffReference, bigTiffReference);
                assert (tiffReference.get());
                return null;
            }
        }
        catch (IOException e) {
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHeader(AtomicBoolean tiffReference, AtomicBoolean bigTiffReference) throws IOException {
        long savedOffset = this.stream.offset();
        try {
            boolean bigTiff;
            boolean bigEndian;
            this.stream.seek(0L);
            long length = this.stream.length();
            if (length < 8L) {
                throw new TiffException("The file" + this.prettyInName() + " is not TIFF (only " + length + " bytes, but a valid TIFF cannot be shorter than 8 bytes)");
            }
            int endianOne = this.stream.readByte() & 0xFF;
            int endianTwo = this.stream.readByte() & 0xFF;
            boolean littleEndian = endianOne == 73 && endianTwo == 73;
            boolean bl = bigEndian = endianOne == 77 && endianTwo == 77;
            if (!littleEndian && !bigEndian) {
                throw new TiffException("The file" + this.prettyInName() + " is not TIFF");
            }
            this.stream.setLittleEndian(littleEndian);
            short magic = this.stream.readShort();
            boolean bl2 = bigTiff = magic == 43;
            if (magic != 42 && magic != 43) {
                throw new TiffException("The file" + this.prettyInName() + " is not TIFF");
            }
            tiffReference.set(true);
            bigTiffReference.set(bigTiff);
            if (length < 26L) {
                throw new TiffException("Too short TIFF file" + this.prettyInName() + ": only " + length + " bytes (a valid TIFF must contain at least 26 bytes); probably the TIFF writing process was not completed normally");
            }
        }
        finally {
            this.stream.seek(savedOffset);
        }
    }

    private TiffCodec.Options buildOptions(TiffTile tile) throws TiffException {
        TiffCodec.Options options = this.codecOptions.clone();
        options.setSizes(tile.getSizeX(), tile.getSizeY());
        options.setBitsPerSample(tile.bitsPerSample());
        options.setNumberOfChannels(tile.samplesPerPixel());
        options.setSigned(tile.sampleType().isSigned());
        options.setFloatingPoint(tile.sampleType().isFloatingPoint());
        options.setCompressionCode(tile.compressionCode());
        options.setByteOrder(tile.byteOrder());
        options.setMaxSizeInBytes(tile.getSizeInBytesInsideTIFF());
        options.setInterleaved(true);
        options.setIfd(tile.ifd());
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedTile getCachedTile(TiffTileIndex tileIndex) {
        Object object = this.tileCacheLock;
        synchronized (object) {
            CachedTile tile = this.tileCacheMap.get(tileIndex);
            if (tile == null) {
                tile = new CachedTile(tileIndex);
                this.tileCacheMap.put(tileIndex, tile);
            }
            return tile;
        }
    }

    private static int cachedByteCountWithCompatibilityTrick(TiffIFD ifd, int index) throws TiffException {
        long result;
        long[] byteCounts;
        boolean tiled = ifd.hasTileInformation();
        int tag = tiled ? 325 : 279;
        Object value = ifd.get(tag);
        if (value instanceof long[] && (byteCounts = (long[])value).length == 1 && (result = byteCounts[0]) >= 0L && result < Integer.MAX_VALUE) {
            return (int)result;
        }
        return ifd.cachedTileOrStripByteCount(index);
    }

    private int correctZeroByteCount(TiffTileIndex tileIndex, int byteCount, long offset) throws IOException {
        if (byteCount == 0 || offset == 0L) {
            long left;
            if (this.missingTilesAllowed) {
                return -1;
            }
            TiffIFD ifd = tileIndex.ifd();
            if (offset > 0L && ifd.cachedTileOrStripByteCountLength() == 1 && ifd.isLastIFD() && (left = this.stream.length() - offset) <= Math.min(Integer.MAX_VALUE, 2L * (long)tileIndex.map().tileSizeInBytes() + 1000L)) {
                byteCount = (int)left;
            }
        }
        if (byteCount == 0 || offset == 0L) {
            throw new TiffException("Zero tile/strip " + (byteCount == 0 ? "byte-count" : "offset") + " is not allowed in a valid TIFF file (tile " + String.valueOf(tileIndex) + ")");
        }
        return byteCount;
    }

    private String prettyInName() {
        return TiffReader.prettyFileName(" %s", this.stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFirstOffset() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            long savedOffset = this.stream.offset();
            try {
                this.stream.seek(this.positionOfFirstIFDOffset());
                this.readFirstOffsetFromCurrentPosition(false, this.bigTiff);
            }
            finally {
                this.stream.seek(savedOffset);
            }
        }
    }

    private long readFirstOffsetFromCurrentPosition(boolean updatePositionOfLastOffset, boolean bigTiff) throws IOException {
        long offset = this.readNextOffset(updatePositionOfLastOffset, bigTiff);
        if (offset == 0L) {
            throw new TiffException("Uncompleted TIFF" + this.prettyInName() + ": the file does not contain any images; probably the TIFF writing process was not completed normally");
        }
        return offset;
    }

    private void skipIFDEntries(long fileLength) throws IOException {
        long numberOfEntries;
        long offset = this.stream.offset();
        int bytesPerEntry = TiffIFD.TiffEntry.bytesPerEntry(this.bigTiff);
        long l = numberOfEntries = this.bigTiff ? this.stream.readLong() : (long)this.stream.readUnsignedShort();
        if (numberOfEntries < 0L || numberOfEntries > (long)(Integer.MAX_VALUE / bytesPerEntry)) {
            throw new TiffException("Too large number of IFD entries in Big TIFF: " + (String)(numberOfEntries < 0L ? ">= 2^63" : "" + numberOfEntries) + " (it is not supported, probably file is broken)");
        }
        long skippedIFDBytes = numberOfEntries * (long)bytesPerEntry;
        if (offset + skippedIFDBytes >= fileLength) {
            throw new TiffException("Invalid TIFF" + this.prettyInName() + ": position of next IFD offset " + (offset + skippedIFDBytes) + " after " + numberOfEntries + " entries is outside the file (probably file is broken)");
        }
        this.stream.skipBytes((int)skippedIFDBytes);
    }

    private long readNextOffset(boolean updatePositionOfLastOffset) throws IOException {
        return this.readNextOffset(updatePositionOfLastOffset, this.bigTiff);
    }

    private long readNextOffset(boolean updatePositionOfLastOffset, boolean bigTiff) throws IOException {
        long fileLength = this.stream.length();
        long fileOffset = this.stream.offset();
        long offset = bigTiff ? this.stream.readLong() : (long)this.stream.readInt() & 0xFFFFFFFFL;
        if (offset < 0L) {
            throw new TiffException("Invalid TIFF" + this.prettyInName() + ": negative 64-bit offset " + offset + " at file position " + fileOffset + ", probably the file is corrupted");
        }
        if (offset >= fileLength) {
            throw new TiffException("Invalid TIFF" + this.prettyInName() + ": offset " + offset + " at file position " + fileOffset + " is outside the file, probably the is corrupted");
        }
        if (updatePositionOfLastOffset) {
            this.positionOfLastIFDOffset = fileOffset;
        }
        return offset;
    }

    private static Object readIFDValueAtEntryOffset(DataHandle<?> in, TiffIFD.TiffEntry entry) throws IOException {
        int type = entry.type();
        int count = entry.valueCount();
        long offset = entry.valueOffset();
        ByteOrder byteOrder = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        LOG.log(System.Logger.Level.TRACE, () -> "Reading entry " + entry.tag() + " from " + offset + "; type=" + type + ", count=" + count);
        in.seek(offset);
        switch (type) {
            case 1: {
                if (count == 1) {
                    return (short)in.readByte();
                }
                byte[] bytes = new byte[count];
                in.readFully(bytes);
                short[] shorts = new short[count];
                for (int j = 0; j < count; ++j) {
                    shorts[j] = (short)(bytes[j] & 0xFF);
                }
                return shorts;
            }
            case 2: {
                byte[] ascii = new byte[count];
                in.read(ascii);
                String[] lines = TiffIFD.asciiToText(ascii);
                return lines.length != 1 ? lines : (lines[0] == null ? "" : lines[0]);
            }
            case 3: {
                if (count == 1) {
                    return in.readUnsignedShort();
                }
                byte[] bytes = TiffReader.readIFDBytes(in, 2L * (long)count);
                short[] shorts = JArrays.bytesToShortArray((byte[])bytes, (ByteOrder)byteOrder);
                int[] result = new int[count];
                for (int j = 0; j < count; ++j) {
                    result[j] = shorts[j] & 0xFFFF;
                }
                return result;
            }
            case 4: 
            case 13: {
                if (count == 1) {
                    return (long)in.readInt() & 0xFFFFFFFFL;
                }
                byte[] bytes = TiffReader.readIFDBytes(in, 4L * (long)count);
                int[] ints = JArrays.bytesToIntArray((byte[])bytes, (ByteOrder)byteOrder);
                return Arrays.stream(ints).mapToLong(anInt -> (long)anInt & 0xFFFFFFFFL).toArray();
            }
            case 16: 
            case 17: 
            case 18: {
                if (count == 1) {
                    return in.readLong();
                }
                byte[] bytes = TiffReader.readIFDBytes(in, 8L * (long)count);
                return JArrays.bytesToLongArray((byte[])bytes, (ByteOrder)byteOrder);
            }
            case 5: 
            case 10: {
                if (count == 1) {
                    return new TagRational(in.readInt(), in.readInt());
                }
                TagRational[] rationals = new TagRational[count];
                for (int j = 0; j < count; ++j) {
                    rationals[j] = new TagRational(in.readInt(), in.readInt());
                }
                return rationals;
            }
            case 6: 
            case 7: {
                if (count == 1) {
                    return in.readByte();
                }
                byte[] sbytes = new byte[count];
                in.read(sbytes);
                return sbytes;
            }
            case 8: {
                if (count == 1) {
                    return in.readShort();
                }
                short[] sshorts = new short[count];
                for (int j = 0; j < count; ++j) {
                    sshorts[j] = in.readShort();
                }
                return sshorts;
            }
            case 9: {
                if (count == 1) {
                    return in.readInt();
                }
                int[] slongs = new int[count];
                for (int j = 0; j < count; ++j) {
                    slongs[j] = in.readInt();
                }
                return slongs;
            }
            case 11: {
                if (count == 1) {
                    return Float.valueOf(in.readFloat());
                }
                float[] floats = new float[count];
                for (int j = 0; j < count; ++j) {
                    floats[j] = in.readFloat();
                }
                return floats;
            }
            case 12: {
                if (count == 1) {
                    return in.readDouble();
                }
                double[] doubles = new double[count];
                for (int j = 0; j < count; ++j) {
                    doubles[j] = in.readDouble();
                }
                return doubles;
            }
        }
        long valueOrOffset = in.readLong();
        return new TiffIFD.UnsupportedTypeValue(type, count, valueOrOffset);
    }

    private static byte[] readIFDBytes(DataHandle<?> in, long length) throws IOException {
        if (length > Integer.MAX_VALUE) {
            throw new TiffException("Too large IFD value: " + length + " >= 2^31 bytes");
        }
        byte[] bytes = new byte[(int)length];
        in.readFully(bytes);
        return bytes;
    }

    private TiffIFD.TiffEntry readIFDEntry(long entryOffset) throws IOException {
        long valueOffset;
        long valueCount;
        this.stream.seek(entryOffset);
        int entryTag = this.stream.readUnsignedShort();
        int entryType = this.stream.readUnsignedShort();
        long l = valueCount = this.bigTiff ? this.stream.readLong() : (long)this.stream.readInt() & 0xFFFFFFFFL;
        if (valueCount < 0L || valueCount > Integer.MAX_VALUE) {
            throw new TiffException("Invalid TIFF: very large number of IFD values in array " + (String)(valueCount < 0L ? " >= 2^63" : valueCount + " >= 2^31") + " is not supported");
        }
        int bytesPerElement = TagTypes.sizeOfType(entryType);
        long valueLength = valueCount * (long)bytesPerElement;
        boolean builtInData = TiffIFD.TiffEntry.builtInData(valueLength, this.bigTiff);
        long l2 = valueOffset = builtInData ? this.stream.offset() : this.readNextOffset(false);
        if (valueOffset < 0L) {
            throw new TiffException("Invalid TIFF: negative offset of IFD values " + valueOffset);
        }
        if (valueOffset > this.stream.length() - valueLength) {
            throw new TiffException("Invalid TIFF: offset of IFD values " + valueOffset + " + total lengths of values " + valueLength + " = " + valueCount + "*" + bytesPerElement + " is outside the file length " + this.stream.length());
        }
        TiffIFD.TiffEntry result = new TiffIFD.TiffEntry(entryTag, entryType, (int)valueCount, valueOffset, this.bigTiff);
        assert (result.valueLength() == valueLength);
        assert (result.builtInData() == builtInData);
        LOG.log(System.Logger.Level.TRACE, () -> String.format("Reading IFD entry: %s - %s", result, Tags.tiffTagName(result.tag(), true)));
        return result;
    }

    private static DataHandle<?> checkNonNull(DataHandle<?> inputStream, TiffOpenMode openMode) {
        Objects.requireNonNull(inputStream, "Null input stream");
        Objects.requireNonNull(openMode, "Null open mode");
        return inputStream;
    }

    public static enum UnpackBits {
        NONE(0),
        UNPACK_TO_0_1(1),
        UNPACK_TO_0_255(-1);

        private final byte bit1Value;

        private UnpackBits(byte bit1Value) {
            this.bit1Value = bit1Value;
        }

        public static UnpackBits of(boolean unpack) {
            return unpack ? UNPACK_TO_0_255 : NONE;
        }

        public boolean isEnabled() {
            return this != NONE;
        }

        public byte bit1Value() {
            return this.bit1Value;
        }
    }

    public static enum UnusualPrecisions {
        NONE,
        DISABLE,
        UNPACK;


        UnusualPrecisions unpackIfEnabled() {
            return this == NONE ? UNPACK : this;
        }

        public static UnusualPrecisions of(boolean unpack) {
            return unpack ? UNPACK : NONE;
        }

        public void throwIfDisabled(TiffMap map) throws TiffException {
            Objects.requireNonNull(map, "Null TIFF map");
            if (this == DISABLE && TiffUnusualPrecisions.isUnusualPrecisions(map.ifd())) {
                throw new UnsupportedTiffFormatException("Support of unusual TIFF bit depth is disabled: " + Arrays.toString(map.ifd().getBitsPerSample()) + " bits/sample for " + map.sampleType().prettyName() + " values");
            }
        }

        public byte[] unpackIfNecessary(TiffMap map, byte[] samples, long numberOfPixels, boolean scaleUnsignedInt24) throws TiffException {
            Objects.requireNonNull(map, "Null TIFF map");
            Objects.requireNonNull(samples, "Null samples");
            this.throwIfDisabled(map);
            return this != UNPACK ? samples : TiffUnusualPrecisions.unpackUnusualPrecisions(samples, map.ifd(), map.numberOfChannels(), numberOfPixels, scaleUnsignedInt24);
        }
    }

    class CachedTile {
        private final TiffTileIndex tileIndex;
        private final Object onlyThisTileLock = new Object();
        private Reference<TiffTile> cachedTile = null;
        private long cachedDataLength;

        CachedTile(TiffTileIndex tileIndex) {
            this.tileIndex = Objects.requireNonNull(tileIndex, "Null tileIndex");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TiffTile readIfNecessary() throws IOException {
            Object object = this.onlyThisTileLock;
            synchronized (object) {
                TiffTile cachedData = this.cached();
                if (cachedData != null) {
                    TiffIO.LOG.log(System.Logger.Level.TRACE, () -> "CACHED tile: " + String.valueOf(this.tileIndex));
                    return cachedData;
                }
                TiffTile result = TiffReader.this.readTile(this.tileIndex);
                this.saveCache(result);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TiffTile cached() {
            Object object = TiffReader.this.tileCacheLock;
            synchronized (object) {
                if (this.cachedTile == null) {
                    return null;
                }
                TiffTile tile = this.cachedTile.get();
                if (tile == null) {
                    TiffIO.LOG.log(System.Logger.Level.DEBUG, () -> "CACHED tile is freed by garbage collector due to insufficiency of memory: " + String.valueOf(this.tileIndex));
                }
                return tile;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveCache(TiffTile tile) {
            Objects.requireNonNull(tile);
            Object object = TiffReader.this.tileCacheLock;
            synchronized (object) {
                if (TiffReader.this.caching && TiffReader.this.maxCachingMemory > 0L) {
                    this.cachedTile = new SoftReference<TiffTile>(tile);
                    this.cachedDataLength = tile.getDecodedDataLength();
                    TiffReader.this.currentCacheMemory += this.cachedDataLength;
                    TiffReader.this.tileCache.add(this);
                    TiffIO.LOG.log(System.Logger.Level.TRACE, () -> "STORING tile in cache: " + String.valueOf(this.tileIndex));
                    while (TiffReader.this.currentCacheMemory > TiffReader.this.maxCachingMemory) {
                        CachedTile cached = TiffReader.this.tileCache.remove();
                        assert (cached != null);
                        TiffReader.this.currentCacheMemory -= cached.cachedDataLength;
                        cached.cachedTile = null;
                        Runtime runtime = Runtime.getRuntime();
                        TiffIO.LOG.log(System.Logger.Level.TRACE, () -> String.format(Locale.US, "REMOVING tile from cache (limit %.1f MB exceeded, used memory %.1f MB): %s", (double)TiffReader.this.maxCachingMemory / 1048576.0, (double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0, cached.tileIndex));
                    }
                }
            }
        }
    }
}

