/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.tiff;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public enum TiffImageKind {
    BASE("base", null),
    ORDINARY("ordinary", null),
    THUMBNAIL("thumbnail", null),
    LABEL("label", "label"),
    MACRO("macro", "macro");

    private final String kindName;
    private final String keyword;
    private final Pattern detectionPattern;
    public static final Pattern LABEL_DETECTION_PATTERN;
    public static final Pattern MACRO_DETECTION_PATTERN;

    private TiffImageKind(String kindName, String keyword) {
        this.kindName = Objects.requireNonNull(kindName);
        this.keyword = keyword;
        this.detectionPattern = keyword == null ? null : Pattern.compile("\\b" + keyword + "\\b", 2);
    }

    public String kindName() {
        return this.kindName;
    }

    public boolean isBase() {
        return this == BASE;
    }

    public boolean isOrdinary() {
        return this == ORDINARY || this == BASE;
    }

    public boolean isSpecial() {
        return !this.isOrdinary();
    }

    public boolean isAdditional() {
        return this == LABEL || this == MACRO;
    }

    public String keyword() {
        return this.keyword;
    }

    public Pattern detectionPattern() {
        return this.detectionPattern;
    }

    public static TiffImageKind ofKindName(String kindName) {
        Objects.requireNonNull(kindName, "Null kind name");
        return TiffImageKind.fromKindName(kindName).orElseThrow(() -> new IllegalArgumentException("Unknown kind name: \"" + kindName + "\""));
    }

    public static Optional<TiffImageKind> fromKindName(String kindName) {
        for (TiffImageKind kind : TiffImageKind.values()) {
            if (!kind.kindName.equalsIgnoreCase(kindName)) continue;
            return Optional.of(kind);
        }
        return Optional.empty();
    }

    static {
        LABEL_DETECTION_PATTERN = TiffImageKind.LABEL.detectionPattern;
        MACRO_DETECTION_PATTERN = TiffImageKind.MACRO.detectionPattern;
    }
}

