/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.segmentation;

import net.algart.executors.modules.opencv.matrices.segmentation.AbstractSuperpixel;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class SuperpixelSEEDS
extends AbstractSuperpixel {
    private int numberOfSuperpixels = 100;
    private int numberOfLevels = 4;
    private int numberOfHistogramBins = 5;
    private int prior = 4;
    private boolean doubleStep = false;
    private int numberOfIterations = 10;

    public int getNumberOfSuperpixels() {
        return this.numberOfSuperpixels;
    }

    public void setNumberOfSuperpixels(int numberOfSuperpixels) {
        this.numberOfSuperpixels = SuperpixelSEEDS.positive((int)numberOfSuperpixels);
    }

    public int getNumberOfLevels() {
        return this.numberOfLevels;
    }

    public void setNumberOfLevels(int numberOfLevels) {
        this.numberOfLevels = SuperpixelSEEDS.positive((int)numberOfLevels);
    }

    public int getNumberOfHistogramBins() {
        return this.numberOfHistogramBins;
    }

    public void setNumberOfHistogramBins(int numberOfHistogramBins) {
        this.numberOfHistogramBins = SuperpixelSEEDS.positive((int)numberOfHistogramBins);
    }

    public int getPrior() {
        return this.prior;
    }

    public void setPrior(int prior) {
        this.prior = prior;
    }

    public boolean isDoubleStep() {
        return this.doubleStep;
    }

    public void setDoubleStep(boolean doubleStep) {
        this.doubleStep = doubleStep;
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public void setNumberOfIterations(int numberOfIterations) {
        this.numberOfIterations = SuperpixelSEEDS.positive((int)numberOfIterations);
    }

    @Override
    public Mat process(Mat source) {
        Mat result = new Mat();
        long tStart = System.nanoTime();
        try (org.bytedeco.opencv.opencv_ximgproc.SuperpixelSEEDS superpixel = opencv_ximgproc.createSuperpixelSEEDS((int)source.cols(), (int)source.rows(), (int)source.channels(), (int)this.numberOfSuperpixels, (int)this.numberOfLevels, (int)this.prior, (int)this.numberOfHistogramBins, (boolean)this.doubleStep);){
            this.addServiceTime(System.nanoTime() - tStart);
            superpixel.iterate(source, this.numberOfIterations);
            SuperpixelSEEDS.logDebug(() -> "Superpixel SEEDS found " + superpixel.getNumberOfSuperpixels() + " superpixels; requested number of superpixels " + this.numberOfSuperpixels + ", number of levels " + this.numberOfLevels + ", number of histogram bins " + this.numberOfHistogramBins + ", prior " + this.prior + " (source: " + String.valueOf(source) + ")");
            superpixel.getLabels(result);
            this.makeLabelsPositiveIfRequired(result);
            this.setToOutputBoundaries((Mat boundaries, Mat labels, boolean needThick) -> superpixel.getLabelContourMask(boundaries, this.drawingBoundariesStyle.thickBoundaries), source, result);
        }
        return result;
    }

    @Override
    public UMat process(UMat source) {
        UMat result = new UMat();
        long tStart = System.nanoTime();
        try (org.bytedeco.opencv.opencv_ximgproc.SuperpixelSEEDS superpixel = opencv_ximgproc.createSuperpixelSEEDS((int)source.cols(), (int)source.rows(), (int)source.channels(), (int)this.numberOfSuperpixels, (int)this.numberOfLevels, (int)this.prior, (int)this.numberOfHistogramBins, (boolean)this.doubleStep);){
            this.addServiceTime(System.nanoTime() - tStart);
            superpixel.iterate(source, this.numberOfIterations);
            SuperpixelSEEDS.logDebug(() -> "Superpixel SEEDS found " + superpixel.getNumberOfSuperpixels() + " superpixels; requested number of superpixels " + this.numberOfSuperpixels + ", number of levels " + this.numberOfLevels + ", number of histogram bins " + this.numberOfHistogramBins + ", prior " + this.prior + " (source: " + String.valueOf(source) + ")");
            superpixel.getLabels(result);
            this.makeLabelsPositiveIfRequired(result);
            this.setToOutputBoundaries((Mat boundaries, Mat labels, boolean needThick) -> superpixel.getLabelContourMask(boundaries, this.drawingBoundariesStyle.thickBoundaries), source, result);
        }
        return result;
    }
}

