/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.misc;

import java.awt.Color;
import java.util.ConcurrentModificationException;
import java.util.Locale;
import java.util.Objects;
import net.algart.executors.modules.opencv.common.OpenCVExecutor;
import net.algart.executors.modules.opencv.matrices.misc.CirclePointsBuilder;
import net.algart.executors.modules.opencv.matrices.misc.TestBorderPixels;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.executors.modules.opencv.util.enums.OConnectivity;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.multimatrix.MultiMatrix;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Scalar;

public final class FloodFill
extends OpenCVExecutor {
    public static final String INPUT_NON_FILLED_MASK = "non_filled_mask";
    public static final String OUTPUT_FILLED = "filled";
    public static final String OUTPUT_MASK = "mask";
    public static final String OUTPUT_MODIFIED_RECTANGLE = "modified_rectangle";
    private static final boolean RETAIN_DRAWN_BORDER_FOR_DEBUGGING = false;
    private static final int NORMAL_FILLER = 127;
    private static final int BORDER_FILLER = 255;
    private boolean reset = true;
    private FillingMode fillingMode = FillingMode.FILL_INITIAL_MASK;
    private boolean returnOnlyModifiedRectangle = false;
    private boolean percents = false;
    private double x = 0.0;
    private double y = 0.0;
    private double maxFillingSize = 0.0;
    private Double loDiff = 0.1;
    private Double upDiff = null;
    private boolean rawDiffValues = false;
    private boolean floodFillFixedRange = false;
    private Color fillColor = Color.WHITE;
    private OConnectivity connectivity = OConnectivity.CONNECTIVITY_4;
    private boolean extendedMask = false;
    private boolean includeNonFilledMask = true;
    private boolean packBits = true;
    private final CirclePointsBuilder circlePointsBuilder = new CirclePointsBuilder();
    private FillingMode lastFillingMode = null;
    private Mat storedImage = null;
    private Mat storedNonFilledMask = null;
    private Mat accumulatingMask = null;
    private Mat workMask = null;

    public FloodFill() {
        this.useVisibleResultParameter();
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addInputMat(INPUT_NON_FILLED_MASK);
        this.addOutputMat(OUTPUT_MASK);
        this.addOutputMat(OUTPUT_FILLED);
        this.addOutputScalar("dim_x");
        this.addOutputScalar("dim_y");
        this.addOutputNumbers(OUTPUT_MODIFIED_RECTANGLE);
        this.addOutputScalar("max_border");
        this.addOutputScalar("max_top");
        this.addOutputScalar("max_bottom");
        this.addOutputScalar("max_left");
        this.addOutputScalar("max_right");
    }

    public boolean isReset() {
        return this.reset;
    }

    public FloodFill setReset(boolean reset) {
        this.reset = reset;
        return this;
    }

    public FillingMode getFillingMode() {
        return this.fillingMode;
    }

    public FloodFill setFillingMode(FillingMode fillingMode) {
        this.fillingMode = (FillingMode)((Object)FloodFill.nonNull((Object)((Object)fillingMode)));
        return this;
    }

    public boolean isReturnOnlyModifiedRectangle() {
        return this.returnOnlyModifiedRectangle;
    }

    public FloodFill setReturnOnlyModifiedRectangle(boolean returnOnlyModifiedRectangle) {
        this.returnOnlyModifiedRectangle = returnOnlyModifiedRectangle;
        return this;
    }

    public boolean isPercents() {
        return this.percents;
    }

    public FloodFill setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public FloodFill setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public FloodFill setY(double y) {
        this.y = y;
        return this;
    }

    public double getMaxFillingSize() {
        return this.maxFillingSize;
    }

    public FloodFill setMaxFillingSize(double maxFillingSize) {
        this.maxFillingSize = FloodFill.nonNegative((double)maxFillingSize);
        return this;
    }

    public Double getLoDiff() {
        return this.loDiff;
    }

    public FloodFill setLoDiff(Double loDiff) {
        this.loDiff = loDiff == null ? null : Double.valueOf(FloodFill.nonNegative((double)loDiff));
        return this;
    }

    public Double getUpDiff() {
        return this.upDiff;
    }

    public FloodFill setUpDiff(Double upDiff) {
        this.upDiff = upDiff == null ? null : Double.valueOf(FloodFill.nonNegative((double)upDiff));
        return this;
    }

    public boolean isRawDiffValues() {
        return this.rawDiffValues;
    }

    public FloodFill setRawDiffValues(boolean rawDiffValues) {
        this.rawDiffValues = rawDiffValues;
        return this;
    }

    public boolean isFloodFillFixedRange() {
        return this.floodFillFixedRange;
    }

    public FloodFill setFloodFillFixedRange(boolean floodFillFixedRange) {
        this.floodFillFixedRange = floodFillFixedRange;
        return this;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public FloodFill setFillColor(Color fillColor) {
        this.fillColor = (Color)FloodFill.nonNull((Object)fillColor);
        return this;
    }

    public OConnectivity getConnectivity() {
        return this.connectivity;
    }

    public FloodFill setConnectivity(OConnectivity connectivity) {
        this.connectivity = (OConnectivity)((Object)FloodFill.nonNull((Object)((Object)connectivity)));
        return this;
    }

    public boolean isExtendedMask() {
        return this.extendedMask;
    }

    public FloodFill setExtendedMask(boolean extendedMask) {
        this.extendedMask = extendedMask;
        return this;
    }

    public boolean isIncludeNonFilledMask() {
        return this.includeNonFilledMask;
    }

    public FloodFill setIncludeNonFilledMask(boolean includeNonFilledMask) {
        this.includeNonFilledMask = includeNonFilledMask;
        return this;
    }

    public boolean isPackBits() {
        return this.packBits;
    }

    public FloodFill setPackBits(boolean packBits) {
        this.packBits = packBits;
        return this;
    }

    public void process() {
        this.processImage(O2SMat.toMat(this.getInputMat(true), false), O2SMat.toMat(this.getInputMat(INPUT_NON_FILLED_MASK, true), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processImage(Mat image, Mat nonFilledMask) {
        long t1 = FloodFill.debugTime();
        this.resetSourceData(image, nonFilledMask);
        boolean filledImageRequested = this.isOutputNecessary(OUTPUT_FILLED);
        boolean resultMaskRequested = this.isOutputNecessary(OUTPUT_MASK);
        this.getScalar("dim_x").setTo(this.storedImage.cols());
        this.getScalar("dim_y").setTo(this.storedImage.rows());
        boolean boundsStatisticsNecessary = this.isOutputNecessary("max_border") || this.isOutputNecessary("max_top") || this.isOutputNecessary("max_bottom") || this.isOutputNecessary("max_left") || this.isOutputNecessary("max_right");
        boolean removeNonFilled = !this.includeNonFilledMask && this.storedNonFilledMask != null;
        IPoint seedPoint = this.seedPoint(image);
        long t2 = FloodFill.debugTime();
        this.circlePointsBuilder.setDimensions(this.accumulatingMask.cols(), this.accumulatingMask.rows());
        this.circlePointsBuilder.setDiameter(this.maxFillingSize);
        int[] pointsXY = this.circlePointsBuilder.pointsXY();
        try (Mat resultMask = null;){
            long t3 = FloodFill.debugTime();
            IRectangularArea modifiedRectangle = this.fillingMode.fill(this, seedPoint);
            long t4 = FloodFill.debugTime();
            if (resultMaskRequested) {
                if (this.returnOnlyModifiedRectangle) {
                    resultMask = this.extractModified(this.accumulatingMask, true, modifiedRectangle);
                    if (removeNonFilled) {
                        this.removeNotFilledFromModifiedPartOfTheMask(resultMask, modifiedRectangle);
                    }
                } else {
                    resultMask = this.reduceMask(this.accumulatingMask, this.storedImage.cols(), this.storedImage.rows(), removeNonFilled);
                }
            }
            long t5 = FloodFill.debugTime();
            this.getNumbers(OUTPUT_MODIFIED_RECTANGLE).setToOrRemove(modifiedRectangle);
            if (boundsStatisticsNecessary) {
                TestBorderPixels.BorderStatistics statistics = TestBorderPixels.findBorderStatistics(this.accumulatingMask, 1);
                this.getScalar("max_border").setTo(statistics.max());
                this.getScalar("max_top").setTo(statistics.maxTop());
                this.getScalar("max_bottom").setTo(statistics.maxBottom());
                this.getScalar("max_left").setTo(statistics.maxLeft());
                this.getScalar("max_right").setTo(statistics.maxRight());
            }
            long t6 = FloodFill.debugTime();
            if (filledImageRequested) {
                Mat filledResult = this.fillingMode.isFillMaskOnly() ? null : (this.returnOnlyModifiedRectangle ? this.extractModified(this.storedImage, false, modifiedRectangle) : OTools.clone(this.storedImage));
                O2SMat.setToOrRemove(this.getMat(OUTPUT_FILLED), filledResult);
            }
            long t7 = FloodFill.debugTime();
            if (resultMaskRequested) {
                if (resultMask == null) {
                    this.getMat(OUTPUT_MASK).remove();
                } else if (this.packBits) {
                    this.getMat(OUTPUT_MASK).setTo((MultiMatrix)O2SMat.toBinaryMatrix(resultMask));
                } else {
                    O2SMat.setTo(this.getMat(OUTPUT_MASK), resultMask);
                    resultMask = null;
                }
            }
            long t8 = FloodFill.debugTime();
            this.fillingMode.cleanup(this, modifiedRectangle);
            this.lastFillingMode = this.fillingMode;
            long t9 = FloodFill.debugTime();
            FloodFill.logDebug((String)String.format(Locale.US, "Flood-filling in %s: %.3f ms:\n  %.3f ms %s,\n  %.3f ms building %d border points to restrict filling size,\n  %.3f ms actual filling%s%s%s,\n  %.3f ms %s mask,\n  %.3f analysing border,\n  %.3f returning filled image%s,\n  %.3f returning mask\n  %.3f cleaning up", OTools.toString(this.storedImage), (double)(t9 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, this.reset ? "initial copying data and " + (nonFilledMask == null ? "creating mask" : (this.extendedMask ? "copying mask" : "extending mask")) : "initializing", (double)(t3 - t2) * 1.0E-6, pointsXY.length / 2, (double)(t4 - t3) * 1.0E-6, this.fillingMode.isFillMaskOnly() ? " mask only" : " mask and image", modifiedRectangle == null ? " - nothing to do" : "", removeNonFilled ? " (with removing original mask)" : "", (double)(t5 - t4) * 1.0E-6, this.extendedMask ? "copying" : "reducing", (double)(t6 - t5) * 1.0E-6, (double)(t7 - t6) * 1.0E-6, filledImageRequested ? "" : " (clearing)", (double)(t8 - t7) * 1.0E-6, (double)(t9 - t8) * 1.0E-6));
        }
    }

    @Override
    public void close() {
        if (this.workMask != null) {
            this.workMask.close();
            this.workMask = null;
        }
        if (this.accumulatingMask != null) {
            this.accumulatingMask.close();
            this.accumulatingMask = null;
        }
        if (this.storedNonFilledMask != null) {
            this.storedNonFilledMask.close();
            this.storedNonFilledMask = null;
        }
        if (this.storedImage != null) {
            this.storedImage.close();
            this.storedImage = null;
        }
        this.circlePointsBuilder.clear();
        super.close();
    }

    private Mat filledResult(Mat mask, boolean needToInsertMask, boolean needToReduceMask) {
        Mat result;
        block13: {
            result = OTools.clone(this.storedImage);
            if (needToInsertMask) {
                Objects.requireNonNull(mask, "Null mask");
                FloodFill.checkMaskSizes(mask, this.storedImage.cols(), this.storedImage.rows(), needToReduceMask);
                try (Mat filler = this.filledMat(this.storedImage);){
                    if (needToReduceMask) {
                        try (Rect rect = new Rect(1, 1, this.storedImage.cols(), this.storedImage.rows());){
                            filler.copyTo(result, mask.apply(rect));
                            break block13;
                        }
                    }
                    filler.copyTo(result, mask);
                }
            }
        }
        return result;
    }

    public IPoint seedPoint(Mat image) {
        Objects.requireNonNull(image, "Null image");
        long seedX = Math.round(this.percents ? this.x / 100.0 * (double)(image.cols() - 1) : this.x);
        long seedY = Math.round(this.percents ? this.y / 100.0 * (double)(image.rows() - 1) : this.y);
        return IPoint.of((long)seedX, (long)seedY);
    }

    public IRectangularArea restrictedFloodFill(Mat image, Mat mask, IPoint seedPoint, boolean fillMaskOnly) {
        long seedX = seedPoint.x() + 1L;
        long seedY = seedPoint.y() + 1L;
        this.circlePointsBuilder.drawAndSavePrevious(mask, seedX, seedY, (byte)-1);
        IRectangularArea result = this.floodFill(this.storedImage, mask, seedPoint, fillMaskOnly);
        this.circlePointsBuilder.restorePrevious(mask, seedX, seedY);
        return result;
    }

    /*
     * Exception decompiling
     */
    public IRectangularArea floodFill(Mat image, Mat mask, IPoint seedPoint, boolean fillMaskOnly) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removeNotFilledFromModifiedPartOfTheMask(Mat resultMask, IRectangularArea modifiedRectangle) {
        if (this.storedNonFilledMask == null || resultMask == null) {
            return;
        }
        if ((modifiedRectangle = this.correctModifiedRectangle(this.storedNonFilledMask, true, modifiedRectangle)) == null) {
            return;
        }
        FloodFill.checkMaskSizes(resultMask, modifiedRectangle.sizeX(), modifiedRectangle.sizeY(), false);
        try (Rect rect = OTools.toRect(modifiedRectangle);){
            opencv_core.bitwise_xor((Mat)resultMask, (Mat)this.storedNonFilledMask.apply(rect), (Mat)resultMask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendMask(Mat result, Mat nonFilledMask, int dimX, int dimY) {
        Objects.requireNonNull(result, "Null result");
        Objects.requireNonNull(nonFilledMask, "Null nonFilledMask");
        FloodFill.checkMaskSizes(nonFilledMask, dimX, dimY, this.extendedMask);
        Mat mask = nonFilledMask;
        try {
            mask = OTools.toMono8UIfNot(nonFilledMask);
            if (this.extendedMask) {
                mask.copyTo(result);
            } else {
                opencv_core.copyMakeBorder((Mat)mask, (Mat)result, (int)1, (int)1, (int)1, (int)1, (int)0);
            }
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mask, nonFilledMask);
        }
    }

    public Mat reduceMask(Mat mask, int dimX, int dimY, boolean removeNotFilled) {
        Mat result = new Mat();
        if (this.extendedMask) {
            if (removeNotFilled && this.storedNonFilledMask != null) {
                opencv_core.bitwise_xor((Mat)mask, (Mat)this.storedNonFilledMask, (Mat)result);
            } else {
                mask.copyTo(result);
            }
        } else {
            try (Rect rect = new Rect(1, 1, dimX, dimY);){
                if (removeNotFilled && this.storedNonFilledMask != null) {
                    opencv_core.bitwise_xor((Mat)mask.apply(rect), (Mat)this.storedNonFilledMask.apply(rect), (Mat)result);
                } else {
                    mask.apply(rect).copyTo(result);
                }
            }
        }
        return result;
    }

    public Mat extractModified(Mat mat, boolean matIsExtended, IRectangularArea modifiedRectangle) {
        Mat result = null;
        if ((modifiedRectangle = this.correctModifiedRectangle(mat, matIsExtended, modifiedRectangle)) != null) {
            result = new Mat();
            try (Rect rect = OTools.toRect(modifiedRectangle);){
                mat.apply(rect).copyTo(result);
            }
        }
        return result;
    }

    private void createIfNecessary(boolean hasNonFilledMask) {
        if (this.storedImage == null) {
            this.storedImage = new Mat();
        }
        if (hasNonFilledMask) {
            if (this.storedNonFilledMask == null) {
                this.storedNonFilledMask = new Mat();
            }
        } else if (this.storedNonFilledMask != null) {
            this.storedNonFilledMask.close();
            this.storedNonFilledMask = null;
        }
        if (this.accumulatingMask == null) {
            this.accumulatingMask = new Mat();
        }
    }

    private void createWorkMaskIfNecessary() {
        if (this.workMask == null) {
            this.workMask = new Mat();
            this.resetMask(this.workMask);
        }
    }

    private Mat accumulatingMask() {
        return this.accumulatingMask;
    }

    private Mat workMask() {
        this.createWorkMaskIfNecessary();
        return this.workMask;
    }

    private void resetSourceData(Mat source, Mat nonFilledMask) {
        if (this.reset) {
            if (source == null) {
                throw new NullPointerException("Source matrix must be specified when \"reset\" is true");
            }
            this.createIfNecessary(nonFilledMask != null);
            if (source.channels() != 4) {
                source.copyTo(this.storedImage);
            } else {
                opencv_imgproc.cvtColor((Mat)source, (Mat)this.storedImage, (int)1);
            }
            if (nonFilledMask != null) {
                this.extendMask(this.storedNonFilledMask, nonFilledMask, source.cols(), source.rows());
            }
            this.resetMask(this.accumulatingMask);
            if (this.workMask != null) {
                this.workMask.close();
                this.workMask = null;
            }
        } else {
            if (this.storedImage == null) {
                throw new IllegalStateException("FloodFill was not initialized: it must be called at least once in \"reset\" mode");
            }
            if (this.accumulatingMask == null) {
                throw new ConcurrentModificationException("Possible illegal multithreading usage: one of masks is not initialized");
            }
            this.fillingMode.correctOnModeChange(this, this.lastFillingMode);
        }
    }

    private IRectangularArea correctModifiedRectangle(Mat mat, boolean matIsExtended, IRectangularArea modifiedRectangle) {
        if (modifiedRectangle == null) {
            return null;
        }
        int dimX = mat.cols();
        int dimY = mat.rows();
        int shift = 0;
        if (matIsExtended) {
            if (dimX < 2 || dimY < 2) {
                throw new IllegalArgumentException("Too little mat: it must be at least 2x2");
            }
            dimX -= 2;
            dimY -= 2;
            shift = 1;
        }
        if (dimX <= 0 || dimY <= 0) {
            return null;
        }
        if ((modifiedRectangle = modifiedRectangle.intersection(IRectangularArea.of((long)0L, (long)0L, (long)dimX, (long)dimY))) == null) {
            return null;
        }
        return modifiedRectangle.shift(IPoint.ofEqualCoordinates((int)2, (long)shift));
    }

    private void resetMask(Mat mask) {
        if (this.storedNonFilledMask != null) {
            this.storedNonFilledMask.copyTo(mask);
        } else {
            Mat.zeros((int)(this.storedImage.rows() + 2), (int)(this.storedImage.cols() + 2), (int)0).asMat().copyTo(mask);
        }
    }

    private void cleanupMask(Mat mask, IRectangularArea modifiedRectangle) {
        if ((modifiedRectangle = this.correctModifiedRectangle(mask, true, modifiedRectangle)) == null) {
            return;
        }
        try (Rect rect = OTools.toRect(modifiedRectangle);){
            mask = mask.apply(rect);
            if (this.storedNonFilledMask != null) {
                this.storedNonFilledMask.apply(rect).copyTo(mask);
            } else {
                Mat.zeros((int)mask.rows(), (int)mask.cols(), (int)0).asMat().copyTo(mask);
            }
        }
    }

    private void insertMaskToAccumulator(IRectangularArea modifiedRectangle) {
        if ((modifiedRectangle = this.correctModifiedRectangle(this.accumulatingMask, true, modifiedRectangle)) == null) {
            return;
        }
        try (Rect rect = OTools.toRect(modifiedRectangle);){
            Mat accumulatingRect = this.accumulatingMask.apply(rect);
            Mat workRect = this.workMask.apply(rect);
            opencv_core.bitwise_or((Mat)accumulatingRect, (Mat)workRect, (Mat)accumulatingRect);
        }
    }

    private void removeMaskFromAccumulator(IRectangularArea modifiedRectangle) {
        if ((modifiedRectangle = this.correctModifiedRectangle(this.accumulatingMask, true, modifiedRectangle)) == null) {
            return;
        }
        try (Rect rect = OTools.toRect(modifiedRectangle);){
            Mat accumulatingRect = this.accumulatingMask.apply(rect);
            Mat workRect = this.workMask.apply(rect);
            opencv_core.bitwise_not((Mat)workRect, (Mat)workRect);
            opencv_core.bitwise_and((Mat)accumulatingRect, (Mat)workRect, (Mat)accumulatingRect);
            if (this.storedNonFilledMask != null) {
                opencv_core.bitwise_or((Mat)accumulatingRect, (Mat)this.storedNonFilledMask.apply(rect), (Mat)accumulatingRect);
            }
        }
    }

    private Scalar fillColor(Mat sourceImage) {
        return OTools.scalarBGR(this.fillColor, OTools.maxPossibleValue(sourceImage));
    }

    private Mat filledMat(Mat sourceImage) {
        Mat result = new Mat(sourceImage.rows(), sourceImage.cols(), sourceImage.type());
        try (Scalar scalar = this.fillColor(sourceImage);){
            result.put(scalar);
        }
        return result;
    }

    private static void checkSeedPoint(Mat image, IPoint seedPoint) {
        Objects.requireNonNull(image, "Null image");
        Objects.requireNonNull(seedPoint, "Null seedPoint");
        if (seedPoint.x() < 0L || seedPoint.x() >= (long)image.cols() || seedPoint.y() < 0L || seedPoint.y() >= (long)image.rows()) {
            throw new IllegalArgumentException("Seed position " + String.valueOf(seedPoint) + " is out of the image image " + image.cols() + "x" + image.rows());
        }
    }

    private static void checkMaskSizes(Mat mask, long dimX, long dimY, boolean extendedMask) {
        int extensionGap;
        int n = extensionGap = extendedMask ? 2 : 0;
        if ((long)mask.cols() != dimX + (long)extensionGap || (long)mask.rows() != dimY + (long)extensionGap) {
            throw new IllegalArgumentException("Illegal mask sizes: the expected sizes (source image?) are " + dimX + "x" + dimY + ", the mask is " + mask.cols() + "x" + mask.rows() + (extendedMask ? ", but the mask must be 2 pixels wider and 2 pixels taller than it" : ""));
        }
    }

    public static enum FillingMode {
        FILL_INITIAL_MASK(true, false),
        FILL_MASK(false, false),
        FILL(false, false),
        FILL_AND_INSERT(false, true){

            @Override
            IRectangularArea fill(FloodFill executor, IPoint seedPoint) {
                IRectangularArea result = this.simpleFill(executor, executor.workMask(), seedPoint);
                executor.insertMaskToAccumulator(result);
                return result;
            }
        }
        ,
        FILL_AND_REMOVE(false, true){

            @Override
            IRectangularArea fill(FloodFill executor, IPoint seedPoint) {
                IRectangularArea result = this.simpleFill(executor, executor.workMask(), seedPoint);
                executor.removeMaskFromAccumulator(result);
                return result;
            }
        };

        private final boolean needToCleanupAccumulator;
        private final boolean needToCleanupWorkMask;

        private FillingMode(boolean needToCleanupAccumulator, boolean needToCleanupWorkMask) {
            this.needToCleanupAccumulator = needToCleanupAccumulator;
            this.needToCleanupWorkMask = needToCleanupWorkMask;
        }

        IRectangularArea fill(FloodFill executor, IPoint seedPoint) {
            return this.simpleFill(executor, executor.accumulatingMask, seedPoint);
        }

        void cleanup(FloodFill executor, IRectangularArea modifiedRectangle) {
            if (this.needToCleanupAccumulator) {
                executor.cleanupMask(executor.accumulatingMask, modifiedRectangle);
            }
            if (this.needToCleanupWorkMask) {
                executor.cleanupMask(executor.workMask, modifiedRectangle);
            }
        }

        final IRectangularArea simpleFill(FloodFill executor, Mat mask, IPoint seedPoint) {
            return executor.restrictedFloodFill(executor.storedImage, mask, seedPoint, this.isFillMaskOnly());
        }

        final void correctOnModeChange(FloodFill executor, FillingMode lastMode) {
            if (this == FILL_INITIAL_MASK && lastMode != FILL_INITIAL_MASK) {
                executor.resetMask(executor.accumulatingMask);
            }
        }

        private boolean needToCleanupAccumulator() {
            return this == FILL_INITIAL_MASK;
        }

        private boolean isFillMaskOnly() {
            return this != FILL;
        }
    }
}

