/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.io;

import java.io.IOError;
import java.io.IOException;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.common.io.WriteFileOperation;
import net.algart.executors.modules.opencv.util.O2SMat;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public final class WriteMat
extends WriteFileOperation
implements ReadOnlyExecutionInput {
    private boolean inputRequired = false;

    public WriteMat() {
        this.addFileOperationPorts();
        this.addInputMat(DEFAULT_INPUT_PORT);
    }

    public WriteMat setFile(String file) {
        super.setFile(file);
        return this;
    }

    public boolean isInputRequired() {
        return this.inputRequired;
    }

    public WriteMat setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
        return this;
    }

    public void process() {
        this.writeMat(this.getInputMat(!this.inputRequired));
    }

    public void writeMat(SMat inputMat) {
        if (inputMat.isInitialized()) {
            this.writeMat(O2SMat.toMat(inputMat));
        }
    }

    public void writeMat(Mat mat) {
        String file = this.completeFilePath().toAbsolutePath().toString();
        WriteMat.logDebug(() -> "Writing OpenCV matrix " + String.valueOf(mat) + " to file " + file);
        if (!opencv_imgcodecs.imwrite((String)file, (Mat)mat)) {
            throw new IOError(new IOException("Cannot write " + file));
        }
    }

    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return this.defaultVisibleResultsInformation(Port.Type.INPUT, DEFAULT_INPUT_PORT);
    }

    public String translateLegacyParameterAlias(String name) {
        return name.equals("requireInput") ? "inputRequired" : name;
    }
}

