/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.io;

import java.io.IOError;
import java.io.IOException;
import java.util.function.Supplier;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.opencv.util.O2SMat;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_videoio.VideoCapture;

public final class ReadMatFromCamera
extends Executor
implements ReadOnlyExecutionInput {
    private int cameraIndex = 0;
    private ApiPreference apiPreference = ApiPreference.AUTO;
    private boolean lockCameraForFurtherUsage = false;
    private volatile Camera savedCamera = null;

    public ReadMatFromCamera() {
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public int getCameraIndex() {
        return this.cameraIndex;
    }

    public ReadMatFromCamera setCameraIndex(int cameraIndex) {
        this.cameraIndex = ReadMatFromCamera.nonNegative((int)cameraIndex);
        return this;
    }

    public ApiPreference getApiPreference() {
        return this.apiPreference;
    }

    public ReadMatFromCamera setApiPreference(ApiPreference apiPreference) {
        this.apiPreference = (ApiPreference)((Object)ReadMatFromCamera.nonNull((Object)((Object)apiPreference)));
        return this;
    }

    public boolean isLockCameraForFurtherUsage() {
        return this.lockCameraForFurtherUsage;
    }

    public ReadMatFromCamera setLockCameraForFurtherUsage(boolean lockCameraForFurtherUsage) {
        this.lockCameraForFurtherUsage = lockCameraForFurtherUsage;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        boolean settingsChanged;
        SMat input = this.getInputMat(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            ReadMatFromCamera.logDebug(() -> "Copying " + String.valueOf(input));
            this.getMat().setTo(input);
            return;
        }
        boolean lockCamera = this.lockCameraForFurtherUsage;
        boolean bl = settingsChanged = this.savedCamera != null && (this.cameraIndex != this.savedCamera.cameraIndex || this.apiPreference != this.savedCamera.apiPreference);
        if (!lockCamera || settingsChanged) {
            if (settingsChanged) {
                ReadMatFromCamera.logInfo(() -> "Camera settings changed, need to reopen");
            }
            this.closeCamera();
        }
        boolean useSavedCamera = this.savedCamera != null;
        Camera camera = useSavedCamera ? this.savedCamera : new Camera(this.cameraIndex, this.apiPreference);
        try {
            Mat mat = camera.readFrame(useSavedCamera ? "saved camera" : "newly created camera");
            O2SMat.setTo(this.getMat(), mat);
            if (lockCamera) {
                this.savedCamera = camera;
            }
        }
        finally {
            if (!lockCamera) {
                camera.release();
            }
        }
    }

    public void close() {
        this.closeCamera();
        super.close();
    }

    private void closeCamera() {
        if (this.savedCamera != null) {
            ReadMatFromCamera.logInfo(() -> "Closing " + String.valueOf(this.savedCamera));
            this.savedCamera.release();
            this.savedCamera = null;
        }
    }

    public static enum ApiPreference {
        AUTO(0),
        VFW(200);

        private final int code;

        public int code() {
            return this.code;
        }

        private ApiPreference(int code) {
            this.code = code;
        }
    }

    public static class Camera {
        private final VideoCapture video;
        private final int cameraIndex;
        private final ApiPreference apiPreference;

        public Camera(int cameraIndex, ApiPreference apiPreference) {
            this.cameraIndex = cameraIndex;
            this.apiPreference = apiPreference;
            ReadMatFromCamera.logInfo((Supplier)() -> "Opening video camera #" + cameraIndex + " (preference: " + String.valueOf((Object)apiPreference) + ")");
            this.video = new VideoCapture();
            if (!this.video.open(cameraIndex, apiPreference.code())) {
                throw new IOError(new IOException("Cannot open camera"));
            }
        }

        public void release() {
            this.video.release();
            this.video.close();
        }

        public Mat readFrame() {
            return this.readFrame(null);
        }

        private Mat readFrame(String cameraTitle) {
            if (!this.video.isOpened()) {
                throw new IOError(new IOException((cameraTitle == null ? "Camera" : cameraTitle) + " is not opened (" + String.valueOf(this) + ")"));
            }
            Mat result = new Mat();
            if (!this.video.read(result)) {
                throw new IOError(new IOException("No frames were grabbed by " + (cameraTitle == null ? "camera" : cameraTitle) + " (" + String.valueOf(this) + ")"));
            }
            return result;
        }

        public String toString() {
            return "video camera #" + this.cameraIndex + ", preference: " + String.valueOf((Object)this.apiPreference);
        }
    }
}

