/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.io;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.opencv.util.O2SMat;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public final class ReadMat
extends FileOperation
implements ReadOnlyExecutionInput {
    private boolean relativizePath = false;

    public ReadMat() {
        this.addFileOperationPorts();
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public static ReadMat getSecureInstance() {
        ReadMat result = new ReadMat();
        result.setSecure(true);
        return result;
    }

    public boolean isRelativizePath() {
        return this.relativizePath;
    }

    public ReadMat setRelativizePath(boolean relativizePath) {
        this.relativizePath = relativizePath;
        return this;
    }

    public ReadMat setFile(String file) {
        super.setFile(file);
        return this;
    }

    public void process() {
        SMat input = this.getInputMat(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            ReadMat.logDebug(() -> "Copying " + String.valueOf(input));
            this.getMat().setTo(input);
        } else {
            this.readMat(this.getMat());
        }
    }

    public SMat readMat() {
        return this.readMat(new SMat());
    }

    public SMat readMat(SMat result) {
        Path path = this.completeOSFilePath(this.relativizePath);
        try {
            if (this.skipIfMissingFileOrThrow(path)) {
                result.remove();
            } else {
                String fileName = path.toString();
                ReadMat.logDebug(() -> "Reading OpenCV matrix from " + fileName);
                Mat mat = opencv_imgcodecs.imread((String)fileName);
                if (mat == null || mat.data() == null) {
                    throw new IOException("Cannot read " + fileName);
                }
                O2SMat.setTo(result, mat);
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return result;
    }
}

