/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.pixels;

import net.algart.arrays.Arrays;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.multimatrix.MultiMatrix2D;

public final class PatternShapeToScalar
extends Executor
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_SHAPE_DESCRIPTION = "shape_specification";
    private boolean invert = false;

    public PatternShapeToScalar() {
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.setDefaultOutputScalar(OUTPUT_SHAPE_DESCRIPTION);
    }

    public boolean isInvert() {
        return this.invert;
    }

    public PatternShapeToScalar setInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    public void process() {
        MultiMatrix2D source = this.getInputMat().toMultiMatrix2D(true);
        if (source.dimX() > Integer.MAX_VALUE || source.dimY() > Integer.MAX_VALUE || (source.dimX() + 1L) * source.dimY() > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large source matrix to be converted to scalar: " + String.valueOf(source));
        }
        PArray array = (PArray)source.intensityChannel().array();
        if (this.invert) {
            array = Arrays.asFuncArray((Func)LinearFunc.getInstance((double)array.maxPossibleValue(1.0), (double[])new double[]{-1.0}), (Class)array.type(), (PArray[])new PArray[]{array});
        }
        PFixedArray integerArray = array instanceof PFixedArray ? (PFixedArray)array : null;
        StringBuilder sb = new StringBuilder();
        int dimY = (int)source.dimY();
        int disp = 0;
        for (int y = 0; y < dimY; ++y) {
            int x = 0;
            int dimX = (int)source.dimX();
            while (x < dimX) {
                if (x > 0) {
                    sb.append(' ');
                }
                if (integerArray != null) {
                    sb.append(integerArray.getLong((long)disp));
                } else {
                    sb.append(array.getDouble((long)disp));
                }
                ++x;
                ++disp;
            }
            sb.append('\n');
        }
        this.getScalar().setTo(sb.toString());
    }
}

