/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.pixels;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.cv.matrices.pixels.GetLabelledPixels;
import net.algart.multimatrix.MultiMatrix2D;

public final class GetPixels
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_MASK = "mask";
    public static final String OUTPUT_PIXEL_VALUES = "pixel_values";
    private boolean rawPixelValues = false;

    public GetPixels() {
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addInputMat(INPUT_MASK);
        this.setDefaultOutputNumbers(OUTPUT_PIXEL_VALUES);
    }

    public boolean isRawPixelValues() {
        return this.rawPixelValues;
    }

    public GetPixels setRawPixelValues(boolean rawPixelValues) {
        this.rawPixelValues = rawPixelValues;
        return this;
    }

    public void process() {
        MultiMatrix2D source = this.getInputMat().toMultiMatrix2D(true);
        MultiMatrix2D mask = this.getInputMat(INPUT_MASK, true).toMultiMatrix2D();
        this.setStartProcessingTimeStamp();
        SNumbers result = this.getNumbers(OUTPUT_PIXEL_VALUES);
        new GetLabelledPixels().setRawPixelValues(this.rawPixelValues).process(source, mask, result, null);
        this.setEndProcessingTimeStamp();
        this.getNumbers().exchange(result);
    }
}

