/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.components;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyOperation;
import net.algart.executors.modules.cv.matrices.morphology.StrictMorphology;
import net.algart.executors.modules.cv.matrices.objects.RetainOrRemoveMode;
import net.algart.executors.modules.cv.matrices.objects.binary.components.FindConnectedWithMask;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class SmartDilatingObjects
extends SeveralMultiMatricesOperation {
    public static final String INPUT_SURELY = "surely";
    public static final String INPUT_MAYBE = "maybe";
    public static final String INPUT_UNLIKELY = "unlikely";
    private MorphologyFilter.Shape surelyDilationShape = MorphologyFilter.Shape.SPHERE;
    private int surelyDilationSize = 11;
    private String surelyCustomPatternSpecification = null;
    private MorphologyFilter.Shape unlikelyErosionShape = MorphologyFilter.Shape.SPHERE;
    private int unlikelyErosionSize = 31;
    private String unlikelyCustomPatternSpecification = null;

    public SmartDilatingObjects() {
        super(new String[]{INPUT_SURELY, INPUT_MAYBE, INPUT_UNLIKELY});
    }

    public MorphologyFilter.Shape getSurelyDilationShape() {
        return this.surelyDilationShape;
    }

    public SmartDilatingObjects setSurelyDilationShape(MorphologyFilter.Shape surelyDilationShape) {
        this.surelyDilationShape = (MorphologyFilter.Shape)((Object)SmartDilatingObjects.nonNull((Object)((Object)surelyDilationShape)));
        return this;
    }

    public int getSurelyDilationSize() {
        return this.surelyDilationSize;
    }

    public SmartDilatingObjects setSurelyDilationSize(int surelyDilationSize) {
        this.surelyDilationSize = SmartDilatingObjects.nonNegative((int)surelyDilationSize);
        return this;
    }

    public String getSurelyCustomPatternSpecification() {
        return this.surelyCustomPatternSpecification;
    }

    public SmartDilatingObjects setSurelyCustomPatternSpecification(String surelyCustomPatternSpecification) {
        this.surelyCustomPatternSpecification = surelyCustomPatternSpecification;
        return this;
    }

    public MorphologyFilter.Shape getUnlikelyErosionShape() {
        return this.unlikelyErosionShape;
    }

    public SmartDilatingObjects setUnlikelyErosionShape(MorphologyFilter.Shape unlikelyErosionShape) {
        this.unlikelyErosionShape = (MorphologyFilter.Shape)((Object)SmartDilatingObjects.nonNull((Object)((Object)unlikelyErosionShape)));
        return this;
    }

    public int getUnlikelyErosionSize() {
        return this.unlikelyErosionSize;
    }

    public SmartDilatingObjects setUnlikelyErosionSize(int unlikelyErosionSize) {
        this.unlikelyErosionSize = SmartDilatingObjects.nonNegative((int)unlikelyErosionSize);
        return this;
    }

    public String getUnlikelyCustomPatternSpecification() {
        return this.unlikelyCustomPatternSpecification;
    }

    public SmartDilatingObjects setUnlikelyCustomPatternSpecification(String unlikelyCustomPatternSpecification) {
        this.unlikelyCustomPatternSpecification = unlikelyCustomPatternSpecification;
        return this;
    }

    public MultiMatrix process(List<MultiMatrix> sources) {
        return this.process(sources.get(0) == null ? null : sources.get(0).asMultiMatrix2D(), sources.get(1) == null ? null : sources.get(1).asMultiMatrix2D(), sources.get(2) == null ? null : sources.get(2).asMultiMatrix2D());
    }

    public MultiMatrix2D process(MultiMatrix2D surely, MultiMatrix2D maybe, MultiMatrix2D unlikely) {
        Objects.requireNonNull(surely, "Null surely matrix");
        Objects.requireNonNull(maybe, "Null maybe matrix");
        surely = surely.nonZeroAnyChannel().clone();
        maybe = maybe.nonZeroAnyChannel().clone();
        MultiMatrix2D possibleInPrinciple = unlikely == null ? null : unlikely.zeroAllChannels().clone();
        StrictMorphology morphology = new StrictMorphology();
        morphology.setOperation(MorphologyOperation.DILATION);
        morphology.setContinuationMode(Matrix.ContinuationMode.ZERO_CONSTANT);
        morphology.setCustomPatternSpecification(this.surelyCustomPatternSpecification);
        morphology.setPattern(this.surelyDilationShape, this.surelyDilationSize);
        MultiMatrix2D dilatedSurely = morphology.process((MultiMatrix)surely).asMultiMatrix2D();
        FindConnectedWithMask findConnectedWithMask = new FindConnectedWithMask();
        findConnectedWithMask.setMode(RetainOrRemoveMode.RETAIN);
        findConnectedWithMask.setIncludeMaskInRetained(false);
        MultiMatrix2D result = findConnectedWithMask.process(Arrays.asList(maybe, surely));
        result = result.min(dilatedSurely);
        maybe = null;
        dilatedSurely = null;
        if (possibleInPrinciple != null) {
            morphology.setCustomPatternSpecification(this.unlikelyCustomPatternSpecification);
            morphology.setPattern(this.unlikelyErosionShape, this.unlikelyErosionSize);
            result = result.min(morphology.process((MultiMatrix)possibleInPrinciple).asMultiMatrix2D());
        }
        result = result.max(surely);
        return result;
    }

    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex == 2;
    }
}

