/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.morphology;

import java.util.Arrays;
import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannelFilter;
import net.algart.executors.modules.core.matrices.geometry.ContinuationMode;
import net.algart.executors.modules.cv.matrices.morphology.PatternSpecificationParser;
import net.algart.math.IRange;
import net.algart.math.Point;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.UniformGridPattern;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.ContinuedMorphology;
import net.algart.matrices.morphology.Morphology;

public abstract class MorphologyFilter
extends MultiMatrixChannelFilter {
    private static final int OPTIMIZED_CIRCLE_SIZE_STEP = 16;
    private static final double OPTIMIZED_CIRCLE_SIZE_BASE = 16.4;
    private Shape shape = Shape.SPHERE;
    private int patternSize = 3;
    private Pattern customPattern = null;
    private String customPatternSpecification = null;
    Matrix.ContinuationMode continuationMode = null;

    public final Pattern getPattern(Matrix<? extends PArray> m) {
        return this.getPattern(m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Pattern getPattern(Matrix<? extends PArray> m, boolean minkowskiOptimizeCircle) {
        int dimCount = m.dimCount();
        if (this.customPattern != null) {
            return this.customPattern;
        }
        long t1 = System.nanoTime();
        try {
            if (this.customPatternSpecification != null && !this.customPatternSpecification.isEmpty()) {
                PatternSpecificationParser parser = PatternSpecificationParser.getInstance(m.elementType());
                Pattern pattern = parser.parse(this.customPatternSpecification);
                return pattern;
            }
            if (minkowskiOptimizeCircle && this.shape == Shape.SPHERE && this.patternSize > 16) {
                Point origin = Point.origin((int)dimCount);
                UniformGridPattern baseSphere = Patterns.newSphereIntegerPattern((Point)origin, (double)Math.max(0.0, 8.2));
                UniformGridPattern baseSpherePlus1 = Patterns.newSphereIntegerPattern((Point)origin, (double)Math.max(0.0, 8.7));
                int multiplier = this.patternSize / 16;
                int remainder = this.patternSize % 16;
                if (remainder == 0) {
                    Pattern pattern = Patterns.newMinkowskiMultiplePattern((Pattern)baseSphere, (int)multiplier);
                    return pattern;
                }
                if (remainder == 1) {
                    UniformGridPattern result = baseSpherePlus1;
                    if (multiplier > 1) {
                        result = Patterns.newMinkowskiSum((Pattern[])new Pattern[]{Patterns.newMinkowskiMultiplePattern((Pattern)baseSphere, (int)(multiplier - 1)), result});
                    }
                    UniformGridPattern uniformGridPattern = result;
                    return uniformGridPattern;
                }
                UniformGridPattern additionalSphere = Patterns.newSphereIntegerPattern((Point)origin, (double)(0.5 * (double)remainder));
                Pattern pattern = Patterns.newMinkowskiSum((Pattern[])new Pattern[]{Patterns.newMinkowskiMultiplePattern((Pattern)baseSphere, (int)multiplier), additionalSphere});
                return pattern;
            }
            Pattern pattern = this.shape.newPattern(dimCount, this.patternSize);
            return pattern;
        }
        finally {
            long t2 = System.nanoTime();
            this.addServiceTime(t2 - t1);
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    public int getPatternSize() {
        return this.patternSize;
    }

    public final MorphologyFilter setPattern(Shape shape, int patternSize) {
        this.shape = Objects.requireNonNull(shape, "Null shape");
        this.patternSize = MorphologyFilter.nonNegative((int)patternSize, (String)"pattern size");
        return this;
    }

    public final MorphologyFilter setCustomPattern(Pattern pattern) {
        this.customPattern = pattern;
        return this;
    }

    public String getCustomPatternSpecification() {
        return this.customPatternSpecification;
    }

    public MorphologyFilter setCustomPatternSpecification(String customPatternSpecification) {
        this.customPatternSpecification = customPatternSpecification;
        return this;
    }

    public Matrix.ContinuationMode getContinuationMode() {
        return this.continuationMode;
    }

    public MorphologyFilter setContinuationMode(Matrix.ContinuationMode continuationMode) {
        this.continuationMode = continuationMode;
        return this;
    }

    public MorphologyFilter setContinuationMode(ContinuationMode continuationMode) {
        Objects.requireNonNull(continuationMode, "Null continuation mode");
        this.continuationMode = continuationMode.continuationModeOrNull();
        return this;
    }

    public void onChangeParameter(String name) {
        switch (name) {
            case "shape": {
                this.setPattern(Shape.of(this.parameters().getString(name).toUpperCase()), this.patternSize);
                break;
            }
            case "patternSize": {
                this.setPattern(this.shape, this.parameters().getInteger(name));
                break;
            }
            default: {
                super.onChangeParameter(name);
            }
        }
    }

    public Morphology createMorphology(Matrix<? extends PArray> m) {
        BasicMorphology morphology = BasicMorphology.getInstance(null);
        if (this.continuationMode != null) {
            morphology = ContinuedMorphology.getInstance((Morphology)morphology, (Matrix.ContinuationMode)this.continuationMode);
        }
        return morphology;
    }

    public static enum Shape {
        SPHERE(new String[]{"CIRCLE"}){

            @Override
            public Pattern newPattern(int numberOfDimensions, int patternSize) {
                return Patterns.newSphereIntegerPattern((Point)Point.origin((int)numberOfDimensions), (double)Math.max(0.0, 0.5 * (double)(patternSize + 1) - 0.2));
            }
        }
        ,
        CUBE(new String[]{"SQUARE"}){

            @Override
            public Pattern newPattern(int numberOfDimensions, int patternSize) {
                Object[] sides = new IRange[numberOfDimensions];
                Arrays.fill(sides, IRange.of((long)(-patternSize / 2), (long)(-patternSize / 2 + patternSize - 1)));
                return Patterns.newRectangularIntegerPattern((IRange[])sides);
            }
        };

        private final String[] alternameNames;

        private Shape(String ... alternameNames) {
            this.alternameNames = alternameNames;
        }

        public abstract Pattern newPattern(int var1, int var2);

        public static Shape of(String name) {
            for (Shape shape : Shape.values()) {
                if (shape.name().equals(name)) {
                    return shape;
                }
                for (String alternateName : shape.alternameNames) {
                    if (!alternateName.equals(name)) continue;
                    return shape;
                }
            }
            throw new IllegalArgumentException("Unknown shape name " + name);
        }
    }
}

