/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

class LibSpheres {
    double s1x;
    double s1y;
    double s1z;
    double s1r;
    double s2x;
    double s2y;
    double s2z;
    double s2r;
    double s3x;
    double s3y;
    double s3z;
    double s3r;
    double p1nx;
    double p1ny;
    double p1nz;
    double p1v;
    private double ix;
    private double iy;
    private double iz;
    private double isqr;
    private double r1sqr;
    private double P;
    public int icnt = 0;
    public int icntfirst = 0;
    public double isx0;
    public double isy0;
    public double isz0;
    public double isx1;
    public double isy1;
    public double isz1;
    public double isspx0;
    public double isspy0;
    public double isspz0;
    public double isspx1;
    public double isspy1;
    public double isspz1;
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    double zmin;
    double zmax;
    public double iSphStraight0;
    public double iSphStraight1;
    public double iSphStraightDN0;
    public double iSphStraightDN1;

    LibSpheres() {
    }

    public boolean intersection_3_spheres(boolean FirstCallForS1andS2) {
        double ij;
        double jz;
        double jy;
        double jx;
        double jsqr;
        double D;
        ++this.icnt;
        if (FirstCallForS1andS2) {
            ++this.icntfirst;
            this.ix = this.s2x - this.s1x;
            this.iy = this.s2y - this.s1y;
            this.iz = this.s2z - this.s1z;
            this.isqr = this.ix * this.ix + this.iy * this.iy + this.iz * this.iz;
            this.r1sqr = this.s1r * this.s1r;
            this.P = this.r1sqr - this.s2r * this.s2r + this.isqr;
        }
        if ((D = this.isqr * (jsqr = (jx = this.s3x - this.s1x) * jx + (jy = this.s3y - this.s1y) * jy + (jz = this.s3z - this.s1z) * jz) - (ij = this.ix * jx + this.iy * jy + this.iz * jz) * ij) <= 1.0E-6 * this.r1sqr) {
            return false;
        }
        double Q = this.r1sqr - this.s3r * this.s3r + jsqr;
        double Dinv = 1.0 / D;
        double temp1 = Dinv * 0.5;
        double a = (this.P * jsqr - Q * ij) * temp1;
        double b = (Q * this.isqr - this.P * ij) * temp1;
        double xc = a * this.ix + b * jx;
        double yc = a * this.iy + b * jy;
        double zc = a * this.iz + b * jz;
        double csqr = (this.r1sqr - (xc * xc + yc * yc + zc * zc)) * Dinv;
        if (csqr < 0.0) {
            return false;
        }
        double c = Math.sqrt(csqr);
        double kxmulc = (this.iy * jz - this.iz * jy) * c;
        double kymulc = (this.iz * jx - this.ix * jz) * c;
        double kzmulc = (this.ix * jy - this.iy * jx) * c;
        this.isx0 = (xc += this.s1x) + kxmulc;
        this.isx1 = xc - kxmulc;
        this.isy0 = (yc += this.s1y) + kymulc;
        this.isy1 = yc - kymulc;
        this.isz0 = (zc += this.s1z) + kzmulc;
        this.isz1 = zc - kzmulc;
        return true;
    }

    public boolean intersection_sphere_sphere_plane() {
        double v1 = this.p1v - this.s1x * this.p1nx - this.s1y * this.p1ny - this.s1z * this.p1nz;
        double pr1sqr = this.s1r * this.s1r - v1 * v1;
        if (pr1sqr <= 0.0) {
            return false;
        }
        double v2 = this.p1v - this.s2x * this.p1nx - this.s2y * this.p1ny - this.s2z * this.p1nz;
        double pr2sqr = this.s2r * this.s2r - v2 * v2;
        if (pr2sqr <= 0.0) {
            return false;
        }
        double Ax = this.s1x + v1 * this.p1nx;
        double ABx = this.s2x + v2 * this.p1nx - Ax;
        double Ay = this.s1y + v1 * this.p1ny;
        double ABy = this.s2y + v2 * this.p1ny - Ay;
        double Az = this.s1z + v1 * this.p1nz;
        double ABz = this.s2z + v2 * this.p1nz - Az;
        double dsqr = ABx * ABx + ABy * ABy + ABz * ABz;
        double d = Math.sqrt(dsqr);
        if (d <= 0.001 * this.s1r) {
            return false;
        }
        double dinv = 1.0 / d;
        double a = (pr1sqr - pr2sqr + dsqr) * 0.5 * dinv;
        double bsqr = pr1sqr - a * a;
        if (bsqr <= 0.0) {
            return false;
        }
        double b = Math.sqrt(bsqr);
        double ix = ABx * dinv;
        double iy = ABy * dinv;
        double iz = ABz * dinv;
        double jxmulb = (iy * this.p1nz - iz * this.p1ny) * b;
        double jymulb = (iz * this.p1nx - ix * this.p1nz) * b;
        double jzmulb = (ix * this.p1ny - iy * this.p1nx) * b;
        double Hx = Ax + a * ix;
        this.isspx0 = Hx + jxmulb;
        this.isspx1 = Hx - jxmulb;
        double Hy = Ay + a * iy;
        this.isspy0 = Hy + jymulb;
        this.isspy1 = Hy - jymulb;
        double Hz = Az + a * iz;
        this.isspz0 = Hz + jzmulb;
        this.isspz1 = Hz - jzmulb;
        return true;
    }

    public void containing_parallelepiped_S1() {
        this.xmin = this.s1x - this.s1r;
        this.xmax = this.s1x + this.s1r;
        this.ymin = this.s1y - this.s1r;
        this.ymax = this.s1y + this.s1r;
        this.zmin = this.s1z - this.s1r;
        this.zmax = this.s1z + this.s1r;
    }

    public void containing_parallelepiped_S2() {
        this.xmin = this.s2x - this.s2r;
        this.xmax = this.s2x + this.s2r;
        this.ymin = this.s2y - this.s2r;
        this.ymax = this.s2y + this.s2r;
        this.zmin = this.s2z - this.s2r;
        this.zmax = this.s2z + this.s2r;
    }

    public void containing_parallelepiped_S3() {
        this.xmin = this.s3x - this.s3r;
        this.xmax = this.s3x + this.s3r;
        this.ymin = this.s3y - this.s3r;
        this.ymax = this.s3y + this.s3r;
        this.zmin = this.s3z - this.s3r;
        this.zmax = this.s3z + this.s3r;
    }

    public boolean intersection_sphere_and_straight(double x, double y, double z, double r, double x0, double y0, double z0, double dx, double dy, double dz, boolean findFirstPoint, boolean findScalarProductionDN) {
        double C;
        double discr;
        double P = (x -= x0) * dx + (y -= y0) * dy + (z -= z0) * dz;
        double A = dx * dx + dy * dy + dz * dz;
        if ((discr = P * P - A * (C = x * x + y * y + z * z - r * r)) <= 0.0) {
            return false;
        }
        double sqrtdiscr = Math.sqrt(discr);
        this.iSphStraight1 = (P + sqrtdiscr) / A;
        if (findFirstPoint) {
            this.iSphStraight0 = (P - sqrtdiscr) / A;
        }
        if (findScalarProductionDN) {
            if (findFirstPoint) {
                this.iSphStraightDN0 = -sqrtdiscr / r;
            }
            this.iSphStraightDN1 = sqrtdiscr / r;
        }
        return true;
    }

    public static boolean areSpheresIntersected(double x1, double y1, double z1, double r1, double x2, double y2, double z2, double r2) {
        double x12 = x1 - x2;
        double y12 = y1 - y2;
        double z12 = z1 - z2;
        double r12 = r1 + r2;
        return x12 * x12 + y12 * y12 + z12 * z12 < r12 * r12 * 0.9999;
    }

    public static boolean isPointInSphere(double xp, double yp, double zp, double x, double y, double z, double r) {
        double dx = xp - x;
        double dy = yp - y;
        double dz = zp - z;
        return dx * dx + dy * dy + dz * dz < r * r * 0.9999;
    }

    public static double intersection2SpheresVolume(double x1, double y1, double z1, double r1, double x2, double y2, double z2, double r2) {
        double d = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
        if (r1 + r2 <= d * 1.00001) {
            return 0.0;
        }
        if (d + r1 <= r2) {
            return 4.1887902047863905 * r1 * r1 * r1;
        }
        if (d + r2 <= r1) {
            return 4.1887902047863905 * r2 * r2 * r2;
        }
        if (r1 > r2) {
            double temp = r1;
            r1 = r2;
            r2 = temp;
        }
        double d1 = (r1 * r1 - r2 * r2 + d * d) / (2.0 * d);
        double d2 = d - d1;
        double rsqr = r1 * r1 - d1 * d1;
        double h1 = r1 - d1;
        double h2 = r2 - d2;
        double segment1 = 0.5235987755982988 * h1 * (3.0 * rsqr + h1 * h1);
        double segment2 = 0.5235987755982988 * h2 * (3.0 * rsqr + h2 * h2);
        return segment1 + segment2;
    }

    public static double intersection2SpheresArea(double x1, double y1, double z1, double r1, double x2, double y2, double z2, double r2) {
        double d = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
        if (r1 + r2 <= d * 1.00001) {
            return 0.0;
        }
        if (d + r1 <= r2) {
            return Math.PI * r1 * r1;
        }
        if (d + r2 <= r1) {
            return Math.PI * r2 * r2;
        }
        if (r1 > r2) {
            double temp = r1;
            r1 = r2;
            r2 = temp;
        }
        double d1 = (r1 * r1 - r2 * r2 + d * d) / (2.0 * d);
        return Math.PI * (r1 * r1 - d1 * d1);
    }

    public static double intersectionSpherePlainArea(double x, double y, double z, double r, double pnx, double pny, double pnz, double pv) {
        double d = pv - x * pnx - y * pny - z * pnz;
        if (d < 0.0) {
            d = -d;
        }
        if (r <= d * 1.00001) {
            return 0.0;
        }
        return Math.PI * (r * r - d * d);
    }
}

