/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import net.algart.model3d.spherepolyhedra.objects.Polynom;

class LibCylinders {
    double c1x;
    double c1y;
    double c1z;
    double c1gx;
    double c1gy;
    double c1gz;
    double c1r;
    double c2x;
    double c2y;
    double c2z;
    double c2gx;
    double c2gy;
    double c2gz;
    double c2r;
    double c3x;
    double c3y;
    double c3z;
    double c3gx;
    double c3gy;
    double c3gz;
    double c3r;
    double s1x;
    double s1y;
    double s1z;
    double s1r;
    double s2x;
    double s2y;
    double s2z;
    double s2r;
    double p1nx;
    double p1ny;
    double p1nz;
    double p1x;
    double p1y;
    double p1z;
    public double polyFactorTol = 100000.0;
    public double polyValueTol = 100.0;
    public double polyRootTol = 100.0;
    public double[] iXYZ = new double[48];
    public double[] debugMaxDist = new double[16];
    public int iCount = 0;
    private Polynom a = new Polynom();
    private Polynom b1 = new Polynom();
    private Polynom b2 = new Polynom();
    private Polynom c1 = new Polynom();
    private Polynom c2 = new Polynom();
    private Polynom bc = new Polynom();
    private Polynom db = new Polynom();
    private Polynom dc = new Polynom();
    private Polynom p = new Polynom();
    private Polynom[] d = new Polynom[9];
    private double[] roots;
    private int XYZofs;
    private double polyRootDist = 0.0;
    private double polyFactorEps = 0.0;
    private double polyValueEps = 0.0;
    private double _v1x;
    private double _v1y;
    private double _v1z;
    private double _len1;
    private boolean chkC1;
    private double _v2x;
    private double _v2y;
    private double _v2z;
    private double _len2;
    private boolean chkC2;
    private double _v3x;
    private double _v3y;
    private double _v3z;
    private double _len3;
    private boolean chkC3;
    private double _p1x;
    private double _p1y;
    private double _p1z;
    private double _p2x;
    private double _p2y;
    private double _p2z;
    private double _p3x;
    private double _p3y;
    private double _p3z;
    private double _r1;
    private double _r2;
    private double _r3;
    private double _vix;
    private double _viy;
    private double _viz;
    private double _vjx;
    private double _vjy;
    private double _vjz;
    private double _vkx;
    private double _vky;
    private double _vkz;
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    double zmin;
    double zmax;

    public LibCylinders() {
        for (int i = 0; i < 9; ++i) {
            this.d[i] = new Polynom();
        }
        this.roots = new double[12];
        this.a.poly4(1.0, 0.0, 2.0, 0.0, 1.0);
        this.libCylindersInit();
    }

    public void libCylindersInit() {
        this.p.rootTol = this.polyRootTol;
        this.p.factorTol = this.polyFactorTol;
        this.p.valueTol = this.polyValueTol;
        this.p.polynomInit();
        this.b2.rootTol = this.polyRootTol;
        this.b2.factorTol = this.polyFactorTol;
        this.b2.valueTol = this.polyValueTol;
        this.b2.polynomInit();
        this.c2.rootTol = this.polyRootTol;
        this.c2.factorTol = this.polyFactorTol;
        this.c2.valueTol = this.polyValueTol;
        this.c2.polynomInit();
        this.polyRootDist = this.polyRootTol * Polynom.machEpsSqrt;
        this.polyFactorEps = this.polyFactorTol * Polynom.machEps;
        this.polyValueEps = this.polyValueTol * Polynom.machEpsSqrt;
    }

    public double dist2cylinder(double px, double py, double pz, double cgx, double cgy, double cgz, double cpx, double cpy, double cpz, double cR) {
        double dpx = px - cpx;
        double dpy = py - cpy;
        double dpz = pz - cpz;
        double len2 = cgx * cgx + cgy * cgy + cgz * cgz;
        double vpx = cgy * dpz - cgz * dpy;
        double vpy = cgz * dpx - cgx * dpz;
        double vpz = cgx * dpy - cgy * dpx;
        return Math.sqrt((vpx * vpx + vpy * vpy + vpz * vpz) / len2) - cR;
    }

    public double dist2sphere(double px, double py, double pz, double spx, double spy, double spz, double sR) {
        double dpx = px - spx;
        double dpy = py - spy;
        double dpz = pz - spz;
        return Math.sqrt(dpx * dpx + dpy * dpy + dpz * dpz) - sR;
    }

    public double dist2plane(double px, double py, double pz, double pnx, double pny, double pnz, double ppx, double ppy, double ppz) {
        double dpx = px - ppx;
        double dpy = py - ppy;
        double dpz = pz - ppz;
        return pnx * dpx + pny * dpy + pnz * dpz;
    }

    public boolean intersection_3_cylinders() {
        int i;
        this.iCount = 0;
        this._v1x = this.c1gx;
        this._v1y = this.c1gy;
        this._v1z = this.c1gz;
        this._p1x = this.c1x;
        this._p1y = this.c1y;
        this._p1z = this.c1z;
        this._r1 = this.c1r;
        this.chkC1 = true;
        this._v2x = this.c2gx;
        this._v2y = this.c2gy;
        this._v2z = this.c2gz;
        this._p2x = this.c2x;
        this._p2y = this.c2y;
        this._p2z = this.c2z;
        this._r2 = this.c2r;
        this.chkC2 = true;
        this._v3x = this.c3gx;
        this._v3y = this.c3gy;
        this._v3z = this.c3gz;
        this._p3x = this.c3x;
        this._p3y = this.c3y;
        this._p3z = this.c3z;
        this._r3 = this.c3r;
        this.chkC3 = true;
        this._len1 = Math.sqrt(this._v1x * this._v1x + this._v1y * this._v1y + this._v1z * this._v1z);
        if (this._len1 == 0.0) {
            return false;
        }
        double scale = 1.0 / this._len1;
        this._v1x *= scale;
        this._v1y *= scale;
        this._v1z *= scale;
        this._len2 = Math.sqrt(this._v2x * this._v2x + this._v2y * this._v2y + this._v2z * this._v2z);
        if (this._len2 == 0.0) {
            return false;
        }
        scale = 1.0 / this._len2;
        this._v2x *= scale;
        this._v2y *= scale;
        this._v2z *= scale;
        this._len3 = Math.sqrt(this._v3x * this._v3x + this._v3y * this._v3y + this._v3z * this._v3z);
        if (this._len3 == 0.0) {
            return false;
        }
        scale = 1.0 / this._len3;
        this._v3x *= scale;
        this._v3y *= scale;
        this._v3z *= scale;
        this.xyz2ijk();
        scale = this._v2x * this._p2x + this._v2y * this._p2y + this._v2z * this._p2z;
        double fa1 = (1.0 - this._v2x) * (1.0 + this._v2x);
        double fb = (1.0 - this._v2y) * (1.0 + this._v2y) * this._r1 * this._r1;
        double fc = (1.0 - this._v2z) * (1.0 + this._v2z) * this._r1 * this._r1;
        double fd = -this._v2x * this._v2y * this._r1;
        double fe = -this._v2x * this._v2z * this._r1;
        double ff = -this._v2y * this._v2z * this._r1 * this._r1;
        double fg = scale * this._v2x - this._p2x;
        double fh = (scale * this._v2y - this._p2y) * this._r1;
        double fi = (scale * this._v2z - this._p2z) * this._r1;
        double fj = this._p2x * this._p2x + this._p2y * this._p2y + this._p2z * this._p2z - scale * scale - this._r2 * this._r2;
        this.b1.poly4(2.0 * fg + 2.0 * fe, 4.0 * fd, 4.0 * fg, 4.0 * fd, 2.0 * fg - 2.0 * fe);
        this.c1.poly4(fj + 2.0 * fi + fc, 4.0 * fh + 4.0 * ff, 2.0 * fj - 2.0 * fc + 4.0 * fb, 4.0 * fh - 4.0 * ff, fj - 2.0 * fi + fc);
        scale = this._v3x * this._p3x + this._v3y * this._p3y + this._v3z * this._p3z;
        double fa2 = (1.0 - this._v3x) * (1.0 + this._v3x);
        fb = (1.0 - this._v3y) * (1.0 + this._v3y) * this._r1 * this._r1;
        fc = (1.0 - this._v3z) * (1.0 + this._v3z) * this._r1 * this._r1;
        fd = -this._v3x * this._v3y * this._r1;
        fe = -this._v3x * this._v3z * this._r1;
        ff = -this._v3y * this._v3z * this._r1 * this._r1;
        fg = scale * this._v3x - this._p3x;
        fh = (scale * this._v3y - this._p3y) * this._r1;
        fi = (scale * this._v3z - this._p3z) * this._r1;
        fj = this._p3x * this._p3x + this._p3y * this._p3y + this._p3z * this._p3z - scale * scale - this._r3 * this._r3;
        this.b2.poly4(2.0 * fg + 2.0 * fe, 4.0 * fd, 4.0 * fg, 4.0 * fd, 2.0 * fg - 2.0 * fe);
        this.c2.poly4(fj + 2.0 * fi + fc, 4.0 * fh + 4.0 * ff, 2.0 * fj - 2.0 * fc + 4.0 * fb, 4.0 * fh - 4.0 * ff, fj - 2.0 * fi + fc);
        if (fa2 > fa1) {
            fj = fa1;
            fa1 = fa2;
            fa2 = fj;
            this.b1.copyTo(this.d[0]);
            this.b2.copyTo(this.b1);
            this.d[0].copyTo(this.b2);
            this.c1.copyTo(this.d[0]);
            this.c2.copyTo(this.c1);
            this.d[0].copyTo(this.c2);
        }
        if (Math.abs(fa1) <= this.polyFactorEps) {
            return false;
        }
        this.d[0].prod(this.b1, this.c2);
        this.d[1].prod(this.b2, this.c1);
        this.bc.diff(this.d[0], this.d[1]);
        this.d[0].prod(this.b1, fa2);
        this.d[1].prod(this.b2, fa1);
        this.b2.diff(this.d[0], this.d[1]);
        this.d[0].prod(this.c1, fa2);
        this.d[1].prod(this.c2, fa1);
        this.c2.diff(this.d[0], this.d[1]);
        if (this.b2.checkDegeneracy()) {
            if (this.c2.checkDegeneracy()) {
                return false;
            }
            this.c2.copyTo(this.p);
        } else {
            this.d[0].prod(this.c2, this.c2);
            this.d[1].prod(this.a, this.d[0]);
            this.d[2].prod(this.bc, this.b2);
            this.p.sum(this.d[1], this.d[2]);
        }
        int nilp = this.p.reduction();
        if (this.p.N == 0) {
            return false;
        }
        this.p.normalize();
        int nroots = this.p.findRoots(this.d, this.roots);
        if (nilp != 0) {
            this.roots[nroots] = 0.0;
            ++nroots;
        }
        this.XYZofs = 0;
        block4: for (i = 0; i < nroots; ++i) {
            fj = this.roots[i];
            scale = this._r1 / (1.0 + fj * fj);
            fh = 2.0 * fj * scale;
            fi = (1.0 - fj) * (1.0 + fj) * scale;
            fb = this.b2.value(fj);
            if (Math.abs(fb) > this.polyValueEps) {
                fg = -this.c2.value(fj) / fb;
                this.addPoint(fg, fh, fi);
                continue;
            }
            fd = this.a.value(fj) * fa1;
            switch (this.p.rootsP2(this.b1.value(fj) / fd, this.c1.value(fj) / fd, this.iXYZ, this.XYZofs)) {
                case 1: {
                    this.addPoint(this.iXYZ[this.XYZofs], fh, fi);
                    continue block4;
                }
                case 2: {
                    fg = this.iXYZ[this.XYZofs + 1];
                    this.addPoint(this.iXYZ[this.XYZofs], fh, fi);
                    this.addPoint(fg, fh, fi);
                }
            }
        }
        for (i = 0; i < this.iCount; ++i) {
            double x = this.iXYZ[3 * i];
            double y = this.iXYZ[3 * i + 1];
            double z = this.iXYZ[3 * i + 2];
            this.debugMaxDist[i] = Math.max(this.dist2cylinder(x, y, z, this.c1gx, this.c1gy, this.c1gz, this.c1x, this.c1y, this.c1z, this.c1r), Math.max(this.dist2cylinder(x, y, z, this.c2gx, this.c2gy, this.c2gz, this.c2x, this.c2y, this.c2z, this.c2r), this.dist2cylinder(x, y, z, this.c3gx, this.c3gy, this.c3gz, this.c3x, this.c3y, this.c3z, this.c3r)));
        }
        return this.iCount > 0;
    }

    public boolean intersection_cylinder_cylinder_sphere() {
        int i;
        this.iCount = 0;
        this._v1x = this.c1gx;
        this._v1y = this.c1gy;
        this._v1z = this.c1gz;
        this._p1x = this.c1x;
        this._p1y = this.c1y;
        this._p1z = this.c1z;
        this._r1 = this.c1r;
        this.chkC1 = true;
        this._v2x = this.c2gx;
        this._v2y = this.c2gy;
        this._v2z = this.c2gz;
        this._p2x = this.c2x;
        this._p2y = this.c2y;
        this._p2z = this.c2z;
        this._r2 = this.c2r;
        this.chkC2 = true;
        this._p3x = this.s1x;
        this._p3y = this.s1y;
        this._p3z = this.s1z;
        this._r3 = this.s1r;
        this.chkC3 = false;
        this._len1 = Math.sqrt(this._v1x * this._v1x + this._v1y * this._v1y + this._v1z * this._v1z);
        if (this._len1 == 0.0) {
            return false;
        }
        double scale = 1.0 / this._len1;
        this._v1x *= scale;
        this._v1y *= scale;
        this._v1z *= scale;
        this._len2 = Math.sqrt(this._v2x * this._v2x + this._v2y * this._v2y + this._v2z * this._v2z);
        if (this._len2 == 0.0) {
            return false;
        }
        scale = 1.0 / this._len2;
        this._v2x *= scale;
        this._v2y *= scale;
        this._v2z *= scale;
        this.xyz2ijk();
        double fb = this._r1 * this._r1;
        double fc = this._r1 * this._r1;
        double fg = -this._p3x;
        double fh = -this._p3y * this._r1;
        double fi = -this._p3z * this._r1;
        double fj = this._p3x * this._p3x + this._p3y * this._p3y + this._p3z * this._p3z - this._r3 * this._r3;
        this.b1.poly4(2.0 * fg, 0.0, 4.0 * fg, 0.0, 2.0 * fg);
        this.c1.poly4(fj + 2.0 * fi + fc, 4.0 * fh, 2.0 * fj - 2.0 * fc + 4.0 * fb, 4.0 * fh, fj - 2.0 * fi + fc);
        scale = this._v2x * this._p2x + this._v2y * this._p2y + this._v2z * this._p2z;
        double fa2 = (1.0 - this._v2x) * (1.0 + this._v2x);
        fb = (1.0 - this._v2y) * (1.0 + this._v2y) * this._r1 * this._r1;
        fc = (1.0 - this._v2z) * (1.0 + this._v2z) * this._r1 * this._r1;
        double fd = -this._v2x * this._v2y * this._r1;
        double fe = -this._v2x * this._v2z * this._r1;
        double ff = -this._v2y * this._v2z * this._r1 * this._r1;
        fg = scale * this._v2x - this._p2x;
        fh = (scale * this._v2y - this._p2y) * this._r1;
        fi = (scale * this._v2z - this._p2z) * this._r1;
        fj = this._p2x * this._p2x + this._p2y * this._p2y + this._p2z * this._p2z - scale * scale - this._r2 * this._r2;
        this.b2.poly4(2.0 * fg + 2.0 * fe, 4.0 * fd, 4.0 * fg, 4.0 * fd, 2.0 * fg - 2.0 * fe);
        this.c2.poly4(fj + 2.0 * fi + fc, 4.0 * fh + 4.0 * ff, 2.0 * fj - 2.0 * fc + 4.0 * fb, 4.0 * fh - 4.0 * ff, fj - 2.0 * fi + fc);
        this.d[0].prod(this.b1, this.c2);
        this.d[1].prod(this.b2, this.c1);
        this.bc.diff(this.d[0], this.d[1]);
        this.d[0].prod(this.b1, fa2);
        this.b2.diff(this.d[0], this.b2);
        this.d[0].prod(this.c1, fa2);
        this.c2.diff(this.d[0], this.c2);
        if (this.b2.checkDegeneracy()) {
            if (this.c2.checkDegeneracy()) {
                return false;
            }
            this.c2.copyTo(this.p);
        } else {
            this.d[0].prod(this.c2, this.c2);
            this.d[1].prod(this.a, this.d[0]);
            this.d[2].prod(this.bc, this.b2);
            this.p.sum(this.d[1], this.d[2]);
        }
        int nilp = this.p.reduction();
        if (this.p.N == 0) {
            return false;
        }
        this.p.normalize();
        int nroots = this.p.findRoots(this.d, this.roots);
        if (nilp != 0) {
            this.roots[nroots] = 0.0;
            ++nroots;
        }
        this.XYZofs = 0;
        block4: for (i = 0; i < nroots; ++i) {
            fj = this.roots[i];
            scale = this._r1 / (1.0 + fj * fj);
            fh = 2.0 * fj * scale;
            fi = (1.0 - fj) * (1.0 + fj) * scale;
            fb = this.b2.value(fj);
            if (Math.abs(fb) > this.polyValueEps) {
                fg = -this.c2.value(fj) / fb;
                this.addPoint(fg, fh, fi);
                continue;
            }
            fd = this.a.value(fj);
            switch (this.p.rootsP2(this.b1.value(fj) / fd, this.c1.value(fj) / fd, this.iXYZ, this.XYZofs)) {
                case 1: {
                    this.addPoint(this.iXYZ[this.XYZofs], fh, fi);
                    continue block4;
                }
                case 2: {
                    fg = this.iXYZ[this.XYZofs + 1];
                    this.addPoint(this.iXYZ[this.XYZofs], fh, fi);
                    this.addPoint(fg, fh, fi);
                }
            }
        }
        for (i = 0; i < this.iCount; ++i) {
            double x = this.iXYZ[3 * i];
            double y = this.iXYZ[3 * i + 1];
            double z = this.iXYZ[3 * i + 2];
            this.debugMaxDist[i] = Math.max(this.dist2cylinder(x, y, z, this.c1gx, this.c1gy, this.c1gz, this.c1x, this.c1y, this.c1z, this.c1r), Math.max(this.dist2cylinder(x, y, z, this.c2gx, this.c2gy, this.c2gz, this.c2x, this.c2y, this.c2z, this.c2r), this.dist2sphere(x, y, z, this.s1x, this.s1y, this.s1z, this.s1r)));
        }
        return this.iCount > 0;
    }

    public boolean intersection_cylinder_cylinder_plane() {
        int i;
        this.iCount = 0;
        this._v1x = this.p1nx;
        this._v1y = this.p1ny;
        this._v1z = this.p1nz;
        this._p1x = this.p1x;
        this._p1y = this.p1y;
        this._p1z = this.p1z;
        this.chkC1 = false;
        this._v2x = this.c1gx;
        this._v2y = this.c1gy;
        this._v2z = this.c1gz;
        this._p2x = this.c1x;
        this._p2y = this.c1y;
        this._p2z = this.c1z;
        this._r2 = this.c1r;
        this.chkC2 = true;
        this._v3x = this.c2gx;
        this._v3y = this.c2gy;
        this._v3z = this.c2gz;
        this._p3x = this.c2x;
        this._p3y = this.c2y;
        this._p3z = this.c2z;
        this._r3 = this.c2r;
        this.chkC3 = true;
        this._len2 = Math.sqrt(this._v2x * this._v2x + this._v2y * this._v2y + this._v2z * this._v2z);
        if (this._len2 == 0.0) {
            return false;
        }
        double scale = 1.0 / this._len2;
        this._v2x *= scale;
        this._v2y *= scale;
        this._v2z *= scale;
        this._len3 = Math.sqrt(this._v3x * this._v3x + this._v3y * this._v3y + this._v3z * this._v3z);
        if (this._len3 == 0.0) {
            return false;
        }
        scale = 1.0 / this._len3;
        this._v3x *= scale;
        this._v3y *= scale;
        this._v3z *= scale;
        this.xyz2ijk();
        scale = this._v2x * this._p2x + this._v2y * this._p2y + this._v2z * this._p2z;
        double fb1 = (1.0 - this._v2y) * (1.0 + this._v2y);
        double fc = (1.0 - this._v2z) * (1.0 + this._v2z);
        double ff = -this._v2y * this._v2z;
        double fh = scale * this._v2y - this._p2y;
        double fi = scale * this._v2z - this._p2z;
        double fj = this._p2x * this._p2x + this._p2y * this._p2y + this._p2z * this._p2z - scale * scale - this._r2 * this._r2;
        this.b1.poly1(2.0 * fh, 2.0 * ff);
        this.c1.poly2(fj, 2.0 * fi, fc);
        scale = this._v3x * this._p3x + this._v3y * this._p3y + this._v3z * this._p3z;
        double fb2 = (1.0 - this._v3y) * (1.0 + this._v3y);
        fc = (1.0 - this._v3z) * (1.0 + this._v3z);
        ff = -this._v3y * this._v3z;
        fh = scale * this._v3y - this._p3y;
        fi = scale * this._v3z - this._p3z;
        fj = this._p3x * this._p3x + this._p3y * this._p3y + this._p3z * this._p3z - scale * scale - this._r3 * this._r3;
        this.b2.poly1(2.0 * fh, 2.0 * ff);
        this.c2.poly2(fj, 2.0 * fi, fc);
        if (fb2 > fb1) {
            fj = fb1;
            fb1 = fb2;
            fb2 = fj;
            this.b1.copyTo(this.d[0]);
            this.b2.copyTo(this.b1);
            this.d[0].copyTo(this.b2);
            this.c1.copyTo(this.d[0]);
            this.c2.copyTo(this.c1);
            this.d[0].copyTo(this.c2);
        }
        if (Math.abs(fb1) <= this.polyFactorEps) {
            return false;
        }
        this.d[0].prod(this.b1, this.c2);
        this.d[1].prod(this.b2, this.c1);
        this.bc.diff(this.d[0], this.d[1]);
        this.d[0].prod(this.b1, fb2);
        this.d[1].prod(this.b2, fb1);
        this.b2.diff(this.d[0], this.d[1]);
        this.d[0].prod(this.c1, fb2);
        this.d[1].prod(this.c2, fb1);
        this.c2.diff(this.d[0], this.d[1]);
        if (this.b2.checkDegeneracy()) {
            if (this.c2.checkDegeneracy()) {
                return false;
            }
            this.c2.copyTo(this.p);
        } else {
            this.d[0].prod(this.c2, this.c2);
            this.d[1].prod(this.bc, this.b2);
            this.p.sum(this.d[0], this.d[1]);
        }
        int nilp = this.p.reduction();
        if (this.p.N == 0) {
            return false;
        }
        this.p.normalize();
        int nroots = this.p.findRoots(this.d, this.roots);
        if (nilp != 0) {
            this.roots[nroots] = 0.0;
            ++nroots;
        }
        this.XYZofs = 0;
        block4: for (i = 0; i < nroots; ++i) {
            fi = this.roots[i];
            fc = this.b2.value(fi);
            if (Math.abs(fc) > this.polyValueEps) {
                fj = -this.c2.value(fi) / fc;
                this.addPoint(0.0, fj, fi);
                continue;
            }
            switch (this.p.rootsP2(this.b1.value(fi) / fb1, this.c1.value(fi) / fb1, this.iXYZ, this.XYZofs)) {
                case 1: {
                    this.addPoint(0.0, this.iXYZ[this.XYZofs], fi);
                    continue block4;
                }
                case 2: {
                    fj = this.iXYZ[this.XYZofs + 1];
                    this.addPoint(0.0, this.iXYZ[this.XYZofs], fi);
                    this.addPoint(0.0, fj, fi);
                }
            }
        }
        for (i = 0; i < this.iCount; ++i) {
            double x = this.iXYZ[3 * i];
            double y = this.iXYZ[3 * i + 1];
            double z = this.iXYZ[3 * i + 2];
            this.debugMaxDist[i] = Math.max(this.dist2plane(x, y, z, this.p1nx, this.p1ny, this.p1nz, this.p1x, this.p1y, this.p1z), Math.max(this.dist2cylinder(x, y, z, this.c1gx, this.c1gy, this.c1gz, this.c1x, this.c1y, this.c1z, this.c1r), this.dist2cylinder(x, y, z, this.c2gx, this.c2gy, this.c2gz, this.c2x, this.c2y, this.c2z, this.c2r)));
        }
        return this.iCount > 0;
    }

    public boolean intersection_cylinder_sphere_sphere() {
        int i;
        this.iCount = 0;
        double dcx = this.s2x - this.s1x;
        double dcy = this.s2y - this.s1y;
        double dcz = this.s2z - this.s1z;
        double d2 = dcx * dcx + dcy * dcy + dcz * dcz;
        if (d2 == 0.0) {
            return false;
        }
        double scale = 1.0 / Math.sqrt(d2);
        d2 = (d2 + this.s1r * this.s1r - this.s2r * this.s2r) / (2.0 * d2);
        this._v1x = dcx * scale;
        this._p1x = this.s1x + d2 * dcx;
        this._v1y = dcy * scale;
        this._p1y = this.s1y + d2 * dcy;
        this._v1z = dcz * scale;
        this._p1z = this.s1z + d2 * dcz;
        this.chkC1 = false;
        this._p2x = this.s2x;
        this._p2y = this.s2y;
        this._p2z = this.s2z;
        this._r2 = this.s2r;
        this.chkC2 = false;
        this._v3x = this.c1gx;
        this._v3y = this.c1gy;
        this._v3z = this.c1gz;
        this._p3x = this.c1x;
        this._p3y = this.c1y;
        this._p3z = this.c1z;
        this._r3 = this.c1r;
        this.chkC3 = true;
        this._len3 = Math.sqrt(this._v3x * this._v3x + this._v3y * this._v3y + this._v3z * this._v3z);
        if (this._len3 == 0.0) {
            return false;
        }
        scale = 1.0 / this._len3;
        this._v3x *= scale;
        this._v3y *= scale;
        this._v3z *= scale;
        this.xyz2ijk();
        if (Math.abs(this._p2x) >= this._r2) {
            return false;
        }
        double fh1 = -this._p2y;
        double fi = -this._p2z;
        double fj = this._p2x * this._p2x + this._p2y * this._p2y + this._p2z * this._p2z - this._r2 * this._r2;
        this.c1.poly2(fj, 2.0 * fi, 1.0);
        scale = this._v3x * this._p3x + this._v3y * this._p3y + this._v3z * this._p3z;
        double fb2 = (1.0 - this._v3y) * (1.0 + this._v3y);
        double fc = (1.0 - this._v3z) * (1.0 + this._v3z);
        double ff = -this._v3y * this._v3z;
        double fh = scale * this._v3y - this._p3y;
        fi = scale * this._v3z - this._p3z;
        fj = this._p3x * this._p3x + this._p3y * this._p3y + this._p3z * this._p3z - scale * scale - this._r3 * this._r3;
        this.b2.poly1(2.0 * fh, 2.0 * ff);
        this.c2.poly2(fj, 2.0 * fi, fc);
        this.d[0].prod(this.c2, 2.0 * fh1);
        this.d[1].prod(this.b2, this.c1);
        this.bc.diff(this.d[0], this.d[1]);
        this.b2.A[0] = this.b2.A[0] - 2.0 * fh1 * fb2;
        this.d[0].prod(this.c1, fb2);
        this.c2.diff(this.c2, this.d[0]);
        if (this.b2.checkDegeneracy()) {
            if (this.c2.checkDegeneracy()) {
                return false;
            }
            this.c2.copyTo(this.p);
        } else {
            this.d[0].prod(this.c2, this.c2);
            this.d[1].prod(this.bc, this.b2);
            this.p.diff(this.d[0], this.d[1]);
        }
        int nilp = this.p.reduction();
        if (this.p.N == 0) {
            return false;
        }
        this.p.normalize();
        int nroots = this.p.findRoots(this.d, this.roots);
        if (nilp != 0) {
            this.roots[nroots] = 0.0;
            ++nroots;
        }
        this.XYZofs = 0;
        block4: for (i = 0; i < nroots; ++i) {
            fi = this.roots[i];
            fc = this.b2.value(fi);
            if (Math.abs(fc) > this.polyValueEps) {
                fj = -this.c2.value(fi) / fc;
                this.addPoint(0.0, fj, fi);
                continue;
            }
            switch (this.p.rootsP2(2.0 * fh1, this.c1.value(fi), this.iXYZ, this.XYZofs)) {
                case 1: {
                    this.addPoint(0.0, this.iXYZ[this.XYZofs], fi);
                    continue block4;
                }
                case 2: {
                    fj = this.iXYZ[this.XYZofs + 1];
                    this.addPoint(0.0, this.iXYZ[this.XYZofs], fi);
                    this.addPoint(0.0, fj, fi);
                }
            }
        }
        for (i = 0; i < this.iCount; ++i) {
            double x = this.iXYZ[3 * i];
            double y = this.iXYZ[3 * i + 1];
            double z = this.iXYZ[3 * i + 2];
            this.debugMaxDist[i] = Math.max(this.dist2sphere(x, y, z, this.s1x, this.s1y, this.s1z, this.s1r), Math.max(this.dist2sphere(x, y, z, this.s2x, this.s2y, this.s2z, this.s2r), this.dist2cylinder(x, y, z, this.c1gx, this.c1gy, this.c1gz, this.c1x, this.c1y, this.c1z, this.c1r)));
        }
        return this.iCount > 0;
    }

    public boolean intersection_cylinder_sphere_plane() {
        int i;
        this.iCount = 0;
        this._v1x = this.p1nx;
        this._v1y = this.p1ny;
        this._v1z = this.p1nz;
        this._p1x = this.p1x;
        this._p1y = this.p1y;
        this._p1z = this.p1z;
        this.chkC1 = false;
        this._p2x = this.s1x;
        this._p2y = this.s1y;
        this._p2z = this.s1z;
        this._r2 = this.s1r;
        this.chkC2 = false;
        this._v3x = this.c1gx;
        this._v3y = this.c1gy;
        this._v3z = this.c1gz;
        this._p3x = this.c1x;
        this._p3y = this.c1y;
        this._p3z = this.c1z;
        this._r3 = this.c1r;
        this.chkC3 = true;
        this._len3 = Math.sqrt(this._v3x * this._v3x + this._v3y * this._v3y + this._v3z * this._v3z);
        if (this._len3 == 0.0) {
            return false;
        }
        double scale = 1.0 / this._len3;
        this._v3x *= scale;
        this._v3y *= scale;
        this._v3z *= scale;
        this.xyz2ijk();
        if (Math.abs(this._p2x) >= this._r2) {
            return false;
        }
        double fh1 = -this._p2y;
        double fi = -this._p2z;
        double fj = this._p2x * this._p2x + this._p2y * this._p2y + this._p2z * this._p2z - this._r2 * this._r2;
        this.c1.poly2(fj, 2.0 * fi, 1.0);
        scale = this._v3x * this._p3x + this._v3y * this._p3y + this._v3z * this._p3z;
        double fb2 = (1.0 - this._v3y) * (1.0 + this._v3y);
        double fc = (1.0 - this._v3z) * (1.0 + this._v3z);
        double ff = -this._v3y * this._v3z;
        double fh = scale * this._v3y - this._p3y;
        fi = scale * this._v3z - this._p3z;
        fj = this._p3x * this._p3x + this._p3y * this._p3y + this._p3z * this._p3z - scale * scale - this._r3 * this._r3;
        this.b2.poly1(2.0 * fh, 2.0 * ff);
        this.c2.poly2(fj, 2.0 * fi, fc);
        this.d[0].prod(this.c2, 2.0 * fh1);
        this.d[1].prod(this.b2, this.c1);
        this.bc.diff(this.d[0], this.d[1]);
        this.b2.A[0] = this.b2.A[0] - 2.0 * fh1 * fb2;
        this.d[0].prod(this.c1, fb2);
        this.c2.diff(this.c2, this.d[0]);
        if (this.b2.checkDegeneracy()) {
            if (this.c2.checkDegeneracy()) {
                return false;
            }
            this.c2.copyTo(this.p);
        } else {
            this.d[0].prod(this.c2, this.c2);
            this.d[1].prod(this.bc, this.b2);
            this.p.diff(this.d[0], this.d[1]);
        }
        int nilp = this.p.reduction();
        if (this.p.N == 0) {
            return false;
        }
        this.p.normalize();
        int nroots = this.p.findRoots(this.d, this.roots);
        if (nilp != 0) {
            this.roots[nroots] = 0.0;
            ++nroots;
        }
        this.XYZofs = 0;
        block4: for (i = 0; i < nroots; ++i) {
            fi = this.roots[i];
            fc = this.b2.value(fi);
            if (Math.abs(fc) > this.polyValueEps) {
                fj = -this.c2.value(fi) / fc;
                this.addPoint(0.0, fj, fi);
                continue;
            }
            switch (this.p.rootsP2(2.0 * fh1, this.c1.value(fi), this.iXYZ, this.XYZofs)) {
                case 1: {
                    this.addPoint(0.0, this.iXYZ[this.XYZofs], fi);
                    continue block4;
                }
                case 2: {
                    fj = this.iXYZ[this.XYZofs + 1];
                    this.addPoint(0.0, this.iXYZ[this.XYZofs], fi);
                    this.addPoint(0.0, fj, fi);
                }
            }
        }
        for (i = 0; i < this.iCount; ++i) {
            double x = this.iXYZ[3 * i];
            double y = this.iXYZ[3 * i + 1];
            double z = this.iXYZ[3 * i + 2];
            this.debugMaxDist[i] = Math.max(this.dist2plane(x, y, z, this.p1nx, this.p1ny, this.p1nz, this.p1x, this.p1y, this.p1z), Math.max(this.dist2sphere(x, y, z, this.s1x, this.s1y, this.s1z, this.s1r), this.dist2cylinder(x, y, z, this.c1gx, this.c1gy, this.c1gz, this.c1x, this.c1y, this.c1z, this.c1r)));
        }
        return this.iCount > 0;
    }

    public void containing_parallelepiped_C1() {
        if (this.c1gx > 0.0) {
            this.xmin = this.c1x - this.c1r;
            this.xmax = this.c1x + this.c1gx + this.c1r;
        } else {
            this.xmin = this.c1x + this.c1gx - this.c1r;
            this.xmax = this.c1x + this.c1r;
        }
        if (this.c1gy > 0.0) {
            this.ymin = this.c1y - this.c1r;
            this.ymax = this.c1y + this.c1gy + this.c1r;
        } else {
            this.ymin = this.c1y + this.c1gy - this.c1r;
            this.ymax = this.c1y + this.c1r;
        }
        if (this.c1gz > 0.0) {
            this.zmin = this.c1z - this.c1r;
            this.zmax = this.c1z + this.c1gz + this.c1r;
        } else {
            this.zmin = this.c1z + this.c1gz - this.c1r;
            this.zmax = this.c1z + this.c1r;
        }
    }

    public void containing_parallelepiped_C2() {
        if (this.c2gx > 0.0) {
            this.xmin = this.c2x - this.c2r;
            this.xmax = this.c2x + this.c2gx + this.c2r;
        } else {
            this.xmin = this.c2x + this.c2gx - this.c2r;
            this.xmax = this.c2x + this.c2r;
        }
        if (this.c2gy > 0.0) {
            this.ymin = this.c2y - this.c2r;
            this.ymax = this.c2y + this.c2gy + this.c2r;
        } else {
            this.ymin = this.c2y + this.c2gy - this.c2r;
            this.ymax = this.c2y + this.c2r;
        }
        if (this.c2gz > 0.0) {
            this.zmin = this.c2z - this.c2r;
            this.zmax = this.c2z + this.c2gz + this.c2r;
        } else {
            this.zmin = this.c2z + this.c2gz - this.c2r;
            this.zmax = this.c2z + this.c2r;
        }
    }

    public void containing_parallelepiped_C3() {
        if (this.c3gx > 0.0) {
            this.xmin = this.c3x - this.c3r;
            this.xmax = this.c3x + this.c3gx + this.c3r;
        } else {
            this.xmin = this.c3x + this.c3gx - this.c3r;
            this.xmax = this.c3x + this.c3r;
        }
        if (this.c3gy > 0.0) {
            this.ymin = this.c3y - this.c3r;
            this.ymax = this.c3y + this.c3gy + this.c3r;
        } else {
            this.ymin = this.c3y + this.c3gy - this.c3r;
            this.ymax = this.c3y + this.c3r;
        }
        if (this.c3gz > 0.0) {
            this.zmin = this.c3z - this.c3r;
            this.zmax = this.c3z + this.c3gz + this.c3r;
        } else {
            this.zmin = this.c3z + this.c3gz - this.c3r;
            this.zmax = this.c3z + this.c3r;
        }
    }

    public void containing_parallelepiped_S1() {
        this.xmin = this.s1x - this.s1r;
        this.xmax = this.s1x + this.s1r;
        this.ymin = this.s1y - this.s1r;
        this.ymax = this.s1y + this.s1r;
        this.zmin = this.s1z - this.s1r;
        this.zmax = this.s1z + this.s1r;
    }

    public void containing_parallelepiped_S2() {
        this.xmin = this.s2x - this.s2r;
        this.xmax = this.s2x + this.s2r;
        this.ymin = this.s2y - this.s2r;
        this.ymax = this.s2y + this.s2r;
        this.zmin = this.s2z - this.s2r;
        this.zmax = this.s2z + this.s2r;
    }

    private void xyz2ijk() {
        this._vix = this._v1x;
        this._viy = this._v1y;
        this._viz = this._v1z;
        double ax = Math.abs(this._vix);
        double ay = Math.abs(this._viy);
        double az = Math.abs(this._viz);
        if (ax <= ay && ax <= az) {
            double rlen = 1.0 / Math.sqrt(ay * ay + az * az);
            this._vjx = 0.0;
            this._vjy = -this._viz * rlen;
            this._vjz = this._viy * rlen;
        } else if (ay <= ax && ay <= az) {
            double rlen = 1.0 / Math.sqrt(ax * ax + az * az);
            this._vjx = this._viz * rlen;
            this._vjy = 0.0;
            this._vjz = -this._vix * rlen;
        } else {
            double rlen = 1.0 / Math.sqrt(ax * ax + ay * ay);
            this._vjx = -this._viy * rlen;
            this._vjy = this._vix * rlen;
            this._vjz = 0.0;
        }
        this._vkx = this._viy * this._vjz - this._viz * this._vjy;
        this._vky = this._viz * this._vjx - this._vix * this._vjz;
        this._vkz = this._vix * this._vjy - this._viy * this._vjx;
        this._p2x -= this._p1x;
        this._p2y -= this._p1y;
        this._p2z -= this._p1z;
        this._p3x -= this._p1x;
        this._p3y -= this._p1y;
        this._p3z -= this._p1z;
        double tmpx = this._p2x * this._vix + this._p2y * this._viy + this._p2z * this._viz;
        double tmpy = this._p2x * this._vjx + this._p2y * this._vjy + this._p2z * this._vjz;
        double tmpz = this._p2x * this._vkx + this._p2y * this._vky + this._p2z * this._vkz;
        this._p2x = tmpx;
        this._p2y = tmpy;
        this._p2z = tmpz;
        tmpx = this._p3x * this._vix + this._p3y * this._viy + this._p3z * this._viz;
        tmpy = this._p3x * this._vjx + this._p3y * this._vjy + this._p3z * this._vjz;
        tmpz = this._p3x * this._vkx + this._p3y * this._vky + this._p3z * this._vkz;
        this._p3x = tmpx;
        this._p3y = tmpy;
        this._p3z = tmpz;
        tmpx = this._v2x * this._vix + this._v2y * this._viy + this._v2z * this._viz;
        tmpy = this._v2x * this._vjx + this._v2y * this._vjy + this._v2z * this._vjz;
        tmpz = this._v2x * this._vkx + this._v2y * this._vky + this._v2z * this._vkz;
        this._v2x = tmpx;
        this._v2y = tmpy;
        this._v2z = tmpz;
        tmpx = this._v3x * this._vix + this._v3y * this._viy + this._v3z * this._viz;
        tmpy = this._v3x * this._vjx + this._v3y * this._vjy + this._v3z * this._vjz;
        tmpz = this._v3x * this._vkx + this._v3y * this._vky + this._v3z * this._vkz;
        this._v3x = tmpx;
        this._v3y = tmpy;
        this._v3z = tmpz;
    }

    private boolean addPoint(double vi, double vj, double vk) {
        double sp;
        if (this.chkC1 && ((sp = vi) < 0.0 || sp > this._len1)) {
            return false;
        }
        if (this.chkC2 && ((sp = (vi - this._p2x) * this._v2x + (vj - this._p2y) * this._v2y + (vk - this._p2z) * this._v2z) < 0.0 || sp > this._len2)) {
            return false;
        }
        if (this.chkC3 && ((sp = (vi - this._p3x) * this._v3x + (vj - this._p3y) * this._v3y + (vk - this._p3z) * this._v3z) < 0.0 || sp > this._len3)) {
            return false;
        }
        this.iXYZ[this.XYZofs] = this._vix * vi + this._vjx * vj + this._vkx * vk + this._p1x;
        this.iXYZ[this.XYZofs + 1] = this._viy * vi + this._vjy * vj + this._vky * vk + this._p1y;
        this.iXYZ[this.XYZofs + 2] = this._viz * vi + this._vjz * vj + this._vkz * vk + this._p1z;
        this.XYZofs += 3;
        ++this.iCount;
        return true;
    }
}

